/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.retrofit.exceptions;

import com.google.common.base.Throwables;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerHttpException;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerNetworkException;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerServerException;
import com.netflix.spinnaker.orca.exceptions.ExceptionHandler;
import com.netflix.spinnaker.orca.retrofit.exceptions.BaseRetrofitExceptionHandler;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpinnakerServerExceptionHandler
extends BaseRetrofitExceptionHandler {
    private final Logger log = LoggerFactory.getLogger(SpinnakerServerExceptionHandler.class);

    public boolean handles(Exception e) {
        return e instanceof SpinnakerServerException;
    }

    public ExceptionHandler.Response handle(String taskName, Exception exception) {
        Map responseDetails;
        String kind;
        SpinnakerServerException ex = (SpinnakerServerException)exception;
        Integer responseCode = null;
        if (ex instanceof SpinnakerNetworkException) {
            kind = "NETWORK";
            responseDetails = ExceptionHandler.responseDetails((String)ex.getMessage());
            responseDetails.put("stackTrace", Throwables.getStackTraceAsString((Throwable)ex));
        } else if (ex instanceof SpinnakerHttpException) {
            SpinnakerHttpException spinnakerHttpException = (SpinnakerHttpException)ex;
            kind = "HTTP";
            responseCode = spinnakerHttpException.getResponseCode();
            Map body = spinnakerHttpException.getResponseBody();
            if (body == null) {
                responseDetails = ExceptionHandler.responseDetails((String)spinnakerHttpException.getMessage());
            } else {
                String error = body.getOrDefault("error", spinnakerHttpException.getReason());
                List<Object> errors = body.getOrDefault("errors", body.getOrDefault("messages", List.of()));
                if (errors.isEmpty()) {
                    errors = List.of(spinnakerHttpException.getMessage());
                }
                responseDetails = ExceptionHandler.responseDetails((String)error, errors);
                Object exceptionProperty = body.get("exception");
                if (exceptionProperty != null) {
                    responseDetails.put("rootException", exceptionProperty);
                } else {
                    responseDetails.put("stackTrace", Throwables.getStackTraceAsString((Throwable)spinnakerHttpException));
                }
            }
            responseDetails.put("status", spinnakerHttpException.getResponseCode());
            responseDetails.put("url", spinnakerHttpException.getUrl());
        } else {
            kind = "UNEXPECTED";
            responseDetails = ExceptionHandler.responseDetails((String)ex.getMessage());
            responseDetails.put("stackTrace", Throwables.getStackTraceAsString((Throwable)ex));
        }
        responseDetails.put("kind", kind);
        return new ExceptionHandler.Response(ex.getClass().getSimpleName(), taskName, responseDetails, this.shouldRetry((Exception)ex, kind, responseCode));
    }
}

