/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.config.OrcaSqlProperties;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.kork.sql.config.DefaultSqlConfiguration;
import com.netflix.spinnaker.kork.sql.config.SqlProperties;
import com.netflix.spinnaker.kork.telemetry.InstrumentedProxy;
import com.netflix.spinnaker.orca.api.pipeline.persistence.ExecutionRepositoryListener;
import com.netflix.spinnaker.orca.interlink.Interlink;
import com.netflix.spinnaker.orca.notifications.NotificationClusterLock;
import com.netflix.spinnaker.orca.notifications.SqlNotificationClusterLock;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.sql.SpringLiquibaseProxy;
import com.netflix.spinnaker.orca.sql.SqlHealthIndicator;
import com.netflix.spinnaker.orca.sql.SqlHealthcheckActivator;
import com.netflix.spinnaker.orca.sql.pipeline.persistence.ExecutionStatisticsRepository;
import com.netflix.spinnaker.orca.sql.pipeline.persistence.SqlExecutionRepository;
import com.netflix.spinnaker.orca.sql.telemetry.SqlActiveExecutionsMonitor;
import java.time.Clock;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import liquibase.integration.spring.SpringLiquibase;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnProperty(value={"sql.enabled"})
@EnableConfigurationProperties(value={OrcaSqlProperties.class})
@Import(value={DefaultSqlConfiguration.class})
@ComponentScan(value={"com.netflix.spinnaker.orca.sql"})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0017J:\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u0019H\u0017J$\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u001e\u001a\u00020\u001fH\u0017JL\u0010 \u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0017J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J \u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020+2\u0006\u0010\r\u001a\u00020\bH\u0017\u00a8\u0006,"}, d2={"Lcom/netflix/spinnaker/config/SqlConfiguration;", "", "()V", "dbHealthIndicator", "Lcom/netflix/spinnaker/orca/sql/SqlHealthIndicator;", "sqlHealthcheckActivator", "Lcom/netflix/spinnaker/orca/sql/SqlHealthcheckActivator;", "sqlProperties", "Lcom/netflix/spinnaker/kork/sql/config/SqlProperties;", "dynamicConfigService", "Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;", "liquibase", "Lliquibase/integration/spring/SpringLiquibase;", "properties", "secondarySqlExecutionRepository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "dsl", "Lorg/jooq/DSLContext;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "registry", "Lcom/netflix/spectator/api/Registry;", "orcaSqlProperties", "Lcom/netflix/spinnaker/config/OrcaSqlProperties;", "poolName", "", "sqlActiveExecutionsMonitor", "Lcom/netflix/spinnaker/orca/sql/telemetry/SqlActiveExecutionsMonitor;", "executionRepository", "Lcom/netflix/spinnaker/orca/sql/pipeline/persistence/ExecutionStatisticsRepository;", "refreshFrequencyMs", "", "sqlExecutionRepository", "interlink", "Ljava/util/Optional;", "Lcom/netflix/spinnaker/orca/interlink/Interlink;", "executionRepositoryListeners", "", "Lcom/netflix/spinnaker/orca/api/pipeline/persistence/ExecutionRepositoryListener;", "sqlNotificationClusterLock", "Lcom/netflix/spinnaker/orca/notifications/SqlNotificationClusterLock;", "jooq", "clock", "Ljava/time/Clock;", "orca-sql"})
public class SqlConfiguration {
    @Bean
    @NotNull
    public SpringLiquibase liquibase(@NotNull SqlProperties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        return new SpringLiquibaseProxy(properties);
    }

    @ConditionalOnProperty(value={"execution-repository.sql.enabled"})
    @Bean
    @NotNull
    public ExecutionRepository sqlExecutionRepository(@NotNull DSLContext dsl, @NotNull ObjectMapper mapper, @NotNull Registry registry, @NotNull SqlProperties properties, @NotNull OrcaSqlProperties orcaSqlProperties, @NotNull Optional<Interlink> interlink, @NotNull Collection<? extends ExecutionRepositoryListener> executionRepositoryListeners) {
        Intrinsics.checkNotNullParameter((Object)dsl, (String)"dsl");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)orcaSqlProperties, (String)"orcaSqlProperties");
        Intrinsics.checkNotNullParameter(interlink, (String)"interlink");
        Intrinsics.checkNotNullParameter(executionRepositoryListeners, (String)"executionRepositoryListeners");
        SqlExecutionRepository sqlExecutionRepository = new SqlExecutionRepository(orcaSqlProperties.getPartitionName(), dsl, mapper, properties.getRetries().getTransactions(), orcaSqlProperties.getBatchReadSize(), orcaSqlProperties.getStageReadSize(), null, interlink.orElse(null), executionRepositoryListeners, 64, null);
        boolean bl = false;
        boolean bl2 = false;
        SqlExecutionRepository it = sqlExecutionRepository;
        boolean bl3 = false;
        Object object = InstrumentedProxy.proxy((Registry)registry, (Object)it, (String)"sql.executions", (Map)MapsKt.mapOf((Pair)new Pair((Object)"repository", (Object)"primary")));
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository");
        }
        return (ExecutionRepository)object;
    }

    @ConditionalOnProperty(value={"execution-repository.sql.enabled", "execution-repository.sql.secondary.enabled"})
    @Bean
    @NotNull
    public ExecutionRepository secondarySqlExecutionRepository(@NotNull DSLContext dsl, @NotNull ObjectMapper mapper, @NotNull Registry registry, @NotNull SqlProperties properties, @NotNull OrcaSqlProperties orcaSqlProperties, @Value(value="${execution-repository.sql.secondary.pool-name}") @NotNull String poolName) {
        Intrinsics.checkNotNullParameter((Object)dsl, (String)"dsl");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)orcaSqlProperties, (String)"orcaSqlProperties");
        Intrinsics.checkNotNullParameter((Object)poolName, (String)"poolName");
        SqlExecutionRepository sqlExecutionRepository = new SqlExecutionRepository(orcaSqlProperties.getPartitionName(), dsl, mapper, properties.getRetries().getTransactions(), orcaSqlProperties.getBatchReadSize(), orcaSqlProperties.getStageReadSize(), poolName, null, null, 384, null);
        boolean bl = false;
        boolean bl2 = false;
        SqlExecutionRepository it = sqlExecutionRepository;
        boolean bl3 = false;
        Object object = InstrumentedProxy.proxy((Registry)registry, (Object)it, (String)"sql.executions", (Map)MapsKt.mapOf((Pair)new Pair((Object)"repository", (Object)"secondary")));
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository");
        }
        return (ExecutionRepository)object;
    }

    @ConditionalOnProperty(value={"monitor.active-executions.redis"}, havingValue="false")
    @Bean
    @NotNull
    public SqlActiveExecutionsMonitor sqlActiveExecutionsMonitor(@Qualifier(value="sqlExecutionRepository") @NotNull ExecutionStatisticsRepository executionRepository, @NotNull Registry registry, @Value(value="${monitor.active-executions.refresh.frequency.ms:60000}") long refreshFrequencyMs) {
        Intrinsics.checkNotNullParameter((Object)executionRepository, (String)"executionRepository");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        return new SqlActiveExecutionsMonitor(executionRepository, registry, refreshFrequencyMs);
    }

    @Bean
    @NotNull
    public SqlHealthcheckActivator sqlHealthcheckActivator(@NotNull DSLContext dsl, @NotNull Registry registry) {
        Intrinsics.checkNotNullParameter((Object)dsl, (String)"dsl");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        return new SqlHealthcheckActivator(dsl, registry, 0, 0, 12, null);
    }

    @Bean(value={"dbHealthIndicator"})
    @NotNull
    public SqlHealthIndicator dbHealthIndicator(@NotNull SqlHealthcheckActivator sqlHealthcheckActivator, @NotNull SqlProperties sqlProperties, @NotNull DynamicConfigService dynamicConfigService) {
        Intrinsics.checkNotNullParameter((Object)sqlHealthcheckActivator, (String)"sqlHealthcheckActivator");
        Intrinsics.checkNotNullParameter((Object)sqlProperties, (String)"sqlProperties");
        Intrinsics.checkNotNullParameter((Object)dynamicConfigService, (String)"dynamicConfigService");
        return new SqlHealthIndicator(sqlHealthcheckActivator, sqlProperties.getDefaultConnectionPoolProperties().getDialect(), dynamicConfigService);
    }

    @ConditionalOnProperty(value={"execution-repository.sql.enabled"})
    @ConditionalOnMissingBean(value={NotificationClusterLock.class})
    @Primary
    @Bean
    @NotNull
    public SqlNotificationClusterLock sqlNotificationClusterLock(@NotNull DSLContext jooq, @NotNull Clock clock, @NotNull SqlProperties properties) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        return new SqlNotificationClusterLock(jooq, clock, properties.getRetries().getTransactions());
    }
}

