/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.sql;

import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jooq.ExecuteContext;
import org.jooq.impl.DefaultExecuteListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/netflix/spinnaker/orca/sql/QueryLogger;", "Lorg/jooq/impl/DefaultExecuteListener;", "dynamicConfigService", "Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;", "(Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "end", "", "ctx", "Lorg/jooq/ExecuteContext;", "orca-sql"})
public final class QueryLogger
extends DefaultExecuteListener {
    private final Logger log;
    private final DynamicConfigService dynamicConfigService;

    public void end(@NotNull ExecuteContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (this.dynamicConfigService.isEnabled("sql.query-logger", false)) {
            String exclude;
            Object[] objectArray = ctx.batchSQL();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ctx.batchSQL()");
            String statements = ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            String string = exclude = (String)this.dynamicConfigService.getConfig(String.class, "sql.query-logger.exclude-pattern", (Object)".*healthcheck.*");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"exclude");
            CharSequence charSequence = string;
            boolean bl = false;
            if (charSequence.length() > 0) {
                Pattern pattern;
                Object object;
                Pattern pattern2;
                try {
                    pattern2 = Pattern.compile(exclude);
                }
                catch (PatternSyntaxException e) {
                    this.log.error("Exclusion pattern invalid: '" + exclude + '\'', (Throwable)e);
                    pattern2 = null;
                }
                if ((object = (pattern = pattern2)) != null && (object = ((Pattern)object).matcher(statements)) != null) {
                    if (((Matcher)object).matches()) {
                        return;
                    }
                }
            }
            this.log.debug(statements);
        }
    }

    public QueryLogger(@NotNull DynamicConfigService dynamicConfigService) {
        Intrinsics.checkNotNullParameter((Object)dynamicConfigService, (String)"dynamicConfigService");
        this.dynamicConfigService = dynamicConfigService;
        this.log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    }
}

