/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.sql;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.q.Activator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.DSLContext;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010!\u001a\u00020\"H\u0007R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0010j\u0002`\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0016\u001a\n\u0018\u00010\u0010j\u0004\u0018\u0001`\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\n \u001d*\u0004\u0018\u00010\u001f0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/netflix/spinnaker/orca/sql/SqlHealthcheckActivator;", "Lcom/netflix/spinnaker/q/Activator;", "jooq", "Lorg/jooq/DSLContext;", "registry", "Lcom/netflix/spectator/api/Registry;", "unhealthyThreshold", "", "healthyThreshold", "(Lorg/jooq/DSLContext;Lcom/netflix/spectator/api/Registry;II)V", "_enabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "get_enabled", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "_healthException", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "enabled", "", "getEnabled", "()Z", "healthException", "getHealthException", "()Ljava/lang/Exception;", "healthyCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "invocationId", "Lcom/netflix/spectator/api/Id;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "unhealthyCounter", "performWrite", "", "orca-sql"})
public final class SqlHealthcheckActivator
implements Activator {
    private final Logger log;
    @NotNull
    private final AtomicBoolean _enabled;
    private final AtomicReference<Exception> _healthException;
    private final AtomicInteger healthyCounter;
    private final AtomicInteger unhealthyCounter;
    private final Id invocationId;
    private final DSLContext jooq;
    private final Registry registry;
    private final int unhealthyThreshold;
    private final int healthyThreshold;

    @NotNull
    public final AtomicBoolean get_enabled() {
        return this._enabled;
    }

    public boolean getEnabled() {
        return this._enabled.get();
    }

    @Nullable
    public final Exception getHealthException() {
        return this._healthException.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedDelay=1000L)
    public final void performWrite() {
        try {
            this.jooq.delete(DSL.table((String)"healthcheck")).execute();
            if (!this._enabled.get() && this.healthyCounter.incrementAndGet() >= this.healthyThreshold) {
                this._enabled.set(true);
                this._healthException.set(null);
                this.log.info("Enabling activator after " + this.healthyThreshold + " healthy cycles");
            }
            this.unhealthyCounter.set(0);
            this.registry.counter(this.invocationId.withTag("status", this.getEnabled() ? "enabled" : "disabled")).increment();
        }
        catch (Exception e) {
            try {
                this._healthException.set(e);
                this.healthyCounter.set(0);
                int n = this.unhealthyCounter.incrementAndGet();
                boolean bl = false;
                boolean bl2 = false;
                int unhealthyCount = n;
                boolean bl3 = false;
                this.log.error("Encountered exception, " + unhealthyCount + '/' + this.unhealthyThreshold + " failures", (Throwable)e);
                if (unhealthyCount >= this.unhealthyThreshold && this._enabled.get()) {
                    this.log.warn("Encountered exception, disabling Activator after " + unhealthyCount + " failures");
                    this._enabled.set(false);
                }
                this.registry.counter(this.invocationId.withTag("status", this.getEnabled() ? "enabled" : "disabled")).increment();
            }
            catch (Throwable throwable) {
                this.registry.counter(this.invocationId.withTag("status", this.getEnabled() ? "enabled" : "disabled")).increment();
                throw throwable;
            }
        }
    }

    public SqlHealthcheckActivator(@NotNull DSLContext jooq, @NotNull Registry registry, int unhealthyThreshold, int healthyThreshold) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.jooq = jooq;
        this.registry = registry;
        this.unhealthyThreshold = unhealthyThreshold;
        this.healthyThreshold = healthyThreshold;
        this.log = LoggerFactory.getLogger(this.getClass());
        this._enabled = new AtomicBoolean(false);
        this._healthException = new AtomicReference();
        this.healthyCounter = new AtomicInteger(0);
        this.unhealthyCounter = new AtomicInteger(0);
        this.invocationId = this.registry.createId("sql.queueActivator.invocations");
    }

    public /* synthetic */ SqlHealthcheckActivator(DSLContext dSLContext, Registry registry, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n = 2;
        }
        if ((n3 & 8) != 0) {
            n2 = 10;
        }
        this(dSLContext, registry, n, n2);
    }

    public void ifEnabled(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Activator.DefaultImpls.ifEnabled((Activator)this, block);
    }
}

