/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.sql.cleanup;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.patterns.LongTaskTimer;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.notifications.AbstractPollingNotificationAgent;
import com.netflix.spinnaker.orca.notifications.NotificationClusterLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010 \u001a\u00020\u000bH\u0014J\b\u0010!\u001a\u00020\u0005H\u0014J\b\u0010\"\u001a\u00020#H&J\b\u0010$\u001a\u00020#H\u0014R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006%"}, d2={"Lcom/netflix/spinnaker/orca/sql/cleanup/AbstractCleanupPollingAgent;", "Lcom/netflix/spinnaker/orca/notifications/AbstractPollingNotificationAgent;", "clusterLock", "Lcom/netflix/spinnaker/orca/notifications/NotificationClusterLock;", "pollingIntervalMs", "", "registry", "Lcom/netflix/spectator/api/Registry;", "(Lcom/netflix/spinnaker/orca/notifications/NotificationClusterLock;JLcom/netflix/spectator/api/Registry;)V", "completedStatuses", "", "", "getCompletedStatuses", "()Ljava/util/List;", "deletedId", "Lcom/netflix/spectator/api/Id;", "getDeletedId", "()Lcom/netflix/spectator/api/Id;", "errorsCounter", "Lcom/netflix/spectator/api/Counter;", "getErrorsCounter", "()Lcom/netflix/spectator/api/Counter;", "invocationTimer", "Lcom/netflix/spectator/api/patterns/LongTaskTimer;", "getInvocationTimer", "()Lcom/netflix/spectator/api/patterns/LongTaskTimer;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "getRegistry", "()Lcom/netflix/spectator/api/Registry;", "getNotificationType", "getPollingInterval", "performCleanup", "", "tick", "orca-sql"})
public abstract class AbstractCleanupPollingAgent
extends AbstractPollingNotificationAgent {
    @NotNull
    private final Logger log;
    @NotNull
    private final List<String> completedStatuses;
    @NotNull
    private final Id deletedId;
    @NotNull
    private final Counter errorsCounter;
    @NotNull
    private final LongTaskTimer invocationTimer;
    private final long pollingIntervalMs;
    @NotNull
    private final Registry registry;

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    @NotNull
    public final List<String> getCompletedStatuses() {
        return this.completedStatuses;
    }

    @NotNull
    public final Id getDeletedId() {
        return this.deletedId;
    }

    @NotNull
    public final Counter getErrorsCounter() {
        return this.errorsCounter;
    }

    @NotNull
    public final LongTaskTimer getInvocationTimer() {
        return this.invocationTimer;
    }

    public abstract void performCleanup();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tick() {
        long timerId = this.invocationTimer.start();
        long startTime = System.currentTimeMillis();
        try {
            this.log.info("Agent " + this.getNotificationType() + " started");
            this.performCleanup();
        }
        catch (Exception e) {
            this.log.error("Agent " + this.getNotificationType() + " failed to perform cleanup", (Throwable)e);
        }
        finally {
            this.log.info("Agent " + this.getNotificationType() + " completed in " + (System.currentTimeMillis() - startTime) + "ms");
            this.invocationTimer.stop(timerId);
        }
    }

    protected long getPollingInterval() {
        return this.pollingIntervalMs;
    }

    @NotNull
    protected String getNotificationType() {
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        return string;
    }

    @NotNull
    public final Registry getRegistry() {
        return this.registry;
    }

    /*
     * WARNING - void declaration
     */
    public AbstractCleanupPollingAgent(@NotNull NotificationClusterLock clusterLock, long pollingIntervalMs, @NotNull Registry registry) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)clusterLock, (String)"clusterLock");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        super(clusterLock);
        this.pollingIntervalMs = pollingIntervalMs;
        this.registry = registry;
        Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(javaClass)");
        this.log = logger;
        Collection collection2 = ExecutionStatus.COMPLETED;
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"ExecutionStatus.COMPLETED");
        Iterable iterable = collection2;
        AbstractCleanupPollingAgent abstractCleanupPollingAgent = this;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ExecutionStatus executionStatus = (ExecutionStatus)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.toString();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        abstractCleanupPollingAgent.completedStatuses = collection;
        Id id = this.registry.createId("pollers." + this.getNotificationType() + ".deleted");
        Intrinsics.checkNotNullExpressionValue((Object)id, (String)"registry.createId(\"polle\u2026otificationType.deleted\")");
        this.deletedId = id;
        Counter counter = this.registry.counter("pollers." + this.getNotificationType() + ".errors");
        Intrinsics.checkNotNullExpressionValue((Object)counter, (String)"registry.counter(\"poller\u2026notificationType.errors\")");
        this.errorsCounter = counter;
        LongTaskTimer longTaskTimer = LongTaskTimer.get((Registry)this.registry, (Id)this.registry.createId("pollers." + this.getNotificationType() + ".timing"));
        Intrinsics.checkNotNullExpressionValue((Object)longTaskTimer, (String)"LongTaskTimer.get(regist\u2026otificationType.timing\"))");
        this.invocationTimer = longTaskTimer;
    }
}

