/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.sql.cleanup;

import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.config.OldPipelineCleanupAgentConfigurationProperties;
import com.netflix.spinnaker.config.OrcaSqlProperties;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.notifications.NotificationClusterLock;
import com.netflix.spinnaker.orca.notifications.scheduling.PipelineDependencyCleanupOperator;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.sql.cleanup.AbstractCleanupPollingAgent;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record3;
import org.jooq.Result;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnExpression(value="${pollers.old-pipeline-cleanup.enabled:false} && ${execution-repository.sql.enabled:false}")
@EnableConfigurationProperties(value={OldPipelineCleanupAgentConfigurationProperties.class, OrcaSqlProperties.class})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0017\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0014\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/netflix/spinnaker/orca/sql/cleanup/OldPipelineCleanupPollingNotificationAgent;", "Lcom/netflix/spinnaker/orca/sql/cleanup/AbstractCleanupPollingAgent;", "clusterLock", "Lcom/netflix/spinnaker/orca/notifications/NotificationClusterLock;", "jooq", "Lorg/jooq/DSLContext;", "clock", "Ljava/time/Clock;", "registry", "Lcom/netflix/spectator/api/Registry;", "executionRepository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "configurationProperties", "Lcom/netflix/spinnaker/config/OldPipelineCleanupAgentConfigurationProperties;", "orcaSqlProperties", "Lcom/netflix/spinnaker/config/OrcaSqlProperties;", "pipelineDependencyCleanupOperators", "", "Lcom/netflix/spinnaker/orca/notifications/scheduling/PipelineDependencyCleanupOperator;", "(Lcom/netflix/spinnaker/orca/notifications/NotificationClusterLock;Lorg/jooq/DSLContext;Ljava/time/Clock;Lcom/netflix/spectator/api/Registry;Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;Lcom/netflix/spinnaker/config/OldPipelineCleanupAgentConfigurationProperties;Lcom/netflix/spinnaker/config/OrcaSqlProperties;Ljava/util/List;)V", "performCleanup", "", "", "application", "", "pipelineConfigId", "thresholdMillis", "", "orca-sql"})
public class OldPipelineCleanupPollingNotificationAgent
extends AbstractCleanupPollingAgent {
    private final DSLContext jooq;
    private final Clock clock;
    private final ExecutionRepository executionRepository;
    private final OldPipelineCleanupAgentConfigurationProperties configurationProperties;
    private final OrcaSqlProperties orcaSqlProperties;
    private final List<PipelineDependencyCleanupOperator> pipelineDependencyCleanupOperators;

    /*
     * WARNING - void declaration
     */
    @Override
    public void performCleanup() {
        Map candidateApplicationsGroups;
        void $this$groupByTo$iv$iv;
        HashSet exceptionalApps = CollectionsKt.toHashSet((Iterable)this.configurationProperties.getExceptionalApplications());
        List list = this.jooq.select((SelectField)DSL.field((String)"application")).from((TableLike)DSL.table((String)"pipelines")).groupBy(new GroupField[]{(GroupField)DSL.field((String)"application")}).having(DSL.count((Field)DSL.field((String)"id")).gt((Object)this.configurationProperties.getMinimumPipelineExecutions())).fetch(DSL.field((String)"application"), String.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jooq\n      .select(field\u2026on\"), String::class.java)");
        Iterable $this$groupBy$iv = list;
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            String app = (String)element$iv$iv;
            boolean bl = false;
            Long key$iv$iv = exceptionalApps.contains(app) ? this.configurationProperties.getExceptionalApplicationsThresholdDays() : this.configurationProperties.getThresholdDays();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$forEach$iv = candidateApplicationsGroups = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            void thresholdToUse;
            Map.Entry element$iv;
            Map.Entry $dstr$thresholdToUse$candidateApplications = element$iv = iterator2.next();
            boolean bl3 = false;
            Map.Entry entry = $dstr$thresholdToUse$candidateApplications;
            boolean bl4 = false;
            long $this$getOrPut$iv$iv$iv = ((Number)entry.getKey()).longValue();
            entry = $dstr$thresholdToUse$candidateApplications;
            bl4 = false;
            List candidateApplications = (List)entry.getValue();
            long thresholdMillis = Instant.ofEpochMilli(this.clock.millis()).minus((long)thresholdToUse, ChronoUnit.DAYS).toEpochMilli();
            for (List chunk : CollectionsKt.chunked((Iterable)candidateApplications, (int)5)) {
                Result pipelineConfigsWithOldExecutions;
                Collection $this$toTypedArray$iv = chunk;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                $this$toTypedArray$iv = this.getCompletedStatuses();
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
                if (stringArray2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                SelectConditionStep queryBuilder = this.jooq.select((SelectField)DSL.field((String)"application"), (SelectField)DSL.field((String)"config_id"), (SelectField)DSL.count((Field)DSL.field((String)"id")).as("count")).from((TableLike)DSL.table((String)"pipelines")).where(DSL.field((String)"application").in((Object[])Arrays.copyOf(stringArray, stringArray.length))).and(DSL.field((String)"build_time").le((Object)thresholdMillis)).and(DSL.field((String)"status").in((Object[])Arrays.copyOf(stringArray2, stringArray2.length)));
                if (this.orcaSqlProperties.getPartitionName() != null) {
                    queryBuilder = queryBuilder.and(DSL.field((Name)DSL.name((String)"partition")).eq((Object)this.orcaSqlProperties.getPartitionName()));
                }
                Result result = pipelineConfigsWithOldExecutions = queryBuilder.groupBy(new GroupField[]{(GroupField)DSL.field((String)"application"), (GroupField)DSL.field((String)"config_id")}).having(DSL.count((Field)DSL.field((String)"id")).gt((Object)this.configurationProperties.getMinimumPipelineExecutions())).fetch();
                Intrinsics.checkNotNullExpressionValue((Object)result, (String)"pipelineConfigsWithOldExecutions");
                Iterable $this$forEach$iv2 = (Iterable)result;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String pipelineConfigId;
                    String application;
                    Record3 it = (Record3)element$iv2;
                    boolean bl5 = false;
                    if ((String)it.getValue(DSL.field((String)"application")) == null) {
                        continue;
                    }
                    if ((String)it.getValue(DSL.field((String)"config_id")) == null) {
                        continue;
                    }
                    try {
                        long startTime = System.currentTimeMillis();
                        this.getLog().debug("Cleaning up old pipelines for " + application + " (pipelineConfigId: " + pipelineConfigId + ')');
                        int deletedPipelineCount = this.performCleanup(application, pipelineConfigId, thresholdMillis);
                        this.getLog().debug("Cleaned up {} old pipelines for {} in {}ms (pipelineConfigId: {})", new Object[]{deletedPipelineCount, application, System.currentTimeMillis() - startTime, pipelineConfigId});
                    }
                    catch (Exception e) {
                        this.getLog().error("Failed to cleanup old pipelines for " + application + " (pipelineConfigId: " + pipelineConfigId + ')', (Throwable)e);
                        this.getErrorsCounter().increment();
                    }
                }
            }
        }
    }

    private int performCleanup(String application, String pipelineConfigId, long thresholdMillis) {
        AtomicInteger deletedExecutionCount = new AtomicInteger();
        Collection $this$toTypedArray$iv = this.getCompletedStatuses();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        SelectConditionStep queryBuilder = this.jooq.select((SelectField)DSL.field((String)"id")).from((TableLike)DSL.table((String)"pipelines")).where(DSL.field((String)"build_time").le((Object)thresholdMillis).and(DSL.field((String)"status").in((Object[])Arrays.copyOf(stringArray, stringArray.length))).and(DSL.field((String)"application").eq((Object)application)).and(DSL.field((String)"config_id").eq((Object)pipelineConfigId)));
        if (this.orcaSqlProperties.getPartitionName() != null) {
            queryBuilder = queryBuilder.and(DSL.field((Name)DSL.name((String)"partition")).eq((Object)this.orcaSqlProperties.getPartitionName()));
        }
        List executionsToRemove = queryBuilder.orderBy((OrderField)DSL.field((String)"build_time").desc()).limit(this.configurationProperties.getMinimumPipelineExecutions(), Integer.MAX_VALUE).fetch(DSL.field((String)"id"), String.class);
        Iterable $this$forEach$iv = this.pipelineDependencyCleanupOperators;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PipelineDependencyCleanupOperator it = (PipelineDependencyCleanupOperator)element$iv;
            boolean bl = false;
            it.cleanup(executionsToRemove);
        }
        List list = executionsToRemove;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"executionsToRemove");
        $this$forEach$iv = CollectionsKt.chunked((Iterable)list, (int)this.configurationProperties.getChunkSize());
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List ids = (List)element$iv;
            boolean bl = false;
            deletedExecutionCount.addAndGet(ids.size());
            this.executionRepository.delete(ExecutionType.PIPELINE, ids);
            this.getRegistry().counter(this.getDeletedId().withTag("application", application)).add((double)ids.size());
        }
        return deletedExecutionCount.intValue();
    }

    public OldPipelineCleanupPollingNotificationAgent(@NotNull NotificationClusterLock clusterLock, @NotNull DSLContext jooq, @NotNull Clock clock, @NotNull Registry registry, @NotNull ExecutionRepository executionRepository, @NotNull OldPipelineCleanupAgentConfigurationProperties configurationProperties, @NotNull OrcaSqlProperties orcaSqlProperties, @NotNull List<? extends PipelineDependencyCleanupOperator> pipelineDependencyCleanupOperators) {
        Intrinsics.checkNotNullParameter((Object)clusterLock, (String)"clusterLock");
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)executionRepository, (String)"executionRepository");
        Intrinsics.checkNotNullParameter((Object)configurationProperties, (String)"configurationProperties");
        Intrinsics.checkNotNullParameter((Object)orcaSqlProperties, (String)"orcaSqlProperties");
        Intrinsics.checkNotNullParameter(pipelineDependencyCleanupOperators, (String)"pipelineDependencyCleanupOperators");
        super(clusterLock, configurationProperties.getIntervalMs(), registry);
        this.jooq = jooq;
        this.clock = clock;
        this.executionRepository = executionRepository;
        this.configurationProperties = configurationProperties;
        this.orcaSqlProperties = orcaSqlProperties;
        this.pipelineDependencyCleanupOperators = pipelineDependencyCleanupOperators;
    }
}

