/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.sql.cleanup;

import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.config.OrcaSqlProperties;
import com.netflix.spinnaker.config.TopApplicationExecutionCleanupAgentConfigurationProperties;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.notifications.NotificationClusterLock;
import com.netflix.spinnaker.orca.notifications.scheduling.PipelineDependencyCleanupOperator;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.sql.cleanup.AbstractCleanupPollingAgent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnExpression(value="${pollers.top-application-execution-cleanup.enabled:false} && ${execution-repository.sql.enabled:false}")
@EnableConfigurationProperties(value={TopApplicationExecutionCleanupAgentConfigurationProperties.class, OrcaSqlProperties.class})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0012\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0012R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/netflix/spinnaker/orca/sql/cleanup/TopApplicationExecutionCleanupPollingNotificationAgent;", "Lcom/netflix/spinnaker/orca/sql/cleanup/AbstractCleanupPollingAgent;", "clusterLock", "Lcom/netflix/spinnaker/orca/notifications/NotificationClusterLock;", "jooq", "Lorg/jooq/DSLContext;", "registry", "Lcom/netflix/spectator/api/Registry;", "executionRepository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "configurationProperties", "Lcom/netflix/spinnaker/config/TopApplicationExecutionCleanupAgentConfigurationProperties;", "orcaSqlProperties", "Lcom/netflix/spinnaker/config/OrcaSqlProperties;", "pipelineDependencyCleanupOperators", "", "Lcom/netflix/spinnaker/orca/notifications/scheduling/PipelineDependencyCleanupOperator;", "(Lcom/netflix/spinnaker/orca/notifications/NotificationClusterLock;Lorg/jooq/DSLContext;Lcom/netflix/spectator/api/Registry;Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;Lcom/netflix/spinnaker/config/TopApplicationExecutionCleanupAgentConfigurationProperties;Lcom/netflix/spinnaker/config/OrcaSqlProperties;Ljava/util/List;)V", "performCleanup", "", "", "application", "", "threshold", "orca-sql"})
public class TopApplicationExecutionCleanupPollingNotificationAgent
extends AbstractCleanupPollingAgent {
    private final DSLContext jooq;
    private final ExecutionRepository executionRepository;
    private final TopApplicationExecutionCleanupAgentConfigurationProperties configurationProperties;
    private final OrcaSqlProperties orcaSqlProperties;
    private final List<PipelineDependencyCleanupOperator> pipelineDependencyCleanupOperators;

    /*
     * WARNING - void declaration
     */
    @Override
    public void performCleanup() {
        Map candidateApplicationGroups;
        void $this$groupByTo$iv$iv;
        List list = this.jooq.select((SelectField)DSL.field((String)"application")).from((TableLike)DSL.table((String)"orchestrations")).groupBy(new GroupField[]{(GroupField)DSL.field((String)"application")}).having(DSL.count((Field)DSL.field((String)"id")).gt((Object)this.configurationProperties.getThreshold())).fetch(DSL.field((String)"application"), String.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jooq\n      .select(DSL.f\u2026on\"), String::class.java)");
        Iterable $this$groupBy$iv = list;
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            String app = (String)element$iv$iv;
            boolean bl4 = false;
            Integer n = this.configurationProperties.getExceptionApplicationThresholds().get(app);
            Integer key$iv$iv = n != null ? n.intValue() : this.configurationProperties.getThreshold();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$forEach$iv = candidateApplicationGroups = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$thresholdToUse$candidateApplications = element$iv = iterator2.next();
            boolean bl3 = false;
            Map.Entry bl4 = $dstr$thresholdToUse$candidateApplications;
            boolean bl5 = false;
            int $this$getOrPut$iv$iv$iv = ((Number)bl4.getKey()).intValue();
            bl4 = $dstr$thresholdToUse$candidateApplications;
            bl5 = false;
            List candidateApplications = (List)bl4.getValue();
            for (List chunk : CollectionsKt.chunked((Iterable)candidateApplications, (int)5)) {
                void $this$forEach$iv2;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                void thresholdToUse;
                List applicationsWithLotsOfOrchestrations;
                Iterable $this$toTypedArray$iv = chunk;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                List list2 = applicationsWithLotsOfOrchestrations = this.jooq.select((SelectField)DSL.field((String)"application")).from((TableLike)DSL.table((String)"orchestrations")).where(this.orcaSqlProperties.getPartitionName() == null ? DSL.noCondition() : DSL.field((Name)DSL.name((String)"partition")).eq((Object)this.orcaSqlProperties.getPartitionName())).and(DSL.field((String)"application").in((Object[])Arrays.copyOf(stringArray, stringArray.length))).groupBy(new GroupField[]{(GroupField)DSL.field((String)"application")}).having(DSL.count((Field)DSL.field((String)"id")).gt((Object)((int)thresholdToUse))).fetch(DSL.field((String)"application"), String.class);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"applicationsWithLotsOfOrchestrations");
                $this$toTypedArray$iv = list2;
                boolean $i$f$filter = false;
                thisCollection$iv = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl6 = false;
                    CharSequence charSequence = it;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    if (!(!(charSequence == null || charSequence.length() == 0))) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv2;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String application = (String)element$iv2;
                    boolean bl9 = false;
                    try {
                        long startTime = System.currentTimeMillis();
                        this.getLog().debug("Cleaning up old orchestrations for " + application);
                        String string = application;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"application");
                        int deletedOrchestrationCount = this.performCleanup(string, (int)thresholdToUse);
                        this.getLog().debug("Cleaned up {} old orchestrations for {} in {}ms", new Object[]{deletedOrchestrationCount, application, System.currentTimeMillis() - startTime});
                    }
                    catch (Exception e) {
                        this.getLog().error("Failed to cleanup old orchestrations for " + application, (Throwable)e);
                        this.getErrorsCounter().increment();
                    }
                }
            }
        }
    }

    private int performCleanup(String application, int threshold) {
        AtomicInteger deletedExecutionCount = new AtomicInteger();
        Collection $this$toTypedArray$iv = this.getCompletedStatuses();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        List executionsToRemove = this.jooq.select((SelectField)DSL.field((String)"id")).from((TableLike)DSL.table((String)"orchestrations")).where(DSL.field((String)"application").eq((Object)application).and(DSL.field((String)"status").in((Object[])Arrays.copyOf(stringArray, stringArray.length)))).orderBy((OrderField)DSL.field((String)"build_time").desc()).limit(threshold, Integer.MAX_VALUE).fetch(DSL.field((String)"id"), String.class);
        this.getLog().debug("Found {} old orchestrations for {}", (Object)executionsToRemove.size(), (Object)application);
        Iterable $this$forEach$iv = this.pipelineDependencyCleanupOperators;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PipelineDependencyCleanupOperator it = (PipelineDependencyCleanupOperator)element$iv;
            boolean bl = false;
            it.cleanup(executionsToRemove);
        }
        List list = executionsToRemove;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"executionsToRemove");
        $this$forEach$iv = CollectionsKt.chunked((Iterable)list, (int)this.configurationProperties.getChunkSize());
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List ids = (List)element$iv;
            boolean bl = false;
            deletedExecutionCount.addAndGet(ids.size());
            this.executionRepository.delete(ExecutionType.ORCHESTRATION, ids);
            this.getRegistry().counter(this.getDeletedId().withTag("application", application)).add((double)ids.size());
        }
        return deletedExecutionCount.intValue();
    }

    public TopApplicationExecutionCleanupPollingNotificationAgent(@NotNull NotificationClusterLock clusterLock, @NotNull DSLContext jooq, @NotNull Registry registry, @NotNull ExecutionRepository executionRepository, @NotNull TopApplicationExecutionCleanupAgentConfigurationProperties configurationProperties, @NotNull OrcaSqlProperties orcaSqlProperties, @NotNull List<? extends PipelineDependencyCleanupOperator> pipelineDependencyCleanupOperators) {
        Intrinsics.checkNotNullParameter((Object)clusterLock, (String)"clusterLock");
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)executionRepository, (String)"executionRepository");
        Intrinsics.checkNotNullParameter((Object)configurationProperties, (String)"configurationProperties");
        Intrinsics.checkNotNullParameter((Object)orcaSqlProperties, (String)"orcaSqlProperties");
        Intrinsics.checkNotNullParameter(pipelineDependencyCleanupOperators, (String)"pipelineDependencyCleanupOperators");
        super(clusterLock, configurationProperties.getIntervalMs(), registry);
        this.jooq = jooq;
        this.executionRepository = executionRepository;
        this.configurationProperties = configurationProperties;
        this.orcaSqlProperties = orcaSqlProperties;
        this.pipelineDependencyCleanupOperators = pipelineDependencyCleanupOperators;
    }
}

