/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.sql.pipeline.persistence;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.sql.pipeline.persistence.JooqKt;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J$\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\f0\u0014H\u0002R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/netflix/spinnaker/orca/sql/pipeline/persistence/ExecutionMapper;", "", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "stageBatchSize", "", "(Lcom/fasterxml/jackson/databind/ObjectMapper;I)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "map", "", "Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution;", "rs", "Ljava/sql/ResultSet;", "context", "Lorg/jooq/DSLContext;", "mapStage", "", "executions", "", "", "orca-sql"})
public final class ExecutionMapper {
    private final Logger log;
    private final ObjectMapper mapper;
    private final int stageBatchSize;

    @NotNull
    public final Collection<PipelineExecution> map(@NotNull ResultSet rs, @NotNull DSLContext context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean bl2 = false;
        List results = new ArrayList();
        boolean bl3 = false;
        Map executionMap = new LinkedHashMap();
        boolean bl4 = false;
        Map legacyMap = new LinkedHashMap();
        while (rs.next()) {
            String content$iv;
            Object $this$readValue$iv;
            ObjectMapper objectMapper = this.mapper;
            Intrinsics.checkNotNullExpressionValue((Object)rs.getString("body"), (String)"rs.getString(\"body\")");
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            $this$readValue$iv = $this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<PipelineExecution>(){});
            bl = false;
            boolean bl5 = false;
            PipelineExecution execution = (PipelineExecution)$this$readValue$iv;
            boolean bl6 = false;
            results.add(execution);
            execution.setPartition(rs.getString("partition"));
            if (Intrinsics.areEqual((Object)rs.getString("id"), (Object)execution.getId()) ^ true) {
                String string = execution.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"execution.id");
                String string2 = rs.getString("id");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"rs.getString(\"id\")");
                legacyMap.put(string, string2);
                String string3 = rs.getString("id");
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"rs.getString(\"id\")");
                executionMap.put(string3, execution);
                continue;
            }
            String string = execution.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"execution.id");
            executionMap.put(string, execution);
        }
        Collection $this$readValue$iv = results;
        bl = false;
        if (!$this$readValue$iv.isEmpty()) {
            ExecutionType executionType = ((PipelineExecution)results.get(0)).getType();
            Intrinsics.checkNotNullExpressionValue((Object)executionType, (String)"results[0].type");
            ExecutionType type = executionType;
            CollectionsKt.chunked((Iterable)results, (int)this.stageBatchSize, (Function1)((Function1)new Function1<List<? extends PipelineExecution>, Unit>(this, legacyMap, context, type, executionMap){
                final /* synthetic */ ExecutionMapper this$0;
                final /* synthetic */ Map $legacyMap;
                final /* synthetic */ DSLContext $context;
                final /* synthetic */ ExecutionType $type;
                final /* synthetic */ Map $executionMap;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull List<? extends PipelineExecution> executions) {
                    void $this$mapTo$iv$iv;
                    Intrinsics.checkNotNullParameter(executions, (String)"executions");
                    Object $this$map$iv = executions;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        String string;
                        void it;
                        PipelineExecution pipelineExecution = (PipelineExecution)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        if (this.$legacyMap.containsKey(it.getId())) {
                            V v = this.$legacyMap.get(it.getId());
                            Intrinsics.checkNotNull(v);
                            string = (String)v;
                        } else {
                            string = it.getId();
                        }
                        String string2 = string;
                        collection.add(string2);
                    }
                    List executionIds = (List)destination$iv$iv;
                    $this$map$iv = JooqKt.selectExecutionStages(this.$context, this.$type, executionIds);
                    $i$f$map = false;
                    boolean bl = false;
                    Object stageResultSet = $this$map$iv;
                    boolean bl2 = false;
                    while (stageResultSet.next()) {
                        Object object = stageResultSet;
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"stageResultSet");
                        ExecutionMapper.access$mapStage(this.this$0, (ResultSet)object, this.$executionMap);
                    }
                    Iterable $this$forEach$iv = executions;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        List $this$sortBy$iv;
                        PipelineExecution execution = (PipelineExecution)element$iv;
                        boolean bl3 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)execution.getStages(), (String)"execution.stages");
                        boolean $i$f$sortBy = false;
                        if ($this$sortBy$iv.size() <= 1) continue;
                        boolean bl4 = false;
                        CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator<T>(){

                            public final int compare(T a, T b) {
                                boolean bl = false;
                                StageExecution it = (StageExecution)a;
                                boolean bl2 = false;
                                StageExecution stageExecution = it;
                                Intrinsics.checkNotNullExpressionValue((Object)stageExecution, (String)"it");
                                it = (StageExecution)b;
                                Comparable comparable = (Comparable)((Object)stageExecution.getRefId());
                                bl2 = false;
                                StageExecution stageExecution2 = it;
                                Intrinsics.checkNotNullExpressionValue((Object)stageExecution2, (String)"it");
                                String string = stageExecution2.getRefId();
                                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
                            }
                        });
                    }
                }
                {
                    this.this$0 = executionMapper;
                    this.$legacyMap = map2;
                    this.$context = dSLContext;
                    this.$type = executionType;
                    this.$executionMap = map3;
                    super(1);
                }
            }));
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    private final void mapStage(ResultSet rs, Map<String, ? extends PipelineExecution> executions) {
        void $this$apply;
        void $this$readValue$iv;
        String executionId;
        String string = executionId = rs.getString("execution_id");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"executionId");
        List list = ((PipelineExecution)MapsKt.getValue(executions, (Object)string)).getStages();
        Object object = this.mapper;
        String string2 = rs.getString("body");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"rs.getString(\"body\")");
        String content$iv = string2;
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef22 = false;
        object = $this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<StageExecution>(){});
        boolean bl = false;
        boolean bl2 = false;
        StageExecution $i$f$jacksonTypeRef22 = (StageExecution)object;
        List list2 = list;
        boolean bl3 = false;
        $this$apply.setExecution((PipelineExecution)MapsKt.getValue(executions, (Object)executionId));
        Unit unit = Unit.INSTANCE;
        list2.add(object);
    }

    public ExecutionMapper(@NotNull ObjectMapper mapper, int stageBatchSize) {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.mapper = mapper;
        this.stageBatchSize = stageBatchSize;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public static final /* synthetic */ void access$mapStage(ExecutionMapper $this, ResultSet rs, Map executions) {
        $this.mapStage(rs, executions);
    }
}

