/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.sql.pipeline.persistence;

import com.netflix.spinnaker.kork.core.RetrySupport;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.sql.pipeline.persistence.JooqKt;
import com.netflix.spinnaker.orca.sql.pipeline.persistence.JooqKt$WhenMappings;
import de.huxhorn.sulky.ulid.ULID;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.TransactionalRunnable;
import org.jooq.impl.DSL;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a*\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\r*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0000\u001a\u0014\u0010\u0013\u001a\n \u000e*\u0004\u0018\u00010\u00140\u0014*\u00020\u000bH\u0000\u001a(\u0010\u0015\u001a\u00020\u0016*\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00160\u001aH\u0000\"\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006\u001b"}, d2={"stagesTableName", "Lorg/jooq/Table;", "Lorg/jooq/Record;", "Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "getStagesTableName", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;)Lorg/jooq/Table;", "tableName", "getTableName", "isULID", "", "id", "", "selectExecutionStages", "Ljava/sql/ResultSet;", "kotlin.jvm.PlatformType", "Lorg/jooq/DSLContext;", "executionType", "executionIds", "", "toWhereCondition", "Lorg/jooq/Condition;", "transactional", "", "retrySupport", "Lcom/netflix/spinnaker/kork/core/RetrySupport;", "fn", "Lkotlin/Function1;", "orca-sql"})
public final class JooqKt {
    public static final void transactional(@NotNull DSLContext $this$transactional, @NotNull RetrySupport retrySupport, @NotNull Function1<? super DSLContext, Unit> fn) {
        Intrinsics.checkNotNullParameter((Object)$this$transactional, (String)"$this$transactional");
        Intrinsics.checkNotNullParameter((Object)retrySupport, (String)"retrySupport");
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        retrySupport.retry((Supplier)new Supplier<Unit>($this$transactional, fn){
            final /* synthetic */ DSLContext $this_transactional;
            final /* synthetic */ Function1 $fn;

            public final void get() {
                this.$this_transactional.transaction(new TransactionalRunnable(this){
                    final /* synthetic */ transactional.1 this$0;

                    public final void run(Configuration ctx) {
                        Function1 function1 = this.this$0.$fn;
                        DSLContext dSLContext = DSL.using((Configuration)ctx);
                        Intrinsics.checkNotNullExpressionValue((Object)dSLContext, (String)"DSL.using(ctx)");
                        function1.invoke((Object)dSLContext);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$this_transactional = dSLContext;
                this.$fn = function1;
            }
        }, 5, 100L, false);
    }

    public static final Condition toWhereCondition(@NotNull String $this$toWhereCondition) {
        Intrinsics.checkNotNullParameter((Object)$this$toWhereCondition, (String)"$this$toWhereCondition");
        return JooqKt.isULID($this$toWhereCondition) ? DSL.field((String)"id").eq((Object)$this$toWhereCondition) : DSL.field((String)"legacy_id").eq((Object)$this$toWhereCondition);
    }

    public static final boolean isULID(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        try {
            if (id.length() == 26) {
                ULID.parseULID((String)id);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @NotNull
    public static final Table<Record> getTableName(@NotNull ExecutionType $this$tableName) {
        Table table;
        Intrinsics.checkNotNullParameter((Object)$this$tableName, (String)"$this$tableName");
        switch (JooqKt$WhenMappings.$EnumSwitchMapping$0[$this$tableName.ordinal()]) {
            case 1: {
                Table table2 = DSL.table((String)"pipelines");
                table = table2;
                Intrinsics.checkNotNullExpressionValue((Object)table2, (String)"DSL.table(\"pipelines\")");
                break;
            }
            case 2: {
                Table table3 = DSL.table((String)"orchestrations");
                table = table3;
                Intrinsics.checkNotNullExpressionValue((Object)table3, (String)"DSL.table(\"orchestrations\")");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return table;
    }

    @NotNull
    public static final Table<Record> getStagesTableName(@NotNull ExecutionType $this$stagesTableName) {
        Table table;
        Intrinsics.checkNotNullParameter((Object)$this$stagesTableName, (String)"$this$stagesTableName");
        switch (JooqKt$WhenMappings.$EnumSwitchMapping$1[$this$stagesTableName.ordinal()]) {
            case 1: {
                Table table2 = DSL.table((String)"pipeline_stages");
                table = table2;
                Intrinsics.checkNotNullExpressionValue((Object)table2, (String)"DSL.table(\"pipeline_stages\")");
                break;
            }
            case 2: {
                Table table3 = DSL.table((String)"orchestration_stages");
                table = table3;
                Intrinsics.checkNotNullExpressionValue((Object)table3, (String)"DSL.table(\"orchestration_stages\")");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return table;
    }

    public static final ResultSet selectExecutionStages(@NotNull DSLContext $this$selectExecutionStages, @NotNull ExecutionType executionType, @NotNull Collection<String> executionIds) {
        Intrinsics.checkNotNullParameter((Object)$this$selectExecutionStages, (String)"$this$selectExecutionStages");
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter(executionIds, (String)"executionIds");
        Collection<String> $this$toTypedArray$iv = executionIds;
        boolean $i$f$toTypedArray = false;
        Collection<String> thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return $this$selectExecutionStages.select((SelectField)DSL.field((String)"execution_id"), (SelectField)DSL.field((String)"body")).from((TableLike)JooqKt.getStagesTableName(executionType)).where(DSL.field((String)"execution_id").in((Object[])Arrays.copyOf(stringArray, stringArray.length))).fetch().intoResultSet();
    }
}

