/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.sql.pipeline.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003BC\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012 \u0010\b\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0012H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0017R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00018\u0001X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/netflix/spinnaker/orca/sql/pipeline/persistence/PagedIterator;", "T", "C", "", "pageSize", "", "toCursor", "Lkotlin/Function1;", "nextPage", "Lkotlin/Function2;", "", "(ILkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)V", "currentPage", "", "cursor", "Ljava/lang/Object;", "index", "isLastPage", "", "hasNext", "loadNextChunkIfNecessary", "", "next", "()Ljava/lang/Object;", "orca-sql"})
public final class PagedIterator<T, C>
implements Iterator<T>,
KMappedMarker {
    private C cursor;
    private final List<T> currentPage;
    private int index;
    private boolean isLastPage;
    private final int pageSize;
    private final Function1<T, C> toCursor;
    private final Function2<Integer, C, Iterable<T>> nextPage;

    @Override
    public boolean hasNext() {
        boolean bl;
        if (this.isLastPage && this.index > CollectionsKt.getLastIndex(this.currentPage)) {
            bl = false;
        } else {
            this.loadNextChunkIfNecessary();
            bl = this.index <= CollectionsKt.getLastIndex(this.currentPage);
        }
        return bl;
    }

    @Override
    public T next() {
        if (this.isLastPage && this.index > CollectionsKt.getLastIndex(this.currentPage)) {
            throw (Throwable)new NoSuchElementException();
        }
        this.loadNextChunkIfNecessary();
        int n = this.index;
        this.index = n + 1;
        return this.currentPage.get(n);
    }

    private final void loadNextChunkIfNecessary() {
        int n = this.index;
        if (0 > n || ((Collection)this.currentPage).size() <= n) {
            Object object;
            this.currentPage.clear();
            Object object2 = this.nextPage.invoke((Object)this.pageSize, this.cursor);
            List<T> list = this.currentPage;
            boolean bl = false;
            boolean bl2 = false;
            Iterable p1 = (Iterable)object2;
            boolean bl3 = false;
            CollectionsKt.addAll((Collection)list, (Iterable)p1);
            this.index = 0;
            Object object3 = CollectionsKt.lastOrNull(this.currentPage);
            if (object3 != null) {
                object2 = object3;
                list = this.toCursor;
                bl = false;
                bl2 = false;
                object = list.invoke(object2);
            } else {
                object = null;
            }
            this.cursor = object;
            this.isLastPage = this.currentPage.size() < this.pageSize;
        }
    }

    public PagedIterator(int pageSize, @NotNull Function1<? super T, ? extends C> toCursor, @NotNull Function2<? super Integer, ? super C, ? extends Iterable<? extends T>> nextPage) {
        Intrinsics.checkNotNullParameter(toCursor, (String)"toCursor");
        Intrinsics.checkNotNullParameter(nextPage, (String)"nextPage");
        this.pageSize = pageSize;
        this.toCursor = toCursor;
        this.nextPage = nextPage;
        boolean bl = false;
        this.currentPage = new ArrayList();
        this.index = -1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

