/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.sql.pipeline.persistence;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.kork.core.RetrySupport;
import com.netflix.spinnaker.kork.exceptions.ConfigurationException;
import com.netflix.spinnaker.kork.exceptions.SystemException;
import com.netflix.spinnaker.kork.sql.config.RetryProperties;
import com.netflix.spinnaker.kork.sql.routing.NamedDatabaseContextHolder;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.Trigger;
import com.netflix.spinnaker.orca.api.pipeline.persistence.ExecutionRepositoryListener;
import com.netflix.spinnaker.orca.interlink.Interlink;
import com.netflix.spinnaker.orca.interlink.events.CancelInterlinkEvent;
import com.netflix.spinnaker.orca.interlink.events.DeleteInterlinkEvent;
import com.netflix.spinnaker.orca.interlink.events.InterlinkEvent;
import com.netflix.spinnaker.orca.interlink.events.PatchStageInterlinkEvent;
import com.netflix.spinnaker.orca.interlink.events.PauseInterlinkEvent;
import com.netflix.spinnaker.orca.interlink.events.RestartStageInterlinkEvent;
import com.netflix.spinnaker.orca.interlink.events.ResumeInterlinkEvent;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionNotFoundException;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.pipeline.persistence.UnpausablePipelineException;
import com.netflix.spinnaker.orca.pipeline.persistence.UnresumablePipelineException;
import com.netflix.spinnaker.orca.sql.pipeline.persistence.ActiveExecutionsReport;
import com.netflix.spinnaker.orca.sql.pipeline.persistence.ExecutionMapper;
import com.netflix.spinnaker.orca.sql.pipeline.persistence.ExecutionStatisticsRepository;
import com.netflix.spinnaker.orca.sql.pipeline.persistence.ForeignExecutionException;
import com.netflix.spinnaker.orca.sql.pipeline.persistence.JooqKt;
import com.netflix.spinnaker.orca.sql.pipeline.persistence.PagedIterator;
import com.netflix.spinnaker.orca.sql.pipeline.persistence.SqlExecutionRepository;
import com.netflix.spinnaker.orca.sql.pipeline.persistence.SqlExecutionRepository$WhenMappings;
import com.netflix.spinnaker.orca.sql.pipeline.persistence.SqlExecutionRepository$retrievePipelinesForApplication$;
import de.huxhorn.sulky.ulid.SpinULID;
import java.security.SecureRandom;
import java.sql.ResultSet;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.DatePart;
import org.jooq.DeleteConditionStep;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.InsertValuesStep2;
import org.jooq.InsertValuesStep3;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Record2;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectConnectByStep;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectForUpdateStep;
import org.jooq.SelectJoinStep;
import org.jooq.SelectLimitPercentStep;
import org.jooq.SelectLimitStep;
import org.jooq.SelectSeekStep1;
import org.jooq.SelectWhereStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.TransactionalRunnable;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.exception.TooManyRowsException;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0093\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t*\u00014\u0018\u0000 \u0095\u00012\u00020\u00012\u00020\u0002:\u0004\u0095\u0001\u0096\u0001Ba\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0004H\u0016J,\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010\u00042\b\u0010!\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u0010\"\u001a\u00020\u0019H\u0002J\b\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0004H\u0016J\u001e\u0010%\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040'H\u0016J&\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040'H\u0002JF\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020,26\u0010-\u001a2\u0012\u0013\u0012\u00110/\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\b(2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\b()\u0012\u0004\u0012\u00020\u00190.J/\u00103\u001a\u0002042 \u00105\u001a\u001c\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020/060.H\u0002\u00a2\u0006\u0002\u00107J\n\u00108\u001a\u0004\u0018\u00010\u0004H\u0016J\u0018\u00109\u001a\u00020:2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0004H\u0016J\u0018\u0010;\u001a\u00020:2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0004H\u0016J\"\u0010<\u001a\u00020:2\u0006\u0010=\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\b\b\u0002\u0010>\u001a\u00020:H\u0002J\u001a\u0010<\u001a\u00020:2\u0006\u00102\u001a\u00020/2\b\b\u0002\u0010>\u001a\u00020:H\u0002JE\u0010?\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040@2\u0006\u0010A\u001a\u00020\u00062\f\u0010B\u001a\b\u0012\u0004\u0012\u00020D0C2\u0006\u0010\u001f\u001a\u00020\u00042\n\b\u0002\u0010E\u001a\u0004\u0018\u00010FH\u0002\u00a2\u0006\u0002\u0010GJ\"\u0010H\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010\u0004H\u0016J\u0018\u0010I\u001a\u00020\u00192\u0006\u00102\u001a\u00020/2\u0006\u0010J\u001a\u00020\u0004H\u0016J\u0018\u0010K\u001a\u00020\u00192\u0006\u0010L\u001a\u00020\u00042\u0006\u0010J\u001a\u00020\u0004H\u0016J\"\u0010M\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010\u0004H\u0016J*\u0010M\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010\u00042\u0006\u0010N\u001a\u00020:H\u0016J\u0016\u0010O\u001a\b\u0012\u0004\u0012\u00020/0P2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001e\u0010O\u001a\b\u0012\u0004\u0012\u00020/0P2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010Q\u001a\u00020RH\u0016J(\u0010O\u001a\b\u0012\u0004\u0012\u00020/0P2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010Q\u001a\u00020R2\b\u0010S\u001a\u0004\u0018\u00010\u0004H\u0002J\u0018\u0010O\u001a\u00020/2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0004H\u0016J\u0018\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00040'2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J \u0010T\u001a\b\u0012\u0004\u0012\u00020\u00040'2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010U\u001a\u00020\fH\u0016J\u0016\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00040W2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J4\u0010X\u001a\b\u0012\u0004\u0012\u00020/0'2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00040'2\u0006\u0010Z\u001a\u00020F2\u0006\u0010[\u001a\u00020F2\u0006\u0010\\\u001a\u00020RH\u0016J\u000e\u0010]\u001a\b\u0012\u0004\u0012\u00020/0WH\u0016J\u0018\u0010^\u001a\u00020/2\u0006\u0010=\u001a\u00020\u001e2\u0006\u0010_\u001a\u00020\u0004H\u0016J\u0010\u0010`\u001a\u00020/2\u0006\u0010_\u001a\u00020\u0004H\u0016J\u001e\u0010a\u001a\b\u0012\u0004\u0012\u00020/0P2\u0006\u0010b\u001a\u00020\u00042\u0006\u0010Q\u001a\u00020RH\u0016J(\u0010a\u001a\b\u0012\u0004\u0012\u00020/0W2\u0006\u0010b\u001a\u00020\u00042\u0006\u0010Q\u001a\u00020R2\b\u0010c\u001a\u0004\u0018\u00010dH\u0016J\u0010\u0010e\u001a\u00020/2\u0006\u0010_\u001a\u00020\u0004H\u0016J\u0016\u0010f\u001a\b\u0012\u0004\u0012\u00020/0P2\u0006\u0010b\u001a\u00020\u0004H\u0016J\u001e\u0010g\u001a\b\u0012\u0004\u0012\u00020/0P2\u0006\u0010h\u001a\u00020\u00042\u0006\u0010Q\u001a\u00020RH\u0016J4\u0010i\u001a\b\u0012\u0004\u0012\u00020/0'2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00040'2\u0006\u0010Z\u001a\u00020F2\u0006\u0010[\u001a\u00020F2\u0006\u0010\\\u001a\u00020RH\u0016J,\u0010j\u001a\u0004\u0018\u00010/2\u0006\u0010A\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\b\b\u0002\u0010k\u001a\u00020:H\u0002JL\u0010l\u001a\b\u0012\u0004\u0012\u00020/0\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010m\u001a\u00020\f2\b\u0010n\u001a\u0004\u0018\u00010\u00042\"\b\u0002\u0010o\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020D0q\u0012\n\u0012\b\u0012\u0004\u0012\u00020D0r\u0018\u00010pH\u0002J2\u0010s\u001a,\u0012(\u0012&\u0012\f\u0012\n \u0017*\u0004\u0018\u00010u0u \u0017*\u0012\u0012\f\u0012\n \u0017*\u0004\u0018\u00010u0u\u0018\u00010t0t0'H\u0002J\u0010\u0010v\u001a\u00020\u00192\u0006\u00102\u001a\u00020/H\u0016J\u0018\u0010w\u001a\u00020\u00192\u0006\u0010A\u001a\u00020\u00062\u0006\u00102\u001a\u00020/H\u0002J\"\u0010x\u001a\u00020\u00192\u0006\u0010A\u001a\u00020\u00062\u0006\u00102\u001a\u00020/2\b\b\u0002\u0010y\u001a\u00020:H\u0002J\u0010\u0010z\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J.\u0010{\u001a\u00020\u00192\u0006\u0010A\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010L\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010|\u001a\u00020:H\u0002J\u0010\u0010}\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J!\u0010~\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\u0007\u0010\u007f\u001a\u00030\u0080\u0001H\u0016J\u0010\u0010~\u001a\u00020\u00192\u0006\u00102\u001a\u00020/H\u0016Jf\u0010\u0081\u0001\u001a\u00020\u00192\u0006\u0010A\u001a\u00020\u00062\f\u0010B\u001a\b\u0012\u0004\u0012\u00020D0C2\u001e\u0010\u0082\u0001\u001a\u0019\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010u0t\u0012\u0006\u0012\u0004\u0018\u00010u0\u0083\u00012\u001c\u0010\u0084\u0001\u001a\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020u0t\u0012\u0006\u0012\u0004\u0018\u00010u0\u0083\u00012\u0007\u0010\u0085\u0001\u001a\u00020\u0004H\u0002J\u0011\u0010\u0086\u0001\u001a\u00020:2\u0006\u00102\u001a\u00020/H\u0002J$\u0010\u0087\u0001\u001a\u00020\u00192\u0019\u0010\u0088\u0001\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00190p\u00a2\u0006\u0003\b\u0089\u0001H\u0002J\u0018\u0010\u008a\u0001\u001a\u0004\u0018\u00010/*\u000b\u0012\u0006\b\u0001\u0012\u00020D0\u008b\u0001H\u0002J\u001b\u00103\u001a\b\u0012\u0004\u0012\u00020/0\u0012*\u000b\u0012\u0006\b\u0001\u0012\u00020D0\u008b\u0001H\u0002JO\u0010j\u001a&\u0012\f\u0012\n \u0017*\u0004\u0018\u00010D0D \u0017*\u0012\u0012\f\u0012\n \u0017*\u0004\u0018\u00010D0D\u0018\u00010q0q*\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\u0015\b\u0002\u0010\u008c\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020u0t0'H\u0002J\u007f\u0010l\u001a\u000b\u0012\u0006\b\u0001\u0012\u00020D0\u008b\u0001*\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\u0015\b\u0002\u0010\u008c\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020u0t0'2\"\u0010\u008d\u0001\u001a\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020D0q\u0012\r\u0012\u000b\u0012\u0006\b\u0001\u0012\u00020D0\u008e\u00010p2%\u0010\u008f\u0001\u001a \u0012\r\u0012\u000b\u0012\u0006\b\u0001\u0012\u00020D0\u008e\u0001\u0012\r\u0012\u000b\u0012\u0006\b\u0001\u0012\u00020D0\u008b\u00010pH\u0002J\u0088\u0001\u0010l\u001a\u000b\u0012\u0006\b\u0001\u0012\u00020D0\u008b\u0001*\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\u0015\b\u0002\u0010\u008c\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020u0t0'2\u0007\u0010\u0090\u0001\u001a\u00020\u00042\"\u0010\u008d\u0001\u001a\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020D0q\u0012\r\u0012\u000b\u0012\u0006\b\u0001\u0012\u00020D0\u008e\u00010p2%\u0010\u008f\u0001\u001a \u0012\r\u0012\u000b\u0012\u0006\b\u0001\u0012\u00020D0\u008e\u0001\u0012\r\u0012\u000b\u0012\u0006\b\u0001\u0012\u00020D0\u008b\u00010pH\u0002J/\u0010\u0091\u0001\u001a\u000b\u0012\u0006\b\u0001\u0012\u00020D0\u008e\u0001*\u000b\u0012\u0006\b\u0001\u0012\u00020D0\u008e\u00012\u000e\u0010\u0092\u0001\u001a\t\u0012\u0005\u0012\u00030\u0080\u00010\u0012H\u0002J\"\u0010\u0093\u0001\u001a\u00020\u0019*\u00020\u00062\u0013\u0010\u0094\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00190pH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0097\u0001"}, d2={"Lcom/netflix/spinnaker/orca/sql/pipeline/persistence/SqlExecutionRepository;", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "Lcom/netflix/spinnaker/orca/sql/pipeline/persistence/ExecutionStatisticsRepository;", "partitionName", "", "jooq", "Lorg/jooq/DSLContext;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "retryProperties", "Lcom/netflix/spinnaker/kork/sql/config/RetryProperties;", "batchReadSize", "", "stageReadSize", "poolName", "interlink", "Lcom/netflix/spinnaker/orca/interlink/Interlink;", "executionRepositoryListeners", "", "Lcom/netflix/spinnaker/orca/api/pipeline/persistence/ExecutionRepositoryListener;", "(Ljava/lang/String;Lorg/jooq/DSLContext;Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/netflix/spinnaker/kork/sql/config/RetryProperties;IILjava/lang/String;Lcom/netflix/spinnaker/orca/interlink/Interlink;Ljava/util/Collection;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "addStage", "", "stage", "Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;", "cancel", "type", "Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "id", "user", "reason", "cleanupOldDeletedExecutions", "countActiveExecutions", "Lcom/netflix/spinnaker/orca/sql/pipeline/persistence/ActiveExecutionsReport;", "delete", "idsToDelete", "", "deleteInternal", "dslContext", "doForeignAware", "event", "Lcom/netflix/spinnaker/orca/interlink/events/InterlinkEvent;", "block", "Lkotlin/Function2;", "Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution;", "Lkotlin/ParameterName;", "name", "execution", "fetchExecutions", "com/netflix/spinnaker/orca/sql/pipeline/persistence/SqlExecutionRepository$fetchExecutions$1", "nextPage", "", "(Lkotlin/jvm/functions/Function2;)Lcom/netflix/spinnaker/orca/sql/pipeline/persistence/SqlExecutionRepository$fetchExecutions$1;", "getPartition", "hasExecution", "", "isCanceled", "isForeign", "executionType", "shouldThrow", "mapLegacyId", "Lkotlin/Pair;", "ctx", "table", "Lorg/jooq/Table;", "Lorg/jooq/Record;", "timestamp", "", "(Lorg/jooq/DSLContext;Lorg/jooq/Table;Ljava/lang/String;Ljava/lang/Long;)Lkotlin/Pair;", "pause", "removeStage", "stageId", "restartStage", "executionId", "resume", "ignoreCurrentStatus", "retrieve", "Lrx/Observable;", "criteria", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository$ExecutionCriteria;", "partition", "retrieveAllApplicationNames", "minExecutions", "retrieveAllExecutionIds", "", "retrieveAllPipelinesForPipelineConfigIdsBetweenBuildTimeBoundary", "pipelineConfigIds", "buildTimeStartBoundary", "buildTimeEndBoundary", "executionCriteria", "retrieveBufferedExecutions", "retrieveByCorrelationId", "correlationId", "retrieveOrchestrationForCorrelationId", "retrieveOrchestrationsForApplication", "application", "sorter", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository$ExecutionComparator;", "retrievePipelineForCorrelationId", "retrievePipelinesForApplication", "retrievePipelinesForPipelineConfigId", "pipelineConfigId", "retrievePipelinesForPipelineConfigIdsBetweenBuildTimeBoundary", "selectExecution", "forUpdate", "selectExecutions", "limit", "cursor", "where", "Lkotlin/Function1;", "Lorg/jooq/SelectJoinStep;", "Lorg/jooq/SelectConditionStep;", "selectFields", "Lorg/jooq/Field;", "", "store", "storeCorrelationIdInternal", "storeExecutionInternal", "storeStages", "storeStage", "storeStageInternal", "notifyListener", "updateStageContext", "updateStatus", "status", "Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionStatus;", "upsert", "insertPairs", "", "updatePairs", "updateId", "validateHandledPartitionOrThrow", "withListener", "callback", "Lkotlin/ExtensionFunctionType;", "fetchExecution", "Lorg/jooq/SelectForUpdateStep;", "fields", "conditions", "Lorg/jooq/SelectConnectByStep;", "seek", "usingIndex", "statusIn", "statuses", "transactional", "fn", "Companion", "SyntheticStageRequired", "orca-sql"})
public final class SqlExecutionRepository
implements ExecutionRepository,
ExecutionStatisticsRepository {
    private final Logger log;
    private final String partitionName;
    private final DSLContext jooq;
    private final ObjectMapper mapper;
    private final RetryProperties retryProperties;
    private final int batchReadSize;
    private final int stageReadSize;
    private final String poolName;
    private final Interlink interlink;
    private final Collection<ExecutionRepositoryListener> executionRepositoryListeners;
    @NotNull
    private static final SpinULID ulid;
    @NotNull
    private static final RetrySupport retrySupport;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(@NotNull PipelineExecution execution) {
        Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            this.transactional(this.jooq, (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(this, execution){
                final /* synthetic */ SqlExecutionRepository this$0;
                final /* synthetic */ PipelineExecution $execution$inlined;
                {
                    this.this$0 = sqlExecutionRepository;
                    this.$execution$inlined = pipelineExecution;
                    super(1);
                }

                public final void invoke(@NotNull DSLContext it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    SqlExecutionRepository.access$storeExecutionInternal(this.this$0, it, this.$execution$inlined, true);
                }
            }));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    public void storeStage(@NotNull StageExecution stage) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        PipelineExecution pipelineExecution = stage.getExecution();
        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"stage.execution");
        ExecutionType executionType = pipelineExecution.getType();
        PipelineExecution pipelineExecution2 = stage.getExecution();
        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution2, (String)"stage.execution");
        this.doForeignAware((InterlinkEvent)new PatchStageInterlinkEvent(executionType, pipelineExecution2.getId(), stage.getId(), this.mapper.writeValueAsString((Object)stage)), (Function2<? super PipelineExecution, ? super DSLContext, Unit>)((Function2)new Function2<PipelineExecution, DSLContext, Unit>(this, stage){
            final /* synthetic */ SqlExecutionRepository this$0;
            final /* synthetic */ StageExecution $stage;

            public final void invoke(@NotNull PipelineExecution $noName_0, @NotNull DSLContext dslContext) {
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)dslContext, (String)"dslContext");
                SqlExecutionRepository.access$transactional(this.this$0, SqlExecutionRepository.access$getJooq$p(this.this$0), (Function1)new Function1<DSLContext, Unit>(this, dslContext){
                    final /* synthetic */ storeStage.1 this$0;
                    final /* synthetic */ DSLContext $dslContext;

                    public final void invoke(@NotNull DSLContext it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        SqlExecutionRepository.storeStageInternal$default(this.this$0.this$0, this.$dslContext, this.this$0.$stage, null, false, 12, null);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$dslContext = dSLContext;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = sqlExecutionRepository;
                this.$stage = stageExecution;
                super(2);
            }
        }));
    }

    public void updateStageContext(@NotNull StageExecution stage) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        this.storeStage(stage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStage(@NotNull PipelineExecution execution, @NotNull String stageId) {
        Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
        Intrinsics.checkNotNullParameter((Object)stageId, (String)"stageId");
        this.validateHandledPartitionOrThrow(execution);
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            this.transactional(this.jooq, (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(this, execution, stageId){
                final /* synthetic */ SqlExecutionRepository this$0;
                final /* synthetic */ PipelineExecution $execution$inlined;
                final /* synthetic */ String $stageId$inlined;
                {
                    this.this$0 = sqlExecutionRepository;
                    this.$execution$inlined = pipelineExecution;
                    this.$stageId$inlined = string;
                    super(1);
                }

                public final void invoke(@NotNull DSLContext it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ExecutionType executionType = this.$execution$inlined.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)executionType, (String)"execution.type");
                    it.delete(JooqKt.getStagesTableName(executionType)).where(JooqKt.toWhereCondition(this.$stageId$inlined)).execute();
                }
            }));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    public void addStage(@NotNull StageExecution stage) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        if (stage.getSyntheticStageOwner() == null || stage.getParentStageId() == null) {
            throw (Throwable)new SyntheticStageRequired();
        }
        this.storeStage(stage);
    }

    public void cancel(@NotNull ExecutionType type, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.cancel(type, id, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doForeignAware(@NotNull InterlinkEvent event, @NotNull Function2<? super PipelineExecution, ? super DSLContext, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            this.transactional(this.jooq, (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(this, event, block){
                final /* synthetic */ SqlExecutionRepository this$0;
                final /* synthetic */ InterlinkEvent $event$inlined;
                final /* synthetic */ Function2 $block$inlined;
                {
                    this.this$0 = sqlExecutionRepository;
                    this.$event$inlined = interlinkEvent;
                    this.$block$inlined = function2;
                    super(1);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public final void invoke(@NotNull DSLContext dslContext) {
                    Intrinsics.checkNotNullParameter((Object)dslContext, (String)"dslContext");
                    ExecutionType executionType = this.$event$inlined.getExecutionType();
                    Intrinsics.checkNotNullExpressionValue((Object)executionType, (String)"event.executionType");
                    String string = this.$event$inlined.getExecutionId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.executionId");
                    PipelineExecution pipelineExecution = SqlExecutionRepository.selectExecution$default(this.this$0, dslContext, executionType, string, false, 8, null);
                    if (pipelineExecution == null) return;
                    PipelineExecution pipelineExecution2 = pipelineExecution;
                    boolean bl = false;
                    boolean bl2 = false;
                    PipelineExecution execution = pipelineExecution2;
                    boolean bl3 = false;
                    if (!SqlExecutionRepository.isForeign$default(this.this$0, execution, false, 2, null)) {
                        this.$block$inlined.invoke((Object)execution, (Object)dslContext);
                        return;
                    }
                    Interlink interlink = SqlExecutionRepository.access$getInterlink$p(this.this$0);
                    if (interlink != null) {
                        interlink.publish(this.$event$inlined.withPartition(execution.getPartition()));
                        return;
                    }
                    String string2 = this.$event$inlined.getExecutionId();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"event.executionId");
                    String string3 = execution.getPartition();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"execution.partition");
                    throw (Throwable)((Object)new ForeignExecutionException(string2, string3, SqlExecutionRepository.access$getPartitionName$p(this.this$0)));
                }
            }));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    public void cancel(@NotNull ExecutionType type, @NotNull String id, @Nullable String user, @Nullable String reason) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.doForeignAware((InterlinkEvent)new CancelInterlinkEvent(type, id, user, reason), (Function2<? super PipelineExecution, ? super DSLContext, Unit>)((Function2)new Function2<PipelineExecution, DSLContext, Unit>(this, user, reason){
            final /* synthetic */ SqlExecutionRepository this$0;
            final /* synthetic */ String $user;
            final /* synthetic */ String $reason;

            public final void invoke(@NotNull PipelineExecution execution, @NotNull DSLContext dslContext) {
                Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
                Intrinsics.checkNotNullParameter((Object)dslContext, (String)"dslContext");
                execution.setCanceled(true);
                if (this.$user != null) {
                    execution.setCanceledBy(this.$user);
                }
                if (this.$reason != null) {
                    CharSequence charSequence = this.$reason;
                    boolean bl = false;
                    if (charSequence.length() > 0) {
                        execution.setCancellationReason(this.$reason);
                    }
                }
                if (execution.getStatus() == ExecutionStatus.NOT_STARTED) {
                    execution.setStatus(ExecutionStatus.CANCELED);
                }
                SqlExecutionRepository.storeExecutionInternal$default(this.this$0, dslContext, execution, false, 4, null);
            }
            {
                this.this$0 = sqlExecutionRepository;
                this.$user = string;
                this.$reason = string2;
                super(2);
            }
        }));
    }

    public void pause(@NotNull ExecutionType type, @NotNull String id, @Nullable String user) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.doForeignAware((InterlinkEvent)new PauseInterlinkEvent(type, id, user), (Function2<? super PipelineExecution, ? super DSLContext, Unit>)((Function2)new Function2<PipelineExecution, DSLContext, Unit>(this, user){
            final /* synthetic */ SqlExecutionRepository this$0;
            final /* synthetic */ String $user;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull PipelineExecution execution, @NotNull DSLContext dslContext) {
                void $this$apply;
                Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
                Intrinsics.checkNotNullParameter((Object)dslContext, (String)"dslContext");
                if (execution.getStatus() != ExecutionStatus.RUNNING) {
                    throw (Throwable)new UnpausablePipelineException("Unable to pause pipeline that is not RUNNING " + "(executionId: " + execution.getId() + ", currentStatus: " + execution.getStatus() + ')');
                }
                execution.setStatus(ExecutionStatus.PAUSED);
                PipelineExecution.PausedDetails pausedDetails = new PipelineExecution.PausedDetails();
                boolean bl = false;
                boolean bl2 = false;
                PipelineExecution.PausedDetails pausedDetails2 = pausedDetails;
                PipelineExecution pipelineExecution = execution;
                boolean bl3 = false;
                $this$apply.setPausedBy(this.$user);
                $this$apply.setPauseTime(Long.valueOf(System.currentTimeMillis()));
                Unit unit = Unit.INSTANCE;
                pipelineExecution.setPaused(pausedDetails);
                SqlExecutionRepository.storeExecutionInternal$default(this.this$0, dslContext, execution, false, 4, null);
            }
            {
                this.this$0 = sqlExecutionRepository;
                this.$user = string;
                super(2);
            }
        }));
    }

    public void resume(@NotNull ExecutionType type, @NotNull String id, @Nullable String user) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.resume(type, id, user, false);
    }

    public void resume(@NotNull ExecutionType type, @NotNull String id, @Nullable String user, boolean ignoreCurrentStatus) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.doForeignAware((InterlinkEvent)new ResumeInterlinkEvent(type, id, user, Boolean.valueOf(ignoreCurrentStatus)), (Function2<? super PipelineExecution, ? super DSLContext, Unit>)((Function2)new Function2<PipelineExecution, DSLContext, Unit>(this, ignoreCurrentStatus, user){
            final /* synthetic */ SqlExecutionRepository this$0;
            final /* synthetic */ boolean $ignoreCurrentStatus;
            final /* synthetic */ String $user;

            public final void invoke(@NotNull PipelineExecution execution, @NotNull DSLContext dslContext) {
                Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
                Intrinsics.checkNotNullParameter((Object)dslContext, (String)"dslContext");
                if (!this.$ignoreCurrentStatus && execution.getStatus() != ExecutionStatus.PAUSED) {
                    throw (Throwable)new UnresumablePipelineException("Unable to resume pipeline that is not PAUSED " + "(executionId: " + execution.getId() + ", currentStatus: " + execution.getStatus());
                }
                execution.setStatus(ExecutionStatus.RUNNING);
                PipelineExecution.PausedDetails pausedDetails = execution.getPaused();
                if (pausedDetails != null) {
                    pausedDetails.setResumedBy(this.$user);
                }
                PipelineExecution.PausedDetails pausedDetails2 = execution.getPaused();
                if (pausedDetails2 != null) {
                    pausedDetails2.setResumeTime(Long.valueOf(System.currentTimeMillis()));
                }
                SqlExecutionRepository.storeExecutionInternal$default(this.this$0, dslContext, execution, false, 4, null);
            }
            {
                this.this$0 = sqlExecutionRepository;
                this.$ignoreCurrentStatus = bl;
                this.$user = string;
                super(2);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled(@NotNull ExecutionType type, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            boolean bl2 = this.jooq.fetchExists((Select)this.jooq.selectFrom(JooqKt.getTableName(type)).where(JooqKt.toWhereCondition(id)).and(DSL.field((String)"canceled").eq((Object)true)));
            return bl2;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    public void restartStage(@NotNull String executionId, @NotNull String stageId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)stageId, (String)"stageId");
        this.doForeignAware((InterlinkEvent)new RestartStageInterlinkEvent(ExecutionType.PIPELINE, executionId, stageId), (Function2<? super PipelineExecution, ? super DSLContext, Unit>)((Function2)new Function2<PipelineExecution, DSLContext, Unit>(this){
            final /* synthetic */ SqlExecutionRepository this$0;

            public final void invoke(@NotNull PipelineExecution $noName_0, @NotNull DSLContext $noName_1) {
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"<anonymous parameter 1>");
                SqlExecutionRepository.access$getLog$p(this.this$0).debug("restartStage is a no-op for local executions");
            }
            {
                this.this$0 = sqlExecutionRepository;
                super(2);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatus(@NotNull PipelineExecution execution) {
        Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            this.transactional(this.jooq, (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(this, execution){
                final /* synthetic */ SqlExecutionRepository this$0;
                final /* synthetic */ PipelineExecution $execution$inlined;
                {
                    this.this$0 = sqlExecutionRepository;
                    this.$execution$inlined = pipelineExecution;
                    super(1);
                }

                public final void invoke(@NotNull DSLContext it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    SqlExecutionRepository.storeExecutionInternal$default(this.this$0, it, this.$execution$inlined, false, 4, null);
                }
            }));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatus(@NotNull ExecutionType type, @NotNull String id, @NotNull ExecutionStatus status) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            this.transactional(this.jooq, (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(this, type, id, status){
                final /* synthetic */ SqlExecutionRepository this$0;
                final /* synthetic */ ExecutionType $type$inlined;
                final /* synthetic */ String $id$inlined;
                final /* synthetic */ ExecutionStatus $status$inlined;
                {
                    this.this$0 = sqlExecutionRepository;
                    this.$type$inlined = executionType;
                    this.$id$inlined = string;
                    this.$status$inlined = executionStatus;
                    super(1);
                }

                public final void invoke(@NotNull DSLContext it) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        PipelineExecution pipelineExecution = SqlExecutionRepository.selectExecution$default(this.this$0, it, this.$type$inlined, this.$id$inlined, false, 8, null);
                        if (pipelineExecution == null) break block0;
                        PipelineExecution pipelineExecution2 = pipelineExecution;
                        boolean bl = false;
                        boolean bl2 = false;
                        PipelineExecution execution = pipelineExecution2;
                        boolean bl3 = false;
                        execution.updateStatus(this.$status$inlined);
                        this.this$0.updateStatus(execution);
                    }
                }
            }));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    public void delete(@NotNull ExecutionType type, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.doForeignAware((InterlinkEvent)new DeleteInterlinkEvent(type, id), (Function2<? super PipelineExecution, ? super DSLContext, Unit>)((Function2)new Function2<PipelineExecution, DSLContext, Unit>(this, type, id){
            final /* synthetic */ SqlExecutionRepository this$0;
            final /* synthetic */ ExecutionType $type;
            final /* synthetic */ String $id;

            public final void invoke(@NotNull PipelineExecution $noName_0, @NotNull DSLContext dslContext) {
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)dslContext, (String)"dslContext");
                Pair pair = SqlExecutionRepository.mapLegacyId$default(this.this$0, dslContext, JooqKt.getTableName(this.$type), this.$id, null, 8, null);
                String ulid = (String)pair.component1();
                SqlExecutionRepository.access$deleteInternal(this.this$0, dslContext, this.$type, CollectionsKt.listOf((Object)ulid));
            }
            {
                this.this$0 = sqlExecutionRepository;
                this.$type = executionType;
                this.$id = string;
                super(2);
            }
        }));
        this.cleanupOldDeletedExecutions();
    }

    public void delete(@NotNull ExecutionType type, @NotNull List<String> idsToDelete) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(idsToDelete, (String)"idsToDelete");
        this.transactional(this.jooq, (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(this, type, idsToDelete){
            final /* synthetic */ SqlExecutionRepository this$0;
            final /* synthetic */ ExecutionType $type;
            final /* synthetic */ List $idsToDelete;

            public final void invoke(@NotNull DSLContext tx) {
                Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                SqlExecutionRepository.access$deleteInternal(this.this$0, tx, this.$type, this.$idsToDelete);
            }
            {
                this.this$0 = sqlExecutionRepository;
                this.$type = executionType;
                this.$idsToDelete = list;
                super(1);
            }
        }));
        this.cleanupOldDeletedExecutions();
    }

    private final void deleteInternal(DSLContext dslContext, ExecutionType type, List<String> idsToDelete) {
        String string;
        switch (SqlExecutionRepository$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                string = "pipeline_id";
                break;
            }
            case 2: {
                string = "orchestration_id";
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("Unexpected field " + type);
            }
        }
        String correlationField = string;
        Collection $this$toTypedArray$iv = idsToDelete;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        dslContext.delete(DSL.table((String)"correlation_ids")).where(DSL.field((String)correlationField).in((Object[])Arrays.copyOf(stringArray, stringArray.length))).execute();
        $this$toTypedArray$iv = idsToDelete;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        dslContext.delete(JooqKt.getStagesTableName(type)).where(DSL.field((String)"execution_id").in((Object[])Arrays.copyOf(stringArray2, stringArray2.length))).execute();
        $this$toTypedArray$iv = idsToDelete;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray3 = thisCollection$iv.toArray(new String[0]);
        if (stringArray3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        dslContext.delete(JooqKt.getTableName(type)).where(DSL.field((String)"id").in((Object[])Arrays.copyOf(stringArray3, stringArray3.length))).execute();
        InsertValuesStep3 insertQueryBuilder = dslContext.insertInto(DSL.table((String)"deleted_executions")).columns(DSL.field((String)"execution_id"), DSL.field((String)"execution_type"), DSL.field((String)"deleted_at"));
        Iterable $this$forEach$iv = idsToDelete;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String id = (String)element$iv;
            boolean bl = false;
            insertQueryBuilder = insertQueryBuilder.values((Object)id, (Object)type.toString(), (Object)DSL.now());
        }
        insertQueryBuilder.execute();
    }

    private final void cleanupOldDeletedExecutions() {
        try {
            List idsToDelete;
            List list = idsToDelete = this.jooq.select((SelectField)DSL.field((String)"id")).from((TableLike)DSL.table((String)"deleted_executions")).where(DSL.field((String)"deleted_at").lt((Object)DSL.timestampSub((Field)DSL.now(), (Number)1, (DatePart)DatePart.DAY))).fetch(DSL.field((String)"id"), Integer.TYPE);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"idsToDelete");
            Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)list, (int)25);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List chunk = (List)element$iv;
                boolean bl = false;
                Collection $this$toTypedArray$iv = chunk;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Integer[] integerArray = thisCollection$iv.toArray(new Integer[0]);
                if (integerArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                this.jooq.deleteFrom(DSL.table((String)"deleted_executions")).where(DSL.field((String)"id").in((Object[])Arrays.copyOf(integerArray, integerArray.length))).execute();
            }
        }
        catch (Exception e) {
            this.log.error("Failed to cleanup some deleted_executions", (Throwable)e);
        }
    }

    @NotNull
    public PipelineExecution retrieve(@NotNull ExecutionType type, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        PipelineExecution pipelineExecution = SqlExecutionRepository.selectExecution$default(this, this.jooq, type, id, false, 8, null);
        if (pipelineExecution == null) {
            throw (Throwable)new ExecutionNotFoundException("No " + type + " found for " + id);
        }
        return pipelineExecution;
    }

    @NotNull
    public Observable<PipelineExecution> retrieve(@NotNull ExecutionType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Observable observable = Observable.from((Iterable)this.fetchExecutions((Function2<? super Integer, ? super String, ? extends Iterable<? extends PipelineExecution>>)((Function2)new Function2<Integer, String, Iterable<? extends PipelineExecution>>(this, type){
            final /* synthetic */ SqlExecutionRepository this$0;
            final /* synthetic */ ExecutionType $type;

            @NotNull
            public final Iterable<PipelineExecution> invoke(int pageSize, @Nullable String cursor) {
                return SqlExecutionRepository.selectExecutions$default(this.this$0, this.$type, pageSize, cursor, null, 8, null);
            }
            {
                this.this$0 = sqlExecutionRepository;
                this.$type = executionType;
                super(2);
            }
        })));
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"Observable.from(\n      f\u2026ze, cursor)\n      }\n    )");
        return observable;
    }

    @NotNull
    public Observable<PipelineExecution> retrieve(@NotNull ExecutionType type, @NotNull ExecutionRepository.ExecutionCriteria criteria) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)criteria, (String)"criteria");
        return this.retrieve(type, criteria, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Observable<PipelineExecution> retrieve(ExecutionType type, ExecutionRepository.ExecutionCriteria criteria, String partition) {
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            SelectForUpdateStep<? extends Record> select = this.selectExecutions(this.jooq, type, CollectionsKt.plus((Collection)this.selectFields(), (Object)DSL.field((String)"status")), (Function1<? super SelectJoinStep<Record>, ? extends SelectConnectByStep<? extends Record>>)((Function1)new Function1<SelectJoinStep<Record>, SelectConnectByStep<? extends Record>>(this, type, partition, criteria){
                final /* synthetic */ SqlExecutionRepository this$0;
                final /* synthetic */ ExecutionType $type$inlined;
                final /* synthetic */ String $partition$inlined;
                final /* synthetic */ ExecutionRepository.ExecutionCriteria $criteria$inlined;
                {
                    this.this$0 = sqlExecutionRepository;
                    this.$type$inlined = executionType;
                    this.$partition$inlined = string;
                    this.$criteria$inlined = executionCriteria;
                    super(1);
                }

                @NotNull
                public final SelectConnectByStep<? extends Record> invoke(@NotNull SelectJoinStep<Record> it) {
                    SelectConnectByStep selectConnectByStep;
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    CharSequence charSequence = this.$partition$inlined;
                    boolean bl = false;
                    boolean bl2 = false;
                    if (charSequence == null || charSequence.length() == 0) {
                        SelectConnectByStep selectConnectByStep2 = (SelectConnectByStep)it;
                        Collection collection = this.$criteria$inlined.getStatuses();
                        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"criteria.statuses");
                        selectConnectByStep = SqlExecutionRepository.access$statusIn(this.this$0, selectConnectByStep2, collection);
                    } else {
                        SelectConditionStep selectConditionStep = it.where(DSL.field((Name)DSL.name((String)"partition")).eq((Object)this.$partition$inlined));
                        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"it.where(field(name(\"partition\")).eq(partition))");
                        SelectConnectByStep selectConnectByStep3 = (SelectConnectByStep)selectConditionStep;
                        Collection collection = this.$criteria$inlined.getStatuses();
                        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"criteria.statuses");
                        selectConnectByStep = SqlExecutionRepository.access$statusIn(this.this$0, selectConnectByStep3, collection);
                    }
                    return selectConnectByStep;
                }
            }), (Function1<? super SelectConnectByStep<? extends Record>, ? extends SelectForUpdateStep<? extends Record>>)((Function1)new Function1<SelectConnectByStep<? extends Record>, SelectForUpdateStep<? extends Record>>(this, type, partition, criteria){
                final /* synthetic */ SqlExecutionRepository this$0;
                final /* synthetic */ ExecutionType $type$inlined;
                final /* synthetic */ String $partition$inlined;
                final /* synthetic */ ExecutionRepository.ExecutionCriteria $criteria$inlined;
                {
                    this.this$0 = sqlExecutionRepository;
                    this.$type$inlined = executionType;
                    this.$partition$inlined = string;
                    this.$criteria$inlined = executionCriteria;
                    super(1);
                }

                @NotNull
                public final SelectForUpdateStep<? extends Record> invoke(@NotNull SelectConnectByStep<? extends Record> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    SelectSeekStep1 selectSeekStep1 = it.orderBy((OrderField)DSL.field((String)"id").desc());
                    boolean bl = false;
                    boolean bl2 = false;
                    SelectSeekStep1 $this$run = selectSeekStep1;
                    boolean bl3 = false;
                    SelectForUpdateStep selectForUpdateStep = this.$criteria$inlined.getPageSize() > 0 ? (SelectForUpdateStep)$this$run.limit(this.$criteria$inlined.getPageSize()) : (SelectForUpdateStep)$this$run;
                    Intrinsics.checkNotNullExpressionValue((Object)selectForUpdateStep, (String)"it.orderBy(field(\"id\").d\u2026          }\n            }");
                    return selectForUpdateStep;
                }
            }));
            Observable observable = Observable.from((Iterable)this.fetchExecutions(select));
            Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"Observable.from(select.fetchExecutions())");
            Observable observable2 = observable;
            return observable2;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Observable<PipelineExecution> retrievePipelinesForApplication(@NotNull String application) {
        Observable observable;
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            Observable observable2 = Observable.from((Iterable)this.fetchExecutions((Function2<? super Integer, ? super String, ? extends Iterable<? extends PipelineExecution>>)((Function2)new Function2<Integer, String, Iterable<? extends PipelineExecution>>(this, application){
                final /* synthetic */ SqlExecutionRepository this$0;
                final /* synthetic */ String $application$inlined;
                {
                    this.this$0 = sqlExecutionRepository;
                    this.$application$inlined = string;
                    super(2);
                }

                @NotNull
                public final Iterable<PipelineExecution> invoke(int pageSize, @Nullable String cursor) {
                    return SqlExecutionRepository.access$selectExecutions(this.this$0, ExecutionType.PIPELINE, pageSize, cursor, (Function1)new Function1<SelectJoinStep<Record>, SelectConditionStep<Record>>(this){
                        final /* synthetic */ retrievePipelinesForApplication$$inlined$withPool$lambda$1 this$0;
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }

                        @NotNull
                        public final SelectConditionStep<Record> invoke(@NotNull SelectJoinStep<Record> it) {
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            SelectConditionStep selectConditionStep = it.where(DSL.field((String)"application").eq((Object)this.this$0.$application$inlined));
                            Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"it.where(field(\"application\").eq(application))");
                            return selectConditionStep;
                        }
                    });
                }
            })));
            observable = observable2;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"withPool(poolName) {\n   \u2026}\n        }\n      )\n    }");
        return observable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Observable<PipelineExecution> retrievePipelinesForPipelineConfigId(@NotNull String pipelineConfigId, @NotNull ExecutionRepository.ExecutionCriteria criteria) {
        Intrinsics.checkNotNullParameter((Object)pipelineConfigId, (String)"pipelineConfigId");
        Intrinsics.checkNotNullParameter((Object)criteria, (String)"criteria");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            SelectForUpdateStep select = criteria.getStatuses().isEmpty() || criteria.getStatuses().size() == ExecutionStatus.values().length ? SqlExecutionRepository.selectExecutions$default(this, this.jooq, ExecutionType.PIPELINE, null, "pipeline_config_id_idx", (Function1)new Function1<SelectJoinStep<Record>, SelectConnectByStep<? extends Record>>(this, criteria, pipelineConfigId){
                final /* synthetic */ SqlExecutionRepository this$0;
                final /* synthetic */ ExecutionRepository.ExecutionCriteria $criteria$inlined;
                final /* synthetic */ String $pipelineConfigId$inlined;
                {
                    this.this$0 = sqlExecutionRepository;
                    this.$criteria$inlined = executionCriteria;
                    this.$pipelineConfigId$inlined = string;
                    super(1);
                }

                @NotNull
                public final SelectConnectByStep<? extends Record> invoke(@NotNull SelectJoinStep<Record> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    SelectConditionStep selectConditionStep = it.where(DSL.field((String)"config_id").eq((Object)this.$pipelineConfigId$inlined));
                    Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"it.where(field(\"config_id\").eq(pipelineConfigId))");
                    SelectConnectByStep selectConnectByStep = (SelectConnectByStep)selectConditionStep;
                    Collection collection = this.$criteria$inlined.getStatuses();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"criteria.statuses");
                    return SqlExecutionRepository.access$statusIn(this.this$0, selectConnectByStep, collection);
                }
            }, (Function1)new Function1<SelectConnectByStep<? extends Record>, SelectForUpdateStep<? extends Record>>(this, criteria, pipelineConfigId){
                final /* synthetic */ SqlExecutionRepository this$0;
                final /* synthetic */ ExecutionRepository.ExecutionCriteria $criteria$inlined;
                final /* synthetic */ String $pipelineConfigId$inlined;
                {
                    this.this$0 = sqlExecutionRepository;
                    this.$criteria$inlined = executionCriteria;
                    this.$pipelineConfigId$inlined = string;
                    super(1);
                }

                @NotNull
                public final SelectForUpdateStep<? extends Record> invoke(@NotNull SelectConnectByStep<? extends Record> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    SelectLimitPercentStep selectLimitPercentStep = it.orderBy((OrderField)DSL.field((String)"id").desc()).limit(this.$criteria$inlined.getPageSize());
                    Intrinsics.checkNotNullExpressionValue((Object)selectLimitPercentStep, (String)"it.orderBy(field(\"id\").d\u2026.limit(criteria.pageSize)");
                    return (SelectForUpdateStep)selectLimitPercentStep;
                }
            }, 2, null) : SqlExecutionRepository.selectExecutions$default(this, this.jooq, ExecutionType.PIPELINE, null, (Function1)new Function1<SelectJoinStep<Record>, SelectConnectByStep<? extends Record>>(this, criteria, pipelineConfigId){
                final /* synthetic */ SqlExecutionRepository this$0;
                final /* synthetic */ ExecutionRepository.ExecutionCriteria $criteria$inlined;
                final /* synthetic */ String $pipelineConfigId$inlined;
                {
                    this.this$0 = sqlExecutionRepository;
                    this.$criteria$inlined = executionCriteria;
                    this.$pipelineConfigId$inlined = string;
                    super(1);
                }

                @NotNull
                public final SelectConnectByStep<? extends Record> invoke(@NotNull SelectJoinStep<Record> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    SelectConditionStep selectConditionStep = it.where(DSL.field((String)"config_id").eq((Object)this.$pipelineConfigId$inlined));
                    Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"it.where(field(\"config_id\").eq(pipelineConfigId))");
                    SelectConnectByStep selectConnectByStep = (SelectConnectByStep)selectConditionStep;
                    Collection collection = this.$criteria$inlined.getStatuses();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"criteria.statuses");
                    return SqlExecutionRepository.access$statusIn(this.this$0, selectConnectByStep, collection);
                }
            }, (Function1)new Function1<SelectConnectByStep<? extends Record>, SelectForUpdateStep<? extends Record>>(this, criteria, pipelineConfigId){
                final /* synthetic */ SqlExecutionRepository this$0;
                final /* synthetic */ ExecutionRepository.ExecutionCriteria $criteria$inlined;
                final /* synthetic */ String $pipelineConfigId$inlined;
                {
                    this.this$0 = sqlExecutionRepository;
                    this.$criteria$inlined = executionCriteria;
                    this.$pipelineConfigId$inlined = string;
                    super(1);
                }

                @NotNull
                public final SelectForUpdateStep<? extends Record> invoke(@NotNull SelectConnectByStep<? extends Record> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    SelectLimitPercentStep selectLimitPercentStep = it.orderBy((OrderField)DSL.field((String)"id").desc()).limit(this.$criteria$inlined.getPageSize());
                    Intrinsics.checkNotNullExpressionValue((Object)selectLimitPercentStep, (String)"it.orderBy(field(\"id\").d\u2026.limit(criteria.pageSize)");
                    return (SelectForUpdateStep)selectLimitPercentStep;
                }
            }, 2, null);
            Observable observable = Observable.from((Iterable)this.fetchExecutions((SelectForUpdateStep<? extends Record>)select));
            Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"Observable.from(select.fetchExecutions())");
            Observable observable2 = observable;
            return observable2;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    @NotNull
    public Observable<PipelineExecution> retrieveOrchestrationsForApplication(@NotNull String application, @NotNull ExecutionRepository.ExecutionCriteria criteria) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)criteria, (String)"criteria");
        Observable observable = Observable.from((Iterable)this.retrieveOrchestrationsForApplication(application, criteria, ExecutionRepository.ExecutionComparator.NATURAL_ASC));
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"Observable.from(retrieve\u2026, criteria, NATURAL_ASC))");
        return observable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<PipelineExecution> retrieveOrchestrationsForApplication(@NotNull String application, @NotNull ExecutionRepository.ExecutionCriteria criteria, @Nullable ExecutionRepository.ExecutionComparator sorter) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)criteria, (String)"criteria");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            List list = CollectionsKt.toMutableList(this.fetchExecutions((SelectForUpdateStep<? extends Record>)SqlExecutionRepository.selectExecutions$default(this, this.jooq, ExecutionType.ORCHESTRATION, null, (Function1)new Function1<SelectJoinStep<Record>, SelectConnectByStep<? extends Record>>(this, application, criteria, sorter){
                final /* synthetic */ SqlExecutionRepository this$0;
                final /* synthetic */ String $application$inlined;
                final /* synthetic */ ExecutionRepository.ExecutionCriteria $criteria$inlined;
                final /* synthetic */ ExecutionRepository.ExecutionComparator $sorter$inlined;
                {
                    this.this$0 = sqlExecutionRepository;
                    this.$application$inlined = string;
                    this.$criteria$inlined = executionCriteria;
                    this.$sorter$inlined = executionComparator;
                    super(1);
                }

                @NotNull
                public final SelectConnectByStep<? extends Record> invoke(@NotNull SelectJoinStep<Record> it) {
                    SelectConnectByStep selectConnectByStep;
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    SelectConditionStep where = it.where(DSL.field((String)"application").eq((Object)this.$application$inlined));
                    Instant startTime = this.$criteria$inlined.getStartTimeCutoff();
                    if (startTime != null) {
                        Condition condition = DSL.field((String)"start_time").greaterThan((Object)startTime.toEpochMilli());
                        Field field = DSL.field((String)"start_time");
                        Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field(\"start_time\")");
                        SelectConditionStep selectConditionStep = where.and(condition.or(field.isNull()));
                        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"where\n              .and\u2026).isNull)\n              )");
                        SelectConnectByStep selectConnectByStep2 = (SelectConnectByStep)selectConditionStep;
                        Collection collection = this.$criteria$inlined.getStatuses();
                        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"criteria.statuses");
                        selectConnectByStep = SqlExecutionRepository.access$statusIn(this.this$0, selectConnectByStep2, collection);
                    } else {
                        SelectConditionStep selectConditionStep = where;
                        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"where");
                        SelectConnectByStep selectConnectByStep3 = (SelectConnectByStep)selectConditionStep;
                        Collection collection = this.$criteria$inlined.getStatuses();
                        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"criteria.statuses");
                        selectConnectByStep = SqlExecutionRepository.access$statusIn(this.this$0, selectConnectByStep3, collection);
                    }
                    return selectConnectByStep;
                }
            }, (Function1)new Function1<SelectConnectByStep<? extends Record>, SelectForUpdateStep<? extends Record>>(this, application, criteria, sorter){
                final /* synthetic */ SqlExecutionRepository this$0;
                final /* synthetic */ String $application$inlined;
                final /* synthetic */ ExecutionRepository.ExecutionCriteria $criteria$inlined;
                final /* synthetic */ ExecutionRepository.ExecutionComparator $sorter$inlined;
                {
                    this.this$0 = sqlExecutionRepository;
                    this.$application$inlined = string;
                    this.$criteria$inlined = executionCriteria;
                    this.$sorter$inlined = executionComparator;
                    super(1);
                }

                /*
                 * Unable to fully structure code
                 */
                @NotNull
                public final SelectForUpdateStep<? extends Record> invoke(@NotNull SelectConnectByStep<? extends Record> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    v0 = this.$sorter$inlined;
                    if (v0 == null) ** GOTO lbl-1000
                    switch (SqlExecutionRepository$WhenMappings.$EnumSwitchMapping$1[v0.ordinal()]) {
                        case 1: {
                            v1 = (SelectLimitStep)it.orderBy((OrderField)DSL.field((String)"start_time").desc().nullsFirst(), (OrderField)DSL.field((String)"id").desc());
                            break;
                        }
                        case 2: {
                            v1 = (SelectLimitStep)it.orderBy((OrderField)DSL.field((String)"build_time").asc(), (OrderField)DSL.field((String)"id").asc());
                            break;
                        }
                        default: lbl-1000:
                        // 2 sources

                        {
                            v1 = (SelectLimitStep)it.orderBy((OrderField)DSL.field((String)"id").desc());
                        }
                    }
                    ordered = v1;
                    v2 = ordered.offset((this.$criteria$inlined.getPage() - 1) * this.$criteria$inlined.getPageSize()).limit(this.$criteria$inlined.getPageSize());
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"ordered.offset((criteria\u2026.limit(criteria.pageSize)");
                    return (SelectForUpdateStep)v2;
                }
            }, 2, null)));
            return list;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    @NotNull
    public PipelineExecution retrieveByCorrelationId(@NotNull ExecutionType executionType, @NotNull String correlationId) {
        PipelineExecution pipelineExecution;
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
        switch (SqlExecutionRepository$WhenMappings.$EnumSwitchMapping$2[executionType.ordinal()]) {
            case 1: {
                pipelineExecution = this.retrievePipelineForCorrelationId(correlationId);
                break;
            }
            case 2: {
                pipelineExecution = this.retrieveOrchestrationForCorrelationId(correlationId);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return pipelineExecution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public PipelineExecution retrieveOrchestrationForCorrelationId(@NotNull String correlationId) {
        Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            Field field = DSL.field((Select)((Select)this.jooq.select((SelectField)DSL.field((String)"c.orchestration_id")).from((TableLike)DSL.table((String)"correlation_ids").as("c")).where(DSL.field((String)"c.id").eq((Object)correlationId)).limit(1)));
            if (field == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Any");
            }
            SelectConditionStep selectConditionStep = SqlExecutionRepository.selectExecution$default(this, this.jooq, ExecutionType.ORCHESTRATION, null, 2, null).where(DSL.field((String)"id").eq((Object)field));
            Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"jooq.selectExecution(ORC\u2026Any\n          )\n        )");
            PipelineExecution execution = this.fetchExecution((SelectForUpdateStep<? extends Record>)((SelectForUpdateStep)selectConditionStep));
            if (execution != null) {
                ExecutionStatus executionStatus = execution.getStatus();
                Intrinsics.checkNotNullExpressionValue((Object)executionStatus, (String)"execution.status");
                if (!executionStatus.isComplete()) {
                    PipelineExecution pipelineExecution = execution;
                    return pipelineExecution;
                }
                this.transactional(this.jooq, (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(this, correlationId){
                    final /* synthetic */ SqlExecutionRepository this$0;
                    final /* synthetic */ String $correlationId$inlined;
                    {
                        this.this$0 = sqlExecutionRepository;
                        this.$correlationId$inlined = string;
                        super(1);
                    }

                    public final void invoke(@NotNull DSLContext it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        it.deleteFrom(DSL.table((String)"correlation_ids")).where(DSL.field((String)"id").eq((Object)this.$correlationId$inlined)).execute();
                    }
                }));
            }
            throw (Throwable)new ExecutionNotFoundException("No Orchestration found for correlation ID " + correlationId);
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public PipelineExecution retrievePipelineForCorrelationId(@NotNull String correlationId) {
        Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            Field field = DSL.field((Select)((Select)this.jooq.select((SelectField)DSL.field((String)"c.pipeline_id")).from((TableLike)DSL.table((String)"correlation_ids").as("c")).where(DSL.field((String)"c.id").eq((Object)correlationId)).limit(1)));
            if (field == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Any");
            }
            SelectConditionStep selectConditionStep = SqlExecutionRepository.selectExecution$default(this, this.jooq, ExecutionType.PIPELINE, null, 2, null).where(DSL.field((String)"id").eq((Object)field));
            Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"jooq.selectExecution(PIP\u2026Any\n          )\n        )");
            PipelineExecution execution = this.fetchExecution((SelectForUpdateStep<? extends Record>)((SelectForUpdateStep)selectConditionStep));
            if (execution != null) {
                ExecutionStatus executionStatus = execution.getStatus();
                Intrinsics.checkNotNullExpressionValue((Object)executionStatus, (String)"execution.status");
                if (!executionStatus.isComplete()) {
                    PipelineExecution pipelineExecution = execution;
                    return pipelineExecution;
                }
                this.transactional(this.jooq, (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(this, correlationId){
                    final /* synthetic */ SqlExecutionRepository this$0;
                    final /* synthetic */ String $correlationId$inlined;
                    {
                        this.this$0 = sqlExecutionRepository;
                        this.$correlationId$inlined = string;
                        super(1);
                    }

                    public final void invoke(@NotNull DSLContext it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        it.deleteFrom(DSL.table((String)"correlation_ids")).where(DSL.field((String)"id").eq((Object)this.$correlationId$inlined)).execute();
                    }
                }));
            }
            throw (Throwable)new ExecutionNotFoundException("No Pipeline found for correlation ID " + correlationId);
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    @NotNull
    public List<PipelineExecution> retrieveBufferedExecutions() {
        ExecutionRepository.ExecutionCriteria executionCriteria = new ExecutionRepository.ExecutionCriteria().setPageSize(100).setStatuses(new ExecutionStatus[]{ExecutionStatus.BUFFERED});
        boolean bl = false;
        boolean bl2 = false;
        ExecutionRepository.ExecutionCriteria criteria = executionCriteria;
        boolean bl3 = false;
        ExecutionRepository.ExecutionCriteria executionCriteria2 = criteria;
        Intrinsics.checkNotNullExpressionValue((Object)executionCriteria2, (String)"criteria");
        List list = (List)Observable.merge(this.retrieve(ExecutionType.ORCHESTRATION, executionCriteria2, this.partitionName), this.retrieve(ExecutionType.PIPELINE, criteria, this.partitionName)).toList().toBlocking().single();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ExecutionCriteria()\n    \u2026ocking().single()\n      }");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<String> retrieveAllApplicationNames(@Nullable ExecutionType type) {
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            List list;
            boolean bl = false;
            if (type == null) {
                List list2 = this.jooq.select((SelectField)DSL.field((String)"application")).from((TableLike)JooqKt.getTableName(ExecutionType.PIPELINE)).groupBy(new GroupField[]{(GroupField)DSL.field((String)"application")}).unionAll((Select)this.jooq.select((SelectField)DSL.field((String)"application")).from((TableLike)JooqKt.getTableName(ExecutionType.ORCHESTRATION)).groupBy(new GroupField[]{(GroupField)DSL.field((String)"application")})).fetch(0, String.class);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"jooq.select(field(\"appli\u2026ch(0, String::class.java)");
                list = CollectionsKt.distinct((Iterable)list2);
            } else {
                List list3 = this.jooq.select((SelectField)DSL.field((String)"application")).from((TableLike)JooqKt.getTableName(type)).groupBy(new GroupField[]{(GroupField)DSL.field((String)"application")}).fetch(0, String.class);
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"jooq.select(field(\"appli\u2026ch(0, String::class.java)");
                list = CollectionsKt.distinct((Iterable)list3);
            }
            List list4 = list;
            return list4;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<String> retrieveAllApplicationNames(@Nullable ExecutionType type, int minExecutions) {
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            List list;
            boolean bl = false;
            if (type == null) {
                List list2 = this.jooq.select((SelectField)DSL.field((String)"application")).from((TableLike)JooqKt.getTableName(ExecutionType.PIPELINE)).groupBy(new GroupField[]{(GroupField)DSL.field((String)"application")}).having(DSL.count().ge((Object)minExecutions)).unionAll((Select)this.jooq.select((SelectField)DSL.field((String)"application")).from((TableLike)JooqKt.getTableName(ExecutionType.ORCHESTRATION)).groupBy(new GroupField[]{(GroupField)DSL.field((String)"application")}).having(DSL.count().ge((Object)minExecutions))).fetch(0, String.class);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"jooq.select(field(\"appli\u2026ch(0, String::class.java)");
                list = CollectionsKt.distinct((Iterable)list2);
            } else {
                List list3 = this.jooq.select((SelectField)DSL.field((String)"application")).from((TableLike)JooqKt.getTableName(type)).groupBy(new GroupField[]{(GroupField)DSL.field((String)"application")}).having(DSL.count().ge((Object)minExecutions)).fetch(0, String.class);
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"jooq.select(field(\"appli\u2026ch(0, String::class.java)");
                list = CollectionsKt.distinct((Iterable)list3);
            }
            List list4 = list;
            return list4;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ActiveExecutionsReport countActiveExecutions() {
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            Condition partitionPredicate = this.partitionName != null ? DSL.field((Name)DSL.name((String)"partition")).eq((Object)this.partitionName) : DSL.value((int)1).eq((Field)DSL.value((int)1));
            Field orchestrationsQuery = this.jooq.selectCount().from((TableLike)JooqKt.getTableName(ExecutionType.ORCHESTRATION)).where(DSL.field((String)"status").eq((Object)ExecutionStatus.RUNNING.toString())).and(partitionPredicate).asField("orchestrations");
            Field pipelinesQuery = this.jooq.selectCount().from((TableLike)JooqKt.getTableName(ExecutionType.PIPELINE)).where(DSL.field((String)"status").eq((Object)ExecutionStatus.RUNNING.toString())).and(partitionPredicate).asField("pipelines");
            Record2 record = (Record2)this.jooq.select((SelectField)orchestrationsQuery, (SelectField)pipelinesQuery).fetchSingle();
            Object object = record.get(0, Integer.TYPE);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"record.get(0, Int::class.java)");
            int n = ((Number)object).intValue();
            Object object2 = record.get(1, Integer.TYPE);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"record.get(1, Int::class.java)");
            ActiveExecutionsReport activeExecutionsReport = new ActiveExecutionsReport(n, ((Number)object2).intValue());
            return activeExecutionsReport;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<PipelineExecution> retrievePipelinesForPipelineConfigIdsBetweenBuildTimeBoundary(@NotNull List<String> pipelineConfigIds, long buildTimeStartBoundary, long buildTimeEndBoundary, @NotNull ExecutionRepository.ExecutionCriteria executionCriteria) {
        Intrinsics.checkNotNullParameter(pipelineConfigIds, (String)"pipelineConfigIds");
        Intrinsics.checkNotNullParameter((Object)executionCriteria, (String)"executionCriteria");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            SelectForUpdateStep select = SqlExecutionRepository.selectExecutions$default(this, this.jooq, ExecutionType.PIPELINE, null, (Function1)new Function1<SelectJoinStep<Record>, SelectConnectByStep<? extends Record>>(this, pipelineConfigIds, buildTimeStartBoundary, buildTimeEndBoundary, executionCriteria){
                final /* synthetic */ SqlExecutionRepository this$0;
                final /* synthetic */ List $pipelineConfigIds$inlined;
                final /* synthetic */ long $buildTimeStartBoundary$inlined;
                final /* synthetic */ long $buildTimeEndBoundary$inlined;
                final /* synthetic */ ExecutionRepository.ExecutionCriteria $executionCriteria$inlined;
                {
                    this.this$0 = sqlExecutionRepository;
                    this.$pipelineConfigIds$inlined = list;
                    this.$buildTimeStartBoundary$inlined = l;
                    this.$buildTimeEndBoundary$inlined = l2;
                    this.$executionCriteria$inlined = executionCriteria;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final SelectConnectByStep<? extends Record> invoke(@NotNull SelectJoinStep<Record> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    Collection $this$toTypedArray$iv = this.$pipelineConfigIds$inlined;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    if (stringArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    SelectConditionStep conditions = it.where(DSL.field((String)"config_id").in((Object[])Arrays.copyOf(stringArray, stringArray.length)).and(DSL.field((String)"build_time").gt((Object)this.$buildTimeStartBoundary$inlined)).and(DSL.field((String)"build_time").lt((Object)this.$buildTimeEndBoundary$inlined)));
                    Collection collection = this.$executionCriteria$inlined.getStatuses();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"executionCriteria.statuses");
                    $this$toTypedArray$iv = collection;
                    $i$f$toTypedArray = false;
                    if (!$this$toTypedArray$iv.isEmpty()) {
                        void $this$mapTo$iv$iv;
                        Collection collection2 = this.$executionCriteria$inlined.getStatuses();
                        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"executionCriteria.statuses");
                        Iterable $this$map$iv = collection2;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it2;
                            ExecutionStatus executionStatus = (ExecutionStatus)item$iv$iv;
                            Collection collection3 = destination$iv$iv;
                            boolean bl = false;
                            String string = it2.toString();
                            collection3.add(string);
                        }
                        List statusStrings = (List)destination$iv$iv;
                        Collection $this$toTypedArray$iv2 = statusStrings;
                        boolean $i$f$toTypedArray2 = false;
                        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
                        String[] stringArray2 = thisCollection$iv2.toArray(new String[0]);
                        if (stringArray2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        conditions = conditions.and(DSL.field((String)"status").in((Object[])Arrays.copyOf(stringArray2, stringArray2.length)));
                    }
                    SelectConditionStep selectConditionStep = conditions;
                    Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"conditions");
                    return (SelectConnectByStep)selectConditionStep;
                }
            }, (Function1)new Function1<SelectConnectByStep<? extends Record>, SelectForUpdateStep<? extends Record>>(this, pipelineConfigIds, buildTimeStartBoundary, buildTimeEndBoundary, executionCriteria){
                final /* synthetic */ SqlExecutionRepository this$0;
                final /* synthetic */ List $pipelineConfigIds$inlined;
                final /* synthetic */ long $buildTimeStartBoundary$inlined;
                final /* synthetic */ long $buildTimeEndBoundary$inlined;
                final /* synthetic */ ExecutionRepository.ExecutionCriteria $executionCriteria$inlined;
                {
                    this.this$0 = sqlExecutionRepository;
                    this.$pipelineConfigIds$inlined = list;
                    this.$buildTimeStartBoundary$inlined = l;
                    this.$buildTimeEndBoundary$inlined = l2;
                    this.$executionCriteria$inlined = executionCriteria;
                    super(1);
                }

                /*
                 * Unable to fully structure code
                 */
                @NotNull
                public final SelectForUpdateStep<? extends Record> invoke(@NotNull SelectConnectByStep<? extends Record> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    v0 = this.$executionCriteria$inlined.getSortType();
                    if (v0 == null) ** GOTO lbl-1000
                    switch (SqlExecutionRepository$WhenMappings.$EnumSwitchMapping$3[v0.ordinal()]) {
                        case 1: {
                            v1 = it.orderBy((OrderField)DSL.field((String)"build_time").asc());
                            break;
                        }
                        case 2: {
                            v1 = it.orderBy((OrderField)DSL.field((String)"build_time").desc());
                            break;
                        }
                        case 3: {
                            v1 = it.orderBy((OrderField)DSL.field((String)"start_time").desc());
                            break;
                        }
                        case 4: {
                            v1 = it.orderBy((OrderField)DSL.field((String)"id").desc());
                            break;
                        }
                        default: lbl-1000:
                        // 2 sources

                        {
                            v1 = it.orderBy((OrderField)DSL.field((String)"id").asc());
                        }
                    }
                    seek = v1;
                    v2 = seek.limit(this.$executionCriteria$inlined.getPageSize()).offset((this.$executionCriteria$inlined.getPage() - 1) * this.$executionCriteria$inlined.getPageSize());
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"seek\n            .limit(\u2026ecutionCriteria.pageSize)");
                    return v2;
                }
            }, 2, null);
            List list = CollectionsKt.toList((Iterable)this.fetchExecutions((SelectForUpdateStep<? extends Record>)select));
            return list;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    @NotNull
    public List<PipelineExecution> retrieveAllPipelinesForPipelineConfigIdsBetweenBuildTimeBoundary(@NotNull List<String> pipelineConfigIds, long buildTimeStartBoundary, long buildTimeEndBoundary, @NotNull ExecutionRepository.ExecutionCriteria executionCriteria) {
        Intrinsics.checkNotNullParameter(pipelineConfigIds, (String)"pipelineConfigIds");
        Intrinsics.checkNotNullParameter((Object)executionCriteria, (String)"executionCriteria");
        boolean bl = false;
        List allExecutions = new ArrayList();
        int page = 1;
        int pageSize = executionCriteria.getPageSize();
        boolean moreResults = true;
        while (moreResults) {
            ExecutionRepository.ExecutionCriteria executionCriteria2 = executionCriteria.setPage(page);
            Intrinsics.checkNotNullExpressionValue((Object)executionCriteria2, (String)"executionCriteria.setPage(page)");
            List<PipelineExecution> results = this.retrievePipelinesForPipelineConfigIdsBetweenBuildTimeBoundary(pipelineConfigIds, buildTimeStartBoundary, buildTimeEndBoundary, executionCriteria2);
            moreResults = results.size() >= pageSize;
            ++page;
            allExecutions.addAll((Collection)results);
        }
        return allExecutions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasExecution(@NotNull ExecutionType type, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            Integer n = (Integer)this.jooq.selectCount().from((TableLike)JooqKt.getTableName(type)).where(JooqKt.toWhereCondition(id)).fetchSingle((Field)DSL.count());
            boolean bl2 = (n != null ? n : 0) > 0;
            return bl2;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<String> retrieveAllExecutionIds(@NotNull ExecutionType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            List list = this.jooq.select((SelectField)DSL.field((String)"id")).from((TableLike)JooqKt.getTableName(type)).fetch("id", String.class);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jooq.select(field(\"id\"))\u2026\"id\", String::class.java)");
            List list2 = list;
            return list2;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<String, String> mapLegacyId(DSLContext ctx, Table<Record> table, String id, Long timestamp) {
        if (JooqKt.isULID(id)) {
            return new Pair((Object)id, null);
        }
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            Object object;
            block9: {
                long ts;
                block8: {
                    boolean bl = false;
                    Long l = timestamp;
                    ts = l != null ? l : System.currentTimeMillis();
                    Record1 row = (Record1)ctx.select((SelectField)DSL.field((String)"id")).from((TableLike)table).where(DSL.field((String)"legacy_id").eq((Object)id)).limit(1).fetchOne();
                    object = row;
                    if (object == null) break block8;
                    Record1 record1 = object;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Record1 it = record1;
                    boolean bl4 = false;
                    Object object2 = it.getValue(DSL.field((String)"id"));
                    if (object2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    object = (String)object2;
                    if (object != null) break block9;
                }
                object = ulid.nextULID(ts);
            }
            Object ulid = object;
            Pair pair = new Pair(ulid, (Object)id);
            return pair;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    static /* synthetic */ Pair mapLegacyId$default(SqlExecutionRepository sqlExecutionRepository, DSLContext dSLContext, Table table, String string, Long l, int n, Object object) {
        if ((n & 8) != 0) {
            l = null;
        }
        return sqlExecutionRepository.mapLegacyId(dSLContext, (Table<Record>)table, string, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void storeExecutionInternal(DSLContext ctx, PipelineExecution execution, boolean storeStages) {
        this.validateHandledPartitionOrThrow(execution);
        List list = execution.getStages();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"execution.stages");
        List stages = CollectionsKt.toList((Iterable)CollectionsKt.toMutableList((Collection)list));
        execution.getStages().clear();
        try {
            void executionId;
            ExecutionType executionType = execution.getType();
            Intrinsics.checkNotNullExpressionValue((Object)executionType, (String)"execution.type");
            Table<Record> tableName = JooqKt.getTableName(executionType);
            ExecutionType executionType2 = execution.getType();
            Intrinsics.checkNotNullExpressionValue((Object)executionType2, (String)"execution.type");
            Table<Record> stageTableName = JooqKt.getStagesTableName(executionType2);
            String status = execution.getStatus().toString();
            String body = this.mapper.writeValueAsString((Object)execution);
            String string = execution.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"execution.id");
            Pair<String, String> pair = this.mapLegacyId(ctx, tableName, string, execution.getStartTime());
            String string2 = (String)pair.component1();
            String legacyId = (String)pair.component2();
            Pair[] pairArray = new Pair[9];
            pairArray[0] = TuplesKt.to((Object)DSL.field((String)"id"), (Object)executionId);
            pairArray[1] = TuplesKt.to((Object)DSL.field((String)"legacy_id"), (Object)legacyId);
            pairArray[2] = TuplesKt.to((Object)DSL.field((Name)DSL.name((String)"partition")), (Object)this.partitionName);
            pairArray[3] = TuplesKt.to((Object)DSL.field((String)"status"), (Object)status);
            pairArray[4] = TuplesKt.to((Object)DSL.field((String)"application"), (Object)execution.getApplication());
            Long l = execution.getBuildTime();
            pairArray[5] = TuplesKt.to((Object)DSL.field((String)"build_time"), (Object)(l != null ? l : System.currentTimeMillis()));
            pairArray[6] = TuplesKt.to((Object)DSL.field((String)"canceled"), (Object)execution.isCanceled());
            pairArray[7] = TuplesKt.to((Object)DSL.field((String)"updated_at"), (Object)System.currentTimeMillis());
            pairArray[8] = TuplesKt.to((Object)DSL.field((String)"body"), (Object)body);
            Map insertPairs = MapsKt.mutableMapOf((Pair[])pairArray);
            Map updatePairs = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)DSL.field((String)"status"), (Object)status), TuplesKt.to((Object)DSL.field((String)"body"), (Object)body), TuplesKt.to((Object)DSL.field((Name)DSL.name((String)"partition")), (Object)this.partitionName), TuplesKt.to((Object)DSL.field((String)"canceled"), (Object)execution.isCanceled()), TuplesKt.to((Object)DSL.field((String)"updated_at"), (Object)System.currentTimeMillis())});
            Long startTime = execution.getStartTime();
            if (startTime != null) {
                insertPairs.put(DSL.field((String)"start_time"), startTime);
                updatePairs.put(DSL.field((String)"start_time"), startTime);
            }
            switch (SqlExecutionRepository$WhenMappings.$EnumSwitchMapping$4[execution.getType().ordinal()]) {
                case 1: {
                    ExecutionType executionType3 = execution.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)executionType3, (String)"execution.type");
                    this.upsert(ctx, JooqKt.getTableName(executionType3), MapsKt.plus((Map)insertPairs, (Pair)TuplesKt.to((Object)DSL.field((String)"config_id"), (Object)execution.getPipelineConfigId())), MapsKt.plus((Map)updatePairs, (Pair)TuplesKt.to((Object)DSL.field((String)"config_id"), (Object)execution.getPipelineConfigId())), (String)executionId);
                    break;
                }
                case 2: {
                    ExecutionType executionType4 = execution.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)executionType4, (String)"execution.type");
                    this.upsert(ctx, JooqKt.getTableName(executionType4), insertPairs, updatePairs, (String)executionId);
                    break;
                }
            }
            this.storeCorrelationIdInternal(ctx, execution);
            if (storeStages) {
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = stages;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    StageExecution stageExecution = (StageExecution)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v8 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"it");
                    String string3 = v8.getId();
                    collection.add(string3);
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] stageIds = stringArray;
                String name$iv = this.poolName;
                boolean $i$f$withPool = false;
                NamedDatabaseContextHolder.INSTANCE.set(name$iv);
                try {
                    boolean bl = false;
                    destination$iv$iv = ctx.deleteFrom(stageTableName).where(DSL.field((String)"execution_id").eq((Object)executionId));
                    $i$f$mapTo = false;
                    boolean bl2 = false;
                    Collection $this$apply = destination$iv$iv;
                    boolean bl3 = false;
                    String[] stringArray2 = stageIds;
                    boolean bl4 = false;
                    if (!(stringArray2.length == 0)) {
                        DeleteConditionStep deleteConditionStep = $this$apply.and(DSL.field((String)"id").notIn((Object[])Arrays.copyOf(stageIds, stageIds.length)));
                        Condition condition = DSL.field((String)"legacy_id").notIn((Object[])Arrays.copyOf(stageIds, stageIds.length));
                        Field field = DSL.field((String)"legacy_id");
                        Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field(\"legacy_id\")");
                        deleteConditionStep.and(condition.or(field.isNull()));
                    }
                    int n = destination$iv$iv.execute();
                }
                finally {
                    NamedDatabaseContextHolder.INSTANCE.clear();
                }
                Iterable $this$forEach$iv = stages;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    StageExecution it = (StageExecution)element$iv;
                    boolean bl = false;
                    StageExecution stageExecution = it;
                    Intrinsics.checkNotNullExpressionValue((Object)stageExecution, (String)"it");
                    SqlExecutionRepository.storeStageInternal$default(this, ctx, stageExecution, (String)executionId, false, 8, null);
                }
            }
            this.withListener((Function1<? super ExecutionRepositoryListener, Unit>)((Function1)new Function1<ExecutionRepositoryListener, Unit>(execution){
                final /* synthetic */ PipelineExecution $execution;

                public final void invoke(@NotNull ExecutionRepositoryListener $this$withListener) {
                    Intrinsics.checkNotNullParameter((Object)$this$withListener, (String)"$this$withListener");
                    $this$withListener.onUpsert(this.$execution);
                }
                {
                    this.$execution = pipelineExecution;
                    super(1);
                }
            }));
            execution.getStages().addAll(stages);
        }
        catch (Throwable throwable) {
            this.withListener((Function1<? super ExecutionRepositoryListener, Unit>)((Function1)new /* invalid duplicate definition of identical inner class */));
            execution.getStages().addAll(stages);
            throw throwable;
        }
    }

    static /* synthetic */ void storeExecutionInternal$default(SqlExecutionRepository sqlExecutionRepository, DSLContext dSLContext, PipelineExecution pipelineExecution, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        sqlExecutionRepository.storeExecutionInternal(dSLContext, pipelineExecution, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void storeStageInternal(DSLContext ctx, StageExecution stage, String executionId, boolean notifyListener) {
        void stageId;
        PipelineExecution pipelineExecution = stage.getExecution();
        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"stage.execution");
        ExecutionType executionType = pipelineExecution.getType();
        Intrinsics.checkNotNullExpressionValue((Object)executionType, (String)"stage.execution.type");
        Table<Record> stageTable = JooqKt.getStagesTableName(executionType);
        PipelineExecution pipelineExecution2 = stage.getExecution();
        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution2, (String)"stage.execution");
        ExecutionType executionType2 = pipelineExecution2.getType();
        Intrinsics.checkNotNullExpressionValue((Object)executionType2, (String)"stage.execution.type");
        Table<Record> table = JooqKt.getTableName(executionType2);
        String body = this.mapper.writeValueAsString((Object)stage);
        PipelineExecution pipelineExecution3 = stage.getExecution();
        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution3, (String)"stage.execution");
        Long buildTime = pipelineExecution3.getBuildTime();
        String string = executionId;
        if (string == null) {
            PipelineExecution pipelineExecution4 = stage.getExecution();
            Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution4, (String)"stage.execution");
            String string2 = pipelineExecution4.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"stage.execution.id");
            string = (String)this.mapLegacyId(ctx, table, string2, buildTime).getFirst();
        }
        String executionUlid = string;
        String string3 = stage.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"stage.id");
        Pair<String, String> pair = this.mapLegacyId(ctx, stageTable, string3, buildTime);
        String string4 = (String)pair.component1();
        String legacyId = (String)pair.component2();
        Map insertPairs = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)DSL.field((String)"id"), (Object)stageId), TuplesKt.to((Object)DSL.field((String)"legacy_id"), (Object)legacyId), TuplesKt.to((Object)DSL.field((String)"execution_id"), (Object)executionUlid), TuplesKt.to((Object)DSL.field((String)"status"), (Object)stage.getStatus().toString()), TuplesKt.to((Object)DSL.field((String)"updated_at"), (Object)System.currentTimeMillis()), TuplesKt.to((Object)DSL.field((String)"body"), (Object)body)});
        Map updatePairs = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)DSL.field((String)"status"), (Object)stage.getStatus().toString()), TuplesKt.to((Object)DSL.field((String)"updated_at"), (Object)System.currentTimeMillis()), TuplesKt.to((Object)DSL.field((String)"body"), (Object)body)});
        String string5 = stage.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"stage.id");
        this.upsert(ctx, stageTable, insertPairs, updatePairs, string5);
        if (notifyListener) {
            this.withListener((Function1<? super ExecutionRepositoryListener, Unit>)((Function1)new Function1<ExecutionRepositoryListener, Unit>(stage){
                final /* synthetic */ StageExecution $stage;

                public final void invoke(@NotNull ExecutionRepositoryListener $this$withListener) {
                    Intrinsics.checkNotNullParameter((Object)$this$withListener, (String)"$receiver");
                    $this$withListener.onUpsert(this.$stage.getExecution());
                }
                {
                    this.$stage = stageExecution;
                    super(1);
                }
            }));
        }
    }

    static /* synthetic */ void storeStageInternal$default(SqlExecutionRepository sqlExecutionRepository, DSLContext dSLContext, StageExecution stageExecution, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        sqlExecutionRepository.storeStageInternal(dSLContext, stageExecution, string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void storeCorrelationIdInternal(DSLContext ctx, PipelineExecution execution) {
        Trigger trigger = execution.getTrigger();
        Intrinsics.checkNotNullExpressionValue((Object)trigger, (String)"execution.trigger");
        if (trigger.getCorrelationId() != null) {
            ExecutionStatus executionStatus = execution.getStatus();
            Intrinsics.checkNotNullExpressionValue((Object)executionStatus, (String)"execution.status");
            if (!executionStatus.isComplete()) {
                Field field;
                switch (SqlExecutionRepository$WhenMappings.$EnumSwitchMapping$5[execution.getType().ordinal()]) {
                    case 1: {
                        field = DSL.field((String)"pipeline_id");
                        break;
                    }
                    case 2: {
                        field = DSL.field((String)"orchestration_id");
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Field executionIdField = field;
                String name$iv = this.poolName;
                boolean $i$f$withPool = false;
                NamedDatabaseContextHolder.INSTANCE.set(name$iv);
                try {
                    boolean bl = false;
                    SelectJoinStep selectJoinStep = ctx.select(new SelectFieldOrAsterisk[0]).from("correlation_ids");
                    Field field2 = DSL.field((String)"id");
                    Trigger trigger2 = execution.getTrigger();
                    Intrinsics.checkNotNullExpressionValue((Object)trigger2, (String)"execution.trigger");
                    boolean exists = ctx.fetchExists((Select)selectJoinStep.where(field2.eq((Object)trigger2.getCorrelationId())).and(executionIdField.eq((Object)execution.getId())));
                    if (!exists) {
                        InsertValuesStep2 insertValuesStep2 = ctx.insertInto(DSL.table((String)"correlation_ids")).columns(DSL.field((String)"id"), executionIdField);
                        Trigger trigger3 = execution.getTrigger();
                        Intrinsics.checkNotNullExpressionValue((Object)trigger3, (String)"execution.trigger");
                        insertValuesStep2.values((Object)trigger3.getCorrelationId(), (Object)execution.getId()).execute();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    NamedDatabaseContextHolder.INSTANCE.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void upsert(DSLContext ctx, Table<Record> table, Map<Field<Object>, ? extends Object> insertPairs, Map<Field<Object>, ? extends Object> updatePairs, String updateId) {
        name$iv = this.poolName;
        $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            $i$a$-withPool-SqlExecutionRepository$upsert$1 = false;
            try {
                $this$toTypedArray$iv = insertPairs.keySet();
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                v0 = thisCollection$iv.toArray(new Field[0]);
                if (v0 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                var9_9 = ctx.insertInto(table, Arrays.copyOf(v0, v0.length)).values(insertPairs.values());
                $i$f$toTypedArray = false;
                thisCollection$iv = false;
                $this$run = var9_9;
                $i$a$-run-SqlExecutionRepository$upsert$1$1 = false;
                v1 = this.jooq.dialect();
                if (v1 == null) ** GOTO lbl-1000
                switch (SqlExecutionRepository$WhenMappings.$EnumSwitchMapping$6[v1.ordinal()]) {
                    case 1: {
                        v2 = $this$run.onConflict(new Field[]{DSL.field((String)"id")}).doUpdate().set(updatePairs).execute();
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        v2 = $this$run.onDuplicateKeyUpdate().set(updatePairs).execute();
                    }
                }
                var9_10 = v2;
            }
            catch (SQLDialectNotSupportedException e) {
                this.log.debug("Falling back to primitive upsert logic: " + e.getMessage());
                exists = ctx.fetchExists((Select)ctx.select(new SelectFieldOrAsterisk[0]).from((TableLike)table).where(DSL.field((String)"id").eq((Object)updateId)).forUpdate());
                var9_10 = exists != false ? ctx.update(table).set(updatePairs).where(DSL.field((String)"id").eq((Object)updateId)).execute() : ctx.insertInto(table).columns((Collection)insertPairs.keySet()).values(insertPairs.values()).execute();
            }
            var14_18 = var9_10;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final SelectConnectByStep<? extends Record> statusIn(SelectConnectByStep<? extends Record> $this$statusIn, Collection<? extends ExecutionStatus> statuses) {
        void $this$mapTo$iv$iv;
        if (statuses.isEmpty() || statuses.size() == ExecutionStatus.values().length) {
            return $this$statusIn;
        }
        Iterable $this$map$iv = statuses;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ExecutionStatus executionStatus = (ExecutionStatus)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.toString();
            collection.add(string);
        }
        List statusStrings = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = statusStrings;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Condition clause = DSL.field((String)"status").in((Object[])Arrays.copyOf(stringArray, stringArray.length));
        SelectConnectByStep selectConnectByStep = $this$statusIn;
        boolean bl = false;
        boolean bl2 = false;
        SelectConnectByStep $this$run = selectConnectByStep;
        boolean bl3 = false;
        SelectConnectByStep selectConnectByStep2 = $this$run;
        SelectConnectByStep selectConnectByStep3 = selectConnectByStep2 instanceof SelectWhereStep ? (SelectConnectByStep)((SelectWhereStep)$this$run).where(clause) : (selectConnectByStep2 instanceof SelectConditionStep ? (SelectConnectByStep)((SelectConditionStep)$this$run).and(clause) : $this$run);
        Intrinsics.checkNotNullExpressionValue((Object)selectConnectByStep3, (String)"run {\n      when (this) \u2026lse -> this\n      }\n    }");
        return selectConnectByStep3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PipelineExecution selectExecution(DSLContext ctx, ExecutionType type, String id, boolean forUpdate) {
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            SelectConditionStep select = SqlExecutionRepository.selectExecution$default(this, ctx, type, null, 2, null).where(JooqKt.toWhereCondition(id));
            if (forUpdate) {
                select.forUpdate();
            }
            SelectConditionStep selectConditionStep = select;
            Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"select");
            PipelineExecution pipelineExecution = this.fetchExecution((SelectForUpdateStep<? extends Record>)((SelectForUpdateStep)selectConditionStep));
            return pipelineExecution;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    static /* synthetic */ PipelineExecution selectExecution$default(SqlExecutionRepository sqlExecutionRepository, DSLContext dSLContext, ExecutionType executionType, String string, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return sqlExecutionRepository.selectExecution(dSLContext, executionType, string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Collection<PipelineExecution> selectExecutions(ExecutionType type, int limit, String cursor, Function1<? super SelectJoinStep<Record>, ? extends SelectConditionStep<Record>> where) {
        String name$iv = this.poolName;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            SelectForUpdateStep select = SqlExecutionRepository.selectExecutions$default(this, this.jooq, type, null, (Function1)new Function1<SelectJoinStep<Record>, SelectConnectByStep<? extends Record>>(this, type, cursor, where, limit){
                final /* synthetic */ SqlExecutionRepository this$0;
                final /* synthetic */ ExecutionType $type$inlined;
                final /* synthetic */ String $cursor$inlined;
                final /* synthetic */ Function1 $where$inlined;
                final /* synthetic */ int $limit$inlined;
                {
                    this.this$0 = sqlExecutionRepository;
                    this.$type$inlined = executionType;
                    this.$cursor$inlined = string;
                    this.$where$inlined = function1;
                    this.$limit$inlined = n;
                    super(1);
                }

                @NotNull
                public final SelectConnectByStep<? extends Record> invoke(@NotNull SelectJoinStep<Record> it) {
                    SelectConnectByStep selectConnectByStep;
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    if (this.$cursor$inlined == null) {
                        SelectConditionStep selectConditionStep = it.where("1=1");
                        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"it.where(\"1=1\")");
                        selectConnectByStep = (SelectConnectByStep)selectConditionStep;
                    } else {
                        SelectConditionStep selectConditionStep = this.$where$inlined == null ? it.where(DSL.field((String)"id").gt((Object)this.$cursor$inlined)) : ((SelectConditionStep)this.$where$inlined.invoke(it)).and(DSL.field((String)"id").gt((Object)this.$cursor$inlined));
                        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"if (where == null) {\n   \u2026gt(cursor))\n            }");
                        selectConnectByStep = (SelectConnectByStep)selectConditionStep;
                    }
                    return selectConnectByStep;
                }
            }, (Function1)new Function1<SelectConnectByStep<? extends Record>, SelectForUpdateStep<? extends Record>>(this, type, cursor, where, limit){
                final /* synthetic */ SqlExecutionRepository this$0;
                final /* synthetic */ ExecutionType $type$inlined;
                final /* synthetic */ String $cursor$inlined;
                final /* synthetic */ Function1 $where$inlined;
                final /* synthetic */ int $limit$inlined;
                {
                    this.this$0 = sqlExecutionRepository;
                    this.$type$inlined = executionType;
                    this.$cursor$inlined = string;
                    this.$where$inlined = function1;
                    this.$limit$inlined = n;
                    super(1);
                }

                @NotNull
                public final SelectForUpdateStep<? extends Record> invoke(@NotNull SelectConnectByStep<? extends Record> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    SelectLimitPercentStep selectLimitPercentStep = it.orderBy((OrderField)DSL.field((String)"id").desc()).limit(this.$limit$inlined);
                    Intrinsics.checkNotNullExpressionValue((Object)selectLimitPercentStep, (String)"it.orderBy(field(\"id\").d\u2026            .limit(limit)");
                    return (SelectForUpdateStep)selectLimitPercentStep;
                }
            }, 2, null);
            Collection<PipelineExecution> collection = this.fetchExecutions((SelectForUpdateStep<? extends Record>)select);
            return collection;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    static /* synthetic */ Collection selectExecutions$default(SqlExecutionRepository sqlExecutionRepository, ExecutionType executionType, int n, String string, Function1 function1, int n2, Object object) {
        if ((n2 & 8) != 0) {
            function1 = null;
        }
        return sqlExecutionRepository.selectExecutions(executionType, n, string, (Function1<? super SelectJoinStep<Record>, ? extends SelectConditionStep<Record>>)function1);
    }

    private final void transactional(DSLContext $this$transactional, Function1<? super DSLContext, Unit> fn) {
        retrySupport.retry((Supplier)new Supplier<Unit>($this$transactional, fn){
            final /* synthetic */ DSLContext $this_transactional;
            final /* synthetic */ Function1 $fn;

            public final void get() {
                this.$this_transactional.transaction(new TransactionalRunnable(this){
                    final /* synthetic */ transactional.1 this$0;

                    public final void run(Configuration ctx) {
                        Function1 function1 = this.this$0.$fn;
                        DSLContext dSLContext = DSL.using((Configuration)ctx);
                        Intrinsics.checkNotNullExpressionValue((Object)dSLContext, (String)"DSL.using(ctx)");
                        function1.invoke((Object)dSLContext);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$this_transactional = dSLContext;
                this.$fn = function1;
            }
        }, this.retryProperties.getMaxRetries(), this.retryProperties.getBackoffMs(), false);
    }

    private final SelectForUpdateStep<? extends Record> selectExecutions(DSLContext $this$selectExecutions, ExecutionType type, List<? extends Field<Object>> fields, Function1<? super SelectJoinStep<Record>, ? extends SelectConnectByStep<? extends Record>> conditions, Function1<? super SelectConnectByStep<? extends Record>, ? extends SelectForUpdateStep<? extends Record>> seek) {
        SelectJoinStep selectJoinStep = $this$selectExecutions.select((Collection)fields).from((TableLike)JooqKt.getTableName(type));
        boolean bl = false;
        boolean bl2 = false;
        SelectJoinStep it = selectJoinStep;
        boolean bl3 = false;
        SelectJoinStep selectJoinStep2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)selectJoinStep2, (String)"it");
        selectJoinStep = (SelectConnectByStep)conditions.invoke((Object)selectJoinStep2);
        bl = false;
        bl2 = false;
        it = selectJoinStep;
        boolean bl4 = false;
        return (SelectForUpdateStep)seek.invoke((Object)it);
    }

    static /* synthetic */ SelectForUpdateStep selectExecutions$default(SqlExecutionRepository sqlExecutionRepository, DSLContext dSLContext, ExecutionType executionType, List list, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            list = sqlExecutionRepository.selectFields();
        }
        return sqlExecutionRepository.selectExecutions(dSLContext, executionType, list, (Function1<? super SelectJoinStep<Record>, ? extends SelectConnectByStep<? extends Record>>)function1, (Function1<? super SelectConnectByStep<? extends Record>, ? extends SelectForUpdateStep<? extends Record>>)function12);
    }

    private final SelectForUpdateStep<? extends Record> selectExecutions(DSLContext $this$selectExecutions, ExecutionType type, List<? extends Field<Object>> fields, String usingIndex, Function1<? super SelectJoinStep<Record>, ? extends SelectConnectByStep<? extends Record>> conditions, Function1<? super SelectConnectByStep<? extends Record>, ? extends SelectForUpdateStep<? extends Record>> seek) {
        SelectJoinStep selectJoinStep = $this$selectExecutions.select((Collection)fields).from((TableLike)(this.jooq.dialect() == SQLDialect.MYSQL ? JooqKt.getTableName(type).forceIndex(new String[]{usingIndex}) : JooqKt.getTableName(type)));
        boolean bl = false;
        boolean bl2 = false;
        SelectJoinStep it = selectJoinStep;
        boolean bl3 = false;
        SelectJoinStep selectJoinStep2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)selectJoinStep2, (String)"it");
        selectJoinStep = (SelectConnectByStep)conditions.invoke((Object)selectJoinStep2);
        bl = false;
        bl2 = false;
        it = selectJoinStep;
        boolean bl4 = false;
        return (SelectForUpdateStep)seek.invoke((Object)it);
    }

    static /* synthetic */ SelectForUpdateStep selectExecutions$default(SqlExecutionRepository sqlExecutionRepository, DSLContext dSLContext, ExecutionType executionType, List list, String string, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            list = sqlExecutionRepository.selectFields();
        }
        return sqlExecutionRepository.selectExecutions(dSLContext, executionType, list, string, (Function1<? super SelectJoinStep<Record>, ? extends SelectConnectByStep<? extends Record>>)function1, (Function1<? super SelectConnectByStep<? extends Record>, ? extends SelectForUpdateStep<? extends Record>>)function12);
    }

    private final SelectJoinStep<Record> selectExecution(DSLContext $this$selectExecution, ExecutionType type, List<? extends Field<Object>> fields) {
        return $this$selectExecution.select((Collection)fields).from((TableLike)JooqKt.getTableName(type));
    }

    static /* synthetic */ SelectJoinStep selectExecution$default(SqlExecutionRepository sqlExecutionRepository, DSLContext dSLContext, ExecutionType executionType, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = sqlExecutionRepository.selectFields();
        }
        return sqlExecutionRepository.selectExecution(dSLContext, executionType, list);
    }

    private final List<Field<Object>> selectFields() {
        return CollectionsKt.listOf((Object[])new Field[]{DSL.field((String)"id"), DSL.field((String)"body"), DSL.field((Name)DSL.name((String)"partition"))});
    }

    private final Collection<PipelineExecution> fetchExecutions(SelectForUpdateStep<? extends Record> $this$fetchExecutions) {
        ExecutionMapper executionMapper = new ExecutionMapper(this.mapper, this.stageReadSize);
        ResultSet resultSet = $this$fetchExecutions.fetch().intoResultSet();
        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"fetch().intoResultSet()");
        return executionMapper.map(resultSet, this.jooq);
    }

    private final PipelineExecution fetchExecution(SelectForUpdateStep<? extends Record> $this$fetchExecution) {
        return (PipelineExecution)CollectionsKt.firstOrNull((Iterable)this.fetchExecutions($this$fetchExecution));
    }

    private final fetchExecutions.1 fetchExecutions(Function2<? super Integer, ? super String, ? extends Iterable<? extends PipelineExecution>> nextPage) {
        return new Iterable<PipelineExecution>(this, nextPage){
            final /* synthetic */ SqlExecutionRepository this$0;
            final /* synthetic */ Function2 $nextPage;

            @NotNull
            public Iterator<PipelineExecution> iterator() {
                return new PagedIterator<T, C>(SqlExecutionRepository.access$getBatchReadSize$p(this.this$0), fetchExecutions.iterator.1.INSTANCE, this.$nextPage);
            }
            {
                this.this$0 = this$0;
                this.$nextPage = $captured_local_variable$1;
            }
        };
    }

    private final boolean isForeign(PipelineExecution execution, boolean shouldThrow) {
        boolean foreign;
        String partition = execution.getPartition();
        boolean bl = foreign = !this.handlesPartition(partition);
        if (foreign && shouldThrow) {
            String string = execution.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"execution.id");
            String string2 = partition;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"partition");
            throw (Throwable)((Object)new ForeignExecutionException(string, string2, this.partitionName));
        }
        return foreign;
    }

    static /* synthetic */ boolean isForeign$default(SqlExecutionRepository sqlExecutionRepository, PipelineExecution pipelineExecution, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return sqlExecutionRepository.isForeign(pipelineExecution, bl);
    }

    private final boolean isForeign(ExecutionType executionType, String id, boolean shouldThrow) {
        boolean bl;
        if (this.partitionName == null) {
            return false;
        }
        try {
            PipelineExecution execution = this.retrieve(executionType, id);
            bl = this.isForeign(execution, shouldThrow);
        }
        catch (ExecutionNotFoundException executionNotFoundException) {
            bl = false;
        }
        return bl;
    }

    static /* synthetic */ boolean isForeign$default(SqlExecutionRepository sqlExecutionRepository, ExecutionType executionType, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return sqlExecutionRepository.isForeign(executionType, string, bl);
    }

    @Nullable
    public String getPartition() {
        return this.partitionName;
    }

    private final boolean validateHandledPartitionOrThrow(PipelineExecution execution) {
        return this.isForeign(execution, true);
    }

    private final void withListener(Function1<? super ExecutionRepositoryListener, Unit> callback) {
        Iterable $this$forEach$iv = this.executionRepositoryListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExecutionRepositoryListener it = (ExecutionRepositoryListener)element$iv;
            boolean bl = false;
            try {
                callback.invoke((Object)it);
            }
            catch (Exception e) {
                this.log.warn("Listener '" + it.getClass().getSimpleName() + "' encountered an error", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlExecutionRepository(@Nullable String partitionName, @NotNull DSLContext jooq, @NotNull ObjectMapper mapper, @NotNull RetryProperties retryProperties, int batchReadSize, int stageReadSize, @NotNull String poolName, @Nullable Interlink interlink, @NotNull Collection<? extends ExecutionRepositoryListener> executionRepositoryListeners) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)retryProperties, (String)"retryProperties");
        Intrinsics.checkNotNullParameter((Object)poolName, (String)"poolName");
        Intrinsics.checkNotNullParameter(executionRepositoryListeners, (String)"executionRepositoryListeners");
        this.partitionName = partitionName;
        this.jooq = jooq;
        this.mapper = mapper;
        this.retryProperties = retryProperties;
        this.batchReadSize = batchReadSize;
        this.stageReadSize = stageReadSize;
        this.poolName = poolName;
        this.interlink = interlink;
        this.executionRepositoryListeners = executionRepositoryListeners;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.log.info("Creating SqlExecutionRepository with partition=" + this.partitionName + " and pool=" + this.poolName);
        try {
            String name$iv = this.poolName;
            boolean $i$f$withPool = false;
            NamedDatabaseContextHolder.INSTANCE.set(name$iv);
            try {
                boolean bl = false;
                this.transactional(this.jooq, (Function1<? super DSLContext, Unit>)((Function1)new Function1<DSLContext, Unit>(this){
                    final /* synthetic */ SqlExecutionRepository this$0;
                    {
                        this.this$0 = sqlExecutionRepository;
                        super(1);
                    }

                    public final void invoke(@NotNull DSLContext it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Record record = SqlExecutionRepository.access$getJooq$p(this.this$0).fetchOne(DSL.table((String)"partition_name"));
                        if (record == null) {
                            if (SqlExecutionRepository.access$getPartitionName$p(this.this$0) != null) {
                                SqlExecutionRepository.access$getJooq$p(this.this$0).insertInto(DSL.table((String)"partition_name")).values(new Object[]{1, SqlExecutionRepository.access$getPartitionName$p(this.this$0)}).execute();
                            }
                        } else {
                            String dbPartitionName;
                            Object object = record.get("name");
                            String string = dbPartitionName = object != null ? object.toString() : null;
                            if (Intrinsics.areEqual((Object)SqlExecutionRepository.access$getPartitionName$p(this.this$0), (Object)dbPartitionName) ^ true) {
                                throw (Throwable)new ConfigurationException("Invalid configuration detected: Can't change partition name to " + SqlExecutionRepository.access$getPartitionName$p(this.this$0) + " on the database once it has been set to " + dbPartitionName);
                            }
                        }
                    }
                }));
                Unit unit = Unit.INSTANCE;
            }
            finally {
                NamedDatabaseContextHolder.INSTANCE.clear();
            }
        }
        catch (TooManyRowsException e) {
            throw (Throwable)new SystemException("The partition_name table should have zero or one rows but multiple rows were found", (Throwable)e);
        }
    }

    public /* synthetic */ SqlExecutionRepository(String string, DSLContext dSLContext, ObjectMapper objectMapper, RetryProperties retryProperties, int n, int n2, String string2, Interlink interlink, Collection collection, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            n = 10;
        }
        if ((n3 & 0x20) != 0) {
            n2 = 200;
        }
        if ((n3 & 0x40) != 0) {
            string2 = "default";
        }
        if ((n3 & 0x80) != 0) {
            interlink = null;
        }
        if ((n3 & 0x100) != 0) {
            collection = CollectionsKt.emptyList();
        }
        this(string, dSLContext, objectMapper, retryProperties, n, n2, string2, interlink, collection);
    }

    static {
        Companion = new Companion(null);
        ulid = new SpinULID(new SecureRandom());
        retrySupport = new RetrySupport();
    }

    public static final /* synthetic */ void access$storeExecutionInternal(SqlExecutionRepository $this, DSLContext ctx, PipelineExecution execution, boolean storeStages) {
        $this.storeExecutionInternal(ctx, execution, storeStages);
    }

    public static final /* synthetic */ void access$transactional(SqlExecutionRepository $this, DSLContext $this$access_u24transactional, Function1 fn) {
        $this.transactional($this$access_u24transactional, (Function1<? super DSLContext, Unit>)fn);
    }

    public static final /* synthetic */ DSLContext access$getJooq$p(SqlExecutionRepository $this) {
        return $this.jooq;
    }

    public static final /* synthetic */ Interlink access$getInterlink$p(SqlExecutionRepository $this) {
        return $this.interlink;
    }

    public static final /* synthetic */ String access$getPartitionName$p(SqlExecutionRepository $this) {
        return $this.partitionName;
    }

    public static final /* synthetic */ Logger access$getLog$p(SqlExecutionRepository $this) {
        return $this.log;
    }

    public static final /* synthetic */ void access$deleteInternal(SqlExecutionRepository $this, DSLContext dslContext, ExecutionType type, List idsToDelete) {
        $this.deleteInternal(dslContext, type, idsToDelete);
    }

    public static final /* synthetic */ SelectConnectByStep access$statusIn(SqlExecutionRepository $this, SelectConnectByStep $this$access_u24statusIn, Collection statuses) {
        return $this.statusIn((SelectConnectByStep<? extends Record>)$this$access_u24statusIn, statuses);
    }

    public static final /* synthetic */ Collection access$selectExecutions(SqlExecutionRepository $this, ExecutionType type, int limit, String cursor, Function1 where) {
        return $this.selectExecutions(type, limit, cursor, (Function1<? super SelectJoinStep<Record>, ? extends SelectConditionStep<Record>>)where);
    }

    public static final /* synthetic */ int access$getBatchReadSize$p(SqlExecutionRepository $this) {
        return $this.batchReadSize;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/netflix/spinnaker/orca/sql/pipeline/persistence/SqlExecutionRepository$SyntheticStageRequired;", "Ljava/lang/IllegalArgumentException;", "Lkotlin/IllegalArgumentException;", "()V", "orca-sql"})
    public static final class SyntheticStageRequired
    extends IllegalArgumentException {
        public SyntheticStageRequired() {
            super("Only synthetic stages can be inserted ad-hoc");
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/netflix/spinnaker/orca/sql/pipeline/persistence/SqlExecutionRepository$Companion;", "", "()V", "retrySupport", "Lcom/netflix/spinnaker/kork/core/RetrySupport;", "getRetrySupport$orca_sql", "()Lcom/netflix/spinnaker/kork/core/RetrySupport;", "ulid", "Lde/huxhorn/sulky/ulid/SpinULID;", "getUlid", "()Lde/huxhorn/sulky/ulid/SpinULID;", "orca-sql"})
    public static final class Companion {
        @NotNull
        public final SpinULID getUlid() {
            return ulid;
        }

        @NotNull
        public final RetrySupport getRetrySupport$orca_sql() {
            return retrySupport;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

