/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.sql.telemetry;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.zaxxer.hikari.metrics.MetricsTracker;
import com.zaxxer.hikari.metrics.PoolStats;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001bH\u0016J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001dH\u0016J\u0006\u0010!\u001a\u00020\u001bR\u0019\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0019\u0010\u0010\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0019\u0010\u0012\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0019\u0010\u0014\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0019\u0010\u0016\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0018\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\r\u00a8\u0006\""}, d2={"Lcom/netflix/spinnaker/orca/sql/telemetry/SpectatorHikariMetricsTracker;", "Lcom/zaxxer/hikari/metrics/MetricsTracker;", "poolName", "", "poolStats", "Lcom/zaxxer/hikari/metrics/PoolStats;", "registry", "Lcom/netflix/spectator/api/Registry;", "(Ljava/lang/String;Lcom/zaxxer/hikari/metrics/PoolStats;Lcom/netflix/spectator/api/Registry;)V", "activeConnectionsId", "Lcom/netflix/spectator/api/Id;", "kotlin.jvm.PlatformType", "getActiveConnectionsId", "()Lcom/netflix/spectator/api/Id;", "blockedThreadsId", "getBlockedThreadsId", "connectionAcquiredId", "getConnectionAcquiredId", "connectionTimeoutId", "getConnectionTimeoutId", "connectionUsageId", "getConnectionUsageId", "idleConnectionsId", "getIdleConnectionsId", "totalConnectionsId", "getTotalConnectionsId", "recordConnectionAcquiredNanos", "", "elapsedAcquiredNanos", "", "recordConnectionTimeout", "recordConnectionUsageMillis", "elapsedBorrowedMillis", "recordPoolStats", "orca-sql"})
public final class SpectatorHikariMetricsTracker
extends MetricsTracker {
    private final Id connectionAcquiredId;
    private final Id connectionUsageId;
    private final Id connectionTimeoutId;
    private final Id idleConnectionsId;
    private final Id activeConnectionsId;
    private final Id totalConnectionsId;
    private final Id blockedThreadsId;
    private final PoolStats poolStats;
    private final Registry registry;

    public final Id getConnectionAcquiredId() {
        return this.connectionAcquiredId;
    }

    public final Id getConnectionUsageId() {
        return this.connectionUsageId;
    }

    public final Id getConnectionTimeoutId() {
        return this.connectionTimeoutId;
    }

    public final Id getIdleConnectionsId() {
        return this.idleConnectionsId;
    }

    public final Id getActiveConnectionsId() {
        return this.activeConnectionsId;
    }

    public final Id getTotalConnectionsId() {
        return this.totalConnectionsId;
    }

    public final Id getBlockedThreadsId() {
        return this.blockedThreadsId;
    }

    public final void recordPoolStats() {
        this.registry.gauge(this.idleConnectionsId).set((double)this.poolStats.getIdleConnections());
        this.registry.gauge(this.activeConnectionsId).set((double)this.poolStats.getActiveConnections());
        this.registry.gauge(this.totalConnectionsId).set((double)this.poolStats.getTotalConnections());
        this.registry.gauge(this.blockedThreadsId).set((double)this.poolStats.getPendingThreads());
    }

    public void recordConnectionAcquiredNanos(long elapsedAcquiredNanos) {
        this.registry.timer(this.connectionAcquiredId).record(elapsedAcquiredNanos, TimeUnit.NANOSECONDS);
    }

    public void recordConnectionUsageMillis(long elapsedBorrowedMillis) {
        this.registry.timer(this.connectionUsageId).record(elapsedBorrowedMillis, TimeUnit.MILLISECONDS);
    }

    public void recordConnectionTimeout() {
        this.registry.counter(this.connectionTimeoutId).increment();
    }

    public SpectatorHikariMetricsTracker(@NotNull String poolName, @NotNull PoolStats poolStats, @NotNull Registry registry) {
        Intrinsics.checkNotNullParameter((Object)poolName, (String)"poolName");
        Intrinsics.checkNotNullParameter((Object)poolStats, (String)"poolStats");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.poolStats = poolStats;
        this.registry = registry;
        this.connectionAcquiredId = this.registry.createId("sql.pool." + poolName + ".connectionAcquiredTiming");
        this.connectionUsageId = this.registry.createId("sql.pool." + poolName + ".connectionUsageTiming");
        this.connectionTimeoutId = this.registry.createId("sql.pool." + poolName + ".connectionTimeout");
        this.idleConnectionsId = this.registry.createId("sql.pool." + poolName + ".idle");
        this.activeConnectionsId = this.registry.createId("sql.pool." + poolName + ".active");
        this.totalConnectionsId = this.registry.createId("sql.pool." + poolName + ".total");
        this.blockedThreadsId = this.registry.createId("sql.pool." + poolName + ".blocked");
    }
}

