/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.sql.telemetry;

import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.sql.pipeline.persistence.ActiveExecutionsReport;
import com.netflix.spinnaker.orca.sql.pipeline.persistence.ExecutionStatisticsRepository;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0011\u001a\u00020\u0012R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000b*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u000b*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/netflix/spinnaker/orca/sql/telemetry/SqlActiveExecutionsMonitor;", "", "executionRepository", "Lcom/netflix/spinnaker/orca/sql/pipeline/persistence/ExecutionStatisticsRepository;", "registry", "Lcom/netflix/spectator/api/Registry;", "refreshFrequencyMs", "", "(Lcom/netflix/spinnaker/orca/sql/pipeline/persistence/ExecutionStatisticsRepository;Lcom/netflix/spectator/api/Registry;J)V", "activeOrchestrationCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "kotlin.jvm.PlatformType", "activePipelineCounter", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "log", "Lorg/slf4j/Logger;", "refreshGauges", "", "orca-sql"})
public final class SqlActiveExecutionsMonitor {
    private final Logger log;
    private final ScheduledExecutorService executor;
    private final AtomicInteger activePipelineCounter;
    private final AtomicInteger activeOrchestrationCounter;
    private final ExecutionStatisticsRepository executionRepository;

    public final void refreshGauges() {
        ActiveExecutionsReport activeExecutionsReport = this.executionRepository.countActiveExecutions();
        boolean bl = false;
        boolean bl2 = false;
        ActiveExecutionsReport $this$run = activeExecutionsReport;
        boolean bl3 = false;
        this.log.info("Refreshing active execution gauges (active: " + $this$run.total() + ')');
        this.activePipelineCounter.set($this$run.getPipelines());
        this.activeOrchestrationCounter.set($this$run.getOrchestrations());
    }

    public SqlActiveExecutionsMonitor(@NotNull ExecutionStatisticsRepository executionRepository, @NotNull Registry registry, long refreshFrequencyMs) {
        Intrinsics.checkNotNullParameter((Object)executionRepository, (String)"executionRepository");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.executionRepository = executionRepository;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.executor = Executors.newScheduledThreadPool(1);
        this.activePipelineCounter = (AtomicInteger)registry.gauge(registry.createId("executions.active").withTag("executionType", ExecutionType.PIPELINE.toString()), (Number)new AtomicInteger(0));
        this.activeOrchestrationCounter = (AtomicInteger)registry.gauge(registry.createId("executions.active").withTag("executionType", ExecutionType.ORCHESTRATION.toString()), (Number)new AtomicInteger(0));
        this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public final void run() {
                try {
                    this.refreshGauges();
                }
                catch (Exception e) {
                    log.error("Unable to refresh active execution gauges", (Throwable)e);
                }
            }
        }, 0L, refreshFrequencyMs, TimeUnit.MILLISECONDS);
    }
}

