/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.controllers;

import com.netflix.spinnaker.orca.capabilities.CapabilitiesService;
import com.netflix.spinnaker.orca.capabilities.models.ExpressionCapabilityResult;
import com.netflix.spinnaker.orca.deploymentmonitor.DeploymentMonitorCapabilities;
import com.netflix.spinnaker.orca.deploymentmonitor.models.DeploymentMonitorDefinition;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CapabilitiesController {
    private CapabilitiesService orcaCapabilities;
    private DeploymentMonitorCapabilities deploymentMonitorCapabilities;

    public CapabilitiesController(CapabilitiesService orcaCapabilities, Optional<DeploymentMonitorCapabilities> deploymentMonitorCapabilities) {
        this.deploymentMonitorCapabilities = deploymentMonitorCapabilities.orElse(null);
        this.orcaCapabilities = orcaCapabilities;
    }

    @GetMapping(value={"/capabilities/deploymentMonitors"})
    public List<DeploymentMonitorDefinition> getDeploymentMonitors() {
        if (this.deploymentMonitorCapabilities == null) {
            return Collections.emptyList();
        }
        return this.deploymentMonitorCapabilities.getDeploymentMonitors();
    }

    @GetMapping(value={"/capabilities/expressions"})
    public ExpressionCapabilityResult getExpressionCapabilities() {
        return this.orcaCapabilities.getExpressionCapabilities();
    }
}

