/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.controllers;

import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionNotFoundException;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CorrelatedTasksController {
    private final ExecutionRepository executionRepository;

    @Autowired
    public CorrelatedTasksController(ExecutionRepository executionRepository) {
        this.executionRepository = executionRepository;
    }

    @GetMapping(path={"/executions/correlated/{correlationId}"}, produces={"application/json"})
    public List<String> getCorrelatedExecutions(@PathVariable String correlationId) {
        return Stream.builder().add(this.getCorrelated(ExecutionType.PIPELINE, correlationId)).add(this.getCorrelated(ExecutionType.ORCHESTRATION, correlationId)).build().filter(Objects::nonNull).map(PipelineExecution::getId).collect(Collectors.toList());
    }

    private PipelineExecution getCorrelated(ExecutionType executionType, String correlationId) {
        try {
            return this.executionRepository.retrieveByCorrelationId(executionType, correlationId);
        }
        catch (ExecutionNotFoundException ignored) {
            return null;
        }
    }
}

