/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.fiat.model.UserPermission;
import com.netflix.spinnaker.fiat.model.resources.Role;
import com.netflix.spinnaker.fiat.shared.FiatService;
import com.netflix.spinnaker.fiat.shared.FiatStatus;
import com.netflix.spinnaker.kork.exceptions.ConfigurationException;
import com.netflix.spinnaker.kork.exceptions.SpinnakerException;
import com.netflix.spinnaker.orca.api.pipeline.ExecutionPreprocessor;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.Trigger;
import com.netflix.spinnaker.orca.clouddriver.service.JobService;
import com.netflix.spinnaker.orca.exceptions.OperationFailedException;
import com.netflix.spinnaker.orca.exceptions.PipelineTemplateValidationException;
import com.netflix.spinnaker.orca.front50.Front50Service;
import com.netflix.spinnaker.orca.front50.PipelineModelMutator;
import com.netflix.spinnaker.orca.igor.BuildService;
import com.netflix.spinnaker.orca.pipeline.ExecutionLauncher;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionNotFoundException;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.pipeline.util.ArtifactUtils;
import com.netflix.spinnaker.orca.pipeline.util.ContextParameterProcessor;
import com.netflix.spinnaker.orca.pipelinetemplate.PipelineTemplateService;
import com.netflix.spinnaker.orca.webhook.service.WebhookService;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.NotFoundException;
import javax.servlet.http.HttpServletResponse;
import net.logstash.logback.argument.StructuredArguments;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import retrofit.RetrofitError;
import retrofit.http.Query;

@RestController
public class OperationsController
implements GroovyObject {
    @Autowired
    private ExecutionLauncher executionLauncher;
    @Autowired(required=false)
    private BuildService buildService;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ExecutionRepository executionRepository;
    @Autowired(required=false)
    private PipelineTemplateService pipelineTemplateService;
    @Autowired
    private ContextParameterProcessor contextParameterProcessor;
    @Autowired(required=false)
    private List<ExecutionPreprocessor> executionPreprocessors;
    @Autowired(required=false)
    private List<PipelineModelMutator> pipelineModelMutators;
    @Autowired(required=false)
    private WebhookService webhookService;
    @Autowired(required=false)
    private JobService jobService;
    @Autowired(required=false)
    private ArtifactUtils artifactUtils;
    @Autowired
    private FiatStatus fiatStatus;
    @Autowired(required=false)
    private FiatService fiatService;
    @Autowired(required=false)
    private Front50Service front50Service;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public OperationsController() {
        MetaClass metaClass;
        CallSite[] callSiteArray = OperationsController.$getCallSiteArray();
        Object object = callSiteArray[0].callConstructor(ArrayList.class);
        this.executionPreprocessors = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        Object object2 = callSiteArray[1].callConstructor(ArrayList.class);
        this.pipelineModelMutators = (List)ScriptBytecodeAdapter.castToType((Object)object2, List.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/orchestrate"})
    public Map<String, Object> orchestrate(@RequestBody Map pipeline, HttpServletResponse response) {
        CallSite[] callSiteArray = OperationsController.$getCallSiteArray();
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].callCurrent((GroovyObject)this, (Object)pipeline), Map.class);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/orchestrate/{pipelineConfigId}"})
    public Map<String, Object> orchestratePipelineConfig(@PathVariable String pipelineConfigId, @RequestBody Map trigger) {
        CallSite[] callSiteArray = OperationsController.$getCallSiteArray();
        Map pipelineConfig = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callCurrent((GroovyObject)this, (Object)pipelineConfigId, (Object)trigger), Map.class);
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].callCurrent((GroovyObject)this, (Object)pipelineConfig), Map.class);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/plan"})
    public Map<String, Object> plan(@RequestBody Map pipeline, @Query(value="resolveArtifacts") boolean resolveArtifacts, HttpServletResponse response) {
        CallSite[] callSiteArray = OperationsController.$getCallSiteArray();
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].callCurrent((GroovyObject)this, (Object)pipeline, (Object)resolveArtifacts), Map.class);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/plan/{pipelineConfigId}"})
    public Map<String, Object> planPipelineConfig(@PathVariable String pipelineConfigId, @Query(value="resolveArtifacts") boolean resolveArtifacts, @RequestBody Map trigger) {
        CallSite[] callSiteArray = OperationsController.$getCallSiteArray();
        Map pipelineConfig = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[6].callCurrent((GroovyObject)this, (Object)pipelineConfigId, (Object)trigger), Map.class);
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[7].callCurrent((GroovyObject)this, (Object)pipelineConfig, (Object)resolveArtifacts), Map.class);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/fail"})
    public void failPipeline(@RequestBody Map pipeline) {
        CallSite[] callSiteArray = OperationsController.$getCallSiteArray();
        String errorMessage = ShortTypeHandling.castToString((Object)callSiteArray[8].call((Object)pipeline, (Object)"errorMessage"));
        callSiteArray[9].callCurrent((GroovyObject)this, (Object)pipeline, (Object)errorMessage);
    }

    private Map buildPipelineConfig(String pipelineConfigId, Map trigger) {
        Reference pipelineConfigId2 = new Reference((Object)pipelineConfigId);
        CallSite[] callSiteArray = OperationsController.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)this.front50Service, null)) {
            throw (Throwable)callSiteArray[10].callConstructor(UnsupportedOperationException.class, (Object)"Front50 is not enabled, no way to retrieve pipeline configs. Fix this by setting front50.enabled: true");
        }
        public final class _buildPipelineConfig_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference pipelineConfigId;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _buildPipelineConfig_closure1(Object _outerInstance, Object _thisObject, Reference pipelineConfigId) {
                Reference reference;
                CallSite[] callSiteArray = _buildPipelineConfig_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.pipelineConfigId = reference = pipelineConfigId;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _buildPipelineConfig_closure1.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), this.pipelineConfigId.get());
            }

            @Generated
            public String getPipelineConfigId() {
                CallSite[] callSiteArray = _buildPipelineConfig_closure1.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.pipelineConfigId.get());
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _buildPipelineConfig_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildPipelineConfig_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getPipeline";
                stringArray[1] = "front50Service";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _buildPipelineConfig_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_buildPipelineConfig_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildPipelineConfig_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Map pipelineConfig = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].call(AuthenticatedRequest.class, (Object)new _buildPipelineConfig_closure1(this, this, pipelineConfigId2)), Map.class);
        Map map = trigger;
        ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)pipelineConfig, (String)"trigger");
        Map map2 = pipelineConfig;
        try {
            return map2;
        }
        catch (RetrofitError e) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[12].callGetPropertySafe(callSiteArray[13].callGetProperty((Object)e)), (Object)callSiteArray[14].callGetProperty(HttpURLConnection.class))) {
                throw (Throwable)callSiteArray[15].callConstructor(NotFoundException.class, (Object)new GStringImpl(new Object[]{(String)pipelineConfigId2.get()}, new String[]{"Pipeline config ", " not found"}));
            }
            throw (Throwable)e;
        }
    }

    private Map planOrOrchestratePipeline(Map pipeline) {
        CallSite[] callSiteArray = OperationsController.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[16].callGetProperty((Object)pipeline))) {
            return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[17].callCurrent((GroovyObject)this, (Object)pipeline, (Object)false), Map.class);
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[18].callCurrent((GroovyObject)this, (Object)pipeline), Map.class);
    }

    private Map<String, Object> planPipeline(Map pipeline, boolean resolveArtifacts) {
        Reference pipeline2 = new Reference((Object)pipeline);
        CallSite[] callSiteArray = OperationsController.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[19].call((Object)log)) ? callSiteArray[20].call((Object)log, (Object)"Not starting pipeline (plan: true): {}", callSiteArray[21].callStatic(StructuredArguments.class, (Object)"pipelineId", callSiteArray[22].callGetProperty((Object)((Map)pipeline2.get())))) : null;
        public final class _planPipeline_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference pipeline;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _planPipeline_closure2(Object _outerInstance, Object _thisObject, Reference pipeline) {
                Reference reference;
                CallSite[] callSiteArray = _planPipeline_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.pipeline = reference = pipeline;
            }

            public Object doCall(Object m) {
                CallSite[] callSiteArray = _planPipeline_closure2.$getCallSiteArray();
                return callSiteArray[0].call(m, this.pipeline.get());
            }

            @Generated
            public Map getPipeline() {
                CallSite[] callSiteArray = _planPipeline_closure2.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.pipeline.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _planPipeline_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "supports";
                return new CallSiteArray(_planPipeline_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _planPipeline_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _planPipeline_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference pipeline;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _planPipeline_closure3(Object _outerInstance, Object _thisObject, Reference pipeline) {
                Reference reference;
                CallSite[] callSiteArray = _planPipeline_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.pipeline = reference = pipeline;
            }

            public Object doCall(Object m) {
                CallSite[] callSiteArray = _planPipeline_closure3.$getCallSiteArray();
                return callSiteArray[0].call(m, this.pipeline.get());
            }

            @Generated
            public Map getPipeline() {
                CallSite[] callSiteArray = _planPipeline_closure3.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.pipeline.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _planPipeline_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "mutate";
                return new CallSiteArray(_planPipeline_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _planPipeline_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[23].call(callSiteArray[24].call(callSiteArray[25].call(this.pipelineModelMutators), (Object)new _planPipeline_closure2(this, this, pipeline2)), (Object)new _planPipeline_closure3(this, this, pipeline2));
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[26].callCurrent((GroovyObject)this, (Object)((Map)pipeline2.get()), (Object)resolveArtifacts), Map.class);
    }

    private Map<String, Object> orchestratePipeline(Map pipeline) {
        CallSite[] callSiteArray = OperationsController.$getCallSiteArray();
        long startTime = DefaultTypeTransformation.longUnbox((Object)callSiteArray[27].call(System.class));
        Exception pipelineError = null;
        try {
            Object object = callSiteArray[28].callCurrent((GroovyObject)this, (Object)pipeline);
            pipeline = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
        }
        catch (Exception e) {
            Exception exception;
            pipelineError = exception = e;
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = "trigger";
        objectArray[1] = callSiteArray[29].callGetProperty((Object)pipeline);
        objectArray[2] = "templateVariables";
        Object object = callSiteArray[30].callGetProperty((Object)pipeline);
        objectArray[3] = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        Map augmentedContext = ScriptBytecodeAdapter.createMap((Object[])objectArray);
        Object processedPipeline = callSiteArray[31].call((Object)this.contextParameterProcessor, (Object)pipeline, (Object)augmentedContext, (Object)false);
        Object object2 = callSiteArray[32].call((Object)this.objectMapper, callSiteArray[33].callGetProperty(processedPipeline), Trigger.class);
        ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)processedPipeline, (String)"trigger");
        if (ScriptBytecodeAdapter.compareEqual((Object)pipelineError, null)) {
            Object id = callSiteArray[34].callCurrent((GroovyObject)this, processedPipeline);
            Object object3 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[35].call((Object)log)) ? callSiteArray[36].call((Object)log, (Object)"Started pipeline {} based on request body {} (took: {}ms)", id, callSiteArray[37].callCurrent((GroovyObject)this, (Object)pipeline), callSiteArray[38].call(callSiteArray[39].call(System.class), (Object)startTime)) : null;
            return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"ref", callSiteArray[40].call((Object)"/pipelines/", id)});
        }
        Object id = callSiteArray[41].callCurrent((GroovyObject)this, processedPipeline, (Object)pipelineError);
        Object object4 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[42].call((Object)log)) ? callSiteArray[43].call((Object)log, (Object)"Failed to start pipeline {} based on request body {}", id, callSiteArray[44].callCurrent((GroovyObject)this, (Object)pipeline)) : null;
        throw (Throwable)pipelineError;
    }

    private void recordPipelineFailure(Map pipeline, String errorMessage) {
        CallSite[] callSiteArray = OperationsController.$getCallSiteArray();
        Exception pipelineError = null;
        try {
            Object object = callSiteArray[45].callCurrent((GroovyObject)this, (Object)pipeline);
            pipeline = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
        }
        catch (Exception e) {
            Exception exception;
            pipelineError = exception = e;
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = "trigger";
        objectArray[1] = callSiteArray[46].callGetProperty((Object)pipeline);
        objectArray[2] = "templateVariables";
        Object object = callSiteArray[47].callGetProperty((Object)pipeline);
        objectArray[3] = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        Map augmentedContext = ScriptBytecodeAdapter.createMap((Object[])objectArray);
        Object processedPipeline = callSiteArray[48].call((Object)this.contextParameterProcessor, (Object)pipeline, (Object)augmentedContext, (Object)false);
        Object object2 = callSiteArray[49].call((Object)this.objectMapper, callSiteArray[50].callGetProperty(processedPipeline), Trigger.class);
        ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)processedPipeline, (String)"trigger");
        if (ScriptBytecodeAdapter.compareNotEqual((Object)pipelineError, null)) {
            Object object3 = callSiteArray[51].callConstructor(SpinnakerException.class, (Object)errorMessage, (Object)pipelineError);
            pipelineError = (Exception)ScriptBytecodeAdapter.castToType((Object)object3, Exception.class);
        } else {
            Object object4 = callSiteArray[52].callConstructor(SpinnakerException.class, (Object)errorMessage);
            pipelineError = (Exception)ScriptBytecodeAdapter.castToType((Object)object4, Exception.class);
        }
        callSiteArray[53].callCurrent((GroovyObject)this, processedPipeline, (Object)pipelineError);
    }

    public Map parseAndValidatePipeline(Map pipeline) {
        CallSite[] callSiteArray = OperationsController.$getCallSiteArray();
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[54].callCurrent((GroovyObject)this, (Object)pipeline, (Object)true), Map.class);
    }

    public Map parseAndValidatePipeline(Map pipeline, boolean resolveArtifacts) {
        Reference pipeline2 = new Reference((Object)pipeline);
        CallSite[] callSiteArray = OperationsController.$getCallSiteArray();
        callSiteArray[55].callCurrent((GroovyObject)this, (Object)((Map)pipeline2.get()), (Object)resolveArtifacts);
        ExecutionPreprocessor preprocessor = null;
        public final class _parseAndValidatePipeline_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference pipeline;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _parseAndValidatePipeline_closure4(Object _outerInstance, Object _thisObject, Reference pipeline) {
                Reference reference;
                CallSite[] callSiteArray = _parseAndValidatePipeline_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.pipeline = reference = pipeline;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _parseAndValidatePipeline_closure4.$getCallSiteArray();
                return callSiteArray[0].call(it, this.pipeline.get(), callSiteArray[1].callGetProperty(ExecutionPreprocessor.Type.class));
            }

            @Generated
            public Map getPipeline() {
                CallSite[] callSiteArray = _parseAndValidatePipeline_closure4.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.pipeline.get(), Map.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _parseAndValidatePipeline_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _parseAndValidatePipeline_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "supports";
                stringArray[1] = "PIPELINE";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _parseAndValidatePipeline_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_parseAndValidatePipeline_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _parseAndValidatePipeline_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[56].call(callSiteArray[57].call(this.executionPreprocessors, (Object)new _parseAndValidatePipeline_closure4(this, this, pipeline2))), Iterator.class);
        while (iterator.hasNext()) {
            preprocessor = (ExecutionPreprocessor)ScriptBytecodeAdapter.castToType(iterator.next(), ExecutionPreprocessor.class);
            Object object = callSiteArray[58].call((Object)preprocessor, (Object)((Map)pipeline2.get()));
            pipeline2.set((Object)((Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class)));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[59].callGetProperty((Object)((Map)pipeline2.get())))) {
            throw (Throwable)callSiteArray[60].callConstructor(ConfigurationException.class, (Object)"Pipeline is disabled and cannot be started.");
        }
        public final class _parseAndValidatePipeline_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _parseAndValidatePipeline_closure5(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _parseAndValidatePipeline_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _parseAndValidatePipeline_closure5.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), null);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _parseAndValidatePipeline_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _parseAndValidatePipeline_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "refId";
                return new CallSiteArray(_parseAndValidatePipeline_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _parseAndValidatePipeline_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object linear = callSiteArray[61].call(callSiteArray[62].callGetProperty((Object)((Map)pipeline2.get())), (Object)new _parseAndValidatePipeline_closure5(this, this));
        if (DefaultTypeTransformation.booleanUnbox((Object)linear)) {
            callSiteArray[63].callStatic(OperationsController.class, (Object)((Map)pipeline2.get()));
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[64].callGetProperty((Object)((Map)pipeline2.get())), null)) {
            throw (Throwable)callSiteArray[65].callConstructor(PipelineTemplateValidationException.class, (Object)"Pipeline template is invalid", (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((List)ScriptBytecodeAdapter.asType((Object)callSiteArray[66].callGetProperty((Object)((Map)pipeline2.get())), List.class)), List.class));
        }
        return (Map)pipeline2.get();
    }

    private void parsePipelineTrigger(Map pipeline, boolean resolveArtifacts) {
        Reference pipeline2 = new Reference((Object)pipeline);
        CallSite[] callSiteArray = OperationsController.$getCallSiteArray();
        if (!(callSiteArray[67].callGetProperty((Object)((Map)pipeline2.get())) instanceof Map)) {
            Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)((Map)pipeline2.get()), (String)"trigger");
            if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[68].callGetProperty((Object)((Map)pipeline2.get()))) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[69].callGetProperty((Object)((Map)pipeline2.get())), (Object)"templatedPipeline") && ScriptBytecodeAdapter.compareNotEqual((Object)this.pipelineTemplateService, null)) {
                    try {
                        Object previousExecution = callSiteArray[70].call((Object)this.pipelineTemplateService, callSiteArray[71].callGetProperty((Object)((Map)pipeline2.get())), callSiteArray[72].callGetProperty((Object)((Map)pipeline2.get())));
                        Object object = callSiteArray[73].call((Object)this.objectMapper, callSiteArray[74].callGetProperty(previousExecution), Map.class);
                        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)((Map)pipeline2.get()), (String)"trigger");
                        Object object2 = callSiteArray[75].callGetProperty(previousExecution);
                        ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)((Map)pipeline2.get()), (String)"executionId");
                    }
                    catch (ExecutionNotFoundException executionNotFoundException) {
                        callSiteArray[76].call((Object)log, (Object)"Could not initialize pipeline template config from previous execution context.");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        callSiteArray[77].call((Object)log, (Object)"Could not initialize pipeline template config from previous execution context.");
                    }
                }
            } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[78].callGetProperty((Object)((Map)pipeline2.get()))) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[79].callGetProperty((Object)((Map)pipeline2.get())), (Object)"templatedPipeline") && ScriptBytecodeAdapter.compareNotEqual((Object)this.pipelineTemplateService, null)) {
                try {
                    Object previousExecution = callSiteArray[80].call((Object)this.pipelineTemplateService, callSiteArray[81].callGetProperty((Object)((Map)pipeline2.get())), callSiteArray[82].callGetProperty((Object)((Map)pipeline2.get())));
                    Object object = callSiteArray[83].call((Object)this.objectMapper, callSiteArray[84].callGetProperty(previousExecution), Map.class);
                    ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)((Map)pipeline2.get()), (String)"trigger");
                    Object object3 = callSiteArray[85].callGetProperty(previousExecution);
                    ScriptBytecodeAdapter.setProperty((Object)object3, null, (Object)((Map)pipeline2.get()), (String)"executionId");
                }
                catch (ExecutionNotFoundException executionNotFoundException) {
                    callSiteArray[86].call((Object)log, (Object)"Could not initialize pipeline template config from previous execution context.");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    callSiteArray[87].call((Object)log, (Object)"Could not initialize pipeline template config from previous execution context.");
                }
            }
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[88].callGetProperty(callSiteArray[89].callGetProperty((Object)((Map)pipeline2.get()))))) {
            String string = "manual";
            ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)callSiteArray[90].callGetProperty((Object)((Map)pipeline2.get())), (String)"type");
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[91].callGetProperty(callSiteArray[92].callGetProperty((Object)((Map)pipeline2.get()))))) {
            Object object = callSiteArray[93].call(callSiteArray[94].call(AuthenticatedRequest.class), (Object)"[anonymous]");
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[95].callGetProperty((Object)((Map)pipeline2.get())), (String)"user");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.buildService)) {
            callSiteArray[96].callCurrent((GroovyObject)this, callSiteArray[97].callGetProperty((Object)((Map)pipeline2.get())));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[98].callGetProperty(callSiteArray[99].callGetProperty((Object)((Map)pipeline2.get())))) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[100].callGetProperty(callSiteArray[101].callGetProperty((Object)((Map)pipeline2.get()))))) {
            PipelineExecution parentExecution = null;
            try {
                Object object = callSiteArray[102].call((Object)this.executionRepository, callSiteArray[103].callGetProperty(ExecutionType.class), callSiteArray[104].callGetProperty(callSiteArray[105].callGetProperty((Object)((Map)pipeline2.get()))));
                parentExecution = (PipelineExecution)ScriptBytecodeAdapter.castToType((Object)object, PipelineExecution.class);
            }
            catch (ExecutionNotFoundException e) {
            }
            if (DefaultTypeTransformation.booleanUnbox(parentExecution)) {
                boolean bl = true;
                ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)callSiteArray[106].callGetProperty((Object)((Map)pipeline2.get())), (String)"isPipeline");
                Object object = callSiteArray[107].callGetProperty((Object)parentExecution);
                ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[108].callGetProperty((Object)((Map)pipeline2.get())), (String)"parentStatus");
                PipelineExecution pipelineExecution = parentExecution;
                ScriptBytecodeAdapter.setProperty((Object)pipelineExecution, null, (Object)callSiteArray[109].callGetProperty((Object)((Map)pipeline2.get())), (String)"parentExecution");
                Object object4 = callSiteArray[110].callGetProperty((Object)parentExecution);
                ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)callSiteArray[111].callGetProperty((Object)((Map)pipeline2.get())), (String)"parentPipelineName");
                Object object5 = callSiteArray[112].call((Object)this.artifactUtils, (Object)parentExecution);
                ScriptBytecodeAdapter.setProperty((Object)object5, null, (Object)((Map)pipeline2.get()), (String)"receivedArtifacts");
            }
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[113].callGetProperty(callSiteArray[114].callGetProperty((Object)((Map)pipeline2.get()))))) {
            Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)callSiteArray[115].callGetProperty((Object)((Map)pipeline2.get())), (String)"parameters");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[116].callGetProperty((Object)((Map)pipeline2.get())))) {
            public final class _parsePipelineTrigger_closure6
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference pipeline;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _parsePipelineTrigger_closure6(Object _outerInstance, Object _thisObject, Reference pipeline) {
                    Reference reference;
                    CallSite[] callSiteArray = _parsePipelineTrigger_closure6.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.pipeline = reference = pipeline;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _parsePipelineTrigger_closure6.$getCallSiteArray();
                    Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(callSiteArray[2].callGetProperty(this.pipeline.get())), callSiteArray[3].callGetProperty(it))) ? callSiteArray[4].call(callSiteArray[5].callGetProperty(callSiteArray[6].callGetProperty(this.pipeline.get())), callSiteArray[7].callGetProperty(it)) : callSiteArray[8].callGetProperty(it);
                    callSiteArray[9].call(callSiteArray[10].callGetProperty(callSiteArray[11].callGetProperty(this.pipeline.get())), callSiteArray[12].callGetProperty(it), object);
                    return object;
                }

                @Generated
                public Map getPipeline() {
                    CallSite[] callSiteArray = _parsePipelineTrigger_closure6.$getCallSiteArray();
                    return (Map)ScriptBytecodeAdapter.castToType((Object)this.pipeline.get(), Map.class);
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _parsePipelineTrigger_closure6.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _parsePipelineTrigger_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "containsKey";
                    stringArray[1] = "parameters";
                    stringArray[2] = "trigger";
                    stringArray[3] = "name";
                    stringArray[4] = "getAt";
                    stringArray[5] = "parameters";
                    stringArray[6] = "trigger";
                    stringArray[7] = "name";
                    stringArray[8] = "default";
                    stringArray[9] = "putAt";
                    stringArray[10] = "parameters";
                    stringArray[11] = "trigger";
                    stringArray[12] = "name";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[13];
                    _parsePipelineTrigger_closure6.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_parsePipelineTrigger_closure6.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _parsePipelineTrigger_closure6.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[117].call(callSiteArray[118].callGetProperty((Object)((Map)pipeline2.get())), (Object)new _parsePipelineTrigger_closure6(this, this, pipeline2));
        }
        if (resolveArtifacts) {
            callSiteArray[119].callSafe((Object)this.artifactUtils, (Object)((Map)pipeline2.get()));
        }
    }

    @Deprecated
    private void decorateBuildInfo(Map trigger) {
        block28: {
            CallSite[] callSiteArray;
            block29: {
                callSiteArray = OperationsController.$getCallSiteArray();
                if (BytecodeInterface8.isOrigZ() && !__$stMC && !BytecodeInterface8.disabledStandardMetaClass()) break block29;
                if (!(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[120].callGetProperty((Object)trigger)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[121].callGetProperty((Object)trigger)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[122].callGetProperty((Object)trigger)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[123].callGetProperty((Object)trigger)))) break block28;
                callSiteArray[124].call((Object)log, (Object)"Populating build information in Orca for trigger {}.", (Object)trigger);
                Object buildInfo = null;
                try {
                    Object object;
                    buildInfo = object = callSiteArray[125].call((Object)this.buildService, callSiteArray[126].callGetProperty((Object)trigger), callSiteArray[127].callGetProperty((Object)trigger), callSiteArray[128].callGetProperty((Object)trigger));
                }
                catch (RetrofitError e) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[129].callGetPropertySafe(callSiteArray[130].callGetProperty((Object)e)), (Object)404)) {
                        throw (Throwable)callSiteArray[131].callConstructor(ConfigurationException.class, (Object)new GStringImpl(new Object[]{callSiteArray[132].callGetProperty((Object)trigger), callSiteArray[133].callGetProperty((Object)trigger), callSiteArray[134].callGetProperty((Object)trigger)}, new String[]{"Build ", " of ", "/", " not found"}));
                    }
                    throw (Throwable)callSiteArray[135].callConstructor(OperationFailedException.class, (Object)new GStringImpl(new Object[]{callSiteArray[136].callGetProperty((Object)trigger), callSiteArray[137].callGetProperty((Object)trigger), callSiteArray[138].callGetProperty((Object)trigger)}, new String[]{"Failed to get build ", " of ", "/", ""}), (Object)e);
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[139].callGetPropertySafe(buildInfo)) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[140].callGetProperty((Object)trigger), (Object)"manual")) {
                    Object object = callSiteArray[141].callGetProperty(buildInfo);
                    ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)trigger, (String)"artifacts");
                }
                Object object = buildInfo;
                ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)trigger, (String)"buildInfo");
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[142].callGetProperty((Object)trigger))) break block28;
                try {
                    Object object2 = callSiteArray[143].call((Object)this.buildService, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[144].callGetProperty((Object)trigger), Integer.class)), Integer.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[145].callGetProperty((Object)trigger), String.class)), String.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[146].callGetProperty((Object)trigger), String.class)), String.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[147].callGetProperty((Object)trigger), String.class)), String.class));
                    ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)trigger, (String)"properties");
                    break block28;
                }
                catch (RetrofitError e) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[148].callGetPropertySafe(callSiteArray[149].callGetProperty((Object)e)), (Object)404)) {
                        throw (Throwable)callSiteArray[150].callConstructor(ConfigurationException.class, callSiteArray[151].call(callSiteArray[152].call((Object)"Expected properties file ", callSiteArray[153].callGetProperty((Object)trigger)), (Object)" (configured on trigger), but it was missing"));
                    }
                    throw (Throwable)callSiteArray[154].callConstructor(OperationFailedException.class, (Object)new GStringImpl(new Object[]{callSiteArray[155].callGetProperty((Object)trigger)}, new String[]{"Failed to get properties file ", ""}), (Object)e);
                }
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[156].callGetProperty((Object)trigger)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[157].callGetProperty((Object)trigger)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[158].callGetProperty((Object)trigger)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[159].callGetProperty((Object)trigger))) {
                callSiteArray[160].call((Object)log, (Object)"Populating build information in Orca for trigger {}.", (Object)trigger);
                Object buildInfo = null;
                try {
                    Object object;
                    buildInfo = object = callSiteArray[161].call((Object)this.buildService, callSiteArray[162].callGetProperty((Object)trigger), callSiteArray[163].callGetProperty((Object)trigger), callSiteArray[164].callGetProperty((Object)trigger));
                }
                catch (RetrofitError e) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[165].callGetPropertySafe(callSiteArray[166].callGetProperty((Object)e)), (Object)404)) {
                        throw (Throwable)callSiteArray[167].callConstructor(ConfigurationException.class, (Object)new GStringImpl(new Object[]{callSiteArray[168].callGetProperty((Object)trigger), callSiteArray[169].callGetProperty((Object)trigger), callSiteArray[170].callGetProperty((Object)trigger)}, new String[]{"Build ", " of ", "/", " not found"}));
                    }
                    throw (Throwable)callSiteArray[171].callConstructor(OperationFailedException.class, (Object)new GStringImpl(new Object[]{callSiteArray[172].callGetProperty((Object)trigger), callSiteArray[173].callGetProperty((Object)trigger), callSiteArray[174].callGetProperty((Object)trigger)}, new String[]{"Failed to get build ", " of ", "/", ""}), (Object)e);
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[175].callGetPropertySafe(buildInfo)) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[176].callGetProperty((Object)trigger), (Object)"manual")) {
                    Object object = callSiteArray[177].callGetProperty(buildInfo);
                    ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)trigger, (String)"artifacts");
                }
                Object object = buildInfo;
                ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)trigger, (String)"buildInfo");
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[178].callGetProperty((Object)trigger))) {
                    try {
                        Object object3 = callSiteArray[179].call((Object)this.buildService, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[180].callGetProperty((Object)trigger), Integer.class)), Integer.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[181].callGetProperty((Object)trigger), String.class)), String.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[182].callGetProperty((Object)trigger), String.class)), String.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[183].callGetProperty((Object)trigger), String.class)), String.class));
                        ScriptBytecodeAdapter.setProperty((Object)object3, null, (Object)trigger, (String)"properties");
                    }
                    catch (RetrofitError e) {
                        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[184].callGetPropertySafe(callSiteArray[185].callGetProperty((Object)e)), (Object)404)) {
                            throw (Throwable)callSiteArray[186].callConstructor(ConfigurationException.class, callSiteArray[187].call(callSiteArray[188].call((Object)"Expected properties file ", callSiteArray[189].callGetProperty((Object)trigger)), (Object)" (configured on trigger), but it was missing"));
                        }
                        throw (Throwable)callSiteArray[190].callConstructor(OperationFailedException.class, (Object)new GStringImpl(new Object[]{callSiteArray[191].callGetProperty((Object)trigger)}, new String[]{"Failed to get properties file ", ""}), (Object)e);
                    }
                }
            }
        }
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/ops"})
    public Map<String, String> ops(@RequestBody List<Map> input) {
        CallSite[] callSiteArray = OperationsController.$getCallSiteArray();
        Map execution = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"application", null, "name", null, "stages", input});
        callSiteArray[192].callCurrent((GroovyObject)this, (Object)execution, (Object)true);
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[193].callCurrent((GroovyObject)this, (Object)execution), Map.class);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/ops"}, consumes={"application/context+json"})
    public Map<String, String> ops(@RequestBody Map input) {
        Object object;
        CallSite[] callSiteArray = OperationsController.$getCallSiteArray();
        Map execution = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"application", callSiteArray[194].callGetProperty((Object)input), "name", callSiteArray[195].callGetProperty((Object)input), "stages", callSiteArray[196].callGetProperty((Object)input), "trigger", DefaultTypeTransformation.booleanUnbox((Object)(object = callSiteArray[197].callGetProperty((Object)input))) ? object : ScriptBytecodeAdapter.createMap((Object[])new Object[0])});
        callSiteArray[198].callCurrent((GroovyObject)this, (Object)execution, (Object)true);
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[199].callCurrent((GroovyObject)this, (Object)execution), Map.class);
    }

    @RequestMapping(value={"/webhooks/preconfigured"})
    public List<Map<String, Object>> preconfiguredWebhooks() {
        CallSite[] callSiteArray = OperationsController.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.webhookService)) {
            return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        }
        Object webhooks = callSiteArray[200].callGetProperty((Object)this.webhookService);
        public final class _preconfiguredWebhooks_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _preconfiguredWebhooks_closure7(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _preconfiguredWebhooks_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _preconfiguredWebhooks_closure7.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _preconfiguredWebhooks_closure7.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _preconfiguredWebhooks_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "permissions";
                return new CallSiteArray(_preconfiguredWebhooks_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _preconfiguredWebhooks_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)webhooks) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[201].call((Object)this.fiatStatus)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[202].call(webhooks, (Object)new _preconfiguredWebhooks_closure7(this, this)))) {
            Object object;
            Reference userPermissionRoles = new Reference((Object)((Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[203].callConstructor(Role.View.class, callSiteArray[204].callConstructor(Role.class, (Object)"anonymous"))}), Set.class)));
            try {
                String user = ShortTypeHandling.castToString((Object)callSiteArray[205].call(callSiteArray[206].call(AuthenticatedRequest.class), (Object)"anonymous"));
                UserPermission.View userPermission = (UserPermission.View)ScriptBytecodeAdapter.castToType((Object)callSiteArray[207].call((Object)this.fiatService, (Object)user), UserPermission.View.class);
                Object object2 = callSiteArray[208].callGetProperty((Object)userPermission);
                userPermissionRoles.set(object2);
            }
            catch (Exception e) {
                callSiteArray[209].call((Object)log, (Object)"Unable to determine roles for current user, falling back to 'anonymous'", (Object)e);
            }
            public final class _preconfiguredWebhooks_closure8
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference userPermissionRoles;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _preconfiguredWebhooks_closure8(Object _outerInstance, Object _thisObject, Reference userPermissionRoles) {
                    Reference reference;
                    CallSite[] callSiteArray = _preconfiguredWebhooks_closure8.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.userPermissionRoles = reference = userPermissionRoles;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _preconfiguredWebhooks_closure8.$getCallSiteArray();
                    return callSiteArray[0].call(it, (Object)"READ", this.userPermissionRoles.get());
                }

                @Generated
                public Object getUserPermissionRoles() {
                    CallSite[] callSiteArray = _preconfiguredWebhooks_closure8.$getCallSiteArray();
                    return this.userPermissionRoles.get();
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _preconfiguredWebhooks_closure8.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _preconfiguredWebhooks_closure8.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "isAllowed";
                    return new CallSiteArray(_preconfiguredWebhooks_closure8.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _preconfiguredWebhooks_closure8.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            webhooks = object = callSiteArray[210].call(webhooks, (Object)new _preconfiguredWebhooks_closure8(this, this, userPermissionRoles));
        }
        public final class _preconfiguredWebhooks_closure9
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _preconfiguredWebhooks_closure9(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _preconfiguredWebhooks_closure9.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _preconfiguredWebhooks_closure9.$getCallSiteArray();
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"label", callSiteArray[0].callGetProperty(it), "description", callSiteArray[1].callGetProperty(it), "type", callSiteArray[2].callGetProperty(it), "waitForCompletion", callSiteArray[3].callGetProperty(it), "preconfiguredProperties", callSiteArray[4].callGetProperty(it), "noUserConfigurableFields", callSiteArray[5].call(it), "parameters", callSiteArray[6].callGetProperty(it), "parameterData", callSiteArray[7].callGetProperty(it)});
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _preconfiguredWebhooks_closure9.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _preconfiguredWebhooks_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "label";
                stringArray[1] = "description";
                stringArray[2] = "type";
                stringArray[3] = "waitForCompletion";
                stringArray[4] = "preconfiguredProperties";
                stringArray[5] = "noUserConfigurableFields";
                stringArray[6] = "parameters";
                stringArray[7] = "parameterData";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _preconfiguredWebhooks_closure9.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_preconfiguredWebhooks_closure9.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _preconfiguredWebhooks_closure9.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[211].call(webhooks, (Object)new _preconfiguredWebhooks_closure9(this, this)), List.class);
    }

    @RequestMapping(value={"/jobs/preconfigured"})
    public List<Map<String, Object>> preconfiguredJob() {
        CallSite[] callSiteArray = OperationsController.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.jobService)) {
            return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        }
        public final class _preconfiguredJob_closure10
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _preconfiguredJob_closure10(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _preconfiguredJob_closure10.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _preconfiguredJob_closure10.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _preconfiguredJob_closure10.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _preconfiguredJob_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "enabled";
                return new CallSiteArray(_preconfiguredJob_closure10.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _preconfiguredJob_closure10.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _preconfiguredJob_closure11
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _preconfiguredJob_closure11(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _preconfiguredJob_closure11.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _preconfiguredJob_closure11.$getCallSiteArray();
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"label", callSiteArray[0].callGetProperty(it), "description", callSiteArray[1].callGetProperty(it), "type", callSiteArray[2].callGetProperty(it), "waitForCompletion", callSiteArray[3].callGetProperty(it), "noUserConfigurableFields", true, "parameters", callSiteArray[4].callGetProperty(it), "producesArtifacts", callSiteArray[5].callGetProperty(it), "uiType", callSiteArray[6].callGetProperty(it)});
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _preconfiguredJob_closure11.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _preconfiguredJob_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "label";
                stringArray[1] = "description";
                stringArray[2] = "type";
                stringArray[3] = "waitForCompletion";
                stringArray[4] = "parameters";
                stringArray[5] = "producesArtifacts";
                stringArray[6] = "uiType";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                _preconfiguredJob_closure11.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_preconfiguredJob_closure11.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _preconfiguredJob_closure11.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[212].call(callSiteArray[213].call(callSiteArray[214].call((Object)this.jobService), (Object)new _preconfiguredJob_closure10(this, this)), (Object)new _preconfiguredJob_closure11(this, this)), List.class);
    }

    private static void applyStageRefIds(Map<String, Serializable> pipelineConfig) {
        CallSite[] callSiteArray = OperationsController.$getCallSiteArray();
        List stages = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[215].callGetProperty(pipelineConfig), List.class);
        public final class _applyStageRefIds_closure12
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _applyStageRefIds_closure12(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _applyStageRefIds_closure12.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Map<String, Object> stage, int index) {
                CallSite[] callSiteArray = _applyStageRefIds_closure12.$getCallSiteArray();
                callSiteArray[0].call(stage, (Object)"refId", callSiteArray[1].call(String.class, (Object)index));
                if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    if (index > 0) {
                        return callSiteArray[2].call(stage, (Object)"requisiteStageRefIds", callSiteArray[3].call(Collections.class, callSiteArray[4].call(String.class, callSiteArray[5].call((Object)index, (Object)1))));
                    }
                    return callSiteArray[6].call(stage, (Object)"requisiteStageRefIds", callSiteArray[7].call(Collections.class));
                }
                if (index > 0) {
                    return callSiteArray[8].call(stage, (Object)"requisiteStageRefIds", callSiteArray[9].call(Collections.class, callSiteArray[10].call(String.class, (Object)(index - 1))));
                }
                return callSiteArray[11].call(stage, (Object)"requisiteStageRefIds", callSiteArray[12].call(Collections.class));
            }

            public Object call(Map<String, Object> stage, int index) {
                CallSite[] callSiteArray = _applyStageRefIds_closure12.$getCallSiteArray();
                return callSiteArray[13].callCurrent((GroovyObject)this, stage, (Object)index);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _applyStageRefIds_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "put";
                stringArray[1] = "valueOf";
                stringArray[2] = "put";
                stringArray[3] = "singletonList";
                stringArray[4] = "valueOf";
                stringArray[5] = "minus";
                stringArray[6] = "put";
                stringArray[7] = "emptyList";
                stringArray[8] = "put";
                stringArray[9] = "singletonList";
                stringArray[10] = "valueOf";
                stringArray[11] = "put";
                stringArray[12] = "emptyList";
                stringArray[13] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[14];
                _applyStageRefIds_closure12.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_applyStageRefIds_closure12.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _applyStageRefIds_closure12.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[216].call((Object)stages, (Object)new _applyStageRefIds_closure12(OperationsController.class, OperationsController.class));
    }

    private String startPipeline(Map config) {
        CallSite[] callSiteArray = OperationsController.$getCallSiteArray();
        callSiteArray[217].callCurrent((GroovyObject)this, (Object)config);
        Object pipeline = callSiteArray[218].call((Object)this.executionLauncher, callSiteArray[219].callGetProperty(ExecutionType.class), (Object)config);
        return ShortTypeHandling.castToString((Object)callSiteArray[220].callGetProperty(pipeline));
    }

    private String markPipelineFailed(Map config, Exception e) {
        CallSite[] callSiteArray = OperationsController.$getCallSiteArray();
        callSiteArray[221].callCurrent((GroovyObject)this, (Object)config);
        Object pipeline = callSiteArray[222].call((Object)this.executionLauncher, callSiteArray[223].callGetProperty(ExecutionType.class), (Object)config, (Object)e);
        return ShortTypeHandling.castToString((Object)callSiteArray[224].callGetProperty(pipeline));
    }

    private Map<String, String> startTask(Map config) {
        Reference config2 = new Reference((Object)config);
        CallSite[] callSiteArray = OperationsController.$getCallSiteArray();
        public final class _startTask_closure13
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _startTask_closure13(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _startTask_closure13.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _startTask_closure13.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), null);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _startTask_closure13.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _startTask_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "refId";
                return new CallSiteArray(_startTask_closure13.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _startTask_closure13.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object linear = callSiteArray[225].call(callSiteArray[226].callGetProperty((Object)((Map)config2.get())), (Object)new _startTask_closure13(this, this));
        if (DefaultTypeTransformation.booleanUnbox((Object)linear)) {
            callSiteArray[227].callStatic(OperationsController.class, (Object)((Map)config2.get()));
        }
        callSiteArray[228].callCurrent((GroovyObject)this, (Object)((Map)config2.get()));
        ExecutionPreprocessor preprocessor = null;
        public final class _startTask_closure14
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference config;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _startTask_closure14(Object _outerInstance, Object _thisObject, Reference config) {
                Reference reference;
                CallSite[] callSiteArray = _startTask_closure14.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.config = reference = config;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _startTask_closure14.$getCallSiteArray();
                return callSiteArray[0].call(it, this.config.get(), callSiteArray[1].callGetProperty(ExecutionPreprocessor.Type.class));
            }

            @Generated
            public Map getConfig() {
                CallSite[] callSiteArray = _startTask_closure14.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.config.get(), Map.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _startTask_closure14.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _startTask_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "supports";
                stringArray[1] = "ORCHESTRATION";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _startTask_closure14.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_startTask_closure14.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _startTask_closure14.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[229].call(callSiteArray[230].call(this.executionPreprocessors, (Object)new _startTask_closure14(this, this, config2))), Iterator.class);
        while (iterator.hasNext()) {
            preprocessor = (ExecutionPreprocessor)ScriptBytecodeAdapter.castToType(iterator.next(), ExecutionPreprocessor.class);
            Object object = callSiteArray[231].call((Object)preprocessor, (Object)((Map)config2.get()));
            config2.set((Object)((Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class)));
        }
        Object pipeline = null;
        try {
            Object object;
            pipeline = object = callSiteArray[232].call((Object)this.executionLauncher, callSiteArray[233].callGetProperty(ExecutionType.class), (Object)((Map)config2.get()));
        }
        catch (Throwable throwable) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[238].call((Object)log)) ? callSiteArray[239].call((Object)log, (Object)"started execution {} from requested task: {}", callSiteArray[240].callGetPropertySafe(pipeline), callSiteArray[241].callCurrent((GroovyObject)this, (Object)((Map)config2.get()))) : null;
            throw throwable;
        }
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[234].call((Object)log)) ? callSiteArray[235].call((Object)log, (Object)"started execution {} from requested task: {}", callSiteArray[236].callGetPropertySafe(pipeline), callSiteArray[237].callCurrent((GroovyObject)this, (Object)((Map)config2.get()))) : null;
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"ref", callSiteArray[242].call((Object)new GStringImpl(new Object[]{callSiteArray[243].callGetProperty(pipeline)}, new String[]{"/tasks/", ""}))});
    }

    private String renderForLogs(Map config) {
        CallSite[] callSiteArray = OperationsController.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[244].call((Object)log))) {
            return ShortTypeHandling.castToString(null);
        }
        Object json = callSiteArray[245].call((Object)this.objectMapper, (Object)config);
        if (ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[246].call(json), (Object)20000)) {
            return ShortTypeHandling.castToString((Object)callSiteArray[247].call((Object)new GStringImpl(new Object[]{callSiteArray[248].call(json)}, new String[]{"(length: ", ") "}), json));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[249].call(callSiteArray[250].call(callSiteArray[251].call((Object)new GStringImpl(new Object[]{callSiteArray[252].call(json)}, new String[]{"(original length: ", ", truncated to first and last 10k) "}), callSiteArray[253].call(json, (Object)ScriptBytecodeAdapter.createRange((Object)0, (Object)10000, (boolean)true))), (Object)" (...) "), callSiteArray[254].call(json, (Object)ScriptBytecodeAdapter.createRange((Object)-10000, (Object)-1, (boolean)true))));
    }

    private void injectPipelineOrigin(Map pipeline) {
        CallSite[] callSiteArray = OperationsController.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[255].callGetProperty((Object)pipeline))) {
            Object object = callSiteArray[256].call(callSiteArray[257].callGetProperty(AuthenticatedRequest.class), (Object)"unknown");
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)pipeline, (String)"origin");
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != OperationsController.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = OperationsController.$getCallSiteArray()[258].call(LoggerFactory.class, (Object)"com.netflix.spinnaker.orca.controllers.OperationsController");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    @Generated
    public ExecutionLauncher getExecutionLauncher() {
        return this.executionLauncher;
    }

    @Generated
    public void setExecutionLauncher(ExecutionLauncher executionLauncher) {
        this.executionLauncher = executionLauncher;
    }

    @Generated
    public BuildService getBuildService() {
        return this.buildService;
    }

    @Generated
    public void setBuildService(BuildService buildService) {
        this.buildService = buildService;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Generated
    public ExecutionRepository getExecutionRepository() {
        return this.executionRepository;
    }

    @Generated
    public void setExecutionRepository(ExecutionRepository executionRepository) {
        this.executionRepository = executionRepository;
    }

    @Generated
    public PipelineTemplateService getPipelineTemplateService() {
        return this.pipelineTemplateService;
    }

    @Generated
    public void setPipelineTemplateService(PipelineTemplateService pipelineTemplateService) {
        this.pipelineTemplateService = pipelineTemplateService;
    }

    @Generated
    public ContextParameterProcessor getContextParameterProcessor() {
        return this.contextParameterProcessor;
    }

    @Generated
    public void setContextParameterProcessor(ContextParameterProcessor contextParameterProcessor) {
        this.contextParameterProcessor = contextParameterProcessor;
    }

    @Generated
    public List<ExecutionPreprocessor> getExecutionPreprocessors() {
        return this.executionPreprocessors;
    }

    @Generated
    public void setExecutionPreprocessors(List<ExecutionPreprocessor> list) {
        this.executionPreprocessors = list;
    }

    @Generated
    public WebhookService getWebhookService() {
        return this.webhookService;
    }

    @Generated
    public void setWebhookService(WebhookService webhookService) {
        this.webhookService = webhookService;
    }

    @Generated
    public JobService getJobService() {
        return this.jobService;
    }

    @Generated
    public void setJobService(JobService jobService) {
        this.jobService = jobService;
    }

    @Generated
    public ArtifactUtils getArtifactUtils() {
        return this.artifactUtils;
    }

    @Generated
    public void setArtifactUtils(ArtifactUtils artifactUtils) {
        this.artifactUtils = artifactUtils;
    }

    @Generated
    public FiatStatus getFiatStatus() {
        return this.fiatStatus;
    }

    @Generated
    public void setFiatStatus(FiatStatus fiatStatus) {
        this.fiatStatus = fiatStatus;
    }

    @Generated
    public FiatService getFiatService() {
        return this.fiatService;
    }

    @Generated
    public void setFiatService(FiatService fiatService) {
        this.fiatService = fiatService;
    }

    @Generated
    public Front50Service getFront50Service() {
        return this.front50Service;
    }

    @Generated
    public void setFront50Service(Front50Service front50Service) {
        this.front50Service = front50Service;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "planOrOrchestratePipeline";
        stringArray[3] = "buildPipelineConfig";
        stringArray[4] = "planOrOrchestratePipeline";
        stringArray[5] = "planPipeline";
        stringArray[6] = "buildPipelineConfig";
        stringArray[7] = "planPipeline";
        stringArray[8] = "remove";
        stringArray[9] = "recordPipelineFailure";
        stringArray[10] = "<$constructor$>";
        stringArray[11] = "allowAnonymous";
        stringArray[12] = "status";
        stringArray[13] = "response";
        stringArray[14] = "HTTP_NOT_FOUND";
        stringArray[15] = "<$constructor$>";
        stringArray[16] = "plan";
        stringArray[17] = "planPipeline";
        stringArray[18] = "orchestratePipeline";
        stringArray[19] = "isInfoEnabled";
        stringArray[20] = "info";
        stringArray[21] = "value";
        stringArray[22] = "id";
        stringArray[23] = "forEach";
        stringArray[24] = "filter";
        stringArray[25] = "stream";
        stringArray[26] = "parseAndValidatePipeline";
        stringArray[27] = "currentTimeMillis";
        stringArray[28] = "parseAndValidatePipeline";
        stringArray[29] = "trigger";
        stringArray[30] = "templateVariables";
        stringArray[31] = "processPipeline";
        stringArray[32] = "convertValue";
        stringArray[33] = "trigger";
        stringArray[34] = "startPipeline";
        stringArray[35] = "isInfoEnabled";
        stringArray[36] = "info";
        stringArray[37] = "renderForLogs";
        stringArray[38] = "minus";
        stringArray[39] = "currentTimeMillis";
        stringArray[40] = "plus";
        stringArray[41] = "markPipelineFailed";
        stringArray[42] = "isInfoEnabled";
        stringArray[43] = "info";
        stringArray[44] = "renderForLogs";
        stringArray[45] = "parseAndValidatePipeline";
        stringArray[46] = "trigger";
        stringArray[47] = "templateVariables";
        stringArray[48] = "process";
        stringArray[49] = "convertValue";
        stringArray[50] = "trigger";
        stringArray[51] = "<$constructor$>";
        stringArray[52] = "<$constructor$>";
        stringArray[53] = "markPipelineFailed";
        stringArray[54] = "parseAndValidatePipeline";
        stringArray[55] = "parsePipelineTrigger";
        stringArray[56] = "iterator";
        stringArray[57] = "findAll";
        stringArray[58] = "process";
        stringArray[59] = "disabled";
        stringArray[60] = "<$constructor$>";
        stringArray[61] = "every";
        stringArray[62] = "stages";
        stringArray[63] = "applyStageRefIds";
        stringArray[64] = "errors";
        stringArray[65] = "<$constructor$>";
        stringArray[66] = "errors";
        stringArray[67] = "trigger";
        stringArray[68] = "plan";
        stringArray[69] = "type";
        stringArray[70] = "retrievePipelineOrNewestExecution";
        stringArray[71] = "executionId";
        stringArray[72] = "id";
        stringArray[73] = "convertValue";
        stringArray[74] = "trigger";
        stringArray[75] = "id";
        stringArray[76] = "info";
        stringArray[77] = "info";
        stringArray[78] = "plan";
        stringArray[79] = "type";
        stringArray[80] = "retrievePipelineOrNewestExecution";
        stringArray[81] = "executionId";
        stringArray[82] = "id";
        stringArray[83] = "convertValue";
        stringArray[84] = "trigger";
        stringArray[85] = "id";
        stringArray[86] = "info";
        stringArray[87] = "info";
        stringArray[88] = "type";
        stringArray[89] = "trigger";
        stringArray[90] = "trigger";
        stringArray[91] = "user";
        stringArray[92] = "trigger";
        stringArray[93] = "orElse";
        stringArray[94] = "getSpinnakerUser";
        stringArray[95] = "trigger";
        stringArray[96] = "decorateBuildInfo";
        stringArray[97] = "trigger";
        stringArray[98] = "parentPipelineId";
        stringArray[99] = "trigger";
        stringArray[100] = "parentExecution";
        stringArray[101] = "trigger";
        stringArray[102] = "retrieve";
        stringArray[103] = "PIPELINE";
        stringArray[104] = "parentPipelineId";
        stringArray[105] = "trigger";
        stringArray[106] = "trigger";
        stringArray[107] = "status";
        stringArray[108] = "trigger";
        stringArray[109] = "trigger";
        stringArray[110] = "name";
        stringArray[111] = "trigger";
        stringArray[112] = "getAllArtifacts";
        stringArray[113] = "parameters";
        stringArray[114] = "trigger";
        stringArray[115] = "trigger";
        stringArray[116] = "parameterConfig";
        stringArray[117] = "each";
        stringArray[118] = "parameterConfig";
        stringArray[119] = "resolveArtifacts";
        stringArray[120] = "master";
        stringArray[121] = "job";
        stringArray[122] = "buildNumber";
        stringArray[123] = "buildInfo";
        stringArray[124] = "info";
        stringArray[125] = "getBuild";
        stringArray[126] = "buildNumber";
        stringArray[127] = "master";
        stringArray[128] = "job";
        stringArray[129] = "status";
        stringArray[130] = "response";
        stringArray[131] = "<$constructor$>";
        stringArray[132] = "buildNumber";
        stringArray[133] = "master";
        stringArray[134] = "job";
        stringArray[135] = "<$constructor$>";
        stringArray[136] = "buildNumber";
        stringArray[137] = "master";
        stringArray[138] = "job";
        stringArray[139] = "artifacts";
        stringArray[140] = "type";
        stringArray[141] = "artifacts";
        stringArray[142] = "propertyFile";
        stringArray[143] = "getPropertyFile";
        stringArray[144] = "buildNumber";
        stringArray[145] = "propertyFile";
        stringArray[146] = "master";
        stringArray[147] = "job";
        stringArray[148] = "status";
        stringArray[149] = "response";
        stringArray[150] = "<$constructor$>";
        stringArray[151] = "plus";
        stringArray[152] = "plus";
        stringArray[153] = "propertyFile";
        stringArray[154] = "<$constructor$>";
        stringArray[155] = "propertyFile";
        stringArray[156] = "master";
        stringArray[157] = "job";
        stringArray[158] = "buildNumber";
        stringArray[159] = "buildInfo";
        stringArray[160] = "info";
        stringArray[161] = "getBuild";
        stringArray[162] = "buildNumber";
        stringArray[163] = "master";
        stringArray[164] = "job";
        stringArray[165] = "status";
        stringArray[166] = "response";
        stringArray[167] = "<$constructor$>";
        stringArray[168] = "buildNumber";
        stringArray[169] = "master";
        stringArray[170] = "job";
        stringArray[171] = "<$constructor$>";
        stringArray[172] = "buildNumber";
        stringArray[173] = "master";
        stringArray[174] = "job";
        stringArray[175] = "artifacts";
        stringArray[176] = "type";
        stringArray[177] = "artifacts";
        stringArray[178] = "propertyFile";
        stringArray[179] = "getPropertyFile";
        stringArray[180] = "buildNumber";
        stringArray[181] = "propertyFile";
        stringArray[182] = "master";
        stringArray[183] = "job";
        stringArray[184] = "status";
        stringArray[185] = "response";
        stringArray[186] = "<$constructor$>";
        stringArray[187] = "plus";
        stringArray[188] = "plus";
        stringArray[189] = "propertyFile";
        stringArray[190] = "<$constructor$>";
        stringArray[191] = "propertyFile";
        stringArray[192] = "parsePipelineTrigger";
        stringArray[193] = "startTask";
        stringArray[194] = "application";
        stringArray[195] = "description";
        stringArray[196] = "job";
        stringArray[197] = "trigger";
        stringArray[198] = "parsePipelineTrigger";
        stringArray[199] = "startTask";
        stringArray[200] = "preconfiguredWebhooks";
        stringArray[201] = "isEnabled";
        stringArray[202] = "any";
        stringArray[203] = "<$constructor$>";
        stringArray[204] = "<$constructor$>";
        stringArray[205] = "orElse";
        stringArray[206] = "getSpinnakerUser";
        stringArray[207] = "getUserPermission";
        stringArray[208] = "roles";
        stringArray[209] = "error";
        stringArray[210] = "findAll";
        stringArray[211] = "collect";
        stringArray[212] = "collect";
        stringArray[213] = "findAll";
        stringArray[214] = "getPreconfiguredStages";
        stringArray[215] = "stages";
        stringArray[216] = "eachWithIndex";
        stringArray[217] = "injectPipelineOrigin";
        stringArray[218] = "start";
        stringArray[219] = "PIPELINE";
        stringArray[220] = "id";
        stringArray[221] = "injectPipelineOrigin";
        stringArray[222] = "fail";
        stringArray[223] = "PIPELINE";
        stringArray[224] = "id";
        stringArray[225] = "every";
        stringArray[226] = "stages";
        stringArray[227] = "applyStageRefIds";
        stringArray[228] = "injectPipelineOrigin";
        stringArray[229] = "iterator";
        stringArray[230] = "findAll";
        stringArray[231] = "process";
        stringArray[232] = "start";
        stringArray[233] = "ORCHESTRATION";
        stringArray[234] = "isInfoEnabled";
        stringArray[235] = "info";
        stringArray[236] = "id";
        stringArray[237] = "renderForLogs";
        stringArray[238] = "isInfoEnabled";
        stringArray[239] = "info";
        stringArray[240] = "id";
        stringArray[241] = "renderForLogs";
        stringArray[242] = "toString";
        stringArray[243] = "id";
        stringArray[244] = "isInfoEnabled";
        stringArray[245] = "writeValueAsString";
        stringArray[246] = "length";
        stringArray[247] = "plus";
        stringArray[248] = "length";
        stringArray[249] = "plus";
        stringArray[250] = "plus";
        stringArray[251] = "plus";
        stringArray[252] = "length";
        stringArray[253] = "getAt";
        stringArray[254] = "getAt";
        stringArray[255] = "origin";
        stringArray[256] = "orElse";
        stringArray[257] = "spinnakerUserOrigin";
        stringArray[258] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[259];
        OperationsController.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(OperationsController.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = OperationsController.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

