/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.controllers;

import com.netflix.spinnaker.orca.api.pipeline.ExecutionPreprocessor;
import com.netflix.spinnaker.orca.pipeline.util.ContextParameterProcessor;
import com.netflix.spinnaker.orca.pipelinetemplate.V2Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/pipelineTemplates"})
@ConditionalOnExpression(value="${pipeline-templates.enabled:true}")
public class V2PipelineTemplateController {
    private static final Logger log = LoggerFactory.getLogger(V2PipelineTemplateController.class);
    @Autowired
    private ContextParameterProcessor contextParameterProcessor;
    @Autowired(required=false)
    private List<ExecutionPreprocessor> executionPreprocessors = new ArrayList<ExecutionPreprocessor>();

    @RequestMapping(value={"/plan"}, method={RequestMethod.POST})
    Map<String, Object> plan(@RequestBody Map<String, Object> pipeline) {
        return V2Util.planPipeline((ContextParameterProcessor)this.contextParameterProcessor, this.executionPreprocessors, pipeline);
    }
}

