/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.util;

import com.google.common.base.Strings;
import com.netflix.spinnaker.kork.exceptions.UserException;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.pipeline.EvaluateVariablesStage;
import com.netflix.spinnaker.orca.pipeline.StageDefinitionBuilderFactory;
import com.netflix.spinnaker.orca.pipeline.expressions.PipelineExpressionEvaluator;
import com.netflix.spinnaker.orca.pipeline.model.StageExecutionImpl;
import com.netflix.spinnaker.orca.pipeline.util.ContextParameterProcessor;
import com.netflix.spinnaker.orca.q.handler.ExpressionAware;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExpressionUtils
implements ExpressionAware {
    private ContextParameterProcessor contextParameterProcessor;
    private StageDefinitionBuilderFactory stageDefinitionBuilderFactory;

    @Autowired
    public ExpressionUtils(ContextParameterProcessor contextParameterProcessor, StageDefinitionBuilderFactory stageDefinitionBuilderFactory) {
        this.contextParameterProcessor = contextParameterProcessor;
        this.stageDefinitionBuilderFactory = stageDefinitionBuilderFactory;
    }

    public Map<String, Object> evaluateVariables(@Nonnull PipelineExecution execution, @Nonnull List<String> requisiteStageRefIds, @Nullable String spelVersionOverride, @Nonnull List<Map<String, String>> expressions) {
        HashMap<String, Object> stageContext = new HashMap<String, Object>();
        stageContext.put("refId", "_AD_HOC_EVALUATE_VARIABLES_STAGE_");
        stageContext.put("requisiteStageRefIds", requisiteStageRefIds);
        stageContext.put("variables", expressions);
        if (!Strings.isNullOrEmpty((String)spelVersionOverride)) {
            if (!PipelineExpressionEvaluator.SpelEvaluatorVersion.isSupported((String)spelVersionOverride)) {
                throw new UserException("SpEL evaluator version " + spelVersionOverride + " is not supported");
            }
            execution.setSpelEvaluator(spelVersionOverride);
        }
        StageExecutionImpl evalVarsStage = new StageExecutionImpl(execution, EvaluateVariablesStage.STAGE_TYPE, stageContext);
        evalVarsStage = ExpressionAware.DefaultImpls.withMergedContext((ExpressionAware)this, (StageExecution)evalVarsStage);
        ExpressionAware.DefaultImpls.includeExpressionEvaluationSummary((ExpressionAware)this, (StageExecution)evalVarsStage);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("result", evalVarsStage.getContext().get("variables"));
        result.put("detail", evalVarsStage.getContext().get("expressionEvaluationSummary"));
        return result;
    }

    @NotNull
    public ContextParameterProcessor getContextParameterProcessor() {
        return this.contextParameterProcessor;
    }

    @NotNull
    public StageDefinitionBuilderFactory getStageDefinitionBuilderFactory() {
        return this.stageDefinitionBuilderFactory;
    }

    public boolean shouldFailOnFailedExpressionEvaluation(@NotNull StageExecution stage) {
        return false;
    }

    public void includeExpressionEvaluationSummary(@NotNull StageExecution stage) {
        ExpressionAware.DefaultImpls.includeExpressionEvaluationSummary((ExpressionAware)this, (StageExecution)stage);
    }

    public boolean hasFailedExpressions(@NotNull StageExecution stage) {
        return ExpressionAware.DefaultImpls.hasFailedExpressions((ExpressionAware)this, (StageExecution)stage);
    }

    @Nonnull
    public StageExecution withMergedContext(@NotNull StageExecution stage) {
        return ExpressionAware.DefaultImpls.withMergedContext((ExpressionAware)this, (StageExecution)stage);
    }

    @Nonnull
    public Logger getLog() {
        return ExpressionAware.DefaultImpls.getLog((ExpressionAware)this);
    }
}

