/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.config.EnhancedMonitoringConfigurationProperties;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;
import rx.schedulers.Schedulers;

@Configuration
@EnableConfigurationProperties(value={EnhancedMonitoringConfigurationProperties.class})
@ConditionalOnExpression(value="${pollers.enhanced-monitoring.enabled:false}")
public class EnhancedMonitoringConfiguration {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Registry registry;
    private final ExecutionRepository executionRepository;
    private final EnhancedMonitoringConfigurationProperties configuration;
    private final Map<String, AtomicLong> orchestrationCountPerApplication = new HashMap<String, AtomicLong>();

    @Autowired
    public EnhancedMonitoringConfiguration(Registry registry, ExecutionRepository executionRepository, EnhancedMonitoringConfigurationProperties configuration) {
        this.registry = registry;
        this.executionRepository = executionRepository;
        this.configuration = configuration;
        Id runningOrchestrationsId = registry.createId("executions.running").withTag("executionType", ExecutionType.ORCHESTRATION.toString());
        for (String application : configuration.getApplications()) {
            Id applicationSpecificId = runningOrchestrationsId.withTag("application", application);
            this.orchestrationCountPerApplication.put(application, (AtomicLong)registry.gauge(applicationSpecificId, (Number)new AtomicLong(0L)));
        }
    }

    @Scheduled(fixedDelayString="${pollers.enhanced-monitoring.interval-ms:60000}")
    void refresh() {
        this.log.info("Refreshing Running Orchestration Counts ({})", this.orchestrationCountPerApplication);
        for (String application : this.configuration.getApplications()) {
            try {
                List executions = (List)this.executionRepository.retrieveOrchestrationsForApplication(application, new ExecutionRepository.ExecutionCriteria().setStatuses(new ExecutionStatus[]{ExecutionStatus.RUNNING})).subscribeOn(Schedulers.io()).toList().toBlocking().single();
                this.orchestrationCountPerApplication.get(application).set(executions.size());
            }
            catch (Exception e) {
                this.log.error("Unable to refresh running orchestration count (application: {})", (Object)application, (Object)e);
            }
        }
        this.log.info("Refreshed Running Orchestration Counts ({})", this.orchestrationCountPerApplication);
    }
}

