/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.controllers;

import com.netflix.spinnaker.kork.web.exceptions.InvalidRequestException;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.front50.Front50Service;
import com.netflix.spinnaker.orca.front50.model.Application;
import com.netflix.spinnaker.orca.model.ExecutionImportResponse;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionNotFoundException;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import retrofit.RetrofitError;

@RestController
@RequestMapping(value={"/admin/executions"})
@ConditionalOnProperty(value={"executions.import.enabled"}, matchIfMissing=false)
public class ExecutionsImportController {
    private static final Logger log = LoggerFactory.getLogger(ExecutionsImportController.class);
    private final Front50Service front50Service;
    private final ExecutionRepository executionRepository;
    private Set<ExecutionStatus> ALLOWED_STATUSES = Collections.unmodifiableSet(Stream.of(ExecutionStatus.CANCELED, ExecutionStatus.SUCCEEDED, ExecutionStatus.TERMINAL).collect(Collectors.toSet()));

    @Autowired
    ExecutionsImportController(ExecutionRepository executionRepository, Front50Service front50Service) {
        this.front50Service = front50Service;
        this.executionRepository = executionRepository;
    }

    @PostMapping(value={""})
    @ResponseStatus(value=HttpStatus.CREATED)
    ExecutionImportResponse createExecution(@RequestBody PipelineExecution execution) {
        Application application;
        block6: {
            application = null;
            try {
                application = this.front50Service.get(execution.getApplication());
                log.info("Importing application with name: {}", (Object)application.name);
            }
            catch (RetrofitError e) {
                if (e.getKind() != RetrofitError.Kind.HTTP || e.getResponse().getStatus() == 404) break block6;
                log.warn("Exception received while retrieving application from front50", (Throwable)e);
            }
        }
        if (application == null) {
            log.info("Application {} not found in front50, but still importing it", (Object)execution.getApplication());
        }
        try {
            this.executionRepository.retrieve(execution.getType(), execution.getId());
            throw new InvalidRequestException("Execution already exists with id: " + execution.getId());
        }
        catch (ExecutionNotFoundException e) {
            log.info("Execution not found: {}, Will continue with importing..", (Object)execution.getId());
            if (this.ALLOWED_STATUSES.contains(execution.getStatus())) {
                log.info("Importing execution with id: {}, status: {} , stages: {}", new Object[]{execution.getId(), execution.getStatus(), execution.getStages().size()});
                execution.getStages().forEach(stage -> stage.setExecution(execution));
                this.executionRepository.store(execution);
                return new ExecutionImportResponse(execution.getId(), execution.getStatus(), execution.getStages().size());
            }
            throw new InvalidRequestException("Cannot import provided execution, Status: " + execution.getStatus());
        }
    }
}

