/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import com.netflix.spinnaker.orca.api.pipeline.graph.StageDefinitionBuilder;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.Trigger;
import com.netflix.spinnaker.orca.front50.Front50Service;
import com.netflix.spinnaker.orca.model.OrchestrationViewModel;
import com.netflix.spinnaker.orca.pipeline.CompoundExecutionOperator;
import com.netflix.spinnaker.orca.pipeline.ExecutionRunner;
import com.netflix.spinnaker.orca.pipeline.StageDefinitionBuilderFactory;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionNotFoundException;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.pipeline.util.ContextParameterProcessor;
import com.netflix.spinnaker.orca.util.ExpressionUtils;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.util.PermutationGenerator;
import java.lang.ref.SoftReference;
import java.nio.charset.Charset;
import java.time.Clock;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PreFilter;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import rx.Observable;
import rx.schedulers.Schedulers;

@RestController
public class TaskController
implements GroovyObject {
    @Autowired(required=false)
    private Front50Service front50Service;
    @Autowired
    private ExecutionRepository executionRepository;
    @Autowired
    private ExecutionRunner executionRunner;
    @Autowired
    private CompoundExecutionOperator executionOperator;
    @Autowired
    private Collection<StageDefinitionBuilder> stageBuilders;
    @Autowired
    private ContextParameterProcessor contextParameterProcessor;
    @Autowired
    private ExpressionUtils expressionUtils;
    @Autowired
    private ObjectMapper mapper;
    @Autowired
    private Registry registry;
    @Autowired
    private StageDefinitionBuilderFactory stageDefinitionBuilderFactory;
    @Value(value="${tasks.days-of-execution-history:14}")
    private int daysOfExecutionHistory;
    @Value(value="${tasks.number-of-old-pipeline-executions-to-include:2}")
    private int numberOfOldPipelineExecutionsToInclude;
    private Clock clock;
    private static Closure startTimeOrId;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public TaskController() {
        MetaClass metaClass;
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        Object object = callSiteArray[0].call(Clock.class);
        this.clock = (Clock)ScriptBytecodeAdapter.castToType((Object)object, Clock.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @PreAuthorize(value="hasPermission(#application, 'APPLICATION', 'READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/applications/{application}/tasks"})
    public List<OrchestrationViewModel> list(@PathVariable String application, @RequestParam(defaultValue="1", value="page") int page, @RequestParam(defaultValue="3500", value="limit") int limit, @RequestParam(value="statuses", required=false) String statuses) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        String string = statuses;
        String string2 = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : callSiteArray[1].call(ScriptBytecodeAdapter.invokeMethod0SpreadSafe(TaskController.class, (Object)callSiteArray[2].call(ExecutionStatus.class), (String)"toString"), (Object)",");
        statuses = ShortTypeHandling.castToString((Object)string2);
        Object executionCriteria = callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call(callSiteArray[7].callConstructor(ExecutionRepository.ExecutionCriteria.class), (Object)page), (Object)limit), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Collection)ScriptBytecodeAdapter.asType((Object)callSiteArray[8].call((Object)statuses, (Object)","), Collection.class)), Collection.class)), callSiteArray[9].call(callSiteArray[10].call(callSiteArray[11].call(callSiteArray[12].call((Object)this.clock), callSiteArray[13].callGetProperty(ZoneOffset.class)), (Object)this.daysOfExecutionHistory)));
        public final class _list_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _list_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _list_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _list_closure1.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _list_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _list_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "convert";
                return new CallSiteArray(_list_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _list_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[14].call(callSiteArray[15].call((Object)this.executionRepository, (Object)application, executionCriteria, callSiteArray[16].callGetProperty(ExecutionRepository.ExecutionComparator.class)), (Object)new _list_closure1(this, this)), List.class);
    }

    @PreAuthorize(value="@fiatPermissionEvaluator.storeWholePermission()")
    @PostFilter(value="hasPermission(filterObject.application, 'APPLICATION', 'READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/tasks"})
    public List<OrchestrationViewModel> list() {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        public final class _list_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _list_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _list_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _list_closure2.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _list_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _list_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "convert";
                return new CallSiteArray(_list_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _list_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[17].call(callSiteArray[18].callGetProperty(callSiteArray[19].call(callSiteArray[20].call((Object)this.executionRepository, callSiteArray[21].callGetProperty(ExecutionType.class)))), (Object)new _list_closure2(this, this)), List.class);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/tasks/{id}"})
    public OrchestrationViewModel getTask(@PathVariable String id) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        return (OrchestrationViewModel)ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].callCurrent((GroovyObject)this, callSiteArray[23].call((Object)this.executionRepository, callSiteArray[24].callGetProperty(ExecutionType.class), (Object)id)), OrchestrationViewModel.class);
    }

    public PipelineExecution getOrchestration(String id) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        return (PipelineExecution)ScriptBytecodeAdapter.castToType((Object)callSiteArray[25].call((Object)this.executionRepository, callSiteArray[26].callGetProperty(ExecutionType.class), (Object)id), PipelineExecution.class);
    }

    @PreAuthorize(value="hasPermission(this.getOrchestration(#id)?.application, 'APPLICATION', 'WRITE')")
    @RequestMapping(method={RequestMethod.DELETE}, value={"/tasks/{id}"})
    public void deleteTask(@PathVariable String id) {
        Reference id2 = new Reference((Object)id);
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        public final class _deleteTask_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference id;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _deleteTask_closure3(Object _outerInstance, Object _thisObject, Reference id) {
                Reference reference;
                CallSite[] callSiteArray = _deleteTask_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.id = reference = id;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _deleteTask_closure3.$getCallSiteArray();
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty(callSiteArray[1].callGetProperty(it)))) {
                    return callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this), callSiteArray[4].callGetProperty(ExecutionType.class), this.id.get());
                }
                Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].call(ScriptBytecodeAdapter.getField(_deleteTask_closure3.class, TaskController.class, (String)"log"))) ? callSiteArray[6].call(ScriptBytecodeAdapter.getField(_deleteTask_closure3.class, TaskController.class, (String)"log"), (Object)new GStringImpl(new Object[]{callSiteArray[7].callGetProperty(ExecutionType.class), this.id.get(), callSiteArray[8].callGetProperty(it)}, new String[]{"Not deleting ", " ", " as it is ", ""})) : null;
                throw (Throwable)callSiteArray[9].callConstructor(CannotDeleteRunningExecution.class, callSiteArray[10].callGetProperty(ExecutionType.class), this.id.get());
            }

            @Generated
            public String getId() {
                CallSite[] callSiteArray = _deleteTask_closure3.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.id.get());
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _deleteTask_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deleteTask_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "complete";
                stringArray[1] = "status";
                stringArray[2] = "delete";
                stringArray[3] = "executionRepository";
                stringArray[4] = "ORCHESTRATION";
                stringArray[5] = "isWarnEnabled";
                stringArray[6] = "warn";
                stringArray[7] = "ORCHESTRATION";
                stringArray[8] = "status";
                stringArray[9] = "<$constructor$>";
                stringArray[10] = "ORCHESTRATION";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[11];
                _deleteTask_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_deleteTask_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _deleteTask_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[27].call(callSiteArray[28].call((Object)this.executionRepository, callSiteArray[29].callGetProperty(ExecutionType.class), (Object)((String)id2.get())), (Object)new _deleteTask_closure3(this, this, id2));
    }

    @PreAuthorize(value="hasPermission(this.getOrchestration(#id)?.application, 'APPLICATION', 'EXECUTE')")
    @RequestMapping(method={RequestMethod.PUT}, value={"/tasks/{id}/cancel"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void cancelTask(@PathVariable String id) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        callSiteArray[30].call((Object)this.executionOperator, callSiteArray[31].callGetProperty(ExecutionType.class), (Object)id);
    }

    @PreFilter(value="hasPermission(this.getOrchestration(filterObject)?.application, 'APPLICATION', 'EXECUTE')")
    @RequestMapping(method={RequestMethod.PUT}, value={"/tasks/cancel"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void cancelTasks(@RequestBody List<String> taskIds) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        public final class _cancelTasks_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _cancelTasks_closure4(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _cancelTasks_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _cancelTasks_closure4.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), callSiteArray[2].callGetProperty(ExecutionType.class), it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _cancelTasks_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _cancelTasks_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "cancel";
                stringArray[1] = "executionOperator";
                stringArray[2] = "ORCHESTRATION";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _cancelTasks_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_cancelTasks_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _cancelTasks_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[32].call(taskIds, (Object)new _cancelTasks_closure4(this, this));
    }

    @PostFilter(value="hasPermission(filterObject.application, 'APPLICATION', 'READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/pipelines"})
    public List<PipelineExecution> listSubsetOfPipelines(@RequestParam(value="pipelineConfigIds", required=false) String pipelineConfigIds, @RequestParam(value="executionIds", required=false) String executionIds, @RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="statuses", required=false) String statuses, @RequestParam(defaultValue="true", value="expand") boolean expand) {
        Integer n;
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        String string = statuses;
        String string2 = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : callSiteArray[33].call(ScriptBytecodeAdapter.invokeMethod0SpreadSafe(TaskController.class, (Object)callSiteArray[34].call(ExecutionStatus.class), (String)"toString"), (Object)",");
        statuses = ShortTypeHandling.castToString((Object)string2);
        Integer n2 = limit;
        limit = n = DefaultTypeTransformation.booleanUnbox((Object)n2) ? n2 : Integer.valueOf(1);
        Reference executionCriteria = new Reference((Object)((ExecutionRepository.ExecutionCriteria)ScriptBytecodeAdapter.castToType((Object)callSiteArray[35].callConstructor(ExecutionRepository.ExecutionCriteria.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pageSize", limit, "statuses", (Collection)ScriptBytecodeAdapter.asType((Object)callSiteArray[36].call((Object)statuses, (Object)","), Collection.class)})), ExecutionRepository.ExecutionCriteria.class)));
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? !DefaultTypeTransformation.booleanUnbox((Object)pipelineConfigIds) && !DefaultTypeTransformation.booleanUnbox((Object)executionIds) : !DefaultTypeTransformation.booleanUnbox((Object)pipelineConfigIds) && !DefaultTypeTransformation.booleanUnbox((Object)executionIds)) {
            return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)pipelineConfigIds) && DefaultTypeTransformation.booleanUnbox((Object)executionIds)) {
            throw (Throwable)callSiteArray[37].callConstructor(IllegalArgumentException.class, (Object)"Only pipelineConfigIds OR executionIds can be specified");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)executionIds)) {
            List ids = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[38].call((Object)executionIds, (Object)","), List.class);
            public final class _listSubsetOfPipelines_closure5
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _listSubsetOfPipelines_closure5(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _listSubsetOfPipelines_closure5.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _listSubsetOfPipelines_closure5.$getCallSiteArray();
                    Object object = callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), callSiteArray[2].callGetProperty(ExecutionType.class), it);
                    try {
                        return object;
                    }
                    catch (ExecutionNotFoundException e) {
                        Object var5_5 = null;
                        return var5_5;
                    }
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _listSubsetOfPipelines_closure5.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _listSubsetOfPipelines_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "retrieve";
                    stringArray[1] = "executionRepository";
                    stringArray[2] = "PIPELINE";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _listSubsetOfPipelines_closure5.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_listSubsetOfPipelines_closure5.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _listSubsetOfPipelines_closure5.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            List executions = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[39].call(callSiteArray[40].call(callSiteArray[41].call(callSiteArray[42].call(callSiteArray[43].call(callSiteArray[44].call(Observable.class, callSiteArray[45].call((Object)ids, (Object)new _listSubsetOfPipelines_closure5(this, this))), callSiteArray[46].call(Schedulers.class)))))), List.class);
            if (!expand) {
                callSiteArray[47].callStatic(TaskController.class, (Object)executions);
            }
            return executions;
        }
        List ids = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[48].call((Object)pipelineConfigIds, (Object)","), List.class);
        public final class _listSubsetOfPipelines_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference executionCriteria;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _listSubsetOfPipelines_closure6(Object _outerInstance, Object _thisObject, Reference executionCriteria) {
                Reference reference;
                CallSite[] callSiteArray = _listSubsetOfPipelines_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.executionCriteria = reference = executionCriteria;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _listSubsetOfPipelines_closure6.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), it, this.executionCriteria.get());
            }

            @Generated
            public ExecutionRepository.ExecutionCriteria getExecutionCriteria() {
                CallSite[] callSiteArray = _listSubsetOfPipelines_closure6.$getCallSiteArray();
                return (ExecutionRepository.ExecutionCriteria)ScriptBytecodeAdapter.castToType((Object)this.executionCriteria.get(), ExecutionRepository.ExecutionCriteria.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _listSubsetOfPipelines_closure6.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _listSubsetOfPipelines_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "retrievePipelinesForPipelineConfigId";
                stringArray[1] = "executionRepository";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _listSubsetOfPipelines_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_listSubsetOfPipelines_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _listSubsetOfPipelines_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        List allPipelines = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[49].call(callSiteArray[50].call(callSiteArray[51].call(callSiteArray[52].call(callSiteArray[53].call(callSiteArray[54].call(Observable.class, callSiteArray[55].call((Object)ids, (Object)new _listSubsetOfPipelines_closure6(this, this, executionCriteria))), callSiteArray[56].call(Schedulers.class))))), (Object)startTimeOrId), List.class);
        if (!expand) {
            callSiteArray[57].callStatic(TaskController.class, (Object)allPipelines);
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[58].callCurrent((GroovyObject)this, (Object)allPipelines, (Object)limit), List.class);
    }

    @PreAuthorize(value="hasPermission(#application, 'APPLICATION', 'READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/applications/{application}/pipelines/search"})
    public List<PipelineExecution> searchForPipelinesByTrigger(@PathVariable(value="application") String application, @RequestParam(value="triggerTypes", required=false) String triggerTypes, @RequestParam(value="pipelineName", required=false) String pipelineName, @RequestParam(value="eventId", required=false) String eventId, @RequestParam(value="trigger", required=false) String encodedTriggerParams, @RequestParam(defaultValue="0", value="triggerTimeStartBoundary") long triggerTimeStartBoundary, @RequestParam(defaultValue="9223372036854775807", value="triggerTimeEndBoundary") long triggerTimeEndBoundary, @RequestParam(value="statuses", required=false) String statuses, @RequestParam(defaultValue="0", value="startIndex") int startIndex, @RequestParam(defaultValue="10", value="size") int size, @RequestParam(defaultValue="false", value="reverse") boolean reverse, @RequestParam(defaultValue="false", value="expand") boolean expand) {
        public final class _searchForPipelinesByTrigger_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference pipelineName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _searchForPipelinesByTrigger_closure7(Object _outerInstance, Object _thisObject, Reference pipelineName) {
                Reference reference;
                CallSite[] callSiteArray = _searchForPipelinesByTrigger_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.pipelineName = reference = pipelineName;
            }

            public Object doCall(Object pipeline) {
                CallSite[] callSiteArray = _searchForPipelinesByTrigger_closure7.$getCallSiteArray();
                if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)this.pipelineName.get(), null) && ScriptBytecodeAdapter.compareNotEqual((Object)this.pipelineName.get(), (Object)"")) {
                        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].call(pipeline, (Object)"name"), (Object)this.pipelineName.get());
                    }
                    return true;
                }
                if (ScriptBytecodeAdapter.compareNotEqual((Object)this.pipelineName.get(), null) && ScriptBytecodeAdapter.compareNotEqual((Object)this.pipelineName.get(), (Object)"")) {
                    return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[1].call(pipeline, (Object)"name"), (Object)this.pipelineName.get());
                }
                return true;
            }

            @Generated
            public String getPipelineName() {
                CallSite[] callSiteArray = _searchForPipelinesByTrigger_closure7.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.pipelineName.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _searchForPipelinesByTrigger_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "get";
                stringArray[1] = "get";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _searchForPipelinesByTrigger_closure7.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_searchForPipelinesByTrigger_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _searchForPipelinesByTrigger_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference pipelineName2 = new Reference((Object)pipelineName);
        Reference eventId2 = new Reference((Object)eventId);
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[59].callStatic(TaskController.class, (Object)triggerTimeStartBoundary, (Object)triggerTimeEndBoundary, (Object)startIndex, (Object)size);
        } else {
            TaskController.validateSearchForPipelinesByTriggerParameters(triggerTimeStartBoundary, triggerTimeEndBoundary, startIndex, size);
        }
        ExecutionRepository.ExecutionComparator sortType = (ExecutionRepository.ExecutionComparator)ShortTypeHandling.castToEnum((Object)callSiteArray[60].callGetProperty(ExecutionRepository.ExecutionComparator.class), ExecutionRepository.ExecutionComparator.class);
        if (reverse) {
            Object object = callSiteArray[61].callGetProperty(ExecutionRepository.ExecutionComparator.class);
            sortType = (ExecutionRepository.ExecutionComparator)ShortTypeHandling.castToEnum((Object)object, ExecutionRepository.ExecutionComparator.class);
        }
        Reference triggerParams = new Reference(null);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[62].callCurrent((GroovyObject)this, (Object)encodedTriggerParams);
            triggerParams.set((Object)((Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class)));
        } else {
            Map map = this.decodeTriggerParams(encodedTriggerParams);
            triggerParams.set((Object)map);
        }
        Reference triggerTypesAsSet = new Reference((Object)((Set)ScriptBytecodeAdapter.castToType(DefaultTypeTransformation.booleanUnbox((Object)triggerTypes) && ScriptBytecodeAdapter.compareNotEqual((Object)triggerTypes, (Object)"*") ? (Set)ScriptBytecodeAdapter.asType((Object)callSiteArray[63].call((Object)triggerTypes, (Object)","), Set.class) : null, Set.class)));
        List pipelineConfigIds = null;
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)application, (Object)"*")) {
                Object object = callSiteArray[64].callCurrent((GroovyObject)this);
                pipelineConfigIds = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
            } else {
                List list;
                List pipelines = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[65].call((Object)this.front50Service, (Object)application, (Object)false), List.class);
                Object object = callSiteArray[66].call(callSiteArray[67].call(callSiteArray[68].call((Object)pipelines), (Object)new _searchForPipelinesByTrigger_closure7(this, this, pipelineName2)), callSiteArray[69].call(Collectors.class));
                pipelines = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
                pipelineConfigIds = list = (List)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.getPropertySpreadSafe(TaskController.class, (Object)pipelines, (String)"id"), List.class);
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)application, (Object)"*")) {
            List list;
            pipelineConfigIds = list = this.getPipelineConfigIdsOfReadableApplications();
        } else {
            List list;
            List pipelines = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[70].call((Object)this.front50Service, (Object)application, (Object)false), List.class);
            Object object = callSiteArray[71].call(callSiteArray[72].call(callSiteArray[73].call((Object)pipelines), (Object)new _searchForPipelinesByTrigger_closure7(this, this, pipelineName2)), callSiteArray[74].call(Collectors.class));
            pipelines = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
            pipelineConfigIds = list = (List)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.getPropertySpreadSafe(TaskController.class, (Object)pipelines, (String)"id"), List.class);
        }
        ExecutionRepository.ExecutionCriteria executionCriteria = null;
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[75].call(callSiteArray[76].call(callSiteArray[77].callConstructor(ExecutionRepository.ExecutionCriteria.class), (Object)sortType), callSiteArray[78].call((Object)size, (Object)2));
            executionCriteria = (ExecutionRepository.ExecutionCriteria)ScriptBytecodeAdapter.castToType((Object)object, ExecutionRepository.ExecutionCriteria.class);
        } else {
            Object object = callSiteArray[79].call(callSiteArray[80].call(callSiteArray[81].callConstructor(ExecutionRepository.ExecutionCriteria.class), (Object)sortType), (Object)(size * 2));
            executionCriteria = (ExecutionRepository.ExecutionCriteria)ScriptBytecodeAdapter.castToType((Object)object, ExecutionRepository.ExecutionCriteria.class);
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)statuses, null) && ScriptBytecodeAdapter.compareNotEqual((Object)statuses, (Object)"")) {
                callSiteArray[82].call((Object)executionCriteria, callSiteArray[83].call(callSiteArray[84].call((Object)statuses, (Object)",")));
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)statuses, null) && ScriptBytecodeAdapter.compareNotEqual((Object)statuses, (Object)"")) {
            callSiteArray[85].call((Object)executionCriteria, callSiteArray[86].call(callSiteArray[87].call((Object)statuses, (Object)",")));
        }
        List matchingExecutions = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[88].callConstructor(ArrayList.class), List.class);
        int page = 1;
        while (ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[89].call((Object)matchingExecutions), (Object)size)) {
            List executions = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[90].call((Object)this.executionRepository, (Object)pipelineConfigIds, (Object)triggerTimeStartBoundary, (Object)triggerTimeEndBoundary, callSiteArray[91].call((Object)executionCriteria, (Object)page)), List.class);
            public final class _searchForPipelinesByTrigger_closure8
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference triggerTypesAsSet;
                private /* synthetic */ Reference eventId;
                private /* synthetic */ Reference triggerParams;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _searchForPipelinesByTrigger_closure8(Object _outerInstance, Object _thisObject, Reference triggerTypesAsSet, Reference eventId, Reference triggerParams) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    CallSite[] callSiteArray = _searchForPipelinesByTrigger_closure8.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.triggerTypesAsSet = reference3 = triggerTypesAsSet;
                    this.eventId = reference2 = eventId;
                    this.triggerParams = reference = triggerParams;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _searchForPipelinesByTrigger_closure8.$getCallSiteArray();
                    if (DefaultTypeTransformation.booleanUnbox((Object)this.triggerTypesAsSet.get()) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(this.triggerTypesAsSet.get(), callSiteArray[1].callGetProperty(callSiteArray[2].call(it))))) {
                        return false;
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)this.eventId.get()) && ScriptBytecodeAdapter.compareNotEqual((Object)this.eventId.get(), (Object)callSiteArray[3].callGetProperty(callSiteArray[4].callGetProperty(callSiteArray[5].call(it))))) {
                        return false;
                    }
                    return callSiteArray[6].callCurrent((GroovyObject)this, callSiteArray[7].call(it), this.triggerParams.get());
                }

                @Generated
                public Set getTriggerTypesAsSet() {
                    CallSite[] callSiteArray = _searchForPipelinesByTrigger_closure8.$getCallSiteArray();
                    return (Set)ScriptBytecodeAdapter.castToType((Object)this.triggerTypesAsSet.get(), Set.class);
                }

                @Generated
                public String getEventId() {
                    CallSite[] callSiteArray = _searchForPipelinesByTrigger_closure8.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.eventId.get());
                }

                @Generated
                public Map getTriggerParams() {
                    CallSite[] callSiteArray = _searchForPipelinesByTrigger_closure8.$getCallSiteArray();
                    return (Map)ScriptBytecodeAdapter.castToType((Object)this.triggerParams.get(), Map.class);
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _searchForPipelinesByTrigger_closure8.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _searchForPipelinesByTrigger_closure8.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "contains";
                    stringArray[1] = "type";
                    stringArray[2] = "getTrigger";
                    stringArray[3] = "eventId";
                    stringArray[4] = "other";
                    stringArray[5] = "getTrigger";
                    stringArray[6] = "compareTriggerWithTriggerSubset";
                    stringArray[7] = "getTrigger";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[8];
                    _searchForPipelinesByTrigger_closure8.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_searchForPipelinesByTrigger_closure8.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _searchForPipelinesByTrigger_closure8.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[92].call((Object)matchingExecutions, callSiteArray[93].call(callSiteArray[94].call(callSiteArray[95].call((Object)executions), (Object)new _searchForPipelinesByTrigger_closure8(this, this, triggerTypesAsSet, eventId2, triggerParams)), callSiteArray[96].call(Collectors.class)));
            if (ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[97].call((Object)executions), (Object)callSiteArray[98].callGetProperty((Object)executionCriteria))) break;
            int n = page;
            page = DefaultTypeTransformation.intUnbox((Object)callSiteArray[99].call((Object)n));
        }
        List rval = null;
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)startIndex, (Object)callSiteArray[100].call((Object)matchingExecutions))) {
                List list;
                rval = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            } else {
                Object object = callSiteArray[101].call((Object)matchingExecutions, (Object)startIndex, callSiteArray[102].call(Math.class, callSiteArray[103].call((Object)matchingExecutions), callSiteArray[104].call((Object)startIndex, (Object)size)));
                rval = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
            }
        } else if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)startIndex, (Object)callSiteArray[105].call((Object)matchingExecutions))) {
            List list;
            rval = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        } else {
            Object object = callSiteArray[106].call((Object)matchingExecutions, (Object)startIndex, callSiteArray[107].call(Math.class, callSiteArray[108].call((Object)matchingExecutions), (Object)(startIndex + size)));
            rval = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        }
        if (!expand) {
            callSiteArray[109].callStatic(TaskController.class, (Object)rval);
        }
        return rval;
    }

    private boolean compareTriggerWithTriggerSubset(Trigger trigger, Map triggerSubset) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        Map triggerAsMap = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[110].call((Object)this.mapper, (Object)trigger, Map.class), Map.class);
        long startMillis = DefaultTypeTransformation.longUnbox((Object)callSiteArray[111].call((Object)this.clock));
        boolean result = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[112].callStatic(TaskController.class, (Object)triggerAsMap, (Object)triggerSubset));
        long ellapsedMillis = DefaultTypeTransformation.longUnbox((Object)callSiteArray[113].call(callSiteArray[114].call((Object)this.clock), (Object)startMillis));
        callSiteArray[115].call(callSiteArray[116].call((Object)this.registry, (Object)"trigger.comparison"), (Object)ellapsedMillis, callSiteArray[117].callGetProperty(TimeUnit.class));
        return result;
    }

    @PostAuthorize(value="hasPermission(returnObject.application, 'APPLICATION', 'READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/pipelines/{id}"})
    public PipelineExecution getPipeline(@PathVariable String id) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        return (PipelineExecution)ScriptBytecodeAdapter.castToType((Object)callSiteArray[118].call((Object)this.executionRepository, callSiteArray[119].callGetProperty(ExecutionType.class), (Object)id), PipelineExecution.class);
    }

    @PreAuthorize(value="hasPermission(this.getPipeline(#id)?.application, 'APPLICATION', 'WRITE')")
    @RequestMapping(method={RequestMethod.DELETE}, value={"/pipelines/{id}"})
    public void deletePipeline(@PathVariable String id) {
        Reference id2 = new Reference((Object)id);
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        public final class _deletePipeline_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference id;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _deletePipeline_closure9(Object _outerInstance, Object _thisObject, Reference id) {
                Reference reference;
                CallSite[] callSiteArray = _deletePipeline_closure9.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.id = reference = id;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _deletePipeline_closure9.$getCallSiteArray();
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty(callSiteArray[1].callGetProperty(it)))) {
                    return callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this), callSiteArray[4].callGetProperty(ExecutionType.class), this.id.get());
                }
                Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].call(ScriptBytecodeAdapter.getField(_deletePipeline_closure9.class, TaskController.class, (String)"log"))) ? callSiteArray[6].call(ScriptBytecodeAdapter.getField(_deletePipeline_closure9.class, TaskController.class, (String)"log"), (Object)new GStringImpl(new Object[]{callSiteArray[7].callGetProperty(ExecutionType.class), this.id.get(), callSiteArray[8].callGetProperty(it)}, new String[]{"Not deleting ", " ", " as it is ", ""})) : null;
                throw (Throwable)callSiteArray[9].callConstructor(CannotDeleteRunningExecution.class, callSiteArray[10].callGetProperty(ExecutionType.class), this.id.get());
            }

            @Generated
            public String getId() {
                CallSite[] callSiteArray = _deletePipeline_closure9.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.id.get());
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _deletePipeline_closure9.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deletePipeline_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "complete";
                stringArray[1] = "status";
                stringArray[2] = "delete";
                stringArray[3] = "executionRepository";
                stringArray[4] = "PIPELINE";
                stringArray[5] = "isWarnEnabled";
                stringArray[6] = "warn";
                stringArray[7] = "PIPELINE";
                stringArray[8] = "status";
                stringArray[9] = "<$constructor$>";
                stringArray[10] = "PIPELINE";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[11];
                _deletePipeline_closure9.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_deletePipeline_closure9.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _deletePipeline_closure9.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[120].call(callSiteArray[121].call((Object)this.executionRepository, callSiteArray[122].callGetProperty(ExecutionType.class), (Object)((String)id2.get())), (Object)new _deletePipeline_closure9(this, this, id2));
    }

    @PreAuthorize(value="hasPermission(this.getPipeline(#id)?.application, 'APPLICATION', 'EXECUTE')")
    @RequestMapping(method={RequestMethod.PUT}, value={"/pipelines/{id}/cancel"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void cancel(@PathVariable String id, @RequestParam(required=false) String reason, @RequestParam(defaultValue="false") boolean force) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        callSiteArray[123].call((Object)this.executionOperator, callSiteArray[124].callGetProperty(ExecutionType.class), (Object)id, callSiteArray[125].call(callSiteArray[126].call(AuthenticatedRequest.class), (Object)"anonymous"), (Object)reason);
    }

    @PreAuthorize(value="hasPermission(this.getPipeline(#id)?.application, 'APPLICATION', 'EXECUTE')")
    @RequestMapping(method={RequestMethod.PUT}, value={"/pipelines/{id}/pause"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void pause(@PathVariable String id) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        callSiteArray[127].call((Object)this.executionOperator, callSiteArray[128].callGetProperty(ExecutionType.class), (Object)id, callSiteArray[129].call(callSiteArray[130].call(AuthenticatedRequest.class), (Object)"anonymous"));
    }

    @PreAuthorize(value="hasPermission(this.getPipeline(#id)?.application, 'APPLICATION', 'EXECUTE')")
    @RequestMapping(method={RequestMethod.PUT}, value={"/pipelines/{id}/resume"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void resume(@PathVariable String id) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        callSiteArray[131].call((Object)this.executionOperator, callSiteArray[132].callGetProperty(ExecutionType.class), (Object)id, callSiteArray[133].call(callSiteArray[134].call(AuthenticatedRequest.class), (Object)"anonymous"), (Object)false);
    }

    @PreAuthorize(value="@fiatPermissionEvaluator.storeWholePermission()")
    @PostFilter(value="hasPermission(this.getPipeline(filterObject)?.application, 'APPLICATION', 'READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/pipelines/running"})
    @ResponseStatus(value=HttpStatus.GONE)
    public List<String> runningPipelines() {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
    }

    @PreAuthorize(value="@fiatPermissionEvaluator.storeWholePermission()")
    @PostFilter(value="hasPermission(this.getPipeline(filterObject)?.application, 'APPLICATION', 'READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/pipelines/waiting"})
    @ResponseStatus(value=HttpStatus.GONE)
    public List<String> waitingPipelines() {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
    }

    @PreAuthorize(value="hasPermission(this.getPipeline(#id)?.application, 'APPLICATION', 'EXECUTE')")
    @RequestMapping(method={RequestMethod.PATCH}, value={"/pipelines/{id}/stages/{stageId}"})
    public PipelineExecution updatePipelineStage(@PathVariable String id, @PathVariable String stageId, @RequestBody Map context) {
        Reference context2 = new Reference((Object)context);
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        public final class _updatePipelineStage_closure10
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference context;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updatePipelineStage_closure10(Object _outerInstance, Object _thisObject, Reference context) {
                Reference reference;
                CallSite[] callSiteArray = _updatePipelineStage_closure10.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.context = reference = context;
            }

            public Object doCall(Object stage) {
                CallSite[] callSiteArray = _updatePipelineStage_closure10.$getCallSiteArray();
                callSiteArray[0].call(callSiteArray[1].callGetProperty(stage), this.context.get());
                callSiteArray[2].callCurrent((GroovyObject)this, stage);
                Object[] objectArray = new Object[6];
                objectArray[0] = "user";
                objectArray[1] = callSiteArray[4].call(callSiteArray[5].call(AuthenticatedRequest.class), (Object)"anonymous");
                objectArray[2] = "allowedAccounts";
                Object object = callSiteArray[6].callSafe(callSiteArray[7].call(callSiteArray[8].call(AuthenticatedRequest.class), null), (Object)",");
                objectArray[3] = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                objectArray[4] = "lastModifiedTime";
                objectArray[5] = callSiteArray[9].call(System.class);
                Object object2 = callSiteArray[3].callConstructor(StageExecution.LastModifiedDetails.class, (Object)ScriptBytecodeAdapter.createMap((Object[])objectArray));
                ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)stage, (String)"lastModified");
                Object object3 = callSiteArray[10].callGetProperty(callSiteArray[11].callGetProperty(stage));
                callSiteArray[12].call(callSiteArray[13].callGetProperty(stage), (Object)"lastModifiedBy", object3);
                return object3;
            }

            @Generated
            public Map getContext() {
                CallSite[] callSiteArray = _updatePipelineStage_closure10.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.context.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updatePipelineStage_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "putAll";
                stringArray[1] = "context";
                stringArray[2] = "validateStageUpdate";
                stringArray[3] = "<$constructor$>";
                stringArray[4] = "orElse";
                stringArray[5] = "getSpinnakerUser";
                stringArray[6] = "split";
                stringArray[7] = "orElse";
                stringArray[8] = "getSpinnakerAccounts";
                stringArray[9] = "currentTimeMillis";
                stringArray[10] = "user";
                stringArray[11] = "lastModified";
                stringArray[12] = "putAt";
                stringArray[13] = "context";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[14];
                _updatePipelineStage_closure10.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_updatePipelineStage_closure10.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updatePipelineStage_closure10.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (PipelineExecution)ScriptBytecodeAdapter.castToType((Object)callSiteArray[135].call((Object)this.executionOperator, callSiteArray[136].callGetProperty(ExecutionType.class), (Object)id, (Object)stageId, (Object)new _updatePipelineStage_closure10(this, this, context2)), PipelineExecution.class);
    }

    public void validateStageUpdate(StageExecution stage) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[137].callGetProperty(callSiteArray[138].callGetProperty((Object)stage))) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[139].callSafe(callSiteArray[140].call((Object)this.stageDefinitionBuilderFactory, (Object)stage), (Object)stage))) {
            throw (Throwable)callSiteArray[141].callConstructor(CannotUpdateExecutionStage.class, (Object)"Cannot manually skip stage.");
        }
    }

    @PreAuthorize(value="hasPermission(this.getPipeline(#id)?.application, 'APPLICATION', 'EXECUTE')")
    @RequestMapping(method={RequestMethod.PUT}, value={"/pipelines/{id}/stages/{stageId}/restart"})
    public PipelineExecution retryPipelineStage(@PathVariable String id, @PathVariable String stageId, @RequestBody Map restartDetails) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        return (PipelineExecution)ScriptBytecodeAdapter.castToType((Object)callSiteArray[142].call((Object)this.executionOperator, (Object)id, (Object)stageId, (Object)restartDetails), PipelineExecution.class);
    }

    @PreAuthorize(value="hasPermission(this.getPipeline(#id)?.application, 'APPLICATION', 'READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/pipelines/{id}/evaluateExpression"})
    public Map evaluateExpressionForExecution(@PathVariable(value="id") String id, @RequestParam(value="expression") String expression) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        Object execution = callSiteArray[143].call((Object)this.executionRepository, callSiteArray[144].callGetProperty(ExecutionType.class), (Object)id);
        Map context = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"execution", execution, "trigger", callSiteArray[145].call((Object)this.mapper, callSiteArray[146].callGetProperty(execution), Map.class)});
        Object evaluated = callSiteArray[147].call((Object)this.contextParameterProcessor, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"expression", expression}), (Object)context, (Object)true);
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", callSiteArray[148].callGetPropertySafe(evaluated), "detail", callSiteArray[149].callGetPropertySafe(evaluated)});
    }

    @PreAuthorize(value="hasPermission(this.getPipeline(#id)?.application, 'APPLICATION', 'READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/pipelines/{id}/{stageId}/evaluateExpression"})
    public Map evaluateExpressionForExecutionAtStage(@PathVariable(value="id") String id, @PathVariable(value="stageId") String stageId, @RequestParam(value="expression") String expression) {
        Reference stageId2 = new Reference((Object)stageId);
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        Object execution = callSiteArray[150].call((Object)this.executionRepository, callSiteArray[151].callGetProperty(ExecutionType.class), (Object)id);
        public final class _evaluateExpressionForExecutionAtStage_closure11
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference stageId;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _evaluateExpressionForExecutionAtStage_closure11(Object _outerInstance, Object _thisObject, Reference stageId) {
                Reference reference;
                CallSite[] callSiteArray = _evaluateExpressionForExecutionAtStage_closure11.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.stageId = reference = stageId;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _evaluateExpressionForExecutionAtStage_closure11.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)this.stageId.get());
            }

            @Generated
            public String getStageId() {
                CallSite[] callSiteArray = _evaluateExpressionForExecutionAtStage_closure11.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.stageId.get());
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _evaluateExpressionForExecutionAtStage_closure11.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _evaluateExpressionForExecutionAtStage_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "id";
                return new CallSiteArray(_evaluateExpressionForExecutionAtStage_closure11.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _evaluateExpressionForExecutionAtStage_closure11.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object stage = callSiteArray[152].call(callSiteArray[153].callGetProperty(execution), (Object)new _evaluateExpressionForExecutionAtStage_closure11(this, this, stageId2));
        if (ScriptBytecodeAdapter.compareEqual((Object)stage, null)) {
            throw (Throwable)callSiteArray[154].callConstructor(NotFoundException.class, (Object)new GStringImpl(new Object[]{(String)stageId2.get(), id}, new String[]{"Stage ", " not found in execution ", ""}));
        }
        Object evaluated = callSiteArray[155].call((Object)this.contextParameterProcessor, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"expression", expression}), callSiteArray[156].call((Object)this.contextParameterProcessor, stage), (Object)true);
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", callSiteArray[157].callGetPropertySafe(evaluated), "detail", callSiteArray[158].callGetPropertySafe(evaluated)});
    }

    @PreAuthorize(value="hasPermission(this.getPipeline(#id)?.application, 'APPLICATION', 'READ')")
    @PostMapping(value={"/pipelines/{id}/evaluateVariables"})
    public Map evaluateVariables(@PathVariable(value="id") String id, @RequestParam(defaultValue="", value="requisiteStageRefIds") String requisiteStageRefIds, @RequestParam(defaultValue="", value="spelVersion") String spelVersionOverride, @RequestBody List<Map<String, String>> expressions) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        Object execution = callSiteArray[159].call((Object)this.executionRepository, callSiteArray[160].callGetProperty(ExecutionType.class), (Object)id);
        public final class _evaluateVariables_closure12
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _evaluateVariables_closure12(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _evaluateVariables_closure12.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _evaluateVariables_closure12.$getCallSiteArray();
                return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty(it));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _evaluateVariables_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "empty";
                return new CallSiteArray(_evaluateVariables_closure12.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _evaluateVariables_closure12.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[161].call((Object)this.expressionUtils, execution, callSiteArray[162].call(callSiteArray[163].call((Object)requisiteStageRefIds, (Object)"[,;\\s]"), (Object)new _evaluateVariables_closure12(this, this)), (Object)spelVersionOverride, expressions), Map.class);
    }

    private Map<String, Object> augmentContext(StageExecution stage) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        Map augmentedContext = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[164].callGetProperty((Object)stage), Map.class);
        callSiteArray[165].call((Object)augmentedContext, (Object)"trigger", callSiteArray[166].callGetProperty(callSiteArray[167].callGetProperty((Object)stage)));
        callSiteArray[168].call((Object)augmentedContext, (Object)"execution", callSiteArray[169].callGetProperty((Object)stage));
        return augmentedContext;
    }

    @PreAuthorize(value="hasPermission(#application, 'APPLICATION', 'READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/v2/applications/{application}/pipelines"})
    public List<PipelineExecution> getApplicationPipelines(@PathVariable String application, @RequestParam(defaultValue="5", value="limit") int limit, @RequestParam(value="statuses", required=false) String statuses, @RequestParam(defaultValue="true", value="expand") Boolean expand) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[170].callCurrent((GroovyObject)this, (Object)application, (Object)limit, (Object)statuses, (Object)expand), List.class);
        }
        return this.getPipelinesForApplication(application, limit, statuses, expand);
    }

    @PreAuthorize(value="hasPermission(#application, 'APPLICATION', 'READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/applications/{application}/pipelines"})
    public List<PipelineExecution> getPipelinesForApplication(@PathVariable String application, @RequestParam(defaultValue="5", value="limit") int limit, @RequestParam(value="statuses", required=false) String statuses, @RequestParam(defaultValue="true", value="expand") Boolean expand) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.front50Service)) {
            throw (Throwable)callSiteArray[171].callConstructor(UnsupportedOperationException.class, (Object)"Cannot lookup pipelines, front50 has not been enabled. Fix this by setting front50.enabled: true");
        }
        if (!(limit != 0)) {
            return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        }
        String string = statuses;
        String string2 = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : callSiteArray[172].call(ScriptBytecodeAdapter.invokeMethod0SpreadSafe(TaskController.class, (Object)callSiteArray[173].call(ExecutionStatus.class), (String)"toString"), (Object)",");
        statuses = ShortTypeHandling.castToString((Object)string2);
        Reference executionCriteria = new Reference(callSiteArray[174].callConstructor(ExecutionRepository.ExecutionCriteria.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pageSize", limit, "statuses", (Collection)ScriptBytecodeAdapter.asType((Object)callSiteArray[175].call((Object)statuses, (Object)","), Collection.class)})));
        List pipelineConfigIds = (List)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.getPropertySpreadSafe(TaskController.class, (Object)callSiteArray[176].call((Object)this.front50Service, (Object)application, (Object)false), (String)"id"), List.class);
        List strategyConfigIds = (List)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.getPropertySpreadSafe(TaskController.class, (Object)callSiteArray[177].call((Object)this.front50Service, (Object)application), (String)"id"), List.class);
        Object allIds = callSiteArray[178].call((Object)pipelineConfigIds, (Object)strategyConfigIds);
        public final class _getPipelinesForApplication_closure13
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference executionCriteria;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getPipelinesForApplication_closure13(Object _outerInstance, Object _thisObject, Reference executionCriteria) {
                Reference reference;
                CallSite[] callSiteArray = _getPipelinesForApplication_closure13.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.executionCriteria = reference = executionCriteria;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getPipelinesForApplication_closure13.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), it, this.executionCriteria.get());
            }

            @Generated
            public Object getExecutionCriteria() {
                CallSite[] callSiteArray = _getPipelinesForApplication_closure13.$getCallSiteArray();
                return this.executionCriteria.get();
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _getPipelinesForApplication_closure13.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getPipelinesForApplication_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "retrievePipelinesForPipelineConfigId";
                stringArray[1] = "executionRepository";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _getPipelinesForApplication_closure13.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getPipelinesForApplication_closure13.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getPipelinesForApplication_closure13.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object allPipelines = callSiteArray[179].call(callSiteArray[180].call(callSiteArray[181].call(callSiteArray[182].call(callSiteArray[183].call(callSiteArray[184].call(Observable.class, callSiteArray[185].call(allIds, (Object)new _getPipelinesForApplication_closure13(this, this, executionCriteria))), callSiteArray[186].call(Schedulers.class))))), (Object)startTimeOrId);
        if (!DefaultTypeTransformation.booleanUnbox((Object)expand)) {
            callSiteArray[187].callStatic(TaskController.class, allPipelines);
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[188].callCurrent((GroovyObject)this, allPipelines, (Object)limit), List.class);
    }

    private static void validateSearchForPipelinesByTriggerParameters(long triggerTimeStartBoundary, long triggerTimeEndBoundary, int startIndex, int size) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigL() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (triggerTimeStartBoundary < (long)0) {
                throw (Throwable)callSiteArray[189].callConstructor(IllegalArgumentException.class, callSiteArray[190].call(String.class, (Object)"triggerTimeStartBoundary must be >= 0: triggerTimeStartBoundary=%s", (Object)triggerTimeStartBoundary));
            }
            if (triggerTimeEndBoundary < (long)0) {
                throw (Throwable)callSiteArray[191].callConstructor(IllegalArgumentException.class, callSiteArray[192].call(String.class, (Object)"triggerTimeEndBoundary must be >= 0: triggerTimeEndBoundary=%s", (Object)triggerTimeEndBoundary));
            }
            if (triggerTimeStartBoundary > triggerTimeEndBoundary) {
                throw (Throwable)callSiteArray[193].callConstructor(IllegalArgumentException.class, callSiteArray[194].call(String.class, (Object)"triggerTimeStartBoundary must be <= triggerTimeEndBoundary: triggerTimeStartBoundary=%s, triggerTimeEndBoundary=%s", (Object)triggerTimeStartBoundary, (Object)triggerTimeEndBoundary));
            }
            if (startIndex < 0) {
                throw (Throwable)callSiteArray[195].callConstructor(IllegalArgumentException.class, callSiteArray[196].call(String.class, (Object)"startIndex must be >= 0: startIndex=%s", (Object)startIndex));
            }
            if (size <= 0) {
                throw (Throwable)callSiteArray[197].callConstructor(IllegalArgumentException.class, callSiteArray[198].call(String.class, (Object)"size must be > 0: size=%s", (Object)size));
            }
        } else {
            if (triggerTimeStartBoundary < (long)0) {
                throw (Throwable)callSiteArray[199].callConstructor(IllegalArgumentException.class, callSiteArray[200].call(String.class, (Object)"triggerTimeStartBoundary must be >= 0: triggerTimeStartBoundary=%s", (Object)triggerTimeStartBoundary));
            }
            if (triggerTimeEndBoundary < (long)0) {
                throw (Throwable)callSiteArray[201].callConstructor(IllegalArgumentException.class, callSiteArray[202].call(String.class, (Object)"triggerTimeEndBoundary must be >= 0: triggerTimeEndBoundary=%s", (Object)triggerTimeEndBoundary));
            }
            if (triggerTimeStartBoundary > triggerTimeEndBoundary) {
                throw (Throwable)callSiteArray[203].callConstructor(IllegalArgumentException.class, callSiteArray[204].call(String.class, (Object)"triggerTimeStartBoundary must be <= triggerTimeEndBoundary: triggerTimeStartBoundary=%s, triggerTimeEndBoundary=%s", (Object)triggerTimeStartBoundary, (Object)triggerTimeEndBoundary));
            }
            if (startIndex < 0) {
                throw (Throwable)callSiteArray[205].callConstructor(IllegalArgumentException.class, callSiteArray[206].call(String.class, (Object)"startIndex must be >= 0: startIndex=%s", (Object)startIndex));
            }
            if (size <= 0) {
                throw (Throwable)callSiteArray[207].callConstructor(IllegalArgumentException.class, callSiteArray[208].call(String.class, (Object)"size must be > 0: size=%s", (Object)size));
            }
        }
    }

    private Map decodeTriggerParams(String encodedTriggerParams) {
        Map triggerParams;
        CallSite[] callSiteArray;
        block5: {
            callSiteArray = TaskController.$getCallSiteArray();
            triggerParams = null;
            if (ScriptBytecodeAdapter.compareNotEqual((Object)encodedTriggerParams, null)) {
                try {
                    byte[] decoded = (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[209].call(callSiteArray[210].call(Base64.class), (Object)encodedTriggerParams), byte[].class);
                    String str = ShortTypeHandling.castToString((Object)callSiteArray[211].callConstructor(String.class, (Object)decoded, callSiteArray[212].call(Charset.class, (Object)"UTF-8")));
                    Object object = callSiteArray[213].call((Object)this.mapper, (Object)str, Map.class);
                    triggerParams = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
                    break block5;
                }
                catch (Exception e) {
                    throw (Throwable)callSiteArray[214].callConstructor(RuntimeException.class, (Object)"Failed to parse encoded trigger", (Object)e);
                }
            }
            Object object = callSiteArray[215].callConstructor(HashMap.class);
            triggerParams = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[216].call(Collections.class, (Object)triggerParams), Map.class);
    }

    private static void clearTriggerStages(Map trigger) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[217].callSafe(callSiteArray[218].callGetProperty((Object)trigger)), (Object)"pipeline")) {
            return;
        }
        callSiteArray[219].call((Object)((List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[220].callGetProperty(callSiteArray[221].callGetProperty((Object)trigger)), List.class)));
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[222].call(callSiteArray[223].callGetProperty(callSiteArray[224].callGetProperty(callSiteArray[225].callGetProperty((Object)trigger)))), (Object)"pipeline")) {
            callSiteArray[226].callStatic(TaskController.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[227].callGetProperty(callSiteArray[228].callGetProperty((Object)trigger)), Map.class)), Map.class));
        }
    }

    private List<PipelineExecution> filterPipelinesByHistoryCutoff(List<PipelineExecution> pipelines, int limit) {
        Reference limit2 = new Reference((Object)limit);
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        Reference cutoffTime = new Reference(callSiteArray[229].call(callSiteArray[230].call(callSiteArray[231].call((Object)this.clock), (Object)this.daysOfExecutionHistory, callSiteArray[232].callGetProperty(ChronoUnit.class))));
        Reference pipelinesSatisfyingCutoff = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _filterPipelinesByHistoryCutoff_closure14
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _filterPipelinesByHistoryCutoff_closure14(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _filterPipelinesByHistoryCutoff_closure14.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _filterPipelinesByHistoryCutoff_closure14.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _filterPipelinesByHistoryCutoff_closure14.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _filterPipelinesByHistoryCutoff_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "pipelineConfigId";
                return new CallSiteArray(_filterPipelinesByHistoryCutoff_closure14.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _filterPipelinesByHistoryCutoff_closure14.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _filterPipelinesByHistoryCutoff_closure15
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference cutoffTime;
            private /* synthetic */ Reference pipelinesSatisfyingCutoff;
            private /* synthetic */ Reference limit;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _filterPipelinesByHistoryCutoff_closure15(Object _outerInstance, Object _thisObject, Reference cutoffTime, Reference pipelinesSatisfyingCutoff, Reference limit) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _filterPipelinesByHistoryCutoff_closure15.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.cutoffTime = reference3 = cutoffTime;
                this.pipelinesSatisfyingCutoff = reference2 = pipelinesSatisfyingCutoff;
                this.limit = reference = limit;
            }

            public Object doCall(List<PipelineExecution> pipelinesGroup) {
                CallSite[] callSiteArray = _filterPipelinesByHistoryCutoff_closure15.$getCallSiteArray();
                Object sortedPipelinesGroup = callSiteArray[0].call(callSiteArray[1].call(pipelinesGroup, ScriptBytecodeAdapter.getField(_filterPipelinesByHistoryCutoff_closure15.class, TaskController.class, (String)"startTimeOrId")));
                public final class _closure21
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference cutoffTime;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure21(Object _outerInstance, Object _thisObject, Reference cutoffTime) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure21.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.cutoffTime = reference = cutoffTime;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure21.$getCallSiteArray();
                        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty(it)) || ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[1].callGetProperty(it), (Object)this.cutoffTime.get());
                        }
                        return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callGetProperty(it)) || ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[3].callGetProperty(it), (Object)this.cutoffTime.get());
                    }

                    @Generated
                    public Object getCutoffTime() {
                        CallSite[] callSiteArray = _closure21.$getCallSiteArray();
                        return this.cutoffTime.get();
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure21.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure21.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "startTime";
                        stringArray[1] = "startTime";
                        stringArray[2] = "startTime";
                        stringArray[3] = "startTime";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[4];
                        _closure21.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure21.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure21.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                Object recentPipelines = callSiteArray[2].call(sortedPipelinesGroup, (Object)new _closure21((Object)this, this.getThisObject(), this.cutoffTime));
                if (!DefaultTypeTransformation.booleanUnbox((Object)recentPipelines) && DefaultTypeTransformation.booleanUnbox((Object)sortedPipelinesGroup)) {
                    Object object;
                    Object upperBounds = callSiteArray[3].call(callSiteArray[4].call(Math.class, callSiteArray[5].call(sortedPipelinesGroup), callSiteArray[6].callGroovyObjectGetProperty((Object)this)), (Object)1);
                    recentPipelines = object = callSiteArray[7].call(sortedPipelinesGroup, (Object)ScriptBytecodeAdapter.createRange((Object)0, (Object)upperBounds, (boolean)true));
                }
                return callSiteArray[8].call(this.pipelinesSatisfyingCutoff.get(), callSiteArray[9].call(recentPipelines, (Object)0, callSiteArray[10].call(Math.class, callSiteArray[11].call(recentPipelines), this.limit.get())));
            }

            @Generated
            public Object call(List<PipelineExecution> pipelinesGroup) {
                CallSite[] callSiteArray = _filterPipelinesByHistoryCutoff_closure15.$getCallSiteArray();
                return callSiteArray[12].callCurrent((GroovyObject)this, pipelinesGroup);
            }

            @Generated
            public Object getCutoffTime() {
                CallSite[] callSiteArray = _filterPipelinesByHistoryCutoff_closure15.$getCallSiteArray();
                return this.cutoffTime.get();
            }

            @Generated
            public Object getPipelinesSatisfyingCutoff() {
                CallSite[] callSiteArray = _filterPipelinesByHistoryCutoff_closure15.$getCallSiteArray();
                return this.pipelinesSatisfyingCutoff.get();
            }

            @Generated
            public int getLimit() {
                CallSite[] callSiteArray = _filterPipelinesByHistoryCutoff_closure15.$getCallSiteArray();
                return DefaultTypeTransformation.intUnbox((Object)this.limit.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _filterPipelinesByHistoryCutoff_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "reverse";
                stringArray[1] = "sort";
                stringArray[2] = "findAll";
                stringArray[3] = "minus";
                stringArray[4] = "min";
                stringArray[5] = "size";
                stringArray[6] = "numberOfOldPipelineExecutionsToInclude";
                stringArray[7] = "getAt";
                stringArray[8] = "addAll";
                stringArray[9] = "subList";
                stringArray[10] = "min";
                stringArray[11] = "size";
                stringArray[12] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[13];
                _filterPipelinesByHistoryCutoff_closure15.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_filterPipelinesByHistoryCutoff_closure15.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _filterPipelinesByHistoryCutoff_closure15.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[233].call(callSiteArray[234].call(callSiteArray[235].call(pipelines, (Object)new _filterPipelinesByHistoryCutoff_closure14(this, this))), (Object)new _filterPipelinesByHistoryCutoff_closure15(this, this, cutoffTime, pipelinesSatisfyingCutoff, limit2));
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[236].call(pipelinesSatisfyingCutoff.get(), (Object)startTimeOrId), List.class);
    }

    private static Object unexpandPipelineExecutions(List<PipelineExecution> pipelineExecutions) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        public final class _unexpandPipelineExecutions_closure16
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _unexpandPipelineExecutions_closure16(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _unexpandPipelineExecutions_closure16.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object pipelineExecution) {
                CallSite[] callSiteArray = _unexpandPipelineExecutions_closure16.$getCallSiteArray();
                callSiteArray[0].callCurrent((GroovyObject)this, callSiteArray[1].callGetProperty(callSiteArray[2].callGetProperty(pipelineExecution)));
                public final class _closure22
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure22(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _closure22.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object stage) {
                        CallSite[] callSiteArray = _closure22.$getCallSiteArray();
                        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callSafe(callSiteArray[1].callGetProperty(stage), (Object)"group"))) {
                            Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"group", callSiteArray[2].callGetProperty(callSiteArray[3].callGetProperty(stage))});
                            ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)stage, (String)"context");
                        } else {
                            Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
                            ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)stage, (String)"context");
                        }
                        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
                        ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)stage, (String)"outputs");
                        List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                        ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)stage, (String)"tasks");
                        return list;
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure22.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "containsKey";
                        stringArray[1] = "context";
                        stringArray[2] = "group";
                        stringArray[3] = "context";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[4];
                        _closure22.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure22.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure22.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[3].call(callSiteArray[4].call(pipelineExecution), (Object)new _closure22((Object)this, this.getThisObject()));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _unexpandPipelineExecutions_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "clearTriggerStages";
                stringArray[1] = "other";
                stringArray[2] = "trigger";
                stringArray[3] = "each";
                stringArray[4] = "getStages";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _unexpandPipelineExecutions_closure16.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_unexpandPipelineExecutions_closure16.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _unexpandPipelineExecutions_closure16.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return callSiteArray[237].call(pipelineExecutions, (Object)new _unexpandPipelineExecutions_closure16(TaskController.class, TaskController.class));
    }

    public static boolean shouldReplace(Map.Entry<String, Object> entry, Map variables) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[238].callStatic(TaskController.class, callSiteArray[239].call((Object)variables, callSiteArray[240].callGetProperty(entry)))) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[241].callStatic(TaskController.class, callSiteArray[242].callGetProperty(entry)));
    }

    private OrchestrationViewModel convert(PipelineExecution orchestration) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        Map variables = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        Object stage = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[243].call(callSiteArray[244].callGetProperty((Object)orchestration)), Iterator.class);
        while (iterator.hasNext()) {
            stage = iterator.next();
            Object entry = null;
            Iterator iterator2 = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[245].call(callSiteArray[246].call(callSiteArray[247].callGetProperty(stage))), Iterator.class);
            while (iterator2.hasNext()) {
                entry = iterator2.next();
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[248].callStatic(TaskController.class, entry, (Object)variables))) continue;
                Object object = callSiteArray[249].callGetProperty(entry);
                callSiteArray[250].call((Object)variables, callSiteArray[251].callGetProperty(entry), object);
            }
        }
        public final class _convert_closure17
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _convert_closure17(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _convert_closure17.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object key, Object value) {
                CallSite[] callSiteArray = _convert_closure17.$getCallSiteArray();
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", key, "value", value});
            }

            @Generated
            public Object call(Object key, Object value) {
                CallSite[] callSiteArray = _convert_closure17.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, key, value);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _convert_closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "doCall";
                return new CallSiteArray(_convert_closure17.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _convert_closure17.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (OrchestrationViewModel)ScriptBytecodeAdapter.castToType((Object)callSiteArray[252].callConstructor(OrchestrationViewModel.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", callSiteArray[253].callGetProperty((Object)orchestration), "name", callSiteArray[254].callGetProperty((Object)orchestration), "application", callSiteArray[255].callGetProperty((Object)orchestration), "status", callSiteArray[256].call((Object)orchestration), "variables", callSiteArray[257].call((Object)variables, (Object)new _convert_closure17(this, this)), "steps", callSiteArray[258].call(callSiteArray[259].callGetProperty(callSiteArray[260].callGetProperty((Object)orchestration))), "buildTime", callSiteArray[261].callGetProperty((Object)orchestration), "startTime", callSiteArray[262].callGetProperty((Object)orchestration), "endTime", callSiteArray[263].callGetProperty((Object)orchestration), "execution", orchestration})), OrchestrationViewModel.class);
    }

    @PostAuthorize(value="hasPermission(returnObject.application, 'APPLICATION', 'READ')")
    private List<String> getPipelineConfigIdsOfReadableApplications() {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        List applicationNames = (List)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.getPropertySpreadSafe(TaskController.class, (Object)callSiteArray[264].call((Object)this.front50Service), (String)"name"), List.class);
        public final class _getPipelineConfigIdsOfReadableApplications_closure18
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getPipelineConfigIdsOfReadableApplications_closure18(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _getPipelineConfigIdsOfReadableApplications_closure18.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object applicationName) {
                CallSite[] callSiteArray = _getPipelineConfigIdsOfReadableApplications_closure18.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.getPropertySpreadSafe(_getPipelineConfigIdsOfReadableApplications_closure18.class, (Object)callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), applicationName, (Object)false), (String)"id"), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getPipelineConfigIdsOfReadableApplications_closure18.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getPipelines";
                stringArray[1] = "front50Service";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _getPipelineConfigIdsOfReadableApplications_closure18.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getPipelineConfigIdsOfReadableApplications_closure18.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getPipelineConfigIdsOfReadableApplications_closure18.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _getPipelineConfigIdsOfReadableApplications_closure19
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getPipelineConfigIdsOfReadableApplications_closure19(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _getPipelineConfigIdsOfReadableApplications_closure19.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object c) {
                CallSite[] callSiteArray = _getPipelineConfigIdsOfReadableApplications_closure19.$getCallSiteArray();
                return callSiteArray[0].call(c);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getPipelineConfigIdsOfReadableApplications_closure19.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "stream";
                return new CallSiteArray(_getPipelineConfigIdsOfReadableApplications_closure19.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getPipelineConfigIdsOfReadableApplications_closure19.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        List pipelineConfigIds = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[265].call(callSiteArray[266].call(callSiteArray[267].call(callSiteArray[268].call((Object)applicationNames), (Object)new _getPipelineConfigIdsOfReadableApplications_closure18(this, this)), (Object)new _getPipelineConfigIdsOfReadableApplications_closure19(this, this)), callSiteArray[269].call(Collectors.class)), List.class);
        return pipelineConfigIds;
    }

    private static boolean isNullOrEmpty(Object value) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)value, null)) {
            return true;
        }
        if (value instanceof Collection) {
            return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[270].call(value));
        }
        if (value instanceof String) {
            return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[271].call(value), (Object)0);
        }
        return ScriptBytecodeAdapter.compareEqual((Object)value, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @VisibleForTesting
    private static boolean checkObjectMatchesSubset(Object object, Object subset) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[272].call(String.class, object)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[273].call(String.class, subset))) {
                return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[274].callStatic(TaskController.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)ShortTypeHandling.castToString((Object)object), String.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)ShortTypeHandling.castToString((Object)subset), String.class)));
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[275].call(Map.class, object)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[276].call(Map.class, subset))) {
                return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[277].callStatic(TaskController.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class)), Map.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Map)ScriptBytecodeAdapter.castToType((Object)subset, Map.class)), Map.class)));
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[278].call(Collection.class, object)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[279].call(Collection.class, subset))) {
                return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[280].callStatic(TaskController.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Collection)ScriptBytecodeAdapter.castToType((Object)object, Collection.class)), Collection.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Collection)ScriptBytecodeAdapter.castToType((Object)subset, Collection.class)), Collection.class)));
            }
            return ScriptBytecodeAdapter.compareEqual((Object)object, (Object)subset);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[281].call(String.class, object)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[282].call(String.class, subset))) {
            return TaskController.checkStringMatchesSubset(ShortTypeHandling.castToString((Object)object), ShortTypeHandling.castToString((Object)subset));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[283].call(Map.class, object)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[284].call(Map.class, subset))) {
            return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[285].callStatic(TaskController.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class)), Map.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Map)ScriptBytecodeAdapter.castToType((Object)subset, Map.class)), Map.class)));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[286].call(Collection.class, object)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[287].call(Collection.class, subset))) {
            return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[288].callStatic(TaskController.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Collection)ScriptBytecodeAdapter.castToType((Object)object, Collection.class)), Collection.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Collection)ScriptBytecodeAdapter.castToType((Object)subset, Collection.class)), Collection.class)));
        }
        return ScriptBytecodeAdapter.compareEqual((Object)object, (Object)subset);
    }

    private static boolean checkStringMatchesSubset(String string, String subset) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[289].call((Object)string, (Object)subset)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[290].call((Object)string, (Object)subset));
    }

    private static boolean checkMapMatchesSubset(Map map, Map subset) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        Object key = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[291].call(callSiteArray[292].call((Object)subset)), Iterator.class);
        while (iterator.hasNext()) {
            key = iterator.next();
            if (!(!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[293].callStatic(TaskController.class, callSiteArray[294].call((Object)map, key), callSiteArray[295].call((Object)subset, key))))) continue;
            return false;
        }
        return true;
    }

    private static boolean checkCollectionMatchesSubset(Collection collection, Collection subset) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[296].call((Object)subset), (Object)callSiteArray[297].call((Object)collection))) {
            return false;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[298].call((Object)subset))) {
            return true;
        }
        PermutationGenerator subsetPermutations = (PermutationGenerator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[299].callConstructor(PermutationGenerator.class, (Object)subset), PermutationGenerator.class);
        List subsetPermutation = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[300].call((Object)subsetPermutations), Iterator.class);
        while (iterator.hasNext()) {
            subsetPermutation = (List)ScriptBytecodeAdapter.castToType(iterator.next(), List.class);
            List collectionCopy = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[301].callConstructor(ArrayList.class, (Object)collection), List.class);
            boolean matchedAllItems = true;
            Object subsetItem = null;
            Iterator iterator2 = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[302].call((Object)subsetPermutation), Iterator.class);
            while (iterator2.hasNext()) {
                boolean bl;
                subsetItem = iterator2.next();
                boolean matchedItem = false;
                int i = 0;
                while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)callSiteArray[303].call((Object)collectionCopy))) {
                    Object collectionItem = callSiteArray[304].call((Object)collectionCopy, (Object)i);
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[305].callStatic(TaskController.class, collectionItem, subsetItem))) {
                        boolean bl2;
                        callSiteArray[306].call((Object)collectionCopy, (Object)i);
                        matchedItem = bl2 = true;
                        break;
                    }
                    int n = i;
                    i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[307].call((Object)n));
                }
                if (!(!matchedItem)) continue;
                matchedAllItems = bl = false;
                break;
            }
            if (!matchedAllItems) continue;
            return true;
        }
        return false;
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(TaskController.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, TaskController.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = TaskController.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(TaskController.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != TaskController.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        public final class __clinit__closure20
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public __clinit__closure20(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = __clinit__closure20.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object a, Object b) {
                CallSite[] callSiteArray = __clinit__closure20.$getCallSiteArray();
                Object object = callSiteArray[0].callGetProperty(a);
                Object aStartTime = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : Integer.valueOf(0);
                Object object2 = callSiteArray[1].callGetProperty(b);
                Object bStartTime = DefaultTypeTransformation.booleanUnbox((Object)object2) ? object2 : Integer.valueOf(0);
                Integer n = ScriptBytecodeAdapter.compareTo((Object)aStartTime, (Object)bStartTime);
                return DefaultTypeTransformation.booleanUnbox((Object)n) ? n : ScriptBytecodeAdapter.compareTo((Object)callSiteArray[2].callGetProperty(b), (Object)callSiteArray[3].callGetProperty(a));
            }

            @Generated
            public Object call(Object a, Object b) {
                CallSite[] callSiteArray = __clinit__closure20.$getCallSiteArray();
                return callSiteArray[4].callCurrent((GroovyObject)this, a, b);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure20.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "startTime";
                stringArray[1] = "startTime";
                stringArray[2] = "id";
                stringArray[3] = "id";
                stringArray[4] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                __clinit__closure20.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(__clinit__closure20.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = __clinit__closure20.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        __clinit__closure20 __clinit__closure202 = new __clinit__closure20(TaskController.class, TaskController.class);
        startTimeOrId = __clinit__closure202;
        Object object = TaskController.$getCallSiteArray()[308].call(LoggerFactory.class, (Object)"com.netflix.spinnaker.orca.controllers.TaskController");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    @Generated
    public Front50Service getFront50Service() {
        return this.front50Service;
    }

    @Generated
    public void setFront50Service(Front50Service front50Service) {
        this.front50Service = front50Service;
    }

    @Generated
    public ExecutionRepository getExecutionRepository() {
        return this.executionRepository;
    }

    @Generated
    public void setExecutionRepository(ExecutionRepository executionRepository) {
        this.executionRepository = executionRepository;
    }

    @Generated
    public ExecutionRunner getExecutionRunner() {
        return this.executionRunner;
    }

    @Generated
    public void setExecutionRunner(ExecutionRunner executionRunner) {
        this.executionRunner = executionRunner;
    }

    @Generated
    public CompoundExecutionOperator getExecutionOperator() {
        return this.executionOperator;
    }

    @Generated
    public void setExecutionOperator(CompoundExecutionOperator compoundExecutionOperator) {
        this.executionOperator = compoundExecutionOperator;
    }

    @Generated
    public Collection<StageDefinitionBuilder> getStageBuilders() {
        return this.stageBuilders;
    }

    @Generated
    public void setStageBuilders(Collection<StageDefinitionBuilder> collection) {
        this.stageBuilders = collection;
    }

    @Generated
    public ContextParameterProcessor getContextParameterProcessor() {
        return this.contextParameterProcessor;
    }

    @Generated
    public void setContextParameterProcessor(ContextParameterProcessor contextParameterProcessor) {
        this.contextParameterProcessor = contextParameterProcessor;
    }

    @Generated
    public ExpressionUtils getExpressionUtils() {
        return this.expressionUtils;
    }

    @Generated
    public void setExpressionUtils(ExpressionUtils expressionUtils) {
        this.expressionUtils = expressionUtils;
    }

    @Generated
    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @Generated
    public void setMapper(ObjectMapper objectMapper) {
        this.mapper = objectMapper;
    }

    @Generated
    public Registry getRegistry() {
        return this.registry;
    }

    @Generated
    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    @Generated
    public StageDefinitionBuilderFactory getStageDefinitionBuilderFactory() {
        return this.stageDefinitionBuilderFactory;
    }

    @Generated
    public void setStageDefinitionBuilderFactory(StageDefinitionBuilderFactory stageDefinitionBuilderFactory) {
        this.stageDefinitionBuilderFactory = stageDefinitionBuilderFactory;
    }

    @Generated
    public int getDaysOfExecutionHistory() {
        return this.daysOfExecutionHistory;
    }

    @Generated
    public void setDaysOfExecutionHistory(int n) {
        this.daysOfExecutionHistory = n;
    }

    @Generated
    public int getNumberOfOldPipelineExecutionsToInclude() {
        return this.numberOfOldPipelineExecutionsToInclude;
    }

    @Generated
    public void setNumberOfOldPipelineExecutionsToInclude(int n) {
        this.numberOfOldPipelineExecutionsToInclude = n;
    }

    @Generated
    public Clock getClock() {
        return this.clock;
    }

    @Generated
    public void setClock(Clock clock) {
        this.clock = clock;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "systemUTC";
        stringArray[1] = "join";
        stringArray[2] = "values";
        stringArray[3] = "setStartTimeCutoff";
        stringArray[4] = "setStatuses";
        stringArray[5] = "setPageSize";
        stringArray[6] = "setPage";
        stringArray[7] = "<$constructor$>";
        stringArray[8] = "split";
        stringArray[9] = "toInstant";
        stringArray[10] = "minusDays";
        stringArray[11] = "atZone";
        stringArray[12] = "instant";
        stringArray[13] = "UTC";
        stringArray[14] = "collect";
        stringArray[15] = "retrieveOrchestrationsForApplication";
        stringArray[16] = "START_TIME_OR_ID";
        stringArray[17] = "collect";
        stringArray[18] = "iterator";
        stringArray[19] = "toBlocking";
        stringArray[20] = "retrieve";
        stringArray[21] = "ORCHESTRATION";
        stringArray[22] = "convert";
        stringArray[23] = "retrieve";
        stringArray[24] = "ORCHESTRATION";
        stringArray[25] = "retrieve";
        stringArray[26] = "ORCHESTRATION";
        stringArray[27] = "with";
        stringArray[28] = "retrieve";
        stringArray[29] = "ORCHESTRATION";
        stringArray[30] = "cancel";
        stringArray[31] = "ORCHESTRATION";
        stringArray[32] = "each";
        stringArray[33] = "join";
        stringArray[34] = "values";
        stringArray[35] = "<$constructor$>";
        stringArray[36] = "split";
        stringArray[37] = "<$constructor$>";
        stringArray[38] = "split";
        stringArray[39] = "findAll";
        stringArray[40] = "single";
        stringArray[41] = "toBlocking";
        stringArray[42] = "toList";
        stringArray[43] = "subscribeOn";
        stringArray[44] = "from";
        stringArray[45] = "collect";
        stringArray[46] = "io";
        stringArray[47] = "unexpandPipelineExecutions";
        stringArray[48] = "split";
        stringArray[49] = "sort";
        stringArray[50] = "single";
        stringArray[51] = "toBlocking";
        stringArray[52] = "toList";
        stringArray[53] = "subscribeOn";
        stringArray[54] = "merge";
        stringArray[55] = "collect";
        stringArray[56] = "io";
        stringArray[57] = "unexpandPipelineExecutions";
        stringArray[58] = "filterPipelinesByHistoryCutoff";
        stringArray[59] = "validateSearchForPipelinesByTriggerParameters";
        stringArray[60] = "BUILD_TIME_DESC";
        stringArray[61] = "BUILD_TIME_ASC";
        stringArray[62] = "decodeTriggerParams";
        stringArray[63] = "split";
        stringArray[64] = "getPipelineConfigIdsOfReadableApplications";
        stringArray[65] = "getPipelines";
        stringArray[66] = "collect";
        stringArray[67] = "filter";
        stringArray[68] = "stream";
        stringArray[69] = "toList";
        stringArray[70] = "getPipelines";
        stringArray[71] = "collect";
        stringArray[72] = "filter";
        stringArray[73] = "stream";
        stringArray[74] = "toList";
        stringArray[75] = "setPageSize";
        stringArray[76] = "setSortType";
        stringArray[77] = "<$constructor$>";
        stringArray[78] = "multiply";
        stringArray[79] = "setPageSize";
        stringArray[80] = "setSortType";
        stringArray[81] = "<$constructor$>";
        stringArray[82] = "setStatuses";
        stringArray[83] = "toList";
        stringArray[84] = "split";
        stringArray[85] = "setStatuses";
        stringArray[86] = "toList";
        stringArray[87] = "split";
        stringArray[88] = "<$constructor$>";
        stringArray[89] = "size";
        stringArray[90] = "retrievePipelinesForPipelineConfigIdsBetweenBuildTimeBoundary";
        stringArray[91] = "setPage";
        stringArray[92] = "addAll";
        stringArray[93] = "collect";
        stringArray[94] = "filter";
        stringArray[95] = "stream";
        stringArray[96] = "toList";
        stringArray[97] = "size";
        stringArray[98] = "pageSize";
        stringArray[99] = "next";
        stringArray[100] = "size";
        stringArray[101] = "subList";
        stringArray[102] = "min";
        stringArray[103] = "size";
        stringArray[104] = "plus";
        stringArray[105] = "size";
        stringArray[106] = "subList";
        stringArray[107] = "min";
        stringArray[108] = "size";
        stringArray[109] = "unexpandPipelineExecutions";
        stringArray[110] = "convertValue";
        stringArray[111] = "millis";
        stringArray[112] = "checkObjectMatchesSubset";
        stringArray[113] = "minus";
        stringArray[114] = "millis";
        stringArray[115] = "record";
        stringArray[116] = "timer";
        stringArray[117] = "MILLISECONDS";
        stringArray[118] = "retrieve";
        stringArray[119] = "PIPELINE";
        stringArray[120] = "with";
        stringArray[121] = "retrieve";
        stringArray[122] = "PIPELINE";
        stringArray[123] = "cancel";
        stringArray[124] = "PIPELINE";
        stringArray[125] = "orElse";
        stringArray[126] = "getSpinnakerUser";
        stringArray[127] = "pause";
        stringArray[128] = "PIPELINE";
        stringArray[129] = "orElse";
        stringArray[130] = "getSpinnakerUser";
        stringArray[131] = "resume";
        stringArray[132] = "PIPELINE";
        stringArray[133] = "orElse";
        stringArray[134] = "getSpinnakerUser";
        stringArray[135] = "updateStage";
        stringArray[136] = "PIPELINE";
        stringArray[137] = "manualSkip";
        stringArray[138] = "context";
        stringArray[139] = "canManuallySkip";
        stringArray[140] = "builderFor";
        stringArray[141] = "<$constructor$>";
        stringArray[142] = "restartStage";
        stringArray[143] = "retrieve";
        stringArray[144] = "PIPELINE";
        stringArray[145] = "convertValue";
        stringArray[146] = "trigger";
        stringArray[147] = "process";
        stringArray[148] = "expression";
        stringArray[149] = "expressionEvaluationSummary";
        stringArray[150] = "retrieve";
        stringArray[151] = "PIPELINE";
        stringArray[152] = "find";
        stringArray[153] = "stages";
        stringArray[154] = "<$constructor$>";
        stringArray[155] = "process";
        stringArray[156] = "buildExecutionContext";
        stringArray[157] = "expression";
        stringArray[158] = "expressionEvaluationSummary";
        stringArray[159] = "retrieve";
        stringArray[160] = "PIPELINE";
        stringArray[161] = "evaluateVariables";
        stringArray[162] = "findAll";
        stringArray[163] = "split";
        stringArray[164] = "context";
        stringArray[165] = "put";
        stringArray[166] = "trigger";
        stringArray[167] = "execution";
        stringArray[168] = "put";
        stringArray[169] = "execution";
        stringArray[170] = "getPipelinesForApplication";
        stringArray[171] = "<$constructor$>";
        stringArray[172] = "join";
        stringArray[173] = "values";
        stringArray[174] = "<$constructor$>";
        stringArray[175] = "split";
        stringArray[176] = "getPipelines";
        stringArray[177] = "getStrategies";
        stringArray[178] = "plus";
        stringArray[179] = "sort";
        stringArray[180] = "single";
        stringArray[181] = "toBlocking";
        stringArray[182] = "toList";
        stringArray[183] = "subscribeOn";
        stringArray[184] = "merge";
        stringArray[185] = "collect";
        stringArray[186] = "io";
        stringArray[187] = "unexpandPipelineExecutions";
        stringArray[188] = "filterPipelinesByHistoryCutoff";
        stringArray[189] = "<$constructor$>";
        stringArray[190] = "format";
        stringArray[191] = "<$constructor$>";
        stringArray[192] = "format";
        stringArray[193] = "<$constructor$>";
        stringArray[194] = "format";
        stringArray[195] = "<$constructor$>";
        stringArray[196] = "format";
        stringArray[197] = "<$constructor$>";
        stringArray[198] = "format";
        stringArray[199] = "<$constructor$>";
        stringArray[200] = "format";
        stringArray[201] = "<$constructor$>";
        stringArray[202] = "format";
        stringArray[203] = "<$constructor$>";
        stringArray[204] = "format";
        stringArray[205] = "<$constructor$>";
        stringArray[206] = "format";
        stringArray[207] = "<$constructor$>";
        stringArray[208] = "format";
        stringArray[209] = "decode";
        stringArray[210] = "getDecoder";
        stringArray[211] = "<$constructor$>";
        stringArray[212] = "forName";
        stringArray[213] = "readValue";
        stringArray[214] = "<$constructor$>";
        stringArray[215] = "<$constructor$>";
        stringArray[216] = "unmodifiableMap";
        stringArray[217] = "toLowerCase";
        stringArray[218] = "type";
        stringArray[219] = "clear";
        stringArray[220] = "stages";
        stringArray[221] = "parentExecution";
        stringArray[222] = "toLowerCase";
        stringArray[223] = "type";
        stringArray[224] = "trigger";
        stringArray[225] = "parentExecution";
        stringArray[226] = "clearTriggerStages";
        stringArray[227] = "trigger";
        stringArray[228] = "parentExecution";
        stringArray[229] = "toEpochMilli";
        stringArray[230] = "minus";
        stringArray[231] = "instant";
        stringArray[232] = "DAYS";
        stringArray[233] = "each";
        stringArray[234] = "values";
        stringArray[235] = "groupBy";
        stringArray[236] = "sort";
        stringArray[237] = "each";
        stringArray[238] = "isNullOrEmpty";
        stringArray[239] = "getAt";
        stringArray[240] = "key";
        stringArray[241] = "isNullOrEmpty";
        stringArray[242] = "value";
        stringArray[243] = "iterator";
        stringArray[244] = "stages";
        stringArray[245] = "iterator";
        stringArray[246] = "entrySet";
        stringArray[247] = "context";
        stringArray[248] = "shouldReplace";
        stringArray[249] = "value";
        stringArray[250] = "putAt";
        stringArray[251] = "key";
        stringArray[252] = "<$constructor$>";
        stringArray[253] = "id";
        stringArray[254] = "description";
        stringArray[255] = "application";
        stringArray[256] = "getStatus";
        stringArray[257] = "collect";
        stringArray[258] = "flatten";
        stringArray[259] = "tasks";
        stringArray[260] = "stages";
        stringArray[261] = "buildTime";
        stringArray[262] = "startTime";
        stringArray[263] = "endTime";
        stringArray[264] = "getAllApplications";
        stringArray[265] = "collect";
        stringArray[266] = "flatMap";
        stringArray[267] = "map";
        stringArray[268] = "stream";
        stringArray[269] = "toList";
        stringArray[270] = "isEmpty";
        stringArray[271] = "length";
        stringArray[272] = "isInstance";
        stringArray[273] = "isInstance";
        stringArray[274] = "checkStringMatchesSubset";
        stringArray[275] = "isInstance";
        stringArray[276] = "isInstance";
        stringArray[277] = "checkMapMatchesSubset";
        stringArray[278] = "isInstance";
        stringArray[279] = "isInstance";
        stringArray[280] = "checkCollectionMatchesSubset";
        stringArray[281] = "isInstance";
        stringArray[282] = "isInstance";
        stringArray[283] = "isInstance";
        stringArray[284] = "isInstance";
        stringArray[285] = "checkMapMatchesSubset";
        stringArray[286] = "isInstance";
        stringArray[287] = "isInstance";
        stringArray[288] = "checkCollectionMatchesSubset";
        stringArray[289] = "equalsIgnoreCase";
        stringArray[290] = "matches";
        stringArray[291] = "iterator";
        stringArray[292] = "keySet";
        stringArray[293] = "checkObjectMatchesSubset";
        stringArray[294] = "get";
        stringArray[295] = "get";
        stringArray[296] = "size";
        stringArray[297] = "size";
        stringArray[298] = "isEmpty";
        stringArray[299] = "<$constructor$>";
        stringArray[300] = "iterator";
        stringArray[301] = "<$constructor$>";
        stringArray[302] = "iterator";
        stringArray[303] = "size";
        stringArray[304] = "get";
        stringArray[305] = "checkObjectMatchesSubset";
        stringArray[306] = "remove";
        stringArray[307] = "next";
        stringArray[308] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[309];
        TaskController.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(TaskController.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = TaskController.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    @ResponseStatus(value=HttpStatus.NOT_IMPLEMENTED)
    static class FeatureNotEnabledException
    extends RuntimeException
    implements GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public FeatureNotEnabledException() {
            MetaClass metaClass;
            CallSite[] callSiteArray = FeatureNotEnabledException.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Generated
        public FeatureNotEnabledException(String param0) {
            MetaClass metaClass;
            CallSite[] callSiteArray = FeatureNotEnabledException.$getCallSiteArray();
            Object[] objectArray = new Object[]{ScriptBytecodeAdapter.createPojoWrapper((Object)param0, String.class)};
            FeatureNotEnabledException featureNotEnabledException = this;
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, RuntimeException.class)) {
                case -2020310112: {
                    Object[] objectArray2 = objectArray;
                    super((Throwable)ScriptBytecodeAdapter.castToType((Object)objectArray[0], Throwable.class));
                    break;
                }
                case -1428966913: {
                    Object[] objectArray2 = objectArray;
                    super(ShortTypeHandling.castToString((Object)objectArray[0]));
                    break;
                }
                case -947674026: {
                    Object[] objectArray2 = objectArray;
                    super(ShortTypeHandling.castToString((Object)objectArray[0]), (Throwable)ScriptBytecodeAdapter.castToType((Object)objectArray[1], Throwable.class), DefaultTypeTransformation.booleanUnbox((Object)objectArray[2]), DefaultTypeTransformation.booleanUnbox((Object)objectArray[3]));
                    break;
                }
                case -255735978: {
                    Object[] objectArray2 = objectArray;
                    super(ShortTypeHandling.castToString((Object)objectArray[0]), (Throwable)ScriptBytecodeAdapter.castToType((Object)objectArray[1], Throwable.class));
                    break;
                }
                case 39797: {
                    Object[] objectArray2 = objectArray;
                    super();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Generated
        public FeatureNotEnabledException(String param0, Throwable param1) {
            MetaClass metaClass;
            CallSite[] callSiteArray = FeatureNotEnabledException.$getCallSiteArray();
            super(param0, param1);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Generated
        public FeatureNotEnabledException(Throwable param0) {
            MetaClass metaClass;
            CallSite[] callSiteArray = FeatureNotEnabledException.$getCallSiteArray();
            Object[] objectArray = new Object[]{ScriptBytecodeAdapter.createPojoWrapper((Object)param0, Throwable.class)};
            FeatureNotEnabledException featureNotEnabledException = this;
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, RuntimeException.class)) {
                case -2020310112: {
                    Object[] objectArray2 = objectArray;
                    super((Throwable)ScriptBytecodeAdapter.castToType((Object)objectArray[0], Throwable.class));
                    break;
                }
                case -1428966913: {
                    Object[] objectArray2 = objectArray;
                    super(ShortTypeHandling.castToString((Object)objectArray[0]));
                    break;
                }
                case -947674026: {
                    Object[] objectArray2 = objectArray;
                    super(ShortTypeHandling.castToString((Object)objectArray[0]), (Throwable)ScriptBytecodeAdapter.castToType((Object)objectArray[1], Throwable.class), DefaultTypeTransformation.booleanUnbox((Object)objectArray[2]), DefaultTypeTransformation.booleanUnbox((Object)objectArray[3]));
                    break;
                }
                case -255735978: {
                    Object[] objectArray2 = objectArray;
                    super(ShortTypeHandling.castToString((Object)objectArray[0]), (Throwable)ScriptBytecodeAdapter.castToType((Object)objectArray[1], Throwable.class));
                    break;
                }
                case 39797: {
                    Object[] objectArray2 = objectArray;
                    super();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Generated
        protected FeatureNotEnabledException(String param0, Throwable param1, boolean param2, boolean param3) {
            MetaClass metaClass;
            CallSite[] callSiteArray = FeatureNotEnabledException.$getCallSiteArray();
            super(param0, param1, param2, param3);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = FeatureNotEnabledException.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(FeatureNotEnabledException.class, TaskController.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = FeatureNotEnabledException.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(FeatureNotEnabledException.class, TaskController.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = FeatureNotEnabledException.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, TaskController.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = FeatureNotEnabledException.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, TaskController.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = FeatureNotEnabledException.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(FeatureNotEnabledException.class, TaskController.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = FeatureNotEnabledException.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(FeatureNotEnabledException.class, TaskController.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != FeatureNotEnabledException.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(FeatureNotEnabledException.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = FeatureNotEnabledException.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    @ResponseStatus(value=HttpStatus.CONFLICT)
    static class CannotDeleteRunningExecution
    extends RuntimeException
    implements GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        public CannotDeleteRunningExecution(ExecutionType type, String id) {
            MetaClass metaClass;
            CallSite[] callSiteArray = CannotDeleteRunningExecution.$getCallSiteArray();
            Object[] objectArray = new Object[]{new GStringImpl(new Object[]{type}, new String[]{"Cannot delete a running ", ", please cancel it first."})};
            CannotDeleteRunningExecution cannotDeleteRunningExecution = this;
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, RuntimeException.class)) {
                case -2020310112: {
                    Object[] objectArray2 = objectArray;
                    super((Throwable)ScriptBytecodeAdapter.castToType((Object)objectArray[0], Throwable.class));
                    break;
                }
                case -1428966913: {
                    Object[] objectArray2 = objectArray;
                    super(ShortTypeHandling.castToString((Object)objectArray[0]));
                    break;
                }
                case -947674026: {
                    Object[] objectArray2 = objectArray;
                    super(ShortTypeHandling.castToString((Object)objectArray[0]), (Throwable)ScriptBytecodeAdapter.castToType((Object)objectArray[1], Throwable.class), DefaultTypeTransformation.booleanUnbox((Object)objectArray[2]), DefaultTypeTransformation.booleanUnbox((Object)objectArray[3]));
                    break;
                }
                case -255735978: {
                    Object[] objectArray2 = objectArray;
                    super(ShortTypeHandling.castToString((Object)objectArray[0]), (Throwable)ScriptBytecodeAdapter.castToType((Object)objectArray[1], Throwable.class));
                    break;
                }
                case 39797: {
                    Object[] objectArray2 = objectArray;
                    super();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = CannotDeleteRunningExecution.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(CannotDeleteRunningExecution.class, TaskController.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = CannotDeleteRunningExecution.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(CannotDeleteRunningExecution.class, TaskController.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = CannotDeleteRunningExecution.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, TaskController.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = CannotDeleteRunningExecution.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, TaskController.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = CannotDeleteRunningExecution.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(CannotDeleteRunningExecution.class, TaskController.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = CannotDeleteRunningExecution.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(CannotDeleteRunningExecution.class, TaskController.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != CannotDeleteRunningExecution.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(CannotDeleteRunningExecution.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = CannotDeleteRunningExecution.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    @ResponseStatus(value=HttpStatus.METHOD_NOT_ALLOWED)
    static class CannotUpdateExecutionStage
    extends RuntimeException
    implements GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public CannotUpdateExecutionStage() {
            MetaClass metaClass;
            CallSite[] callSiteArray = CannotUpdateExecutionStage.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Generated
        public CannotUpdateExecutionStage(String param0) {
            MetaClass metaClass;
            CallSite[] callSiteArray = CannotUpdateExecutionStage.$getCallSiteArray();
            Object[] objectArray = new Object[]{ScriptBytecodeAdapter.createPojoWrapper((Object)param0, String.class)};
            CannotUpdateExecutionStage cannotUpdateExecutionStage = this;
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, RuntimeException.class)) {
                case -2020310112: {
                    Object[] objectArray2 = objectArray;
                    super((Throwable)ScriptBytecodeAdapter.castToType((Object)objectArray[0], Throwable.class));
                    break;
                }
                case -1428966913: {
                    Object[] objectArray2 = objectArray;
                    super(ShortTypeHandling.castToString((Object)objectArray[0]));
                    break;
                }
                case -947674026: {
                    Object[] objectArray2 = objectArray;
                    super(ShortTypeHandling.castToString((Object)objectArray[0]), (Throwable)ScriptBytecodeAdapter.castToType((Object)objectArray[1], Throwable.class), DefaultTypeTransformation.booleanUnbox((Object)objectArray[2]), DefaultTypeTransformation.booleanUnbox((Object)objectArray[3]));
                    break;
                }
                case -255735978: {
                    Object[] objectArray2 = objectArray;
                    super(ShortTypeHandling.castToString((Object)objectArray[0]), (Throwable)ScriptBytecodeAdapter.castToType((Object)objectArray[1], Throwable.class));
                    break;
                }
                case 39797: {
                    Object[] objectArray2 = objectArray;
                    super();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Generated
        public CannotUpdateExecutionStage(String param0, Throwable param1) {
            MetaClass metaClass;
            CallSite[] callSiteArray = CannotUpdateExecutionStage.$getCallSiteArray();
            super(param0, param1);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Generated
        public CannotUpdateExecutionStage(Throwable param0) {
            MetaClass metaClass;
            CallSite[] callSiteArray = CannotUpdateExecutionStage.$getCallSiteArray();
            Object[] objectArray = new Object[]{ScriptBytecodeAdapter.createPojoWrapper((Object)param0, Throwable.class)};
            CannotUpdateExecutionStage cannotUpdateExecutionStage = this;
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, RuntimeException.class)) {
                case -2020310112: {
                    Object[] objectArray2 = objectArray;
                    super((Throwable)ScriptBytecodeAdapter.castToType((Object)objectArray[0], Throwable.class));
                    break;
                }
                case -1428966913: {
                    Object[] objectArray2 = objectArray;
                    super(ShortTypeHandling.castToString((Object)objectArray[0]));
                    break;
                }
                case -947674026: {
                    Object[] objectArray2 = objectArray;
                    super(ShortTypeHandling.castToString((Object)objectArray[0]), (Throwable)ScriptBytecodeAdapter.castToType((Object)objectArray[1], Throwable.class), DefaultTypeTransformation.booleanUnbox((Object)objectArray[2]), DefaultTypeTransformation.booleanUnbox((Object)objectArray[3]));
                    break;
                }
                case -255735978: {
                    Object[] objectArray2 = objectArray;
                    super(ShortTypeHandling.castToString((Object)objectArray[0]), (Throwable)ScriptBytecodeAdapter.castToType((Object)objectArray[1], Throwable.class));
                    break;
                }
                case 39797: {
                    Object[] objectArray2 = objectArray;
                    super();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Generated
        protected CannotUpdateExecutionStage(String param0, Throwable param1, boolean param2, boolean param3) {
            MetaClass metaClass;
            CallSite[] callSiteArray = CannotUpdateExecutionStage.$getCallSiteArray();
            super(param0, param1, param2, param3);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = CannotUpdateExecutionStage.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(CannotUpdateExecutionStage.class, TaskController.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = CannotUpdateExecutionStage.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(CannotUpdateExecutionStage.class, TaskController.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = CannotUpdateExecutionStage.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, TaskController.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = CannotUpdateExecutionStage.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, TaskController.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = CannotUpdateExecutionStage.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(CannotUpdateExecutionStage.class, TaskController.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = CannotUpdateExecutionStage.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(CannotUpdateExecutionStage.class, TaskController.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != CannotUpdateExecutionStage.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(CannotUpdateExecutionStage.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = CannotUpdateExecutionStage.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

