/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.webhook.config;

import com.netflix.spinnaker.fiat.model.resources.Role;
import com.netflix.spinnaker.orca.api.preconfigured.jobs.PreconfiguredStageParameter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.http.HttpMethod;

@ConfigurationProperties(value="webhook")
public class WebhookProperties {
    private static final Logger log = LoggerFactory.getLogger(WebhookProperties.class);
    private static final Set<String> IGNORE_FIELDS = Set.of("props", "enabled", "label", "description", "type", "parameters", "parameterValues", "permissions", "parameterData");
    private static final List<Field> ALL_FIELDS = Arrays.stream(PreconfiguredWebhook.class.getDeclaredFields()).filter(f -> !f.isSynthetic()).filter(f -> !IGNORE_FIELDS.contains(f.getName())).collect(Collectors.toList());
    private List<PreconfiguredWebhook> preconfigured = new ArrayList<PreconfiguredWebhook>();
    private TrustSettings trust;
    private boolean verifyRedirects = true;
    private List<Integer> defaultRetryStatusCodes = List.of(Integer.valueOf(429));

    public List<PreconfiguredWebhook> getPreconfigured() {
        return this.preconfigured;
    }

    public TrustSettings getTrust() {
        return this.trust;
    }

    public boolean isVerifyRedirects() {
        return this.verifyRedirects;
    }

    public List<Integer> getDefaultRetryStatusCodes() {
        return this.defaultRetryStatusCodes;
    }

    public void setPreconfigured(List<PreconfiguredWebhook> preconfigured) {
        this.preconfigured = preconfigured;
    }

    public void setTrust(TrustSettings trust) {
        this.trust = trust;
    }

    public void setVerifyRedirects(boolean verifyRedirects) {
        this.verifyRedirects = verifyRedirects;
    }

    public void setDefaultRetryStatusCodes(List<Integer> defaultRetryStatusCodes) {
        this.defaultRetryStatusCodes = defaultRetryStatusCodes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebhookProperties)) {
            return false;
        }
        WebhookProperties other = (WebhookProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isVerifyRedirects() != other.isVerifyRedirects()) {
            return false;
        }
        List<PreconfiguredWebhook> this$preconfigured = this.getPreconfigured();
        List<PreconfiguredWebhook> other$preconfigured = other.getPreconfigured();
        if (this$preconfigured == null ? other$preconfigured != null : !((Object)this$preconfigured).equals(other$preconfigured)) {
            return false;
        }
        TrustSettings this$trust = this.getTrust();
        TrustSettings other$trust = other.getTrust();
        if (this$trust == null ? other$trust != null : !((Object)this$trust).equals(other$trust)) {
            return false;
        }
        List<Integer> this$defaultRetryStatusCodes = this.getDefaultRetryStatusCodes();
        List<Integer> other$defaultRetryStatusCodes = other.getDefaultRetryStatusCodes();
        return !(this$defaultRetryStatusCodes == null ? other$defaultRetryStatusCodes != null : !((Object)this$defaultRetryStatusCodes).equals(other$defaultRetryStatusCodes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebhookProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isVerifyRedirects() ? 79 : 97);
        List<PreconfiguredWebhook> $preconfigured = this.getPreconfigured();
        result = result * 59 + ($preconfigured == null ? 43 : ((Object)$preconfigured).hashCode());
        TrustSettings $trust = this.getTrust();
        result = result * 59 + ($trust == null ? 43 : ((Object)$trust).hashCode());
        List<Integer> $defaultRetryStatusCodes = this.getDefaultRetryStatusCodes();
        result = result * 59 + ($defaultRetryStatusCodes == null ? 43 : ((Object)$defaultRetryStatusCodes).hashCode());
        return result;
    }

    public String toString() {
        return "WebhookProperties(preconfigured=" + this.getPreconfigured() + ", trust=" + this.getTrust() + ", verifyRedirects=" + this.isVerifyRedirects() + ", defaultRetryStatusCodes=" + this.getDefaultRetryStatusCodes() + ")";
    }

    public static enum StatusUrlResolution {
        getMethod,
        locationHeader,
        webhookResponse;

    }

    public static class PreconfiguredWebhook {
        public boolean enabled = true;
        public String label;
        public String description;
        public String type;
        public List<PreconfiguredStageParameter> parameters;
        public String url;
        public Map<String, List<String>> customHeaders;
        public Map<String, String> parameterValues;
        public Map<String, Map<String, String>> parameterData;
        public HttpMethod method;
        public String payload;
        public List<Integer> failFastStatusCodes;
        public Boolean waitForCompletion;
        public StatusUrlResolution statusUrlResolution;
        public String statusUrlJsonPath;
        public String statusJsonPath;
        public String progressJsonPath;
        public String successStatuses;
        public String canceledStatuses;
        public String terminalStatuses;
        public Map<String, List<String>> permissions;
        public Boolean signalCancellation;
        public String cancelEndpoint;
        public HttpMethod cancelMethod;
        public String cancelPayload;

        public List<String> getPreconfiguredProperties() {
            return ALL_FIELDS.stream().filter(f -> {
                try {
                    return f.get(this) != null;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }).map(Field::getName).collect(Collectors.toList());
        }

        public boolean noUserConfigurableFields() {
            if (this.waitForCompletion == null) {
                return false;
            }
            if (this.waitForCompletion.booleanValue()) {
                return this.getPreconfiguredProperties().size() >= ALL_FIELDS.size() - (StatusUrlResolution.webhookResponse.equals((Object)this.statusUrlResolution) ? 0 : 1);
            }
            return this.url != null && this.customHeaders != null && this.method != null && this.payload != null;
        }

        public boolean isAllowed(String permission, Set<Role.View> roles) {
            if (this.permissions == null || !this.permissions.containsKey(permission)) {
                return true;
            }
            List<String> permissionList = this.permissions.get(permission);
            if (permissionList == null || permissionList.size() == 0) {
                return true;
            }
            return permissionList.stream().anyMatch(p -> this.anyRoleMatches((String)p, roles));
        }

        private boolean anyRoleMatches(String role, Set<Role.View> roles) {
            return roles.stream().anyMatch(r -> r.getName().contains(role));
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return this.description;
        }

        public String getType() {
            return this.type;
        }

        public List<PreconfiguredStageParameter> getParameters() {
            return this.parameters;
        }

        public String getUrl() {
            return this.url;
        }

        public Map<String, List<String>> getCustomHeaders() {
            return this.customHeaders;
        }

        public Map<String, String> getParameterValues() {
            return this.parameterValues;
        }

        public Map<String, Map<String, String>> getParameterData() {
            return this.parameterData;
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        public String getPayload() {
            return this.payload;
        }

        public List<Integer> getFailFastStatusCodes() {
            return this.failFastStatusCodes;
        }

        public Boolean getWaitForCompletion() {
            return this.waitForCompletion;
        }

        public StatusUrlResolution getStatusUrlResolution() {
            return this.statusUrlResolution;
        }

        public String getStatusUrlJsonPath() {
            return this.statusUrlJsonPath;
        }

        public String getStatusJsonPath() {
            return this.statusJsonPath;
        }

        public String getProgressJsonPath() {
            return this.progressJsonPath;
        }

        public String getSuccessStatuses() {
            return this.successStatuses;
        }

        public String getCanceledStatuses() {
            return this.canceledStatuses;
        }

        public String getTerminalStatuses() {
            return this.terminalStatuses;
        }

        public Map<String, List<String>> getPermissions() {
            return this.permissions;
        }

        public Boolean getSignalCancellation() {
            return this.signalCancellation;
        }

        public String getCancelEndpoint() {
            return this.cancelEndpoint;
        }

        public HttpMethod getCancelMethod() {
            return this.cancelMethod;
        }

        public String getCancelPayload() {
            return this.cancelPayload;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setParameters(List<PreconfiguredStageParameter> parameters) {
            this.parameters = parameters;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setCustomHeaders(Map<String, List<String>> customHeaders) {
            this.customHeaders = customHeaders;
        }

        public void setParameterValues(Map<String, String> parameterValues) {
            this.parameterValues = parameterValues;
        }

        public void setParameterData(Map<String, Map<String, String>> parameterData) {
            this.parameterData = parameterData;
        }

        public void setMethod(HttpMethod method) {
            this.method = method;
        }

        public void setPayload(String payload) {
            this.payload = payload;
        }

        public void setFailFastStatusCodes(List<Integer> failFastStatusCodes) {
            this.failFastStatusCodes = failFastStatusCodes;
        }

        public void setWaitForCompletion(Boolean waitForCompletion) {
            this.waitForCompletion = waitForCompletion;
        }

        public void setStatusUrlResolution(StatusUrlResolution statusUrlResolution) {
            this.statusUrlResolution = statusUrlResolution;
        }

        public void setStatusUrlJsonPath(String statusUrlJsonPath) {
            this.statusUrlJsonPath = statusUrlJsonPath;
        }

        public void setStatusJsonPath(String statusJsonPath) {
            this.statusJsonPath = statusJsonPath;
        }

        public void setProgressJsonPath(String progressJsonPath) {
            this.progressJsonPath = progressJsonPath;
        }

        public void setSuccessStatuses(String successStatuses) {
            this.successStatuses = successStatuses;
        }

        public void setCanceledStatuses(String canceledStatuses) {
            this.canceledStatuses = canceledStatuses;
        }

        public void setTerminalStatuses(String terminalStatuses) {
            this.terminalStatuses = terminalStatuses;
        }

        public void setPermissions(Map<String, List<String>> permissions) {
            this.permissions = permissions;
        }

        public void setSignalCancellation(Boolean signalCancellation) {
            this.signalCancellation = signalCancellation;
        }

        public void setCancelEndpoint(String cancelEndpoint) {
            this.cancelEndpoint = cancelEndpoint;
        }

        public void setCancelMethod(HttpMethod cancelMethod) {
            this.cancelMethod = cancelMethod;
        }

        public void setCancelPayload(String cancelPayload) {
            this.cancelPayload = cancelPayload;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PreconfiguredWebhook)) {
                return false;
            }
            PreconfiguredWebhook other = (PreconfiguredWebhook)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            Boolean this$waitForCompletion = this.getWaitForCompletion();
            Boolean other$waitForCompletion = other.getWaitForCompletion();
            if (this$waitForCompletion == null ? other$waitForCompletion != null : !((Object)this$waitForCompletion).equals(other$waitForCompletion)) {
                return false;
            }
            Boolean this$signalCancellation = this.getSignalCancellation();
            Boolean other$signalCancellation = other.getSignalCancellation();
            if (this$signalCancellation == null ? other$signalCancellation != null : !((Object)this$signalCancellation).equals(other$signalCancellation)) {
                return false;
            }
            String this$label = this.getLabel();
            String other$label = other.getLabel();
            if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            List<PreconfiguredStageParameter> this$parameters = this.getParameters();
            List<PreconfiguredStageParameter> other$parameters = other.getParameters();
            if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            Map<String, List<String>> this$customHeaders = this.getCustomHeaders();
            Map<String, List<String>> other$customHeaders = other.getCustomHeaders();
            if (this$customHeaders == null ? other$customHeaders != null : !((Object)this$customHeaders).equals(other$customHeaders)) {
                return false;
            }
            Map<String, String> this$parameterValues = this.getParameterValues();
            Map<String, String> other$parameterValues = other.getParameterValues();
            if (this$parameterValues == null ? other$parameterValues != null : !((Object)this$parameterValues).equals(other$parameterValues)) {
                return false;
            }
            Map<String, Map<String, String>> this$parameterData = this.getParameterData();
            Map<String, Map<String, String>> other$parameterData = other.getParameterData();
            if (this$parameterData == null ? other$parameterData != null : !((Object)this$parameterData).equals(other$parameterData)) {
                return false;
            }
            HttpMethod this$method = this.getMethod();
            HttpMethod other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$payload = this.getPayload();
            String other$payload = other.getPayload();
            if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
                return false;
            }
            List<Integer> this$failFastStatusCodes = this.getFailFastStatusCodes();
            List<Integer> other$failFastStatusCodes = other.getFailFastStatusCodes();
            if (this$failFastStatusCodes == null ? other$failFastStatusCodes != null : !((Object)this$failFastStatusCodes).equals(other$failFastStatusCodes)) {
                return false;
            }
            StatusUrlResolution this$statusUrlResolution = this.getStatusUrlResolution();
            StatusUrlResolution other$statusUrlResolution = other.getStatusUrlResolution();
            if (this$statusUrlResolution == null ? other$statusUrlResolution != null : !((Object)((Object)this$statusUrlResolution)).equals((Object)other$statusUrlResolution)) {
                return false;
            }
            String this$statusUrlJsonPath = this.getStatusUrlJsonPath();
            String other$statusUrlJsonPath = other.getStatusUrlJsonPath();
            if (this$statusUrlJsonPath == null ? other$statusUrlJsonPath != null : !this$statusUrlJsonPath.equals(other$statusUrlJsonPath)) {
                return false;
            }
            String this$statusJsonPath = this.getStatusJsonPath();
            String other$statusJsonPath = other.getStatusJsonPath();
            if (this$statusJsonPath == null ? other$statusJsonPath != null : !this$statusJsonPath.equals(other$statusJsonPath)) {
                return false;
            }
            String this$progressJsonPath = this.getProgressJsonPath();
            String other$progressJsonPath = other.getProgressJsonPath();
            if (this$progressJsonPath == null ? other$progressJsonPath != null : !this$progressJsonPath.equals(other$progressJsonPath)) {
                return false;
            }
            String this$successStatuses = this.getSuccessStatuses();
            String other$successStatuses = other.getSuccessStatuses();
            if (this$successStatuses == null ? other$successStatuses != null : !this$successStatuses.equals(other$successStatuses)) {
                return false;
            }
            String this$canceledStatuses = this.getCanceledStatuses();
            String other$canceledStatuses = other.getCanceledStatuses();
            if (this$canceledStatuses == null ? other$canceledStatuses != null : !this$canceledStatuses.equals(other$canceledStatuses)) {
                return false;
            }
            String this$terminalStatuses = this.getTerminalStatuses();
            String other$terminalStatuses = other.getTerminalStatuses();
            if (this$terminalStatuses == null ? other$terminalStatuses != null : !this$terminalStatuses.equals(other$terminalStatuses)) {
                return false;
            }
            Map<String, List<String>> this$permissions = this.getPermissions();
            Map<String, List<String>> other$permissions = other.getPermissions();
            if (this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions)) {
                return false;
            }
            String this$cancelEndpoint = this.getCancelEndpoint();
            String other$cancelEndpoint = other.getCancelEndpoint();
            if (this$cancelEndpoint == null ? other$cancelEndpoint != null : !this$cancelEndpoint.equals(other$cancelEndpoint)) {
                return false;
            }
            HttpMethod this$cancelMethod = this.getCancelMethod();
            HttpMethod other$cancelMethod = other.getCancelMethod();
            if (this$cancelMethod == null ? other$cancelMethod != null : !this$cancelMethod.equals(other$cancelMethod)) {
                return false;
            }
            String this$cancelPayload = this.getCancelPayload();
            String other$cancelPayload = other.getCancelPayload();
            return !(this$cancelPayload == null ? other$cancelPayload != null : !this$cancelPayload.equals(other$cancelPayload));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PreconfiguredWebhook;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            Boolean $waitForCompletion = this.getWaitForCompletion();
            result = result * 59 + ($waitForCompletion == null ? 43 : ((Object)$waitForCompletion).hashCode());
            Boolean $signalCancellation = this.getSignalCancellation();
            result = result * 59 + ($signalCancellation == null ? 43 : ((Object)$signalCancellation).hashCode());
            String $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : $label.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            List<PreconfiguredStageParameter> $parameters = this.getParameters();
            result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            Map<String, List<String>> $customHeaders = this.getCustomHeaders();
            result = result * 59 + ($customHeaders == null ? 43 : ((Object)$customHeaders).hashCode());
            Map<String, String> $parameterValues = this.getParameterValues();
            result = result * 59 + ($parameterValues == null ? 43 : ((Object)$parameterValues).hashCode());
            Map<String, Map<String, String>> $parameterData = this.getParameterData();
            result = result * 59 + ($parameterData == null ? 43 : ((Object)$parameterData).hashCode());
            HttpMethod $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $payload = this.getPayload();
            result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
            List<Integer> $failFastStatusCodes = this.getFailFastStatusCodes();
            result = result * 59 + ($failFastStatusCodes == null ? 43 : ((Object)$failFastStatusCodes).hashCode());
            StatusUrlResolution $statusUrlResolution = this.getStatusUrlResolution();
            result = result * 59 + ($statusUrlResolution == null ? 43 : ((Object)((Object)$statusUrlResolution)).hashCode());
            String $statusUrlJsonPath = this.getStatusUrlJsonPath();
            result = result * 59 + ($statusUrlJsonPath == null ? 43 : $statusUrlJsonPath.hashCode());
            String $statusJsonPath = this.getStatusJsonPath();
            result = result * 59 + ($statusJsonPath == null ? 43 : $statusJsonPath.hashCode());
            String $progressJsonPath = this.getProgressJsonPath();
            result = result * 59 + ($progressJsonPath == null ? 43 : $progressJsonPath.hashCode());
            String $successStatuses = this.getSuccessStatuses();
            result = result * 59 + ($successStatuses == null ? 43 : $successStatuses.hashCode());
            String $canceledStatuses = this.getCanceledStatuses();
            result = result * 59 + ($canceledStatuses == null ? 43 : $canceledStatuses.hashCode());
            String $terminalStatuses = this.getTerminalStatuses();
            result = result * 59 + ($terminalStatuses == null ? 43 : $terminalStatuses.hashCode());
            Map<String, List<String>> $permissions = this.getPermissions();
            result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
            String $cancelEndpoint = this.getCancelEndpoint();
            result = result * 59 + ($cancelEndpoint == null ? 43 : $cancelEndpoint.hashCode());
            HttpMethod $cancelMethod = this.getCancelMethod();
            result = result * 59 + ($cancelMethod == null ? 43 : $cancelMethod.hashCode());
            String $cancelPayload = this.getCancelPayload();
            result = result * 59 + ($cancelPayload == null ? 43 : $cancelPayload.hashCode());
            return result;
        }

        public String toString() {
            return "WebhookProperties.PreconfiguredWebhook(enabled=" + this.isEnabled() + ", label=" + this.getLabel() + ", description=" + this.getDescription() + ", type=" + this.getType() + ", parameters=" + this.getParameters() + ", url=" + this.getUrl() + ", customHeaders=" + this.getCustomHeaders() + ", parameterValues=" + this.getParameterValues() + ", parameterData=" + this.getParameterData() + ", method=" + this.getMethod() + ", payload=" + this.getPayload() + ", failFastStatusCodes=" + this.getFailFastStatusCodes() + ", waitForCompletion=" + this.getWaitForCompletion() + ", statusUrlResolution=" + this.getStatusUrlResolution() + ", statusUrlJsonPath=" + this.getStatusUrlJsonPath() + ", statusJsonPath=" + this.getStatusJsonPath() + ", progressJsonPath=" + this.getProgressJsonPath() + ", successStatuses=" + this.getSuccessStatuses() + ", canceledStatuses=" + this.getCanceledStatuses() + ", terminalStatuses=" + this.getTerminalStatuses() + ", permissions=" + this.getPermissions() + ", signalCancellation=" + this.getSignalCancellation() + ", cancelEndpoint=" + this.getCancelEndpoint() + ", cancelMethod=" + this.getCancelMethod() + ", cancelPayload=" + this.getCancelPayload() + ")";
        }
    }

    public static class TrustSettings {
        private boolean enabled;
        private String trustStore;
        private String trustStorePassword;

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getTrustStore() {
            return this.trustStore;
        }

        public String getTrustStorePassword() {
            return this.trustStorePassword;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setTrustStore(String trustStore) {
            this.trustStore = trustStore;
        }

        public void setTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TrustSettings)) {
                return false;
            }
            TrustSettings other = (TrustSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            String this$trustStore = this.getTrustStore();
            String other$trustStore = other.getTrustStore();
            if (this$trustStore == null ? other$trustStore != null : !this$trustStore.equals(other$trustStore)) {
                return false;
            }
            String this$trustStorePassword = this.getTrustStorePassword();
            String other$trustStorePassword = other.getTrustStorePassword();
            return !(this$trustStorePassword == null ? other$trustStorePassword != null : !this$trustStorePassword.equals(other$trustStorePassword));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TrustSettings;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            String $trustStore = this.getTrustStore();
            result = result * 59 + ($trustStore == null ? 43 : $trustStore.hashCode());
            String $trustStorePassword = this.getTrustStorePassword();
            result = result * 59 + ($trustStorePassword == null ? 43 : $trustStorePassword.hashCode());
            return result;
        }

        public String toString() {
            return "WebhookProperties.TrustSettings(enabled=" + this.isEnabled() + ", trustStore=" + this.getTrustStore() + ", trustStorePassword=" + this.getTrustStorePassword() + ")";
        }
    }
}

