/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.webhook.pipeline;

import com.netflix.spinnaker.fiat.model.UserPermission;
import com.netflix.spinnaker.fiat.shared.FiatService;
import com.netflix.spinnaker.kork.exceptions.SystemException;
import com.netflix.spinnaker.orca.api.pipeline.graph.TaskNode;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.webhook.config.WebhookProperties;
import com.netflix.spinnaker.orca.webhook.exception.PreconfiguredWebhookNotFoundException;
import com.netflix.spinnaker.orca.webhook.exception.PreconfiguredWebhookUnauthorizedException;
import com.netflix.spinnaker.orca.webhook.pipeline.WebhookStage;
import com.netflix.spinnaker.orca.webhook.service.WebhookService;
import com.netflix.spinnaker.orca.webhook.tasks.MonitorWebhookTask;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PreconfiguredWebhookStage
extends WebhookStage {
    private static final Set<String> IGNORE_FIELDS = Set.of("props", "enabled", "label", "description", "type", "parameters");
    private static List<Field> ALL_FIELDS = Arrays.stream(WebhookProperties.PreconfiguredWebhook.class.getDeclaredFields()).filter(f -> !f.isSynthetic()).filter(f -> !IGNORE_FIELDS.contains(f.getName())).collect(Collectors.toList());
    private final FiatService fiatService;
    private final WebhookService webhookService;

    @Autowired
    PreconfiguredWebhookStage(WebhookService webhookService, FiatService fiatService, MonitorWebhookTask monitorWebhookTask) {
        super(monitorWebhookTask);
        this.webhookService = webhookService;
        this.fiatService = fiatService;
    }

    @Override
    public void taskGraph(@Nonnull StageExecution stage, @Nonnull TaskNode.Builder builder) {
        String user;
        UserPermission.View userPermission;
        boolean isAllowed;
        WebhookProperties.PreconfiguredWebhook preconfiguredWebhook = this.webhookService.getPreconfiguredWebhooks().stream().filter(webhook -> Objects.equals(stage.getType(), webhook.getType())).findFirst().orElseThrow(() -> new PreconfiguredWebhookNotFoundException(stage.getType()));
        Map<String, List<String>> permissions = preconfiguredWebhook.getPermissions();
        if (permissions != null && !permissions.isEmpty() && !(isAllowed = preconfiguredWebhook.isAllowed("WRITE", (userPermission = this.fiatService.getUserPermission(user = AuthenticatedRequest.getSpinnakerUser().orElse("anonymous"))).getRoles()))) {
            throw new PreconfiguredWebhookUnauthorizedException(user, stage.getType());
        }
        PreconfiguredWebhookStage.overrideIfNotSetInContextAndOverrideDefault(stage.getContext(), preconfiguredWebhook);
        super.taskGraph(stage, builder);
    }

    private static void overrideIfNotSetInContextAndOverrideDefault(Map<String, Object> context, WebhookProperties.PreconfiguredWebhook preconfiguredWebhook) {
        ALL_FIELDS.forEach(it -> {
            try {
                if (context.get(it.getName()) == null || it.get(preconfiguredWebhook) != null) {
                    context.put(it.getName(), it.get(preconfiguredWebhook));
                }
            }
            catch (IllegalAccessException e) {
                throw new SystemException(String.format("unexpected reflection issue for field '%s'", it.getName()), (Throwable)e);
            }
        });
    }
}

