/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.webhook.pipeline;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.netflix.spinnaker.kork.exceptions.UserException;
import com.netflix.spinnaker.orca.api.pipeline.graph.StageDefinitionBuilder;
import com.netflix.spinnaker.orca.api.pipeline.graph.StageGraphBuilder;
import com.netflix.spinnaker.orca.api.pipeline.graph.TaskNode;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.pipeline.tasks.WaitTask;
import com.netflix.spinnaker.orca.pipeline.tasks.artifacts.BindProducedArtifactsTask;
import com.netflix.spinnaker.orca.webhook.config.WebhookProperties;
import com.netflix.spinnaker.orca.webhook.tasks.CreateWebhookTask;
import com.netflix.spinnaker.orca.webhook.tasks.MonitorWebhookTask;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class WebhookStage
implements StageDefinitionBuilder {
    private static final Logger log = LoggerFactory.getLogger(WebhookStage.class);
    private final MonitorWebhookTask monitorWebhookTask;

    @Autowired
    public WebhookStage(MonitorWebhookTask monitorWebhookTask) {
        this.monitorWebhookTask = monitorWebhookTask;
    }

    public void taskGraph(@Nonnull StageExecution stage, @Nonnull TaskNode.Builder builder) {
        StageData stageData = (StageData)stage.mapTo(StageData.class);
        if (stageData.monitorOnly && !stageData.waitForCompletion) {
            throw new UserException("Can't specify monitorOnly = true and waitForCompletion = false at the same time");
        }
        if (!stageData.monitorOnly) {
            builder.withTask("createWebhook", CreateWebhookTask.class);
        }
        if (stageData.waitForCompletion) {
            if (stageData.waitBeforeMonitor > 0) {
                stage.getContext().putIfAbsent("waitTime", stageData.waitBeforeMonitor);
                builder.withTask("waitBeforeMonitorWebhook", WaitTask.class);
            }
            builder.withTask("monitorWebhook", MonitorWebhookTask.class);
        }
        if (stage.getContext().containsKey("expectedArtifacts")) {
            builder.withTask("bindProducedArtifacts", BindProducedArtifactsTask.class);
        }
    }

    public void onFailureStages(@Nonnull StageExecution stage, @Nonnull StageGraphBuilder graph) {
        this.monitorWebhookTask.onCancel(stage);
    }

    public static class WebhookMonitorResponseStageData {
        private String error;
        private Map<String, String> headers;
        private Object body;
        private HttpStatus statusCode;
        private Integer statusCodeValue;
        private String progressMessage;
        private Number percentComplete;
        private Object resolvedValue;
        private List<Integer> pastStatusCodes;

        public String getError() {
            return this.error;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public Object getBody() {
            return this.body;
        }

        public HttpStatus getStatusCode() {
            return this.statusCode;
        }

        public Integer getStatusCodeValue() {
            return this.statusCodeValue;
        }

        public String getProgressMessage() {
            return this.progressMessage;
        }

        public Number getPercentComplete() {
            return this.percentComplete;
        }

        public Object getResolvedValue() {
            return this.resolvedValue;
        }

        public List<Integer> getPastStatusCodes() {
            return this.pastStatusCodes;
        }

        public void setError(String error) {
            this.error = error;
        }

        public void setHeaders(Map<String, String> headers) {
            this.headers = headers;
        }

        public void setBody(Object body) {
            this.body = body;
        }

        public void setStatusCode(HttpStatus statusCode) {
            this.statusCode = statusCode;
        }

        public void setStatusCodeValue(Integer statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        public void setProgressMessage(String progressMessage) {
            this.progressMessage = progressMessage;
        }

        public void setPercentComplete(Number percentComplete) {
            this.percentComplete = percentComplete;
        }

        public void setResolvedValue(Object resolvedValue) {
            this.resolvedValue = resolvedValue;
        }

        public void setPastStatusCodes(List<Integer> pastStatusCodes) {
            this.pastStatusCodes = pastStatusCodes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WebhookMonitorResponseStageData)) {
                return false;
            }
            WebhookMonitorResponseStageData other = (WebhookMonitorResponseStageData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$statusCodeValue = this.getStatusCodeValue();
            Integer other$statusCodeValue = other.getStatusCodeValue();
            if (this$statusCodeValue == null ? other$statusCodeValue != null : !((Object)this$statusCodeValue).equals(other$statusCodeValue)) {
                return false;
            }
            String this$error = this.getError();
            String other$error = other.getError();
            if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
                return false;
            }
            Map<String, String> this$headers = this.getHeaders();
            Map<String, String> other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            Object this$body = this.getBody();
            Object other$body = other.getBody();
            if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
                return false;
            }
            HttpStatus this$statusCode = this.getStatusCode();
            HttpStatus other$statusCode = other.getStatusCode();
            if (this$statusCode == null ? other$statusCode != null : !this$statusCode.equals(other$statusCode)) {
                return false;
            }
            String this$progressMessage = this.getProgressMessage();
            String other$progressMessage = other.getProgressMessage();
            if (this$progressMessage == null ? other$progressMessage != null : !this$progressMessage.equals(other$progressMessage)) {
                return false;
            }
            Number this$percentComplete = this.getPercentComplete();
            Number other$percentComplete = other.getPercentComplete();
            if (this$percentComplete == null ? other$percentComplete != null : !this$percentComplete.equals(other$percentComplete)) {
                return false;
            }
            Object this$resolvedValue = this.getResolvedValue();
            Object other$resolvedValue = other.getResolvedValue();
            if (this$resolvedValue == null ? other$resolvedValue != null : !this$resolvedValue.equals(other$resolvedValue)) {
                return false;
            }
            List<Integer> this$pastStatusCodes = this.getPastStatusCodes();
            List<Integer> other$pastStatusCodes = other.getPastStatusCodes();
            return !(this$pastStatusCodes == null ? other$pastStatusCodes != null : !((Object)this$pastStatusCodes).equals(other$pastStatusCodes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WebhookMonitorResponseStageData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $statusCodeValue = this.getStatusCodeValue();
            result = result * 59 + ($statusCodeValue == null ? 43 : ((Object)$statusCodeValue).hashCode());
            String $error = this.getError();
            result = result * 59 + ($error == null ? 43 : $error.hashCode());
            Map<String, String> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            Object $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            HttpStatus $statusCode = this.getStatusCode();
            result = result * 59 + ($statusCode == null ? 43 : $statusCode.hashCode());
            String $progressMessage = this.getProgressMessage();
            result = result * 59 + ($progressMessage == null ? 43 : $progressMessage.hashCode());
            Number $percentComplete = this.getPercentComplete();
            result = result * 59 + ($percentComplete == null ? 43 : $percentComplete.hashCode());
            Object $resolvedValue = this.getResolvedValue();
            result = result * 59 + ($resolvedValue == null ? 43 : $resolvedValue.hashCode());
            List<Integer> $pastStatusCodes = this.getPastStatusCodes();
            result = result * 59 + ($pastStatusCodes == null ? 43 : ((Object)$pastStatusCodes).hashCode());
            return result;
        }

        public String toString() {
            return "WebhookStage.WebhookMonitorResponseStageData(error=" + this.getError() + ", headers=" + this.getHeaders() + ", body=" + this.getBody() + ", statusCode=" + this.getStatusCode() + ", statusCodeValue=" + this.getStatusCodeValue() + ", progressMessage=" + this.getProgressMessage() + ", percentComplete=" + this.getPercentComplete() + ", resolvedValue=" + this.getResolvedValue() + ", pastStatusCodes=" + this.getPastStatusCodes() + ")";
        }
    }

    public static class WebhookResponseStageData {
        private String error;
        private Map<String, String> headers;
        private Object body;
        private HttpStatus statusCode;
        private Integer statusCodeValue;
        private WebhookMonitorResponseStageData monitor;
        private String statusEndpoint;

        public String getError() {
            return this.error;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public Object getBody() {
            return this.body;
        }

        public HttpStatus getStatusCode() {
            return this.statusCode;
        }

        public Integer getStatusCodeValue() {
            return this.statusCodeValue;
        }

        public WebhookMonitorResponseStageData getMonitor() {
            return this.monitor;
        }

        public String getStatusEndpoint() {
            return this.statusEndpoint;
        }

        public void setError(String error) {
            this.error = error;
        }

        public void setHeaders(Map<String, String> headers) {
            this.headers = headers;
        }

        public void setBody(Object body) {
            this.body = body;
        }

        public void setStatusCode(HttpStatus statusCode) {
            this.statusCode = statusCode;
        }

        public void setStatusCodeValue(Integer statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        public void setMonitor(WebhookMonitorResponseStageData monitor) {
            this.monitor = monitor;
        }

        public void setStatusEndpoint(String statusEndpoint) {
            this.statusEndpoint = statusEndpoint;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WebhookResponseStageData)) {
                return false;
            }
            WebhookResponseStageData other = (WebhookResponseStageData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$statusCodeValue = this.getStatusCodeValue();
            Integer other$statusCodeValue = other.getStatusCodeValue();
            if (this$statusCodeValue == null ? other$statusCodeValue != null : !((Object)this$statusCodeValue).equals(other$statusCodeValue)) {
                return false;
            }
            String this$error = this.getError();
            String other$error = other.getError();
            if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
                return false;
            }
            Map<String, String> this$headers = this.getHeaders();
            Map<String, String> other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            Object this$body = this.getBody();
            Object other$body = other.getBody();
            if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
                return false;
            }
            HttpStatus this$statusCode = this.getStatusCode();
            HttpStatus other$statusCode = other.getStatusCode();
            if (this$statusCode == null ? other$statusCode != null : !this$statusCode.equals(other$statusCode)) {
                return false;
            }
            WebhookMonitorResponseStageData this$monitor = this.getMonitor();
            WebhookMonitorResponseStageData other$monitor = other.getMonitor();
            if (this$monitor == null ? other$monitor != null : !((Object)this$monitor).equals(other$monitor)) {
                return false;
            }
            String this$statusEndpoint = this.getStatusEndpoint();
            String other$statusEndpoint = other.getStatusEndpoint();
            return !(this$statusEndpoint == null ? other$statusEndpoint != null : !this$statusEndpoint.equals(other$statusEndpoint));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WebhookResponseStageData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $statusCodeValue = this.getStatusCodeValue();
            result = result * 59 + ($statusCodeValue == null ? 43 : ((Object)$statusCodeValue).hashCode());
            String $error = this.getError();
            result = result * 59 + ($error == null ? 43 : $error.hashCode());
            Map<String, String> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            Object $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            HttpStatus $statusCode = this.getStatusCode();
            result = result * 59 + ($statusCode == null ? 43 : $statusCode.hashCode());
            WebhookMonitorResponseStageData $monitor = this.getMonitor();
            result = result * 59 + ($monitor == null ? 43 : ((Object)$monitor).hashCode());
            String $statusEndpoint = this.getStatusEndpoint();
            result = result * 59 + ($statusEndpoint == null ? 43 : $statusEndpoint.hashCode());
            return result;
        }

        public String toString() {
            return "WebhookStage.WebhookResponseStageData(error=" + this.getError() + ", headers=" + this.getHeaders() + ", body=" + this.getBody() + ", statusCode=" + this.getStatusCode() + ", statusCodeValue=" + this.getStatusCodeValue() + ", monitor=" + this.getMonitor() + ", statusEndpoint=" + this.getStatusEndpoint() + ")";
        }
    }

    public static class RetryData {
        int maxAttempts;

        public int getMaxAttempts() {
            return this.maxAttempts;
        }

        public void setMaxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RetryData)) {
                return false;
            }
            RetryData other = (RetryData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getMaxAttempts() == other.getMaxAttempts();
        }

        protected boolean canEqual(Object other) {
            return other instanceof RetryData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxAttempts();
            return result;
        }

        public String toString() {
            return "WebhookStage.RetryData(maxAttempts=" + this.getMaxAttempts() + ")";
        }
    }

    public static class StageData {
        public String url;
        public Object payload;
        public Map<String, Object> customHeaders;
        public List<Integer> failFastStatusCodes = List.of(Integer.valueOf(HttpStatus.GATEWAY_TIMEOUT.value()));
        public boolean waitForCompletion;
        public WebhookProperties.StatusUrlResolution statusUrlResolution;
        public String statusUrlJsonPath;
        public boolean monitorOnly;
        @JsonFormat(with={JsonFormat.Feature.ACCEPT_CASE_INSENSITIVE_PROPERTIES})
        public HttpMethod method = HttpMethod.POST;
        public String statusEndpoint;
        public String statusJsonPath;
        public String progressJsonPath;
        public String cancelEndpoint;
        @JsonFormat(with={JsonFormat.Feature.ACCEPT_CASE_INSENSITIVE_PROPERTIES})
        public HttpMethod cancelMethod = HttpMethod.POST;
        public Object cancelPayload;
        public String successStatuses;
        public String canceledStatuses;
        public String terminalStatuses;
        public List<Integer> retryStatusCodes;
        public int waitBeforeMonitor;
        private Map<Integer, RetryData> retries;
        private WebhookResponseStageData webhook = new WebhookResponseStageData();

        public String getUrl() {
            return this.url;
        }

        public Object getPayload() {
            return this.payload;
        }

        public Map<String, Object> getCustomHeaders() {
            return this.customHeaders;
        }

        public List<Integer> getFailFastStatusCodes() {
            return this.failFastStatusCodes;
        }

        public boolean isWaitForCompletion() {
            return this.waitForCompletion;
        }

        public WebhookProperties.StatusUrlResolution getStatusUrlResolution() {
            return this.statusUrlResolution;
        }

        public String getStatusUrlJsonPath() {
            return this.statusUrlJsonPath;
        }

        public boolean isMonitorOnly() {
            return this.monitorOnly;
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        public String getStatusEndpoint() {
            return this.statusEndpoint;
        }

        public String getStatusJsonPath() {
            return this.statusJsonPath;
        }

        public String getProgressJsonPath() {
            return this.progressJsonPath;
        }

        public String getCancelEndpoint() {
            return this.cancelEndpoint;
        }

        public HttpMethod getCancelMethod() {
            return this.cancelMethod;
        }

        public Object getCancelPayload() {
            return this.cancelPayload;
        }

        public String getSuccessStatuses() {
            return this.successStatuses;
        }

        public String getCanceledStatuses() {
            return this.canceledStatuses;
        }

        public String getTerminalStatuses() {
            return this.terminalStatuses;
        }

        public List<Integer> getRetryStatusCodes() {
            return this.retryStatusCodes;
        }

        public int getWaitBeforeMonitor() {
            return this.waitBeforeMonitor;
        }

        public Map<Integer, RetryData> getRetries() {
            return this.retries;
        }

        public WebhookResponseStageData getWebhook() {
            return this.webhook;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setPayload(Object payload) {
            this.payload = payload;
        }

        public void setCustomHeaders(Map<String, Object> customHeaders) {
            this.customHeaders = customHeaders;
        }

        public void setFailFastStatusCodes(List<Integer> failFastStatusCodes) {
            this.failFastStatusCodes = failFastStatusCodes;
        }

        public void setWaitForCompletion(boolean waitForCompletion) {
            this.waitForCompletion = waitForCompletion;
        }

        public void setStatusUrlResolution(WebhookProperties.StatusUrlResolution statusUrlResolution) {
            this.statusUrlResolution = statusUrlResolution;
        }

        public void setStatusUrlJsonPath(String statusUrlJsonPath) {
            this.statusUrlJsonPath = statusUrlJsonPath;
        }

        public void setMonitorOnly(boolean monitorOnly) {
            this.monitorOnly = monitorOnly;
        }

        @JsonFormat(with={JsonFormat.Feature.ACCEPT_CASE_INSENSITIVE_PROPERTIES})
        public void setMethod(HttpMethod method) {
            this.method = method;
        }

        public void setStatusEndpoint(String statusEndpoint) {
            this.statusEndpoint = statusEndpoint;
        }

        public void setStatusJsonPath(String statusJsonPath) {
            this.statusJsonPath = statusJsonPath;
        }

        public void setProgressJsonPath(String progressJsonPath) {
            this.progressJsonPath = progressJsonPath;
        }

        public void setCancelEndpoint(String cancelEndpoint) {
            this.cancelEndpoint = cancelEndpoint;
        }

        @JsonFormat(with={JsonFormat.Feature.ACCEPT_CASE_INSENSITIVE_PROPERTIES})
        public void setCancelMethod(HttpMethod cancelMethod) {
            this.cancelMethod = cancelMethod;
        }

        public void setCancelPayload(Object cancelPayload) {
            this.cancelPayload = cancelPayload;
        }

        public void setSuccessStatuses(String successStatuses) {
            this.successStatuses = successStatuses;
        }

        public void setCanceledStatuses(String canceledStatuses) {
            this.canceledStatuses = canceledStatuses;
        }

        public void setTerminalStatuses(String terminalStatuses) {
            this.terminalStatuses = terminalStatuses;
        }

        public void setRetryStatusCodes(List<Integer> retryStatusCodes) {
            this.retryStatusCodes = retryStatusCodes;
        }

        public void setWaitBeforeMonitor(int waitBeforeMonitor) {
            this.waitBeforeMonitor = waitBeforeMonitor;
        }

        public void setRetries(Map<Integer, RetryData> retries) {
            this.retries = retries;
        }

        public void setWebhook(WebhookResponseStageData webhook) {
            this.webhook = webhook;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StageData)) {
                return false;
            }
            StageData other = (StageData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isWaitForCompletion() != other.isWaitForCompletion()) {
                return false;
            }
            if (this.isMonitorOnly() != other.isMonitorOnly()) {
                return false;
            }
            if (this.getWaitBeforeMonitor() != other.getWaitBeforeMonitor()) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            Object this$payload = this.getPayload();
            Object other$payload = other.getPayload();
            if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
                return false;
            }
            Map<String, Object> this$customHeaders = this.getCustomHeaders();
            Map<String, Object> other$customHeaders = other.getCustomHeaders();
            if (this$customHeaders == null ? other$customHeaders != null : !((Object)this$customHeaders).equals(other$customHeaders)) {
                return false;
            }
            List<Integer> this$failFastStatusCodes = this.getFailFastStatusCodes();
            List<Integer> other$failFastStatusCodes = other.getFailFastStatusCodes();
            if (this$failFastStatusCodes == null ? other$failFastStatusCodes != null : !((Object)this$failFastStatusCodes).equals(other$failFastStatusCodes)) {
                return false;
            }
            WebhookProperties.StatusUrlResolution this$statusUrlResolution = this.getStatusUrlResolution();
            WebhookProperties.StatusUrlResolution other$statusUrlResolution = other.getStatusUrlResolution();
            if (this$statusUrlResolution == null ? other$statusUrlResolution != null : !((Object)((Object)this$statusUrlResolution)).equals((Object)other$statusUrlResolution)) {
                return false;
            }
            String this$statusUrlJsonPath = this.getStatusUrlJsonPath();
            String other$statusUrlJsonPath = other.getStatusUrlJsonPath();
            if (this$statusUrlJsonPath == null ? other$statusUrlJsonPath != null : !this$statusUrlJsonPath.equals(other$statusUrlJsonPath)) {
                return false;
            }
            HttpMethod this$method = this.getMethod();
            HttpMethod other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$statusEndpoint = this.getStatusEndpoint();
            String other$statusEndpoint = other.getStatusEndpoint();
            if (this$statusEndpoint == null ? other$statusEndpoint != null : !this$statusEndpoint.equals(other$statusEndpoint)) {
                return false;
            }
            String this$statusJsonPath = this.getStatusJsonPath();
            String other$statusJsonPath = other.getStatusJsonPath();
            if (this$statusJsonPath == null ? other$statusJsonPath != null : !this$statusJsonPath.equals(other$statusJsonPath)) {
                return false;
            }
            String this$progressJsonPath = this.getProgressJsonPath();
            String other$progressJsonPath = other.getProgressJsonPath();
            if (this$progressJsonPath == null ? other$progressJsonPath != null : !this$progressJsonPath.equals(other$progressJsonPath)) {
                return false;
            }
            String this$cancelEndpoint = this.getCancelEndpoint();
            String other$cancelEndpoint = other.getCancelEndpoint();
            if (this$cancelEndpoint == null ? other$cancelEndpoint != null : !this$cancelEndpoint.equals(other$cancelEndpoint)) {
                return false;
            }
            HttpMethod this$cancelMethod = this.getCancelMethod();
            HttpMethod other$cancelMethod = other.getCancelMethod();
            if (this$cancelMethod == null ? other$cancelMethod != null : !this$cancelMethod.equals(other$cancelMethod)) {
                return false;
            }
            Object this$cancelPayload = this.getCancelPayload();
            Object other$cancelPayload = other.getCancelPayload();
            if (this$cancelPayload == null ? other$cancelPayload != null : !this$cancelPayload.equals(other$cancelPayload)) {
                return false;
            }
            String this$successStatuses = this.getSuccessStatuses();
            String other$successStatuses = other.getSuccessStatuses();
            if (this$successStatuses == null ? other$successStatuses != null : !this$successStatuses.equals(other$successStatuses)) {
                return false;
            }
            String this$canceledStatuses = this.getCanceledStatuses();
            String other$canceledStatuses = other.getCanceledStatuses();
            if (this$canceledStatuses == null ? other$canceledStatuses != null : !this$canceledStatuses.equals(other$canceledStatuses)) {
                return false;
            }
            String this$terminalStatuses = this.getTerminalStatuses();
            String other$terminalStatuses = other.getTerminalStatuses();
            if (this$terminalStatuses == null ? other$terminalStatuses != null : !this$terminalStatuses.equals(other$terminalStatuses)) {
                return false;
            }
            List<Integer> this$retryStatusCodes = this.getRetryStatusCodes();
            List<Integer> other$retryStatusCodes = other.getRetryStatusCodes();
            if (this$retryStatusCodes == null ? other$retryStatusCodes != null : !((Object)this$retryStatusCodes).equals(other$retryStatusCodes)) {
                return false;
            }
            Map<Integer, RetryData> this$retries = this.getRetries();
            Map<Integer, RetryData> other$retries = other.getRetries();
            if (this$retries == null ? other$retries != null : !((Object)this$retries).equals(other$retries)) {
                return false;
            }
            WebhookResponseStageData this$webhook = this.getWebhook();
            WebhookResponseStageData other$webhook = other.getWebhook();
            return !(this$webhook == null ? other$webhook != null : !((Object)this$webhook).equals(other$webhook));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StageData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isWaitForCompletion() ? 79 : 97);
            result = result * 59 + (this.isMonitorOnly() ? 79 : 97);
            result = result * 59 + this.getWaitBeforeMonitor();
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            Object $payload = this.getPayload();
            result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
            Map<String, Object> $customHeaders = this.getCustomHeaders();
            result = result * 59 + ($customHeaders == null ? 43 : ((Object)$customHeaders).hashCode());
            List<Integer> $failFastStatusCodes = this.getFailFastStatusCodes();
            result = result * 59 + ($failFastStatusCodes == null ? 43 : ((Object)$failFastStatusCodes).hashCode());
            WebhookProperties.StatusUrlResolution $statusUrlResolution = this.getStatusUrlResolution();
            result = result * 59 + ($statusUrlResolution == null ? 43 : ((Object)((Object)$statusUrlResolution)).hashCode());
            String $statusUrlJsonPath = this.getStatusUrlJsonPath();
            result = result * 59 + ($statusUrlJsonPath == null ? 43 : $statusUrlJsonPath.hashCode());
            HttpMethod $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $statusEndpoint = this.getStatusEndpoint();
            result = result * 59 + ($statusEndpoint == null ? 43 : $statusEndpoint.hashCode());
            String $statusJsonPath = this.getStatusJsonPath();
            result = result * 59 + ($statusJsonPath == null ? 43 : $statusJsonPath.hashCode());
            String $progressJsonPath = this.getProgressJsonPath();
            result = result * 59 + ($progressJsonPath == null ? 43 : $progressJsonPath.hashCode());
            String $cancelEndpoint = this.getCancelEndpoint();
            result = result * 59 + ($cancelEndpoint == null ? 43 : $cancelEndpoint.hashCode());
            HttpMethod $cancelMethod = this.getCancelMethod();
            result = result * 59 + ($cancelMethod == null ? 43 : $cancelMethod.hashCode());
            Object $cancelPayload = this.getCancelPayload();
            result = result * 59 + ($cancelPayload == null ? 43 : $cancelPayload.hashCode());
            String $successStatuses = this.getSuccessStatuses();
            result = result * 59 + ($successStatuses == null ? 43 : $successStatuses.hashCode());
            String $canceledStatuses = this.getCanceledStatuses();
            result = result * 59 + ($canceledStatuses == null ? 43 : $canceledStatuses.hashCode());
            String $terminalStatuses = this.getTerminalStatuses();
            result = result * 59 + ($terminalStatuses == null ? 43 : $terminalStatuses.hashCode());
            List<Integer> $retryStatusCodes = this.getRetryStatusCodes();
            result = result * 59 + ($retryStatusCodes == null ? 43 : ((Object)$retryStatusCodes).hashCode());
            Map<Integer, RetryData> $retries = this.getRetries();
            result = result * 59 + ($retries == null ? 43 : ((Object)$retries).hashCode());
            WebhookResponseStageData $webhook = this.getWebhook();
            result = result * 59 + ($webhook == null ? 43 : ((Object)$webhook).hashCode());
            return result;
        }

        public String toString() {
            return "WebhookStage.StageData(url=" + this.getUrl() + ", payload=" + this.getPayload() + ", customHeaders=" + this.getCustomHeaders() + ", failFastStatusCodes=" + this.getFailFastStatusCodes() + ", waitForCompletion=" + this.isWaitForCompletion() + ", statusUrlResolution=" + this.getStatusUrlResolution() + ", statusUrlJsonPath=" + this.getStatusUrlJsonPath() + ", monitorOnly=" + this.isMonitorOnly() + ", method=" + this.getMethod() + ", statusEndpoint=" + this.getStatusEndpoint() + ", statusJsonPath=" + this.getStatusJsonPath() + ", progressJsonPath=" + this.getProgressJsonPath() + ", cancelEndpoint=" + this.getCancelEndpoint() + ", cancelMethod=" + this.getCancelMethod() + ", cancelPayload=" + this.getCancelPayload() + ", successStatuses=" + this.getSuccessStatuses() + ", canceledStatuses=" + this.getCanceledStatuses() + ", terminalStatuses=" + this.getTerminalStatuses() + ", retryStatusCodes=" + this.getRetryStatusCodes() + ", waitBeforeMonitor=" + this.getWaitBeforeMonitor() + ", retries=" + this.getRetries() + ", webhook=" + this.getWebhook() + ")";
        }
    }
}

