/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.webhook.tasks;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.netflix.spinnaker.orca.webhook.pipeline.WebhookStage;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

class WebhookStatusCheckUrlRetriever {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Pattern URL_SCHEME = Pattern.compile("(.*)://(.*)");

    WebhookStatusCheckUrlRetriever() {
    }

    public String getStatusCheckUrl(ResponseEntity response, WebhookStage.StageData stageData) {
        Object statusCheckUrl = null;
        switch (stageData.statusUrlResolution) {
            case getMethod: {
                statusCheckUrl = stageData.url;
                break;
            }
            case locationHeader: {
                statusCheckUrl = response.getHeaders().getFirst("Location");
                break;
            }
            case webhookResponse: {
                statusCheckUrl = (String)JsonPath.compile((String)stageData.statusUrlJsonPath, (Predicate[])new Predicate[0]).read(response.getBody());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + stageData.statusUrlResolution);
            }
        }
        this.log.info("Web hook status check url as resolved: {}", statusCheckUrl);
        if (statusCheckUrl != null && !((String)statusCheckUrl).equals(stageData.url)) {
            Matcher statusUrlMatcher = URL_SCHEME.matcher((CharSequence)statusCheckUrl);
            URI statusCheckUri = URI.create((String)statusCheckUrl).normalize();
            String statusCheckHost = statusCheckUri.getHost();
            URI webHookUri = URI.create(stageData.url).normalize();
            String webHookHost = webHookUri.getHost();
            if (webHookHost.equals(statusCheckHost) && !webHookUri.getScheme().equals(statusCheckUri.getScheme()) && statusUrlMatcher.find()) {
                statusCheckUrl = webHookUri.getScheme() + "://" + statusUrlMatcher.group(2);
                this.log.info("Adjusted Web hook status check url: {}", statusCheckUrl);
            }
        }
        return statusCheckUrl;
    }
}

