/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.webhook.util;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.X509TrustManager;

public class UnionX509TrustManager
implements X509TrustManager {
    private final List<X509TrustManager> delegates;

    public UnionX509TrustManager(List<X509TrustManager> delegates) {
        this.delegates = Collections.unmodifiableList(delegates);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        for (X509TrustManager delegate : this.delegates) {
            try {
                delegate.checkClientTrusted(chain, authType);
                return;
            }
            catch (CertificateException certificateException) {
            }
        }
        throw new CertificateException("None of the configured trust managers trusted the specified client.");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        for (X509TrustManager delegate : this.delegates) {
            try {
                delegate.checkServerTrusted(chain, authType);
                return;
            }
            catch (CertificateException certificateException) {
            }
        }
        throw new CertificateException("None of the configured trust managers trusted the specified server.");
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        for (X509TrustManager delegate : this.delegates) {
            certificates.addAll(Arrays.asList(delegate.getAcceptedIssuers()));
        }
        return certificates.toArray(new X509Certificate[0]);
    }
}

