/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.webhook.config;

import com.netflix.spinnaker.okhttp.OkHttpClientConfigurationProperties;
import com.netflix.spinnaker.orca.config.UserConfiguredUrlRestrictions;
import com.netflix.spinnaker.orca.webhook.config.WebhookProperties;
import com.netflix.spinnaker.orca.webhook.util.UnionX509TrustManager;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.StreamUtils;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnProperty(prefix="webhook.stage", value={"enabled"}, matchIfMissing=true)
@ComponentScan(value={"com.netflix.spinnaker.orca.webhook"})
@EnableConfigurationProperties(value={WebhookProperties.class})
public class WebhookConfiguration {
    private final WebhookProperties webhookProperties;

    @Autowired
    public WebhookConfiguration(WebhookProperties webhookProperties) {
        this.webhookProperties = webhookProperties;
    }

    @Bean
    @ConditionalOnMissingBean(value={RestTemplate.class})
    public RestTemplate restTemplate(ClientHttpRequestFactory webhookRequestFactory) {
        RestTemplate restTemplate = new RestTemplate(webhookRequestFactory);
        List converters = restTemplate.getMessageConverters();
        converters.add(new ObjectStringHttpMessageConverter());
        converters.add(new MapToStringHttpMessageConverter());
        restTemplate.setMessageConverters(converters);
        return restTemplate;
    }

    @Bean
    public ClientHttpRequestFactory webhookRequestFactory(OkHttpClientConfigurationProperties okHttpClientConfigurationProperties, UserConfiguredUrlRestrictions userConfiguredUrlRestrictions) {
        X509TrustManager trustManager = this.webhookX509TrustManager();
        SSLSocketFactory sslSocketFactory = this.getSSLSocketFactory(trustManager);
        OkHttpClient client = new OkHttpClient.Builder().sslSocketFactory(sslSocketFactory, trustManager).addNetworkInterceptor(chain -> {
            String redirectLocation;
            Response response = chain.proceed(chain.request());
            if (this.webhookProperties.isVerifyRedirects() && response.isRedirect() && (redirectLocation = response.header("Location")) != null && !redirectLocation.trim().startsWith("/")) {
                userConfiguredUrlRestrictions.validateURI(redirectLocation);
            }
            return response;
        }).build();
        OkHttp3ClientHttpRequestFactory requestFactory = new OkHttp3ClientHttpRequestFactory(client);
        requestFactory.setReadTimeout(Math.toIntExact(okHttpClientConfigurationProperties.getReadTimeoutMs()));
        requestFactory.setConnectTimeout(Math.toIntExact(okHttpClientConfigurationProperties.getConnectTimeoutMs()));
        return requestFactory;
    }

    private X509TrustManager webhookX509TrustManager() {
        ArrayList<X509TrustManager> trustManagers = new ArrayList<X509TrustManager>();
        trustManagers.add(this.getTrustManager(null));
        this.getCustomKeyStore().ifPresent(keyStore -> trustManagers.add(this.getTrustManager((KeyStore)keyStore)));
        return new UnionX509TrustManager(trustManagers);
    }

    private SSLSocketFactory getSSLSocketFactory(X509TrustManager trustManager) {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new X509TrustManager[]{trustManager}, null);
            return sslContext.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private X509TrustManager getTrustManager(KeyStore keyStore) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            return (X509TrustManager)trustManagers[0];
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private Optional<KeyStore> getCustomKeyStore() {
        KeyStore keyStore;
        WebhookProperties.TrustSettings trustSettings = this.webhookProperties.getTrust();
        if (trustSettings == null || !trustSettings.isEnabled() || StringUtils.isEmpty((CharSequence)trustSettings.getTrustStore())) {
            return Optional.empty();
        }
        try {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        try (FileInputStream file = new FileInputStream(trustSettings.getTrustStore());){
            keyStore.load(file, trustSettings.getTrustStorePassword().toCharArray());
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
        return Optional.of(keyStore);
    }

    public class MapToStringHttpMessageConverter
    extends AbstractHttpMessageConverter<Map<String, Object>> {
        MapToStringHttpMessageConverter() {
            super(Charset.defaultCharset(), new MediaType[]{MediaType.APPLICATION_FORM_URLENCODED});
        }

        protected boolean supports(Class<?> clazz) {
            return Map.class.isAssignableFrom(clazz);
        }

        protected Map<String, Object> readInternal(Class<? extends Map<String, Object>> clazz, HttpInputMessage inputMessage) throws HttpMessageNotReadableException {
            throw new UnsupportedOperationException();
        }

        protected void writeInternal(Map<String, Object> body, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
            Charset charset = this.getContentTypeCharset(outputMessage.getHeaders().getContentType());
            String str = body.entrySet().stream().map(p -> this.urlEncode((String)p.getKey(), charset) + "=" + this.urlEncode(p.getValue().toString(), charset)).reduce((p1, p2) -> p1 + "&" + p2).orElse("");
            StreamUtils.copy((String)str, (Charset)charset, (OutputStream)outputMessage.getBody());
        }

        private Charset getContentTypeCharset(MediaType contentType) {
            if (contentType != null && contentType.getCharset() != null) {
                return contentType.getCharset();
            }
            return this.getDefaultCharset();
        }

        private String urlEncode(String str, Charset charset) {
            try {
                return URLEncoder.encode(str, charset.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public class ObjectStringHttpMessageConverter
    extends StringHttpMessageConverter {
        public boolean supports(Class<?> clazz) {
            return clazz == Object.class;
        }
    }
}

