/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.webhook.service;

import com.netflix.spinnaker.kork.exceptions.SpinnakerException;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.config.UserConfiguredUrlRestrictions;
import com.netflix.spinnaker.orca.webhook.config.WebhookProperties;
import com.netflix.spinnaker.orca.webhook.pipeline.WebhookStage;
import com.netflix.spinnaker.orca.webhook.service.RestTemplateProvider;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@Service
public class WebhookService {
    private static final Logger log = LoggerFactory.getLogger(WebhookService.class);
    static final List<String> headerDenyList = List.of("X-SPINNAKER-USER", "X-SPINNAKER-ACCOUNT", "X-SPINNAKER-USER-ORIGIN", "X-SPINNAKER-REQUEST-ID", "X-SPINNAKER-EXECUTION-ID");
    @Autowired
    private List<RestTemplateProvider> restTemplateProviders = new ArrayList<RestTemplateProvider>();
    @Autowired
    private UserConfiguredUrlRestrictions userConfiguredUrlRestrictions;
    @Autowired
    private WebhookProperties preconfiguredWebhookProperties;

    public ResponseEntity<Object> callWebhook(StageExecution stageExecution) {
        RestTemplateData restTemplateData = this.getRestTemplateData(WebhookTaskType.CREATE, stageExecution);
        if (restTemplateData == null) {
            throw new SpinnakerException("Unable to determine rest template to call webhook");
        }
        return restTemplateData.exchange();
    }

    public ResponseEntity<Object> getWebhookStatus(StageExecution stageExecution) {
        RestTemplateData restTemplateData = this.getRestTemplateData(WebhookTaskType.MONITOR, stageExecution);
        if (restTemplateData == null) {
            throw new SpinnakerException("Unable to determine rest template to monitor webhook");
        }
        return restTemplateData.exchange();
    }

    public ResponseEntity<Object> cancelWebhook(StageExecution stageExecution) {
        RestTemplateData restTemplateData = this.getRestTemplateData(WebhookTaskType.CANCEL, stageExecution);
        if (restTemplateData == null) {
            log.warn("Cannot determine rest template to cancel the webhook");
            return null;
        }
        WebhookStage.StageData stageData = restTemplateData.stageData;
        try {
            log.info("Sending best effort webhook cancellation to {}", (Object)stageData.cancelEndpoint);
            ResponseEntity<Object> response = restTemplateData.exchange();
            log.debug("Received status code {} from cancel endpoint {} in execution {} in stage {}", new Object[]{response.getStatusCode(), stageData.cancelEndpoint, stageExecution.getExecution().getId(), stageExecution.getId()});
            return response;
        }
        catch (HttpStatusCodeException e) {
            log.warn("Failed to cancel webhook {} with statusCode={}", new Object[]{stageData.cancelEndpoint, e.getStatusCode().value(), e});
        }
        catch (Exception e) {
            log.warn("Failed to cancel webhook {}", (Object)stageData.cancelEndpoint, (Object)e);
        }
        return null;
    }

    private RestTemplateData getRestTemplateData(WebhookTaskType taskType, StageExecution stageExecution) {
        String destinationUrl = null;
        for (RestTemplateProvider provider : this.restTemplateProviders) {
            WebhookStage.StageData stageData = (WebhookStage.StageData)stageExecution.mapTo(provider.getStageDataType());
            HttpHeaders headers = WebhookService.buildHttpHeaders(stageData.customHeaders);
            HttpMethod httpMethod = HttpMethod.GET;
            HttpEntity payloadEntity = null;
            switch (taskType) {
                case CREATE: {
                    destinationUrl = stageData.url;
                    payloadEntity = new HttpEntity(stageData.payload, (MultiValueMap)headers);
                    httpMethod = stageData.method;
                    break;
                }
                case MONITOR: {
                    destinationUrl = Optional.ofNullable(stageData.getStatusEndpoint()).map(String::trim).orElse(stageData.getUrl());
                    payloadEntity = new HttpEntity(null, (MultiValueMap)headers);
                    break;
                }
                case CANCEL: {
                    destinationUrl = stageData.cancelEndpoint;
                    payloadEntity = new HttpEntity(stageData.cancelPayload, (MultiValueMap)headers);
                    httpMethod = stageData.cancelMethod;
                    break;
                }
                default: {
                    destinationUrl = "";
                }
            }
            if (destinationUrl == null || destinationUrl.isEmpty() || !provider.supports(destinationUrl, stageData)) continue;
            URI validatedUri = this.userConfiguredUrlRestrictions.validateURI(provider.getTargetUrl(destinationUrl, stageData));
            RestTemplate restTemplate = provider.getRestTemplate(destinationUrl);
            return new RestTemplateData(restTemplate, validatedUri, httpMethod, (HttpEntity<Object>)payloadEntity, stageData);
        }
        log.warn("Unable to find rest template provider for url: {} , executionId: {}, webhookTaskType: {}", new Object[]{destinationUrl, stageExecution.getId(), taskType});
        return null;
    }

    public List<WebhookProperties.PreconfiguredWebhook> getPreconfiguredWebhooks() {
        return this.preconfiguredWebhookProperties.getPreconfigured().stream().filter(WebhookProperties.PreconfiguredWebhook::isEnabled).collect(Collectors.toList());
    }

    private static HttpHeaders buildHttpHeaders(Map<String, Object> customHeaders) {
        HttpHeaders headers = new HttpHeaders();
        if (customHeaders != null) {
            customHeaders.forEach((key, value) -> {
                if (headerDenyList.contains(key.toUpperCase())) {
                    return;
                }
                if (value instanceof List) {
                    headers.put(key, (List)value);
                } else {
                    headers.add(key, value.toString());
                }
            });
        }
        return headers;
    }

    private static enum WebhookTaskType {
        CREATE,
        MONITOR,
        CANCEL;

    }

    private static class RestTemplateData {
        final RestTemplate restTemplate;
        final URI validatedUri;
        final HttpMethod httpMethod;
        final HttpEntity<Object> payloadEntity;
        final WebhookStage.StageData stageData;

        RestTemplateData(RestTemplate restTemplate, URI validatedUri, HttpMethod httpMethod, HttpEntity<Object> payloadEntity, WebhookStage.StageData stageData) {
            this.restTemplate = restTemplate;
            this.validatedUri = validatedUri;
            this.httpMethod = httpMethod;
            this.payloadEntity = payloadEntity;
            this.stageData = stageData;
        }

        public ResponseEntity<Object> exchange() {
            return this.restTemplate.exchange(this.validatedUri, this.httpMethod, this.payloadEntity, Object.class);
        }
    }
}

