/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.webhook.tasks;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.orca.api.pipeline.RetryableTask;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.webhook.config.WebhookProperties;
import com.netflix.spinnaker.orca.webhook.service.WebhookService;
import com.netflix.spinnaker.orca.webhook.tasks.WebhookResponseProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class CreateWebhookTask
implements RetryableTask {
    private static final Logger log = LoggerFactory.getLogger(CreateWebhookTask.class);
    private final WebhookService webhookService;
    private final WebhookProperties webhookProperties;
    private final ObjectMapper objectMapper;

    @Autowired
    public CreateWebhookTask(WebhookService webhookService, WebhookProperties webhookProperties, ObjectMapper objectMapper) {
        this.webhookService = webhookService;
        this.webhookProperties = webhookProperties;
        this.objectMapper = objectMapper;
    }

    public TaskResult execute(StageExecution stage) {
        WebhookResponseProcessor responseProcessor = new WebhookResponseProcessor(this.objectMapper, stage, this.webhookProperties);
        try {
            ResponseEntity<Object> response = this.webhookService.callWebhook(stage);
            return responseProcessor.process(response, null);
        }
        catch (Exception e) {
            return responseProcessor.process(null, e);
        }
    }

    public long getBackoffPeriod() {
        return 10000L;
    }

    public long getTimeout() {
        return 300000L;
    }
}

