/*
 * Decompiled with CFR 0.152.
 */
package spray.can.parsing;

import akka.util.ByteString;
import java.nio.charset.Charset;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import spray.can.parsing.CharUtils$;
import spray.can.parsing.HttpHeaderParser;
import spray.can.parsing.HttpMessagePartParser;
import spray.can.parsing.HttpRequestPartParser$;
import spray.can.parsing.NotEnoughDataException$;
import spray.can.parsing.ParserSettings;
import spray.can.parsing.ParsingException;
import spray.can.parsing.ParsingException$;
import spray.can.parsing.Result;
import spray.http.ChunkedRequestStart;
import spray.http.ErrorInfo;
import spray.http.HttpEntity;
import spray.http.HttpHeader;
import spray.http.HttpHeaders;
import spray.http.HttpMessagePart;
import spray.http.HttpMethod;
import spray.http.HttpMethods$;
import spray.http.HttpProtocol;
import spray.http.HttpProtocols$;
import spray.http.HttpRequest;
import spray.http.IllegalUriException;
import spray.http.StatusCode;
import spray.http.StatusCodes$;
import spray.http.Uri;
import spray.http.Uri$;
import spray.http.parser.ParserInput;
import spray.http.parser.ParserInput$;
import spray.util.package$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g!B\u0001\u0003\u0001\u0011A!!\u0006%uiB\u0014V-];fgR\u0004\u0016M\u001d;QCJ\u001cXM\u001d\u0006\u0003\u0007\u0011\tq\u0001]1sg&twM\u0003\u0002\u0006\r\u0005\u00191-\u00198\u000b\u0003\u001d\tQa\u001d9sCf\u001c2\u0001A\u0005\u000e!\tQ1\"D\u0001\u0003\u0013\ta!AA\u000bIiR\u0004X*Z:tC\u001e,\u0007+\u0019:u!\u0006\u00148/\u001a:\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\n)\u0001\u0011\t\u0011)A\u0005-e\t\u0011bX:fiRLgnZ:\u0004\u0001A\u0011!bF\u0005\u00031\t\u0011a\u0002U1sg\u0016\u00148+\u001a;uS:<7/\u0003\u0002\u001b\u0017\u0005A1/\u001a;uS:<7\u000f\u0003\u0005\u001d\u0001\t\u0005\t\u0015!\u0003\u001e\u0003M\u0011\u0018m\u001e*fcV,7\u000f^+sS\"+\u0017\rZ3s!\tqa$\u0003\u0002 \u001f\t9!i\\8mK\u0006t\u0007\"C\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012&\u00035y\u0006.Z1eKJ\u0004\u0016M]:feB\u0011!bI\u0005\u0003I\t\u0011\u0001\u0003\u0013;ua\"+\u0017\rZ3s!\u0006\u00148/\u001a:\n\u0005\u0019Z\u0011\u0001\u00045fC\u0012,'\u000fU1sg\u0016\u0014\b\"\u0002\u0015\u0001\t\u0003I\u0013A\u0002\u001fj]&$h\bF\u0002+[9\"\"a\u000b\u0017\u0011\u0005)\u0001\u0001bB\u0011(!\u0003\u0005\rA\t\u0005\u0006)\u001d\u0002\rA\u0006\u0005\b9\u001d\u0002\n\u00111\u0001\u001e\u0011\u0019\u0001\u0004\u0001)Q\u0005c\u00051Q.\u001a;i_\u0012\u0004\"AM\u001b\u000e\u0003MR!\u0001\u000e\u0004\u0002\t!$H\u000f]\u0005\u0003mM\u0012!\u0002\u0013;ua6+G\u000f[8e\u0011\u0019A\u0004\u0001)Q\u0005s\u0005\u0019QO]5\u0011\u0005IR\u0014BA\u001e4\u0005\r)&/\u001b\u0005\u0007{\u0001\u0001\u000b\u0015\u0002 \u0002\u0011U\u0014\u0018NQ=uKN\u00042AD B\u0013\t\u0001uBA\u0003BeJ\f\u0017\u0010\u0005\u0002\u000f\u0005&\u00111i\u0004\u0002\u0005\u0005f$X\rC\u0003F\u0001\u0011\u0005a)\u0001\u0005d_BLx+\u001b;i)\tYs\tC\u0003I\t\u0002\u0007\u0011*A\nxCJtwJ\\%mY\u0016<\u0017\r\u001c%fC\u0012,'\u000f\u0005\u0003\u000f\u00152{\u0015BA&\u0010\u0005%1UO\\2uS>t\u0017\u0007\u0005\u00023\u001b&\u0011aj\r\u0002\n\u000bJ\u0014xN]%oM>\u0004\"A\u0004)\n\u0005E{!\u0001B+oSRDQa\u0015\u0001\u0005\u0002Q\u000bA\u0002]1sg\u0016lUm]:bO\u0016$2!\u0016-c!\tQa+\u0003\u0002X\u0005\t1!+Z:vYRDQ!\u0017*A\u0002i\u000bQ!\u001b8qkR\u0004\"a\u00171\u000e\u0003qS!!\u00180\u0002\tU$\u0018\u000e\u001c\u0006\u0002?\u0006!\u0011m[6b\u0013\t\tGL\u0001\u0006CsR,7\u000b\u001e:j]\u001eDQa\u0019*A\u0002\u0011\faa\u001c4gg\u0016$\bC\u0001\bf\u0013\t1wBA\u0002J]RDQ\u0001\u001b\u0001\u0005\u0002%\f1\u0002]1sg\u0016lU\r\u001e5pIR\u0019AM[6\t\u000be;\u0007\u0019\u0001.\t\u000b1<\u0007\u0019\u00013\u0002\r\r,(o]8s\u0011\u0015q\u0007\u0001\"\u0001p\u0003I\u0001\u0018M]:f%\u0016\fX/Z:u)\u0006\u0014x-\u001a;\u0015\u0007\u0011\u0004\u0018\u000fC\u0003Z[\u0002\u0007!\fC\u0003m[\u0002\u0007A\rC\u0003t\u0001\u0011\u0005A/A\u0006cC\u0012\u0004&o\u001c;pG>dW#A;\u0011\u000591\u0018BA<\u0010\u0005\u001dqu\u000e\u001e5j]\u001eDQ!\u001f\u0001\u0005\u0002i\f1\u0002]1sg\u0016,e\u000e^5usR\u0001Rk_A\r\u00037\ty\"a\u000e\u0002D\u0005=\u00131\u000b\u0005\u0006yb\u0004\r!`\u0001\bQ\u0016\fG-\u001a:t!\u0015q\u0018QBA\n\u001d\ry\u0018\u0011\u0002\b\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011QA\u000b\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0012bAA\u0006\u001f\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\b\u0003#\u0011A\u0001T5ti*\u0019\u00111B\b\u0011\u0007I\n)\"C\u0002\u0002\u0018M\u0012!\u0002\u0013;ua\"+\u0017\rZ3s\u0011\u0015I\u0006\u00101\u0001[\u0011\u0019\ti\u0002\u001fa\u0001I\u0006I!m\u001c3z'R\f'\u000f\u001e\u0005\b\u0003CA\b\u0019AA\u0012\u0003\r\u0019G\u000e\u001b\t\u0006\u001d\u0005\u0015\u0012\u0011F\u0005\u0004\u0003Oy!AB(qi&|g\u000e\u0005\u0003\u0002,\u0005Ebb\u0001\u001a\u0002.%\u0019\u0011qF\u001a\u0002\u0017!#H\u000f\u001d%fC\u0012,'o]\u0005\u0005\u0003g\t)DA\nD_:$XM\u001c;%[&tWo\u001d'f]\u001e$\bNC\u0002\u00020MBq!!\u000fy\u0001\u0004\tY$A\u0002di\"\u0004RADA\u0013\u0003{\u0001B!a\u000b\u0002@%!\u0011\u0011IA\u001b\u0005E\u0019uN\u001c;f]R$S.\u001b8vgRK\b/\u001a\u0005\b\u0003\u000bB\b\u0019AA$\u0003\r!X\r\u001b\t\u0006\u001d\u0005\u0015\u0012\u0011\n\t\u0005\u0003W\tY%\u0003\u0003\u0002N\u0005U\"A\u0006+sC:\u001ch-\u001a:%[&tWo]#oG>$\u0017N\\4\t\r\u0005E\u0003\u00101\u0001\u001e\u0003EAwn\u001d;IK\u0006$WM\u001d)sKN,g\u000e\u001e\u0005\u0007\u0003+B\b\u0019A\u000f\u00029\rdwn]3BMR,'OU3ta>t7/Z\"p[BdW\r^5p]\"9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0013aB7fgN\fw-\u001a\u000b\u0007\u0003;\n\u0019'!\u001a\u0011\u0007I\ny&C\u0002\u0002bM\u00121\u0002\u0013;uaJ+\u0017/^3ti\"1A0a\u0016A\u0002uD\u0001\"a\u001a\u0002X\u0001\u0007\u0011\u0011N\u0001\u0007K:$\u0018\u000e^=\u0011\u0007I\nY'C\u0002\u0002nM\u0012!\u0002\u0013;ua\u0016sG/\u001b;z\u0011\u001d\t\t\b\u0001C\u0001\u0003g\n\u0011c\u00195v].\u001cF/\u0019:u\u001b\u0016\u001c8/Y4f)\u0011\t)(a\u001f\u0011\u0007I\n9(C\u0002\u0002zM\u00121c\u00115v].,GMU3rk\u0016\u001cHo\u0015;beRDa\u0001`A8\u0001\u0004ixACA@\u0005\u0005\u0005\tR\u0001\u0003\u0002\u0002\u0006)\u0002\n\u001e;q%\u0016\fX/Z:u!\u0006\u0014H\u000fU1sg\u0016\u0014\bc\u0001\u0006\u0002\u0004\u001aI\u0011AAA\u0001\u0012\u000b!\u0011QQ\n\u0006\u0003\u0007\u000b9)\u0004\t\u0005\u0003\u0013\u000b\u0019*\u0004\u0002\u0002\f*!\u0011QRAH\u0003\u0011a\u0017M\\4\u000b\u0005\u0005E\u0015\u0001\u00026bm\u0006LA!!&\u0002\f\n1qJ\u00196fGRDq\u0001KAB\t\u0003\tI\n\u0006\u0002\u0002\u0002\"Q\u0011QTAB#\u0003%\t!a(\u0002\u001d%t\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0015\u0016\u0004;\u0005\r6FAAS!\u0011\t9+!-\u000e\u0005\u0005%&\u0002BAV\u0003[\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=v\"\u0001\u0006b]:|G/\u0019;j_:LA!a-\u0002*\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\u0005]\u00161QI\u0001\n\u0003\tI,\u0001\bj]&$H\u0005Z3gCVdG\u000fJ\u001a\u0015\r\u0005m\u0016QXA`U\r\u0011\u00131\u0015\u0005\u0007)\u0005U\u0006\u0019\u0001\f\t\rq\t)\f1\u0001\u001e\u0001")
public class HttpRequestPartParser
extends HttpMessagePartParser
implements ScalaObject {
    private final boolean rawRequestUriHeader;
    private HttpMethod method;
    private Uri uri;
    private byte[] uriBytes;

    public static final HttpHeaderParser init$default$3(ParserSettings parserSettings, boolean bl) {
        return HttpRequestPartParser$.MODULE$.init$default$3(parserSettings, bl);
    }

    public static final boolean init$default$2() {
        return HttpRequestPartParser$.MODULE$.init$default$2();
    }

    public HttpRequestPartParser copyWith(Function1<ErrorInfo, BoxedUnit> warnOnIllegalHeader) {
        return new HttpRequestPartParser(this.settings(), this.rawRequestUriHeader, this.headerParser().copyWith(warnOnIllegalHeader));
    }

    @Override
    public Result parseMessage(ByteString input, int offset) {
        int cursor = this.parseMethod(input, offset);
        cursor = this.parseRequestTarget(input, cursor);
        if (CharUtils$.MODULE$.byteChar(input, cursor = this.parseProtocol(input, cursor)) == '\r' && CharUtils$.MODULE$.byteChar(input, cursor + 1) == '\n') {
            return this.parseHeaderLines(input, cursor + 2, (List<HttpHeader>)this.parseHeaderLines$default$3(), this.parseHeaderLines$default$4(), (Option<HttpHeaders.Connection>)this.parseHeaderLines$default$5(), (Option<HttpHeaders.Content$minusLength>)this.parseHeaderLines$default$6(), (Option<HttpHeaders.Content$minusType>)this.parseHeaderLines$default$7(), (Option<HttpHeaders.Transfer$minusEncoding>)this.parseHeaderLines$default$8(), this.parseHeaderLines$default$9(), this.parseHeaderLines$default$10());
        }
        throw this.badProtocol();
    }

    public int parseMethod(ByteString input$1, int cursor$1) {
        int n;
        char c = CharUtils$.MODULE$.byteChar(input$1, cursor$1);
        block0 : switch (c) {
            default: {
                n = this.parseCustomMethod$1(this.parseCustomMethod$default$1$1(), this.parseCustomMethod$default$2$1(), input$1, cursor$1);
                break;
            }
            case 'D': {
                n = this.parseMethod$1(HttpMethods$.MODULE$.DELETE(), this.parseMethod$default$2$1(), input$1, cursor$1);
                break;
            }
            case 'O': {
                n = this.parseMethod$1(HttpMethods$.MODULE$.OPTIONS(), this.parseMethod$default$2$1(), input$1, cursor$1);
                break;
            }
            case 'H': {
                n = this.parseMethod$1(HttpMethods$.MODULE$.HEAD(), this.parseMethod$default$2$1(), input$1, cursor$1);
                break;
            }
            case 'C': {
                n = this.parseMethod$1(HttpMethods$.MODULE$.CONNECT(), this.parseMethod$default$2$1(), input$1, cursor$1);
                break;
            }
            case 'P': {
                char c2 = CharUtils$.MODULE$.byteChar(input$1, cursor$1 + 1);
                switch (c2) {
                    default: {
                        n = this.parseCustomMethod$1(this.parseCustomMethod$default$1$1(), this.parseCustomMethod$default$2$1(), input$1, cursor$1);
                        break block0;
                    }
                    case 'A': {
                        n = this.parseMethod$1(HttpMethods$.MODULE$.PATCH(), 2, input$1, cursor$1);
                        break block0;
                    }
                    case 'O': {
                        n = this.parseMethod$1(HttpMethods$.MODULE$.POST(), 2, input$1, cursor$1);
                        break block0;
                    }
                    case 'U': 
                }
                n = this.parseMethod$1(HttpMethods$.MODULE$.PUT(), 2, input$1, cursor$1);
                break;
            }
            case 'G': {
                n = this.parseMethod$1(HttpMethods$.MODULE$.GET(), this.parseMethod$default$2$1(), input$1, cursor$1);
                break;
            }
            case 'T': {
                n = this.parseMethod$1(HttpMethods$.MODULE$.TRACE(), this.parseMethod$default$2$1(), input$1, cursor$1);
            }
        }
        return n;
    }

    public int parseRequestTarget(ByteString input$2, int cursor$2) {
        int uriStart = cursor$2;
        int uriEndLimit$1 = cursor$2 + this.settings().maxUriLength();
        int uriEnd = this.findUriEnd$1(this.findUriEnd$default$1$1(cursor$2), input$2, cursor$2, uriEndLimit$1);
        try {
            this.uriBytes = (byte[])input$2.iterator().slice(uriStart, uriEnd).toArray((ClassManifest)Manifest$.MODULE$.Byte());
            ParserInput x$2 = ParserInput$.MODULE$.apply(this.uriBytes);
            Uri.ParsingMode x$3 = this.settings().uriParsingMode();
            Charset x$4 = Uri$.MODULE$.parseHttpRequestTarget$default$2();
            this.uri = Uri$.MODULE$.parseHttpRequestTarget(x$2, x$4, x$3);
            return uriEnd + 1;
        }
        catch (IllegalUriException illegalUriException) {
            throw new ParsingException((StatusCode)StatusCodes$.MODULE$.BadRequest(), illegalUriException.info());
        }
    }

    @Override
    public Nothing$ badProtocol() {
        throw new ParsingException((StatusCode)StatusCodes$.MODULE$.HTTPVersionNotSupported(), ParsingException$.MODULE$.init$default$2());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Result parseEntity(List<HttpHeader> headers, ByteString input$3, int bodyStart$1, Option<HttpHeaders.Content$minusLength> clh, Option<HttpHeaders.Content$minusType> cth, Option<HttpHeaders.Transfer$minusEncoding> teh, boolean hostHeaderPresent, boolean closeAfterResponseCompletion$1) {
        Result result2;
        block17: {
            long contentLength;
            long l;
            Option<HttpHeaders.Content$minusLength> option;
            Option<HttpHeaders.Transfer$minusEncoding> option2;
            block16: {
                if (hostHeaderPresent) break block16;
                HttpProtocol httpProtocol = this.protocol();
                HttpProtocol httpProtocol2 = HttpProtocols$.MODULE$.HTTP$div1$u002E0();
                if (httpProtocol != null ? !httpProtocol.equals(httpProtocol2) : httpProtocol2 != null) break block17;
            }
            if ((option2 = teh) instanceof Some) {
                Some some = (Some)option2;
                HttpHeaders.Transfer$minusEncoding transfer$minusEncoding = (HttpHeaders.Transfer$minusEncoding)some.x();
                HttpHeaders.Transfer$minusEncoding te = transfer$minusEncoding;
                if (!this.gd1$1(te)) {
                    result2 = this.fail((StatusCode)StatusCodes$.MODULE$.NotImplemented(), new StringBuilder().append((Object)transfer$minusEncoding.toString()).append((Object)" is not supported by this server").toString(), this.fail$default$3());
                    return result2;
                }
                if (clh.isEmpty()) {
                    result2 = this.emit((HttpMessagePart)this.chunkStartMessage(headers), closeAfterResponseCompletion$1, (Function0<Result>)new Serializable(this, input$3, bodyStart$1, closeAfterResponseCompletion$1){
                        public static final long serialVersionUID;
                        private final HttpRequestPartParser $outer;
                        private final ByteString input$3;
                        private final int bodyStart$1;
                        private final boolean closeAfterResponseCompletion$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Result apply() {
                            return this.$outer.parseChunk(this.input$3, this.bodyStart$1, this.closeAfterResponseCompletion$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.input$3 = byteString;
                            this.bodyStart$1 = n;
                            this.closeAfterResponseCompletion$1 = bl;
                        }
                    });
                    return result2;
                }
                result2 = this.fail("A chunked request must not contain a Content-Length header.");
                return result2;
            }
            None$ none$ = None$.MODULE$;
            Option<HttpHeaders.Transfer$minusEncoding> option3 = option2;
            if (none$ == null) {
                if (option3 != null) {
                    throw new MatchError(option2);
                }
            } else if (!none$.equals(option3)) throw new MatchError(option2);
            if ((option = clh) instanceof Some) {
                Some some = (Some)option;
                HttpHeaders.Content$minusLength content$minusLength = (HttpHeaders.Content$minusLength)some.x();
                if (content$minusLength == null) throw new MatchError(option);
                l = content$minusLength.length();
            } else {
                None$ none$2 = None$.MODULE$;
                Option<HttpHeaders.Content$minusLength> option4 = option;
                if (none$2 == null) {
                    if (option4 != null) {
                        throw new MatchError(option);
                    }
                } else if (!none$2.equals(option4)) throw new MatchError(option);
                l = contentLength = 0L;
            }
            if (contentLength == 0L) {
                result2 = this.emit((HttpMessagePart)this.message(headers, (HttpEntity)HttpEntity.Empty$.MODULE$), closeAfterResponseCompletion$1, (Function0<Result>)new Serializable(this, input$3, bodyStart$1){
                    public static final long serialVersionUID;
                    private final HttpRequestPartParser $outer;
                    private final ByteString input$3;
                    private final int bodyStart$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Result apply() {
                        return this.$outer.parseMessageSafe(this.input$3, this.bodyStart$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.input$3 = byteString;
                        this.bodyStart$1 = n;
                    }
                });
                return result2;
            }
            if (contentLength <= this.settings().maxContentLength()) {
                result2 = this.parseFixedLengthBody(headers, input$3, bodyStart$1, contentLength, cth, closeAfterResponseCompletion$1);
                return result2;
            }
            result2 = this.fail((StatusCode)StatusCodes$.MODULE$.RequestEntityTooLarge(), new StringBuilder().append((Object)"Request Content-Length ").append((Object)BoxesRunTime.boxToLong((long)contentLength)).append((Object)"exceeds the configured limit of ").append((Object)BoxesRunTime.boxToLong((long)this.settings().maxContentLength())).toString(), this.fail$default$3());
            return result2;
        }
        result2 = this.fail("Request is missing required `Host` header");
        return result2;
    }

    public HttpRequest message(List<HttpHeader> headers, HttpEntity entity) {
        List list;
        if (this.rawRequestUriHeader) {
            HttpHeaders.Raw$minusRequest$minusURI raw$minusRequest$minusURI = new HttpHeaders.Raw$minusRequest$minusURI(new String(this.uriBytes, package$.MODULE$.US_ASCII()));
            list = headers.$colon$colon((Object)raw$minusRequest$minusURI);
        } else {
            list = headers;
        }
        List requestHeaders = list;
        return new HttpRequest(this.method, this.uri, requestHeaders, entity, this.protocol());
    }

    public ChunkedRequestStart chunkStartMessage(List<HttpHeader> headers) {
        return new ChunkedRequestStart(this.message(headers, (HttpEntity)HttpEntity.Empty$.MODULE$));
    }

    private final int parseCustomMethod$1(int ix, java.lang.StringBuilder sb, ByteString byteString, int n) {
        while (ix < 16) {
            char c = CharUtils$.MODULE$.byteChar(byteString, n + ix);
            if (c == ' ') {
                Option option = HttpMethods$.MODULE$.getForKey((Object)sb.toString());
                if (option instanceof Some) {
                    this.method = (HttpMethod)((Some)option).x();
                    return n + ix + 1;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                    ix = Integer.MAX_VALUE;
                    continue;
                }
                throw new MatchError((Object)option);
            }
            sb = sb.append(c);
            ++ix;
        }
        throw new ParsingException((StatusCode)StatusCodes$.MODULE$.NotImplemented(), new ErrorInfo("Unsupported HTTP method", sb.toString()));
    }

    private final java.lang.StringBuilder parseCustomMethod$default$2$1() {
        return new java.lang.StringBuilder(16);
    }

    private final int parseCustomMethod$default$1$1() {
        return 0;
    }

    private final int parseMethod$1(HttpMethod meth, int ix, ByteString byteString, int n) {
        int n2;
        block4: {
            while (true) {
                if (ix == meth.value().length()) {
                    if (CharUtils$.MODULE$.byteChar(byteString, n + ix) == ' ') {
                        this.method = meth;
                        n2 = n + ix + 1;
                    } else {
                        n2 = this.parseCustomMethod$1(this.parseCustomMethod$default$1$1(), this.parseCustomMethod$default$2$1(), byteString, n);
                    }
                    break block4;
                }
                if (CharUtils$.MODULE$.byteChar(byteString, n + ix) != meth.value().charAt(ix)) break;
                ++ix;
            }
            n2 = this.parseCustomMethod$1(this.parseCustomMethod$default$1$1(), this.parseCustomMethod$default$2$1(), byteString, n);
        }
        return n2;
    }

    private final int parseMethod$default$2$1() {
        return 1;
    }

    private final int findUriEnd$1(int ix, ByteString byteString, int n, int n2) {
        while (true) {
            if (ix == byteString.length()) {
                throw NotEnoughDataException$.MODULE$;
            }
            if (CharUtils$.MODULE$.isWhitespaceOrNewline((char)BoxesRunTime.unboxToByte((Object)byteString.apply(ix)))) {
                return ix;
            }
            if (ix >= n2) break;
            ++ix;
        }
        throw new ParsingException((StatusCode)StatusCodes$.MODULE$.RequestUriTooLong(), new StringBuilder().append((Object)"URI length exceeds the configured limit of ").append((Object)BoxesRunTime.boxToInteger((int)this.settings().maxUriLength())).append((Object)" characters").toString());
    }

    private final int findUriEnd$default$1$1(int n) {
        return n;
    }

    private final boolean gd1$1(HttpHeaders.Transfer$minusEncoding transfer$minusEncoding) {
        return transfer$minusEncoding.encodings().size() == 1 && transfer$minusEncoding.hasChunked();
    }

    public HttpRequestPartParser(ParserSettings _settings, boolean rawRequestUriHeader, HttpHeaderParser _headerParser) {
        this.rawRequestUriHeader = rawRequestUriHeader;
        super(_settings, _headerParser);
        this.method = HttpMethods$.MODULE$.GET();
        this.uri = Uri.Empty$.MODULE$;
        this.uriBytes = (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, (ClassManifest)Manifest$.MODULE$.Byte());
    }
}

