/*
 * Decompiled with CFR 0.152.
 */
package spray.json;

import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import spray.json.JsArray;
import spray.json.JsFalse$;
import spray.json.JsNull$;
import spray.json.JsNumber$;
import spray.json.JsObject;
import spray.json.JsString;
import spray.json.JsTrue$;
import spray.json.JsValue;
import spray.json.JsonParser$;
import spray.json.ParserInput;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005mv!B\u0001\u0003\u0011\u00039\u0011A\u0003&t_:\u0004\u0016M]:fe*\u00111\u0001B\u0001\u0005UN|gNC\u0001\u0006\u0003\u0015\u0019\bO]1z\u0007\u0001\u0001\"\u0001C\u0005\u000e\u0003\t1QA\u0003\u0002\t\u0002-\u0011!BS:p]B\u000b'o]3s'\tIA\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006'%!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001dAQAF\u0005\u0005\u0002]\tQ!\u00199qYf$\"\u0001G\u000e\u0011\u0005!I\u0012B\u0001\u000e\u0003\u0005\u001dQ5OV1mk\u0016DQ\u0001H\u000bA\u0002u\tQ!\u001b8qkR\u0004\"\u0001\u0003\u0010\n\u0005}\u0011!a\u0003)beN,'/\u00138qkR4A!I\u0005\u0001E\t\u0001\u0002+\u0019:tS:<W\t_2faRLwN\\\n\u0003A\r\u0002\"\u0001\n\u0017\u000f\u0005\u0015RcB\u0001\u0014*\u001b\u00059#B\u0001\u0015\u0007\u0003\u0019a$o\\8u}%\tq\"\u0003\u0002,\u001d\u00059\u0001/Y2lC\u001e,\u0017BA\u0017/\u0005A\u0011VO\u001c;j[\u0016,\u0005pY3qi&|gN\u0003\u0002,\u001d!A\u0001\u0007\tBC\u0002\u0013\u0005\u0011'A\u0004tk6l\u0017M]=\u0016\u0003I\u0002\"a\r\u001c\u000f\u00055!\u0014BA\u001b\u000f\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0007\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Ur\u0001\u0002\u0003\u001e!\u0005\u0003\u0005\u000b\u0011\u0002\u001a\u0002\u0011M,X.\\1ss\u0002B\u0001\u0002\u0010\u0011\u0003\u0006\u0004%\t!M\u0001\u0007I\u0016$\u0018-\u001b7\t\u0011y\u0002#\u0011!Q\u0001\nI\nq\u0001Z3uC&d\u0007\u0005C\u0003\u0014A\u0011\u0005\u0001\tF\u0002B\u0007\u0012\u0003\"A\u0011\u0011\u000e\u0003%AQ\u0001M A\u0002IBq\u0001P \u0011\u0002\u0003\u0007!gB\u0004G\u0013\u0005\u0005\t\u0012A$\u0002!A\u000b'o]5oO\u0016C8-\u001a9uS>t\u0007C\u0001\"I\r\u001d\t\u0013\"!A\t\u0002%\u001b2\u0001\u0013\u0007K!\ti1*\u0003\u0002M\u001d\ta1+\u001a:jC2L'0\u00192mK\")1\u0003\u0013C\u0001\u001dR\tq\tC\u0004Q\u0011F\u0005I\u0011A)\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0005\u0011&F\u0001\u001aTW\u0005!\u0006CA+[\u001b\u00051&BA,Y\u0003%)hn\u00195fG.,GM\u0003\u0002Z\u001d\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005m3&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"9Q\fSA\u0001\n\u0013q\u0016a\u0003:fC\u0012\u0014Vm]8mm\u0016$\u0012a\u0018\t\u0003A\u0016l\u0011!\u0019\u0006\u0003E\u000e\fA\u0001\\1oO*\tA-\u0001\u0003kCZ\f\u0017B\u00014b\u0005\u0019y%M[3di\u001a!!B\u0001\u0001i'\t9G\u0002\u0003\u0005\u001dO\n\u0005\t\u0015!\u0003\u001e\u0011\u0015\u0019r\r\"\u0001l)\taW\u000e\u0005\u0002\tO\")AD\u001ba\u0001;!1qn\u001aQ\u0001\nA\f!a\u001d2\u0011\u0005\u0001\f\u0018B\u0001:b\u00055\u0019FO]5oO\n+\u0018\u000e\u001c3fe\"1Ao\u001aQ!\nU\f!bY;sg>\u00148\t[1s!\tia/\u0003\u0002x\u001d\t!1\t[1s\u0011%Ix\r1A\u0001B\u0003&\u0001$A\u0004kgZ\u000bG.^3\t\u000bm<G\u0011\u0001?\u0002\u0019A\f'o]3KgZ\u000bG.^3\u0015\u0003aAqA`4C\u0002\u00135q0A\u0002F\u001f&+\"!!\u0001\u0010\u0005\u0005\rAd\u0001\u0001\u0000\u0000$A\u0011qA4!\u0002\u001b\t\t!\u0001\u0003F\u001f&\u0003\u0003bBA\u0006O\u0012%\u0011QB\u0001\u0006m\u0006dW/\u001a\u000b\u0003\u0003\u001f\u00012!DA\t\u0013\r\t\u0019B\u0004\u0002\u0005+:LG\u000fC\u0004\u0002\u0018\u001d$I!!\u0007\u0002\u000b\u0019\fGn]3\u0015\u0005\u0005m\u0001cA\u0007\u0002\u001e%\u0019\u0011q\u0004\b\u0003\u000f\t{w\u000e\\3b]\"9\u00111E4\u0005\n\u0005e\u0011\u0001\u00028vY2Dq!a\nh\t\u0013\tI\"\u0001\u0003ueV,\u0007bBA\u0016O\u0012%\u0011QB\u0001\u0007_\nTWm\u0019;\t\u000f\u0005=r\r\"\u0003\u0002\u000e\u0005)\u0011M\u001d:bs\"9\u00111G4\u0005\n\u00055\u0011A\u00028v[\n,'\u000fC\u0004\u00028\u001d$I!!\u0004\u0002\u0007%tG\u000fC\u0004\u0002<\u001d$I!!\u0004\u0002\t\u0019\u0014\u0018m\u0019\u0005\b\u0003\u007f9G\u0011BA\u0007\u0003\r)\u0007\u0010\u001d\u0005\b\u0003\u0007:G\u0011BA\u0007\u0003=yg.Z(s\u001b>\u0014X\rR5hSR\u001c\bbBA$O\u0012%\u0011QB\u0001\u0011u\u0016\u0014xn\u0014:N_J,G)[4jiNDC!!\u0012\u0002LA!\u0011QJA(\u001b\u0005A\u0016bAA)1\n9A/Y5me\u0016\u001c\u0007bBA+O\u0012%\u0011\u0011D\u0001\u0006\t&;\u0015\n\u0016\u0005\b\u00033:G\u0011BA\u0007\u0003\u0019\u0019HO]5oO\"9\u0011QL4\u0005\n\u0005e\u0011\u0001B2iCJDq!!\u0019h\t\u0013\tI\"A\u0004fg\u000e\f\u0007/\u001a3\t\u000f\u0005\u0015t\r\"\u0003\u0002\u000e\u0005\u0011qo\u001d\u0015\u0005\u0003G\nY\u0005C\u0004\u0002l\u001d$I!!\u001c\u0002\u0005\rDG\u0003BA\u000e\u0003_Bq!!\u001d\u0002j\u0001\u0007Q/A\u0001d\u0011\u001d\t)g\u001aC\u0005\u0003k\"B!a\u0007\u0002x!9\u0011\u0011OA:\u0001\u0004)\bbBA>O\u0012%\u0011\u0011D\u0001\bC\u00124\u0018M\\2f\u0011\u001d\tyh\u001aC\u0005\u0003\u0003\u000b\u0001\"\u00199qK:$7K\u0011\u000b\u0005\u00037\t\u0019\tC\u0004\u0002r\u0005u\u0004\u0019A;\t\u000f\u0005\u001du\r\"\u0003\u0002\n\u00069!/Z9vSJ,G\u0003BA\b\u0003\u0017Cq!!\u001d\u0002\u0006\u0002\u0007Q\u000fC\u0004\u0002\u0010\u001e$I!!%\u0002\t\u0019\f\u0017\u000e\u001c\u000b\t\u0003'\u000bI*!(\u0002(B\u0019Q\"!&\n\u0007\u0005]eBA\u0004O_RD\u0017N\\4\t\u000f\u0005m\u0015Q\u0012a\u0001e\u00051A/\u0019:hKRD!\"a(\u0002\u000eB\u0005\t\u0019AAQ\u0003\u0019\u0019WO]:peB\u0019Q\"a)\n\u0007\u0005\u0015fBA\u0002J]RD\u0011\"!+\u0002\u000eB\u0005\t\u0019A;\u0002\u0013\u0015\u0014(o\u001c:DQ\u0006\u0014\b\"CAWOF\u0005I\u0011BAX\u000391\u0017-\u001b7%I\u00164\u0017-\u001e7uII*\"!!-+\u0007\u0005\u00056\u000bC\u0005\u00026\u001e\f\n\u0011\"\u0003\u00028\u0006qa-Y5mI\u0011,g-Y;mi\u0012\u001aTCAA]U\t)8\u000b")
public class JsonParser {
    private final ParserInput input;
    private final StringBuilder sb;
    private char cursorChar;
    private JsValue jsValue;
    private final char EOI;

    public static JsValue apply(ParserInput parserInput) {
        return JsonParser$.MODULE$.apply(parserInput);
    }

    public JsValue parseJsValue() {
        this.ws();
        this.value();
        return this.jsValue;
    }

    private final char EOI() {
        return '\uffff';
    }

    private void value() {
        int mark = this.input.cursor();
        char c = this.cursorChar;
        switch (c) {
            default: {
                throw this.fail("JSON Value", this.fail$default$2(), this.fail$default$3());
            }
            case '\"': {
                this.string();
                this.jsValue = new JsString(this.sb.toString());
                break;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.number();
                break;
            }
            case '[': {
                this.advance();
                this.array();
                break;
            }
            case '{': {
                this.advance();
                this.object();
                break;
            }
            case 't': {
                this.simpleValue$1(this.true(), JsTrue$.MODULE$, mark);
                break;
            }
            case 'n': {
                this.simpleValue$1(this.null(), JsNull$.MODULE$, mark);
                break;
            }
            case 'f': {
                this.simpleValue$1(this.false(), JsFalse$.MODULE$, mark);
            }
        }
    }

    private boolean false() {
        return this.advance() && this.ch('a') && this.ch('l') && this.ch('s') && this.ws('e');
    }

    private boolean null() {
        return this.advance() && this.ch('u') && this.ch('l') && this.ws('l');
    }

    private boolean true() {
        return this.advance() && this.ch('r') && this.ch('u') && this.ws('e');
    }

    private void object() {
        this.ws();
        ObjectRef map = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        if (this.cursorChar != '}') {
            this.members$1(map);
        }
        this.require('}');
        this.ws();
        this.jsValue = new JsObject((Map<String, JsValue>)((Map)map.elem));
    }

    private void array() {
        this.ws();
        ObjectRef list = ObjectRef.create((Object)package$.MODULE$.Vector().newBuilder());
        if (this.cursorChar != ']') {
            this.values$1(list);
        }
        this.require(']');
        this.ws();
        this.jsValue = new JsArray((Vector<JsValue>)((Vector)((Builder)list.elem).result()));
    }

    private void number() {
        int start = this.input.cursor();
        this.ch('-');
        this.int();
        this.frac();
        this.exp();
        this.jsValue = JsNumber$.MODULE$.apply(this.input.sliceCharArray(start, this.input.cursor()));
        this.ws();
    }

    private void int() {
        if (!this.ch('0')) {
            this.oneOrMoreDigits();
        }
    }

    private void frac() {
        if (this.ch('.')) {
            this.oneOrMoreDigits();
        }
    }

    private void exp() {
        if ((this.ch('e') || this.ch('E')) && (this.ch('-') || this.ch('+') || true)) {
            this.oneOrMoreDigits();
        }
    }

    private void oneOrMoreDigits() {
        if (this.DIGIT()) {
            this.zeroOrMoreDigits();
            return;
        }
        throw this.fail("DIGIT", this.fail$default$2(), this.fail$default$3());
    }

    private void zeroOrMoreDigits() {
        while (this.DIGIT()) {
        }
    }

    private boolean DIGIT() {
        return this.cursorChar >= '0' && this.cursorChar <= '9' && this.advance();
    }

    private void string() {
        this.require('\"');
        this.sb.setLength(0);
        while (this.char()) {
            this.cursorChar = this.input.nextUtf8Char();
        }
        this.require('\"');
        this.ws();
    }

    private boolean char() {
        boolean bl;
        if ((1L << this.cursorChar & (long)(31 - this.cursorChar >> 31) & 0x7FFFFFFBEFFFFFFFL) != 0L) {
            bl = this.appendSB(this.cursorChar);
        } else {
            char c = this.cursorChar;
            switch (c) {
                default: {
                    if (c >= ' ' && this.appendSB(c)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case '\\': {
                    this.advance();
                    bl = this.escaped();
                    break;
                }
                case '\"': 
                case '\uffff': {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private boolean escaped() {
        boolean bl;
        char c = this.cursorChar;
        switch (c) {
            default: {
                throw this.fail("JSON escape sequence", this.fail$default$2(), this.fail$default$3());
            }
            case 'u': {
                this.advance();
                bl = this.unicode$1();
                break;
            }
            case 't': {
                bl = this.appendSB('\t');
                break;
            }
            case 'r': {
                bl = this.appendSB('\r');
                break;
            }
            case 'n': {
                bl = this.appendSB('\n');
                break;
            }
            case 'f': {
                bl = this.appendSB('\f');
                break;
            }
            case 'b': {
                bl = this.appendSB('\b');
                break;
            }
            case '\"': 
            case '/': 
            case '\\': {
                bl = this.appendSB(this.cursorChar);
            }
        }
        return bl;
    }

    private void ws() {
        while ((1L << this.cursorChar & (long)(this.cursorChar - 64 >> 31) & 0x100002600L) != 0L) {
            this.advance();
        }
    }

    private boolean ch(char c) {
        boolean bl;
        if (this.cursorChar == c) {
            this.advance();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean ws(char c) {
        boolean bl;
        if (this.ch(c)) {
            this.ws();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean advance() {
        this.cursorChar = this.input.nextChar();
        return true;
    }

    private boolean appendSB(char c) {
        this.sb.append(c);
        return true;
    }

    private void require(char c) {
        if (this.ch(c)) {
            return;
        }
        throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)c)})), this.fail$default$2(), this.fail$default$3());
    }

    private Nothing$ fail(String target, int cursor, char errorChar) {
        ParserInput.Line line = this.input.getLine(cursor);
        if (line != null) {
            String string;
            Tuple3 tuple3;
            int lineNr = line.lineNr();
            int col = line.column();
            String text = line.text();
            Tuple3 tuple32 = tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)lineNr), (Object)BoxesRunTime.boxToInteger((int)col), (Object)text);
            int lineNr2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
            int col2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
            String text2 = (String)tuple32._3();
            if (errorChar != '\uffff') {
                String c = Character.isISOControl(errorChar) ? new StringOps(Predef$.MODULE$.augmentString("\\u%04x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)errorChar)})) : ((Object)BoxesRunTime.boxToCharacter((char)errorChar)).toString();
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"character '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c}));
            } else {
                string = "end-of-input";
            }
            String unexpected = string;
            String summary = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected ", " at input index ", " (line ", ", position ", "), expected ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unexpected, BoxesRunTime.boxToInteger((int)cursor), BoxesRunTime.boxToInteger((int)lineNr2), BoxesRunTime.boxToInteger((int)col2), target}));
            String sanitizedText = (String)new StringOps(Predef$.MODULE$.augmentString(text2)).map((Function1)new Serializable(this){

                public final char apply(char c) {
                    return Character.isISOControl(c) ? (char)'?' : (char)c;
                }
            }, Predef$.MODULE$.StringCanBuildFrom());
            String detail = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n", "\\n", "^\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sanitizedText, new StringOps(Predef$.MODULE$.augmentString(" ")).$times(col2 - 1)}));
            throw new ParsingException(summary, detail);
        }
        throw new MatchError((Object)line);
    }

    private int fail$default$2() {
        return this.input.cursor();
    }

    private char fail$default$3() {
        return this.cursorChar;
    }

    private final void simpleValue$1(boolean matched, JsValue value, int mark$1) {
        if (matched) {
            this.jsValue = value;
            return;
        }
        throw this.fail("JSON Value", mark$1, this.fail$default$3());
    }

    private final void members$1(ObjectRef map$1) {
        do {
            this.string();
            this.require(':');
            this.ws();
            String key = this.sb.toString();
            this.value();
            map$1.elem = ((Map)map$1.elem).updated((Object)key, (Object)this.jsValue);
        } while (this.ws(','));
    }

    private final void values$1(ObjectRef list$1) {
        do {
            this.value();
            ((Builder)list$1.elem).$plus$eq((Object)this.jsValue);
        } while (this.ws(','));
    }

    private final int hexValue$1(char c) {
        block5: {
            int n;
            block3: {
                block4: {
                    block2: {
                        if ('0' > c || c > '9') break block2;
                        n = c - 48;
                        break block3;
                    }
                    if ('a' > c || c > 'f') break block4;
                    n = c - 87;
                    break block3;
                }
                if ('A' > c || c > 'F') break block5;
                n = c - 55;
            }
            return n;
        }
        throw this.fail("hex digit", this.fail$default$2(), this.fail$default$3());
    }

    private final boolean unicode$1() {
        int value = this.hexValue$1(this.cursorChar);
        this.advance();
        value = (value << 4) + this.hexValue$1(this.cursorChar);
        this.advance();
        value = (value << 4) + this.hexValue$1(this.cursorChar);
        this.advance();
        value = (value << 4) + this.hexValue$1(this.cursorChar);
        return this.appendSB((char)value);
    }

    public JsonParser(ParserInput input) {
        this.input = input;
        this.sb = new StringBuilder();
        this.cursorChar = input.nextChar();
    }

    public static class ParsingException
    extends RuntimeException {
        private final String summary;
        private final String detail;

        public String summary() {
            return this.summary;
        }

        public String detail() {
            return this.detail;
        }

        public ParsingException(String summary, String detail) {
            this.summary = summary;
            this.detail = detail;
            super(summary.isEmpty() ? detail : (detail.isEmpty() ? summary : new scala.collection.mutable.StringBuilder().append((Object)summary).append((Object)":").append((Object)detail).toString()));
        }
    }
}

