/*
 * Copyright © 2011-2013 the spray project <http://spray.io>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package spray.util
package pimps

import java.io.InputStream
import java.util.Arrays

class PimpedInputStream(underlying: InputStream) {

  def toByteArrayStream(chunkSize: Int): Stream[Array[Byte]] = {
    val buffer = new Array[Byte](chunkSize)
    val bytesRead = underlying.read(buffer)
    if (bytesRead > 0) {
      val bytes = if (bytesRead == buffer.length) buffer else Arrays.copyOfRange(buffer, 0, bytesRead)
      Stream.cons(bytes, toByteArrayStream(chunkSize))
    } else {
      underlying.close()
      Stream.Empty
    }
  }

}