/*
 * Copyright © 2011-2013 the spray project <http://spray.io>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package spray.util.pimps

import com.typesafe.config.Config
import scala.concurrent.duration.Duration

class PimpedConfig(underlying: Config) {

  def getDuration(path: String): Duration = underlying.getString(path) match {
    case "infinite" ⇒ Duration.Inf
    case x          ⇒ Duration(x)
  }

  def getPossiblyInfiniteInt(path: String): Int = underlying.getString(path) match {
    case "infinite" ⇒ Int.MaxValue
    case x          ⇒ underlying.getInt(path)
  }

  def getIntBytes(path: String): Int = {
    val value: Long = underlying getBytes path
    if (value <= Int.MaxValue) value.toInt
    else sys.error(s"Config setting '$path' must not be larger than ${Int.MaxValue}")
  }

  def getPossiblyInfiniteIntBytes(path: String): Int = underlying.getString(path) match {
    case "infinite" ⇒ Int.MaxValue
    case x          ⇒ getIntBytes(path)
  }
  def getPossiblyInfiniteLongBytes(path: String): Long = underlying.getString(path) match {
    case "infinite" ⇒ Long.MaxValue
    case x          ⇒ getIntBytes(path)
  }
}
