/*
 * Decompiled with CFR 0.152.
 */
package io.spring.develocity.conventions.maven;

import com.gradle.develocity.agent.maven.api.cache.BuildCacheApi;
import com.gradle.develocity.agent.maven.api.cache.LocalBuildCache;
import com.gradle.develocity.agent.maven.api.cache.RemoteBuildCache;
import io.spring.develocity.conventions.core.ConfigurableBuildCache;
import java.util.function.Consumer;

class MavenConfigurableBuildCache
implements ConfigurableBuildCache {
    private final BuildCacheApi buildCache;

    MavenConfigurableBuildCache(BuildCacheApi buildCache) {
        this.buildCache = buildCache;
    }

    public void local(Consumer<ConfigurableBuildCache.LocalBuildCache> local) {
        local.accept(new MavenLocalBuildCache(this.buildCache.getLocal()));
    }

    public void remote(Consumer<ConfigurableBuildCache.RemoteBuildCache> remote) {
        remote.accept(new MavenRemoteBuildCache(this.buildCache.getRemote()));
    }

    private static final class MavenRemoteBuildCache
    implements ConfigurableBuildCache.RemoteBuildCache {
        private final RemoteBuildCache remoteBuildCache;

        private MavenRemoteBuildCache(RemoteBuildCache remoteBuildCache) {
            this.remoteBuildCache = remoteBuildCache;
        }

        public void enable() {
            this.remoteBuildCache.setEnabled(true);
        }

        public void enablePush() {
            this.remoteBuildCache.setStoreEnabled(true);
        }

        public void setServer(String server) {
            String url = server;
            if (!url.endsWith("/cache/")) {
                url = url + "/cache/";
            }
            this.remoteBuildCache.getServer().setUrl(url);
        }
    }

    private static final class MavenLocalBuildCache
    implements ConfigurableBuildCache.LocalBuildCache {
        private final LocalBuildCache localBuildCache;

        private MavenLocalBuildCache(LocalBuildCache localBuildCache) {
            this.localBuildCache = localBuildCache;
        }

        public void enable() {
            this.localBuildCache.setEnabled(true);
        }
    }
}

