/*
 * Decompiled with CFR 0.152.
 */
package io.spring.develocity.conventions.maven;

import com.gradle.develocity.agent.maven.api.scan.BuildScanApi;
import com.gradle.develocity.agent.maven.api.scan.BuildScanPublishing;
import io.spring.develocity.conventions.core.ConfigurableBuildScan;
import java.net.InetAddress;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

class MavenConfigurableBuildScan
implements ConfigurableBuildScan {
    private final BuildScanApi buildScan;

    MavenConfigurableBuildScan(BuildScanApi buildScan) {
        this.buildScan = buildScan;
    }

    public void captureInputFiles(boolean capture) {
        this.buildScan.getCapture().setFileFingerprints(capture);
    }

    public void obfuscation(Consumer<ConfigurableBuildScan.ObfuscationConfigurer> configurer) {
        configurer.accept(new ConfigurableBuildScan.ObfuscationConfigurer(){

            public void ipAddresses(Function<? super List<InetAddress>, ? extends List<String>> obfuscator) {
                MavenConfigurableBuildScan.this.buildScan.getObfuscation().ipAddresses(obfuscator);
            }
        });
    }

    public void publishIfAuthenticated() {
        this.buildScan.getPublishing().onlyIf(BuildScanPublishing.PublishingContext::isAuthenticated);
    }

    public void uploadInBackground(boolean enabled) {
        this.buildScan.setUploadInBackground(enabled);
    }

    public void link(String name, String url) {
        this.buildScan.link(name, url);
    }

    public void tag(String tag) {
        this.buildScan.tag(tag);
    }

    public void value(String name, String value) {
        this.buildScan.value(name, value);
    }

    public void background(Consumer<ConfigurableBuildScan> backgroundConfigurer) {
        this.buildScan.background(backgrounded -> backgroundConfigurer.accept(new MavenConfigurableBuildScan((BuildScanApi)backgrounded)));
    }
}

