/*
 * Decompiled with CFR 0.152.
 */
package io.spring.develocity.conventions.maven;

import io.spring.develocity.conventions.core.ProcessRunner;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ProcessBuilderProcessRunner
implements ProcessRunner {
    ProcessBuilderProcessRunner() {
    }

    public void run(Consumer<ProcessRunner.ProcessSpec> configurer) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        ProcessBuilderProcessSpec spec = new ProcessBuilderProcessSpec(processBuilder);
        configurer.accept(spec);
        try {
            processBuilder.start().waitFor();
            Files.copy(spec.output, spec.outputStream);
        }
        catch (Exception ex) {
            throw new ProcessRunner.RunFailedException(ex);
        }
    }

    private static final class ProcessBuilderProcessSpec
    implements ProcessRunner.ProcessSpec {
        private final ProcessBuilder processBuilder;
        private final Path output;
        private OutputStream outputStream;

        private ProcessBuilderProcessSpec(ProcessBuilder processBuilder) {
            this.processBuilder = processBuilder;
            try {
                this.output = Files.createTempFile("output", "txt", new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public void commandLine(Object ... commandLine) {
            List<String> command = Stream.of(commandLine).map(Object::toString).collect(Collectors.toList());
            this.processBuilder.command(command);
        }

        public void standardOutput(OutputStream standardOutput) {
            this.processBuilder.redirectOutput(this.output.toFile());
            this.outputStream = standardOutput;
        }
    }
}

