/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.exclusions;

import io.spring.gradle.dependencymanagement.DependencyManagementConfigurationContainer;
import io.spring.gradle.dependencymanagement.exclusions.Exclusions;
import io.spring.gradle.dependencymanagement.maven.EffectiveModelBuilder;
import io.spring.gradle.dependencymanagement.maven.ModelExclusionCollector;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.Model;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.specs.Specs;

public class ExclusionResolver {
    private final DependencyHandler dependencyHandler;
    private final DependencyManagementConfigurationContainer configurationContainer;
    private final EffectiveModelBuilder effectiveModelBuilder;
    private final Map<String, Exclusions> exclusionsCache = new HashMap<String, Exclusions>();

    public ExclusionResolver(DependencyHandler dependencyHandler, DependencyManagementConfigurationContainer configurationContainer, EffectiveModelBuilder effectiveModelBuilder) {
        this.dependencyHandler = dependencyHandler;
        this.configurationContainer = configurationContainer;
        this.effectiveModelBuilder = effectiveModelBuilder;
    }

    public Map<String, Exclusions> resolveExclusions(Collection<ResolvedComponentResult> resolvedComponents) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        HashMap<String, Exclusions> exclusionsById = new HashMap<String, Exclusions>();
        for (ResolvedComponentResult resolvedComponent : resolvedComponents) {
            if (resolvedComponent.getId() instanceof ProjectComponentIdentifier || resolvedComponent.getModuleVersion().getGroup() == null || resolvedComponent.getModuleVersion().getName() == null) continue;
            String id = resolvedComponent.getModuleVersion().getGroup() + ":" + resolvedComponent.getModuleVersion().getName();
            Exclusions exclusions = this.exclusionsCache.get(id);
            if (exclusions != null) {
                exclusionsById.put(id, exclusions);
                continue;
            }
            dependencies.add(this.dependencyHandler.create((Object)(id + ":" + resolvedComponent.getModuleVersion().getVersion() + "@pom")));
        }
        Configuration configuration = this.configurationContainer.newConfiguration(dependencies.toArray(new Dependency[dependencies.size()]));
        ModelExclusionCollector exclusionsCollector = new ModelExclusionCollector();
        for (ResolvedArtifact resolvedArtifact : configuration.getResolvedConfiguration().getLenientConfiguration().getArtifacts(Specs.SATISFIES_ALL)) {
            ModuleVersionIdentifier moduleId = resolvedArtifact.getModuleVersion().getId();
            File pom = resolvedArtifact.getFile();
            Model model = this.effectiveModelBuilder.buildModel(pom);
            Exclusions exclusions = (Exclusions)exclusionsCollector.collectExclusions(model);
            String id = moduleId.getGroup() + ":" + moduleId.getName();
            this.exclusionsCache.put(id, exclusions);
            exclusionsById.put(id, exclusions);
        }
        return exclusionsById;
    }
}

