/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;

public class DependencyManagementConfigurationContainer {
    private final List<Action<Configuration>> actions = new ArrayList<Action<Configuration>>();
    private final ConfigurationContainer delegate;

    public DependencyManagementConfigurationContainer(Project project) {
        this.delegate = project.getConfigurations();
    }

    public Configuration newConfiguration(Dependency ... dependencies) {
        return this.newConfiguration((ConfigurationConfigurer)null, dependencies);
    }

    Configuration newConfiguration(ConfigurationConfigurer configurer, Dependency ... dependencies) {
        Configuration configuration = this.delegate.detachedConfiguration(dependencies);
        if (configurer != null) {
            configurer.configure(configuration);
        }
        for (Action<Configuration> action : this.actions) {
            action.execute((Object)configuration);
        }
        return configuration;
    }

    public void apply(Action<Configuration> action) {
        this.actions.add(action);
    }

    public static interface ConfigurationConfigurer {
        public void configure(Configuration var1);
    }
}

