/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal;

import io.spring.gradle.dependencymanagement.internal.DependencyManagementConfigurationContainer;
import io.spring.gradle.dependencymanagement.internal.DependencyManagementContainer;
import io.spring.gradle.dependencymanagement.internal.DependencyManagementSettings;
import io.spring.gradle.dependencymanagement.internal.ExclusionResolver;
import io.spring.gradle.dependencymanagement.internal.Exclusions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExclusionConfiguringAction
implements Action<ResolvableDependencies> {
    private static final Logger logger = LoggerFactory.getLogger(ExclusionConfiguringAction.class);
    private final DependencyManagementSettings dependencyManagementSettings;
    private final DependencyManagementContainer dependencyManagementContainer;
    private final DependencyManagementConfigurationContainer configurationContainer;
    private final Configuration configuration;
    private final ExclusionResolver exclusionResolver;
    private final DependencyManagementConfigurationContainer.ConfigurationConfigurer configurationConfigurer;

    ExclusionConfiguringAction(DependencyManagementSettings dependencyManagementSettings, DependencyManagementContainer dependencyManagementContainer, DependencyManagementConfigurationContainer configurationContainer, Configuration configuration, ExclusionResolver exclusionResolver, DependencyManagementConfigurationContainer.ConfigurationConfigurer configurationConfigurer) {
        this.dependencyManagementSettings = dependencyManagementSettings;
        this.dependencyManagementContainer = dependencyManagementContainer;
        this.configurationContainer = configurationContainer;
        this.configuration = configuration;
        this.exclusionResolver = exclusionResolver;
        this.configurationConfigurer = configurationConfigurer;
    }

    public void execute(ResolvableDependencies resolvableDependencies) {
        if (this.dependencyManagementSettings.isApplyMavenExclusions()) {
            this.applyMavenExclusions(resolvableDependencies);
        }
    }

    private void applyMavenExclusions(ResolvableDependencies resolvableDependencies) {
        Set<DependencyCandidate> excludedDependencies = this.findExcludedDependencies();
        if (logger.isInfoEnabled()) {
            logger.info("Excluding " + excludedDependencies);
        }
        ArrayList exclusions = new ArrayList();
        for (DependencyCandidate excludedDependency : excludedDependencies) {
            HashMap<String, String> exclusion = new HashMap<String, String>();
            exclusion.put("group", excludedDependency.groupId);
            exclusion.put("module", excludedDependency.artifactId);
            exclusions.add(exclusion);
        }
        for (Dependency dependency : resolvableDependencies.getDependencies()) {
            if (!(dependency instanceof ModuleDependency)) continue;
            for (Map map : exclusions) {
                ((ModuleDependency)dependency).exclude(map);
            }
        }
    }

    private Set<DependencyCandidate> findExcludedDependencies() {
        DependencySet allDependencies = this.configuration.getAllDependencies();
        Configuration configurationCopy = this.configurationContainer.newConfiguration(this.configurationConfigurer, (Dependency[])allDependencies.toArray((Object[])new Dependency[allDependencies.size()]));
        ResolutionResult resolutionResult = configurationCopy.getIncoming().getResolutionResult();
        ResolvedComponentResult root = resolutionResult.getRoot();
        final HashSet<DependencyCandidate> excludedDependencies = new HashSet<DependencyCandidate>();
        resolutionResult.allDependencies((Action)new Action<DependencyResult>(){

            public void execute(DependencyResult dependencyResult) {
                DependencyCandidate dependencyCandidate;
                if (dependencyResult instanceof ResolvedDependencyResult) {
                    ResolvedDependencyResult resolved = (ResolvedDependencyResult)dependencyResult;
                    excludedDependencies.add(new DependencyCandidate(resolved.getSelected().getModuleVersion().getGroup(), resolved.getSelected().getModuleVersion().getName()));
                } else if (dependencyResult instanceof UnresolvedDependencyResult && (dependencyCandidate = ExclusionConfiguringAction.this.toDependencyCandidate((UnresolvedDependencyResult)dependencyResult)) != null) {
                    excludedDependencies.add(dependencyCandidate);
                }
            }
        });
        Set<DependencyCandidate> includedDependencies = this.determineIncludedComponents(root, this.exclusionResolver.resolveExclusions(resolutionResult.getAllComponents()));
        excludedDependencies.removeAll(includedDependencies);
        return excludedDependencies;
    }

    private Set<DependencyCandidate> determineIncludedComponents(ResolvedComponentResult root, Map<String, Exclusions> pomExclusionsById) {
        LinkedList<Node> queue = new LinkedList<Node>();
        queue.add(new Node(root, this.getId(root), new HashSet()));
        HashSet<ResolvedComponentResult> seen = new HashSet<ResolvedComponentResult>();
        HashSet<DependencyCandidate> includedComponents = new HashSet<DependencyCandidate>();
        while (!queue.isEmpty()) {
            Node node = (Node)queue.remove();
            includedComponents.add(new DependencyCandidate(node.component.getModuleVersion().getGroup(), node.component.getModuleVersion().getName()));
            for (DependencyResult dependency : node.component.getDependencies()) {
                if (dependency instanceof ResolvedDependencyResult) {
                    this.handleResolvedDependency((ResolvedDependencyResult)dependency, node, pomExclusionsById, queue, seen);
                    continue;
                }
                if (!(dependency instanceof UnresolvedDependencyResult)) continue;
                this.handleUnresolvedDependency((UnresolvedDependencyResult)dependency, node, includedComponents);
            }
        }
        return includedComponents;
    }

    private void handleResolvedDependency(ResolvedDependencyResult dependency, Node node, Map<String, Exclusions> pomExclusionsById, LinkedList<Node> queue, Set<ResolvedComponentResult> seen) {
        ResolvedComponentResult child = dependency.getSelected();
        String childId = this.getId(child);
        if (!node.excluded(childId) && seen.add(child)) {
            queue.add(new Node(child, childId, this.getChildExclusions(node, childId, pomExclusionsById)));
        }
    }

    private void handleUnresolvedDependency(UnresolvedDependencyResult dependency, Node node, Set<DependencyCandidate> includedComponents) {
        DependencyCandidate dependencyCandidate = this.toDependencyCandidate(dependency);
        if (dependencyCandidate != null && !node.excluded(dependencyCandidate.groupId + ":" + dependencyCandidate.artifactId)) {
            includedComponents.add(dependencyCandidate);
        }
    }

    private DependencyCandidate toDependencyCandidate(UnresolvedDependencyResult unresolved) {
        ComponentSelector attemptedSelector = unresolved.getAttempted();
        if (!(attemptedSelector instanceof ModuleComponentSelector)) {
            return null;
        }
        ModuleComponentSelector attemptedModuleSelector = (ModuleComponentSelector)attemptedSelector;
        return new DependencyCandidate(attemptedModuleSelector.getGroup(), attemptedModuleSelector.getModule());
    }

    private Set<String> getChildExclusions(Node parent, String childId, Map<String, Exclusions> pomExclusionsById) {
        HashSet<String> childExclusions = new HashSet<String>(parent.exclusions);
        this.addAllIfPossible(childExclusions, this.dependencyManagementContainer.getExclusions(this.configuration).exclusionsForDependency(childId));
        Exclusions exclusionsInPom = pomExclusionsById.get(parent.id);
        if (exclusionsInPom != null) {
            this.addAllIfPossible(childExclusions, exclusionsInPom.exclusionsForDependency(childId));
        }
        return childExclusions;
    }

    private void addAllIfPossible(Set<String> current, Set<String> addition) {
        if (addition != null) {
            current.addAll(addition);
        }
    }

    private String getId(ResolvedComponentResult component) {
        return component.getModuleVersion().getGroup() + ":" + component.getModuleVersion().getName();
    }

    private static final class DependencyCandidate {
        private final String groupId;
        private final String artifactId;

        private DependencyCandidate(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DependencyCandidate that = (DependencyCandidate)o;
            if (!this.groupId.equals(that.groupId)) {
                return false;
            }
            return this.artifactId.equals(that.artifactId);
        }

        public int hashCode() {
            int result = this.groupId.hashCode();
            result = 31 * result + this.artifactId.hashCode();
            return result;
        }

        public String toString() {
            return this.groupId + ":" + this.artifactId;
        }
    }

    private static final class Node {
        private final ResolvedComponentResult component;
        private final String id;
        private final Set<String> exclusions;

        private Node(ResolvedComponentResult component, String id, Set<String> exclusions) {
            this.component = component;
            this.id = id;
            this.exclusions = exclusions;
        }

        private boolean excluded(String id) {
            return this.exclusions != null && this.exclusions.contains(id);
        }
    }
}

