/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.org.eclipse.sisu.launch;

import io.spring.gradle.dependencymanagement.org.eclipse.sisu.inject.DefaultBeanLocator;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.inject.MutableBeanLocator;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.inject.Weak;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.launch.SisuTracker;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.osgi.ServiceBindings;
import io.spring.gradle.dependencymanagement.org.osgi.framework.BundleActivator;
import io.spring.gradle.dependencymanagement.org.osgi.framework.BundleContext;
import java.util.Collections;
import java.util.Map;

public class SisuExtender
implements BundleActivator {
    private static final Map<Long, MutableBeanLocator> locators = Collections.synchronizedMap(Weak.values());
    protected SisuTracker tracker;

    public void start(BundleContext context) {
        this.tracker = this.createTracker(context);
        this.tracker.open();
    }

    public void stop(BundleContext context) {
        this.tracker.close();
        this.tracker = null;
    }

    protected int bundleStateMask() {
        return 40;
    }

    protected SisuTracker createTracker(BundleContext context) {
        return new SisuTracker(context, this.bundleStateMask(), this.findLocator(context));
    }

    protected MutableBeanLocator createLocator(BundleContext context) {
        DefaultBeanLocator locator = new DefaultBeanLocator();
        locator.add(new ServiceBindings(context));
        return locator;
    }

    protected final MutableBeanLocator findLocator(BundleContext context) {
        Long extenderId = context.getBundle().getBundleId();
        MutableBeanLocator locator = locators.get(extenderId);
        if (locator == null) {
            locator = this.createLocator(context);
            locators.put(extenderId, locator);
        }
        return locator;
    }
}

