/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.nullability;

import io.spring.gradle.nullability.NullabilityPluginExtension;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.ltgt.gradle.errorprone.ErrorProneOptions;
import net.ltgt.gradle.errorprone.ErrorPronePlugin;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;

public class NullabilityPlugin
implements Plugin<Project> {
    private static final Pattern COMPILE_MAIN_SOURCES_TASK_NAME = Pattern.compile("compile(\\d+)?Java");

    public void apply(Project project) {
        NullabilityPluginExtension nullability = (NullabilityPluginExtension)project.getExtensions().create("nullability", NullabilityPluginExtension.class, new Object[0]);
        project.getPlugins().apply(ErrorPronePlugin.class);
        this.configureDependencies(project, nullability);
        this.configureJavaCompilation(project);
    }

    private void configureDependencies(Project project, NullabilityPluginExtension nullability) {
        project.getConfigurations().getByName("errorprone");
        project.getDependencies().add("errorprone", (Object)nullability.getErrorProneVersion().map(version -> "com.google.errorprone:error_prone_core:" + version));
        project.getDependencies().add("errorprone", (Object)nullability.getNullAwayVersion().map(version -> "com.uber.nullaway:nullaway:" + version));
    }

    private void configureJavaCompilation(Project project) {
        project.getTasks().withType(JavaCompile.class).configureEach(javaCompile -> {
            if (this.compilesMainSources((JavaCompile)javaCompile)) {
                this.configureErrorProne((JavaCompile)javaCompile);
            } else {
                this.disableErrorProne((JavaCompile)javaCompile);
            }
        });
    }

    private boolean compilesMainSources(JavaCompile compileTask) {
        return COMPILE_MAIN_SOURCES_TASK_NAME.matcher(compileTask.getName()).matches();
    }

    private void configureErrorProne(JavaCompile javaCompile) {
        this.errorProneOptions(javaCompile, options -> {
            options.getDisableAllChecks().set((Object)true);
            options.option("NullAway:OnlyNullMarked", "true");
            options.option("NullAway:CustomContractAnnotations", "org.springframework.lang.Contract");
            options.option("NullAway:JSpecifyMode", "true");
            options.error(new String[]{"NullAway"});
        });
    }

    private void disableErrorProne(JavaCompile javaCompile) {
        this.errorProneOptions(javaCompile, errorProneOptions -> errorProneOptions.getEnabled().set((Object)false));
    }

    private void errorProneOptions(JavaCompile compileTask, Consumer<ErrorProneOptions> optionsConsumer) {
        CompileOptions options = compileTask.getOptions();
        ErrorProneOptions errorProneOptions = (ErrorProneOptions)((ExtensionAware)options).getExtensions().getByType(ErrorProneOptions.class);
        optionsConsumer.accept(errorProneOptions);
    }
}

