/*
 * Decompiled with CFR 0.152.
 */
package com.github.api;

import com.github.api.Issue;
import com.github.api.Milestone;
import com.github.api.Release;
import com.github.api.Repository;
import com.github.api.User;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import shaded.com.fasterxml.jackson.annotation.JsonInclude;
import shaded.com.fasterxml.jackson.core.JsonProcessingException;
import shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import shaded.com.fasterxml.jackson.databind.ObjectMapper;
import shaded.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;

public class GitHubApi {
    private final HttpClient httpClient = HttpClient.newHttpClient();
    private final ObjectMapper objectMapper = GitHubApi.getObjectMapper();
    private final String baseUrl;
    private final String accessToken;

    public GitHubApi(String accessToken) {
        this("https://api.github.com", accessToken);
    }

    public GitHubApi(String baseUrl, String accessToken) {
        this.baseUrl = baseUrl;
        this.accessToken = accessToken;
    }

    private static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setDefaultPropertyInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.registerModule(new JavaTimeModule());
        return objectMapper;
    }

    public User getUser() {
        HttpRequest httpRequest = this.requestBuilder("/user").GET().build();
        return this.performRequest(httpRequest, User.class);
    }

    public void createRelease(Repository repository, Release release) {
        String uri = "/repos/%s/%s/releases".formatted(repository.owner(), repository.name());
        HttpRequest httpRequest = this.requestBuilder(uri).header("Content-Type", "application/json").POST(this.bodyValue(release)).build();
        this.performRequest(httpRequest, Void.class);
    }

    public void createMilestone(Repository repository, Milestone milestone) {
        String uri = "/repos/%s/%s/milestones".formatted(repository.owner(), repository.name());
        HttpRequest httpRequest = this.requestBuilder(uri).header("Content-Type", "application/json").POST(this.bodyValue(milestone)).build();
        this.performRequest(httpRequest, Void.class);
    }

    public List<Milestone> getMilestones(Repository repository) {
        String uri = "/repos/%s/%s/milestones?per_page=100".formatted(repository.owner(), repository.name());
        HttpRequest httpRequest = this.requestBuilder(uri).GET().build();
        return new ArrayList<Milestone>(Arrays.asList(this.performRequest(httpRequest, Milestone[].class)));
    }

    public Milestone getMilestone(Repository repository, String title) {
        Milestone[] milestones;
        String uri = "/repos/%s/%s/milestones?per_page=100".formatted(repository.owner(), repository.name());
        HttpRequest httpRequest = this.requestBuilder(uri).GET().build();
        for (Milestone m : milestones = this.performRequest(httpRequest, Milestone[].class)) {
            if (!m.title().equals(title)) continue;
            return m;
        }
        return null;
    }

    public void closeMilestone(Repository repository, Long milestone) {
        String uri = "/repos/%s/%s/milestones/%s".formatted(repository.owner(), repository.name(), milestone);
        Map<String, String> request = Map.of("state", "closed");
        HttpRequest httpRequest = this.requestBuilder(uri).method("PATCH", this.bodyValue(request)).build();
        this.performRequest(httpRequest, Void.class);
    }

    public boolean hasOpenIssues(Repository repository, Long milestone) {
        String uri = "/repos/%s/%s/issues?per_page=1&milestone=%s".formatted(repository.owner(), repository.name(), milestone);
        HttpRequest httpRequest = this.requestBuilder(uri).GET().build();
        Issue[] issues = this.performRequest(httpRequest, Issue[].class);
        return issues.length > 0;
    }

    private HttpRequest.Builder requestBuilder(String uri) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(this.baseUrl + uri).normalize()).header("Accept", "application/json").header("X-GitHub-Api-Version", "2022-11-28");
        if (this.accessToken != null) {
            builder.setHeader("Authorization", "Bearer %s".formatted(this.accessToken));
        }
        return builder;
    }

    private <T> T performRequest(HttpRequest httpRequest, Class<T> responseType) {
        try {
            HttpResponse<String> httpResponse = this.httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            if (httpResponse.statusCode() >= 300) {
                throw new HttpClientException(httpResponse.statusCode(), httpResponse.body());
            }
            String responseBody = Void.class.isAssignableFrom(responseType) ? "null" : httpResponse.body();
            return this.objectMapper.readValue(responseBody, responseType);
        }
        catch (IOException | InterruptedException ex) {
            throw new RuntimeException("Unable to perform request:", ex);
        }
    }

    private <T> HttpRequest.BodyPublisher bodyValue(T body) {
        try {
            return HttpRequest.BodyPublishers.ofString(this.objectMapper.writeValueAsString(body));
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Unable to serialize json:", ex);
        }
    }

    public static class HttpClientException
    extends RuntimeException {
        private final int statusCode;
        private final String responseBody;

        private HttpClientException(int statusCode, String responseBody) {
            super(statusCode + "[" + responseBody + "]");
            this.statusCode = statusCode;
            this.responseBody = responseBody;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getResponseBody() {
            return this.responseBody;
        }

        @Override
        public String toString() {
            return this.statusCode + "[" + this.responseBody + "]";
        }
    }
}

