/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.plugin.release;

import io.spring.gradle.plugin.core.ProjectUtils;
import io.spring.gradle.plugin.core.RegularFileUtils;
import io.spring.gradle.plugin.release.GetGitHubUserNameTask;
import io.spring.gradle.plugin.release.GetNextReleaseMilestoneTask;
import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;

public abstract class GenerateChangelogTask
extends JavaExec {
    public static final String TASK_NAME = "generateChangelog";
    private static final String GENERATE_CHANGELOG_CONFIGURATION = "changelogGenerator";
    private static final String GENERATE_CHANGELOG_PATH = "changelog/release-notes.md";
    private static final String GENERATE_CHANGELOG_DEPENDENCY = "spring-io:github-changelog-generator:0.0.8";
    private static final String GENERATE_CHANGELOG_REPO_LAYOUT = "[organization]/[artifact]/releases/download/v[revision]/[artifact].[ext]";
    private static final String GENERATE_CHANGELOG_REPO_URL = "https://github.com/";
    private static final String GENERATE_CHANGELOG_GROUP = "spring-io";

    @Input
    public abstract Property<String> getVersion();

    @Input
    @Optional
    public abstract Property<String> getUsername();

    @Input
    @Optional
    public abstract Property<String> getPassword();

    @OutputFile
    public abstract RegularFileProperty getReleaseNotesFile();

    public void exec() {
        String version = (String)this.getVersion().get();
        String username = (String)this.getUsername().getOrNull();
        String password = (String)this.getPassword().getOrNull();
        File outputFile = (File)this.getReleaseNotesFile().getAsFile().get();
        File parent = outputFile.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IllegalStateException("Unable to create " + outputFile);
        }
        this.args(new Object[]{"--spring.config.location=scripts/release/release-notes-sections.yml"});
        if (username != null && password != null) {
            this.args(new Object[]{"--github.username=" + username, "--github.password=" + password});
        }
        this.args(new Object[]{version, outputFile.toString()});
        super.exec();
    }

    public static void register(Project project) {
        GenerateChangelogTask.createGenerateChangelogConfiguration(project);
        GenerateChangelogTask.createGenerateChangelogRepository(project);
        project.getTasks().register(TASK_NAME, GenerateChangelogTask.class, task -> {
            task.setGroup("Release");
            task.setDescription("Generate the release notes (changelog) for a milestone.");
            task.doNotTrackState("API call to GitHub needs to check for open issues every time");
            task.setWorkingDir(project.getRootDir());
            task.classpath(new Object[]{project.getConfigurations().getAt(GENERATE_CHANGELOG_CONFIGURATION)});
            Provider versionProvider = ProjectUtils.getProperty(project, "nextVersion").orElse(ProjectUtils.findTaskByType(project, GetNextReleaseMilestoneTask.class).getNextReleaseMilestoneFile().map(RegularFileUtils::readString));
            task.getVersion().set(versionProvider);
            if (project.hasProperty("gitHubAccessToken")) {
                Provider usernameProvider = ProjectUtils.getProperty(project, "gitHubUserName").orElse(ProjectUtils.findTaskByType(project, GetGitHubUserNameTask.class).getUsernameFile().map(RegularFileUtils::readString));
                task.getUsername().set(usernameProvider);
                task.getPassword().set(ProjectUtils.getProperty(project, "gitHubAccessToken"));
            }
            task.getReleaseNotesFile().set(project.getLayout().getBuildDirectory().file(GENERATE_CHANGELOG_PATH));
        });
    }

    private static void createGenerateChangelogConfiguration(Project project) {
        project.getConfigurations().create(GENERATE_CHANGELOG_CONFIGURATION, configuration -> configuration.defaultDependencies(dependencies -> dependencies.add((Object)project.getDependencies().create((Object)GENERATE_CHANGELOG_DEPENDENCY))));
    }

    private static void createGenerateChangelogRepository(Project project) {
        IvyArtifactRepository repository = project.getRepositories().ivy(repo -> {
            repo.setUrl((Object)GENERATE_CHANGELOG_REPO_URL);
            repo.patternLayout(layout -> layout.artifact(GENERATE_CHANGELOG_REPO_LAYOUT));
            repo.getMetadataSources().artifact();
        });
        project.getRepositories().exclusiveContent(exclusiveContentRepository -> {
            exclusiveContentRepository.forRepositories(new ArtifactRepository[]{repository});
            exclusiveContentRepository.filter(descriptor -> descriptor.includeGroup(GENERATE_CHANGELOG_GROUP));
        });
    }
}

