/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.plugin.release;

import io.spring.gradle.plugin.release.CheckBranchHasCommercialSupportTask;
import io.spring.gradle.plugin.release.CheckBranchHasOssSupportTask;
import io.spring.gradle.plugin.release.CheckMilestoneHasOpenIssuesTask;
import io.spring.gradle.plugin.release.CheckMilestoneIsDueTodayTask;
import io.spring.gradle.plugin.release.CloseMilestoneTask;
import io.spring.gradle.plugin.release.CreateGitHubReleaseTask;
import io.spring.gradle.plugin.release.CreateReleaseTask;
import io.spring.gradle.plugin.release.CreateSaganReleaseTask;
import io.spring.gradle.plugin.release.DeleteSaganReleaseTask;
import io.spring.gradle.plugin.release.GenerateChangelogTask;
import io.spring.gradle.plugin.release.GetGitHubUserNameTask;
import io.spring.gradle.plugin.release.GetNextReleaseMilestoneTask;
import io.spring.gradle.plugin.release.GetNextSnapshotVersionTask;
import io.spring.gradle.plugin.release.GetPreviousReleaseMilestoneTask;
import io.spring.gradle.plugin.release.ScheduleNextReleaseTask;
import io.spring.gradle.plugin.release.SpringReleasePluginExtension;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class SpringReleasePlugin
implements Plugin<Project> {
    static final String TASK_GROUP = "Release";
    static final String EXTENSION_NAME = "springRelease";
    static final String GITHUB_USER_NAME_PROPERTY = "gitHubUserName";
    static final String GITHUB_ACCESS_TOKEN_PROPERTY = "gitHubAccessToken";
    static final String PREVIOUS_VERSION_PROPERTY = "previousVersion";
    static final String NEXT_VERSION_PROPERTY = "nextVersion";
    static final String CURRENT_VERSION_PROPERTY = "currentVersion";
    static final String CREATE_RELEASE_PROPERTY = "createRelease";
    static final String BRANCH_PROPERTY = "branch";

    public void apply(Project project) {
        SpringReleasePluginExtension springRelease = (SpringReleasePluginExtension)project.getExtensions().create(EXTENSION_NAME, SpringReleasePluginExtension.class, new Object[0]);
        springRelease.getRepositoryOwner().convention((Object)"spring-projects");
        springRelease.getRepositoryName().convention((Object)project.getRootProject().getName());
        springRelease.getReplaceSnapshotVersionInReferenceDocUrl().convention((Object)false);
        springRelease.getReleaseVersionPrefix().convention((Object)"");
        GetGitHubUserNameTask.register(project);
        DeleteSaganReleaseTask.register(project);
        GetPreviousReleaseMilestoneTask.register(project);
        GetNextReleaseMilestoneTask.register(project);
        GetNextSnapshotVersionTask.register(project);
        GenerateChangelogTask.register(project);
        CreateReleaseTask.register(project);
        CreateGitHubReleaseTask.register(project);
        CreateSaganReleaseTask.register(project);
        CheckMilestoneHasOpenIssuesTask.register(project);
        CheckMilestoneIsDueTodayTask.register(project);
        CheckBranchHasOssSupportTask.register(project);
        CheckBranchHasCommercialSupportTask.register(project);
        ScheduleNextReleaseTask.register(project);
        CloseMilestoneTask.register(project);
    }
}

