/*
 * Decompiled with CFR 0.152.
 */
package io.spring.release;

import com.github.api.GitHubApi;
import com.github.api.Milestone;
import com.github.api.Release;
import com.github.api.Repository;
import io.spring.api.Generation;
import io.spring.api.SaganApi;
import io.spring.release.SpringReleaseTrain;
import io.spring.release.SpringReleaseTrainSpec;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SpringReleases {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^([0-9]+)\\.([0-9]+)\\.([0-9]+)(-.+)?$");
    private final GitHubApi gitHubApi;
    private final SaganApi saganApi;

    public SpringReleases(String accessToken) {
        this.gitHubApi = new GitHubApi(accessToken);
        this.saganApi = accessToken != null ? new SaganApi(this.gitHubApi.getUser().login(), accessToken) : new SaganApi("anonymous", "invalid");
    }

    public SpringReleases(GitHubApi gitHubApi, SaganApi saganApi) {
        this.gitHubApi = gitHubApi;
        this.saganApi = saganApi;
    }

    public String getNextReleaseMilestone(String owner, String repo, String version) {
        List<Milestone> milestones;
        String nextPreRelease;
        Matcher versionMatcher = SpringReleases.versionMatcher(version);
        if (!Objects.equals(versionMatcher.group(4), "-SNAPSHOT")) {
            return version;
        }
        String major = versionMatcher.group(1);
        String minor = versionMatcher.group(2);
        String patch = versionMatcher.group(3);
        String baseVersion = "%s.%s.%s".formatted(major, minor, patch);
        if (patch.equals("0") && (nextPreRelease = SpringReleases.getNextPreRelease(baseVersion, milestones = this.gitHubApi.getMilestones(new Repository(owner, repo)))) != null) {
            return nextPreRelease;
        }
        return baseVersion;
    }

    public String getPreviousReleaseMilestone(String repo, String version) {
        Matcher versionMatcher = SpringReleases.versionMatcher(version);
        String major = versionMatcher.group(1);
        String minor = versionMatcher.group(2);
        boolean versionIsSnapshot = Objects.equals(versionMatcher.group(4), "-SNAPSHOT");
        List<io.spring.api.Release> releases = this.saganApi.getReleases(repo);
        releases.removeIf(candidate -> {
            Matcher matcher = SpringReleases.versionMatcher(candidate.version());
            String candidateMajor = matcher.group(1);
            String candidateMinor = matcher.group(2);
            boolean candidateIsSnapshot = Objects.equals(matcher.group(4), "-SNAPSHOT");
            return versionIsSnapshot != candidateIsSnapshot || !candidateMajor.equals(major) || !candidateMinor.equals(minor);
        });
        return releases.size() == 1 ? releases.get(0).version() : null;
    }

    public boolean hasOpenIssues(String owner, String repo, String version) {
        Repository repository = new Repository(owner, repo);
        Milestone milestone = this.gitHubApi.getMilestone(repository, version);
        return this.gitHubApi.hasOpenIssues(repository, milestone.number());
    }

    public boolean isDueToday(String owner, String repo, String version) {
        LocalDate dueOn;
        Repository repository = new Repository(owner, repo);
        Milestone milestone = this.gitHubApi.getMilestone(repository, version);
        if (milestone == null || milestone.dueOn() == null) {
            return false;
        }
        LocalDate today = LocalDate.now();
        return !today.isBefore(dueOn = milestone.dueOn().atZone(ZoneOffset.UTC).toLocalDate());
    }

    public boolean hasOssSupport(String repo, String branch) {
        Generation generation;
        if (branch.equals("main")) {
            return true;
        }
        LocalDate today = LocalDate.now();
        return !today.isBefore((generation = this.saganApi.getGeneration(repo, branch)).initialReleaseDate()) && !today.isAfter(generation.ossSupportEndDate());
    }

    public boolean hasCommercialSupport(String repo, String branch) {
        Generation generation;
        if (branch.equals("main")) {
            return false;
        }
        LocalDate today = LocalDate.now();
        return today.isAfter((generation = this.saganApi.getGeneration(repo, branch)).ossSupportEndDate()) && !today.isAfter(generation.commercialSupportEndDate());
    }

    public void closeMilestone(String owner, String repo, String version) {
        Repository repository = new Repository(owner, repo);
        Milestone milestone = this.gitHubApi.getMilestone(repository, version);
        this.gitHubApi.closeMilestone(repository, milestone.number());
    }

    public void createRelease(String owner, String repo, String version, String branch, String body, String referenceDocUrl, String apiDocUrl) {
        Repository repository = new Repository(owner, repo);
        this.gitHubApi.createRelease(repository, SpringReleases.gitHubRelease(version, branch, body));
        this.saganApi.createRelease(repo, SpringReleases.saganRelease(version, referenceDocUrl, apiDocUrl));
    }

    public void createGitHubRelease(String owner, String repo, String version, String branch, String body) {
        Repository repository = new Repository(owner, repo);
        this.gitHubApi.createRelease(repository, SpringReleases.gitHubRelease(version, branch, body));
    }

    public void createSaganRelease(String repo, String version, String referenceDocUrl, String apiDocUrl) {
        this.saganApi.createRelease(repo, SpringReleases.saganRelease(version, referenceDocUrl, apiDocUrl));
    }

    public void deleteRelease(String repo, String version) {
        this.saganApi.deleteRelease(repo, version);
    }

    public void scheduleReleaseIfNotExists(String owner, String repo, String version, int weekOfMonth, int dayOfWeek) {
        Matcher versionMatcher = SpringReleases.versionMatcher(version);
        String major = versionMatcher.group(1);
        String minor = versionMatcher.group(2);
        String patch = versionMatcher.group(3);
        String suffix = versionMatcher.group(4);
        if (suffix != null && !Objects.equals(suffix, "-SNAPSHOT")) {
            return;
        }
        Repository repository = new Repository(owner, repo);
        String baseVersion = "%s.%s.%s".formatted(major, minor, patch);
        if (this.gitHubApi.getMilestone(repository, baseVersion) != null) {
            return;
        }
        SpringReleaseTrainSpec releaseTrainSpec = SpringReleaseTrainSpec.builder().nextTrain().version(baseVersion).weekOfMonth(dayOfWeek).dayOfWeek(weekOfMonth).build();
        SpringReleaseTrain releaseTrain = new SpringReleaseTrain(releaseTrainSpec);
        if (baseVersion.endsWith(".0")) {
            releaseTrain.getTrainDates().forEach((milestoneTitle, dueOn) -> {
                Milestone milestone = new Milestone((String)milestoneTitle, null, dueOn.atTime(LocalTime.NOON).toInstant(ZoneOffset.UTC));
                this.gitHubApi.createMilestone(repository, milestone);
            });
        } else {
            LocalDate startDate = LocalDate.now();
            LocalDate dueOn2 = releaseTrain.getNextReleaseDate(startDate);
            Milestone milestone = new Milestone(baseVersion, null, dueOn2.atTime(LocalTime.NOON).toInstant(ZoneOffset.UTC));
            this.gitHubApi.createMilestone(repository, milestone);
        }
    }

    public static String getNextSnapshotVersion(String version) {
        Matcher versionMatcher = SpringReleases.versionMatcher(version);
        if (Objects.equals(versionMatcher.group(4), "-SNAPSHOT")) {
            return version;
        }
        String major = versionMatcher.group(1);
        String minor = versionMatcher.group(2);
        String patch = versionMatcher.group(3);
        String modifier = versionMatcher.group(4);
        if (modifier == null) {
            patch = String.valueOf(Integer.parseInt(patch) + 1);
        }
        return "%s.%s.%s-SNAPSHOT".formatted(major, minor, patch);
    }

    private static String getNextPreRelease(String baseVersion, List<Milestone> milestones) {
        String versionPrefix = baseVersion + "-";
        return milestones.stream().filter(milestone -> milestone.title().startsWith(versionPrefix)).sorted(Comparator.comparing(Milestone::dueOn)).map(Milestone::title).findFirst().orElse(null);
    }

    private static Release gitHubRelease(String version, String branch, String body) {
        return Release.tag(version).commit(branch).name(version).body(body).preRelease(version.contains("-")).build();
    }

    private static io.spring.api.Release saganRelease(String version, String referenceDocUrl, String apiDocUrl) {
        return new io.spring.api.Release(version, referenceDocUrl, apiDocUrl, null, false);
    }

    public static Matcher versionMatcher(String version) {
        Matcher versionMatcher = VERSION_PATTERN.matcher(version);
        if (!versionMatcher.find()) {
            throw new IllegalArgumentException("Given version is not a valid version: %s".formatted(version));
        }
        return versionMatcher;
    }
}

