/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.actuate.autoconfigure;

import io.spring.initializr.actuate.stat.ProjectGenerationStatPublisher;
import io.spring.initializr.actuate.stat.ProjectRequestDocumentFactory;
import io.spring.initializr.actuate.stat.StatsProperties;
import io.spring.initializr.metadata.InitializrMetadataProvider;
import java.util.Collections;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestTemplateAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;

@Configuration
@EnableConfigurationProperties(value={StatsProperties.class})
@ConditionalOnProperty(value={"initializr.stats.elastic.uri"})
@AutoConfigureAfter(value={RestTemplateAutoConfiguration.class}, name={"io.spring.initializr.web.autoconfigure.InitializrAutoConfiguration"})
class InitializrStatsAutoConfiguration {
    private final StatsProperties statsProperties;

    InitializrStatsAutoConfiguration(StatsProperties statsProperties) {
        this.statsProperties = statsProperties;
    }

    @Bean
    @ConditionalOnBean(value={InitializrMetadataProvider.class})
    ProjectGenerationStatPublisher projectRequestStatHandler(RestTemplateBuilder restTemplateBuilder) {
        return new ProjectGenerationStatPublisher(new ProjectRequestDocumentFactory(), this.statsProperties, restTemplateBuilder, this.statsRetryTemplate());
    }

    @Bean
    @ConditionalOnMissingBean(name={"statsRetryTemplate"})
    RetryTemplate statsRetryTemplate() {
        RetryTemplate retryTemplate = new RetryTemplate();
        ExponentialBackOffPolicy backOffPolicy = new ExponentialBackOffPolicy();
        backOffPolicy.setInitialInterval(3000L);
        backOffPolicy.setMultiplier(3.0);
        SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy(this.statsProperties.getElastic().getMaxAttempts(), Collections.singletonMap(Exception.class, true));
        retryTemplate.setBackOffPolicy((BackOffPolicy)backOffPolicy);
        retryTemplate.setRetryPolicy((RetryPolicy)retryPolicy);
        return retryTemplate;
    }
}

