/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.actuate.stat;

import io.spring.initializr.actuate.stat.ProjectRequestDocument;
import io.spring.initializr.generator.version.Version;
import io.spring.initializr.metadata.InitializrMetadata;
import io.spring.initializr.web.project.ProjectFailedEvent;
import io.spring.initializr.web.project.ProjectRequest;
import io.spring.initializr.web.project.ProjectRequestEvent;
import io.spring.initializr.web.project.WebProjectRequest;
import io.spring.initializr.web.support.Agent;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public class ProjectRequestDocumentFactory {
    public ProjectRequestDocument createDocument(ProjectRequestEvent event) {
        InitializrMetadata metadata = event.getMetadata();
        ProjectRequest request = event.getProjectRequest();
        ProjectRequestDocument document = new ProjectRequestDocument();
        document.setGenerationTimestamp(event.getTimestamp());
        document.setGroupId(request.getGroupId());
        document.setArtifactId(request.getArtifactId());
        document.setPackageName(request.getPackageName());
        document.setVersion(this.determineVersionInformation(request));
        document.setClient(this.determineClientInformation(request));
        document.setJavaVersion(request.getJavaVersion());
        if (StringUtils.hasText((String)request.getJavaVersion()) && metadata.getJavaVersions().get(request.getJavaVersion()) == null) {
            document.triggerError().setJavaVersion(true);
        }
        document.setLanguage(request.getLanguage());
        if (StringUtils.hasText((String)request.getLanguage()) && metadata.getLanguages().get(request.getLanguage()) == null) {
            document.triggerError().setLanguage(true);
        }
        document.setPackaging(request.getPackaging());
        if (StringUtils.hasText((String)request.getPackaging()) && metadata.getPackagings().get(request.getPackaging()) == null) {
            document.triggerError().setPackaging(true);
        }
        document.setType(request.getType());
        document.setBuildSystem(this.determineBuildSystem(request));
        if (StringUtils.hasText((String)request.getType()) && metadata.getTypes().get(request.getType()) == null) {
            document.triggerError().setType(true);
        }
        ArrayList dependencies = new ArrayList(request.getDependencies());
        List<String> validDependencies = dependencies.stream().filter(id -> metadata.getDependencies().get(id) != null).collect(Collectors.toList());
        document.setDependencies(new ProjectRequestDocument.DependencyInformation(validDependencies));
        List<String> invalidDependencies = dependencies.stream().filter(id -> !validDependencies.contains(id)).collect(Collectors.toList());
        if (!invalidDependencies.isEmpty()) {
            document.triggerError().triggerInvalidDependencies(invalidDependencies);
        }
        if (event instanceof ProjectFailedEvent) {
            ProjectRequestDocument.ErrorStateInformation errorState = document.triggerError();
            ProjectFailedEvent failed = (ProjectFailedEvent)event;
            if (failed.getCause() != null) {
                errorState.setMessage(failed.getCause().getMessage());
            }
        }
        return document;
    }

    private String determineBuildSystem(ProjectRequest request) {
        String type = request.getType();
        String[] elements = type.split("-");
        return elements.length == 2 ? elements[0] : null;
    }

    private ProjectRequestDocument.VersionInformation determineVersionInformation(ProjectRequest request) {
        Version version = Version.safeParse((String)request.getBootVersion());
        if (version != null && version.getMajor() != null) {
            return new ProjectRequestDocument.VersionInformation(version);
        }
        return null;
    }

    private ProjectRequestDocument.ClientInformation determineClientInformation(ProjectRequest request) {
        if (request instanceof WebProjectRequest) {
            WebProjectRequest webProjectRequest = (WebProjectRequest)request;
            Agent agent = this.determineAgent(webProjectRequest);
            String ip = this.determineIp(webProjectRequest);
            String country = this.determineCountry(webProjectRequest);
            if (agent != null || ip != null || country != null) {
                return new ProjectRequestDocument.ClientInformation(agent, ip, country);
            }
        }
        return null;
    }

    private Agent determineAgent(WebProjectRequest request) {
        String userAgent = (String)request.getParameters().get("user-agent");
        if (StringUtils.hasText((String)userAgent)) {
            return Agent.fromUserAgent((String)userAgent);
        }
        return null;
    }

    private String determineIp(WebProjectRequest request) {
        String candidate = (String)request.getParameters().get("cf-connecting-ip");
        return StringUtils.hasText((String)candidate) ? candidate : (String)request.getParameters().get("x-forwarded-for");
    }

    private String determineCountry(WebProjectRequest request) {
        String candidate = (String)request.getParameters().get("cf-ipcountry");
        if (StringUtils.hasText((String)candidate) && !"xx".equalsIgnoreCase(candidate)) {
            return candidate;
        }
        return null;
    }
}

