/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.actuate.autoconfigure;

import io.spring.initializr.actuate.stat.ProjectGenerationStatPublisher;
import io.spring.initializr.actuate.stat.ProjectRequestDocumentFactory;
import io.spring.initializr.actuate.stat.StatsProperties;
import io.spring.initializr.metadata.InitializrMetadataProvider;
import java.util.Collections;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.web.client.RestTemplateAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.StringUtils;

@AutoConfiguration(after={RestTemplateAutoConfiguration.class}, afterName={"io.spring.initializr.web.autoconfigure.InitializrAutoConfiguration"})
@EnableConfigurationProperties(value={StatsProperties.class})
@Conditional(value={ElasticUriCondition.class})
class InitializrStatsAutoConfiguration {
    private final StatsProperties statsProperties;

    InitializrStatsAutoConfiguration(StatsProperties statsProperties) {
        this.statsProperties = statsProperties;
    }

    @Bean
    @ConditionalOnBean(value={InitializrMetadataProvider.class})
    ProjectGenerationStatPublisher projectRequestStatHandler(RestTemplateBuilder restTemplateBuilder) {
        return new ProjectGenerationStatPublisher(new ProjectRequestDocumentFactory(), this.statsProperties, restTemplateBuilder, this.statsRetryTemplate());
    }

    @Bean
    @ConditionalOnMissingBean(name={"statsRetryTemplate"})
    RetryTemplate statsRetryTemplate() {
        RetryTemplate retryTemplate = new RetryTemplate();
        ExponentialBackOffPolicy backOffPolicy = new ExponentialBackOffPolicy();
        backOffPolicy.setInitialInterval(3000L);
        backOffPolicy.setMultiplier(3.0);
        SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy(this.statsProperties.getElastic().getMaxAttempts(), Collections.singletonMap(Exception.class, true));
        retryTemplate.setBackOffPolicy((BackOffPolicy)backOffPolicy);
        retryTemplate.setRetryPolicy((RetryPolicy)retryPolicy);
        return retryTemplate;
    }

    static class ElasticUriCondition
    extends SpringBootCondition {
        ElasticUriCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String elasticUri = context.getEnvironment().getProperty("initializr.stats.elastic.uri");
            if (StringUtils.hasText((String)elasticUri)) {
                return ConditionOutcome.match((String)"initializr.stats.elastic.uri is set");
            }
            return ConditionOutcome.noMatch((String)"initializr.stats.elastic.uri is not set");
        }
    }
}

