/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.actuate.info;

import io.spring.initializr.generator.version.Version;
import io.spring.initializr.generator.version.VersionRange;
import io.spring.initializr.metadata.Dependency;
import io.spring.initializr.metadata.InitializrMetadataProvider;
import java.lang.invoke.CallSite;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.actuate.info.Info;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.util.ObjectUtils;

public class DependencyRangesInfoContributor
implements InfoContributor {
    private final InitializrMetadataProvider metadataProvider;

    public DependencyRangesInfoContributor(InitializrMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    public void contribute(Info.Builder builder) {
        LinkedHashMap details = new LinkedHashMap();
        this.metadataProvider.get().getDependencies().getAll().forEach(dependency -> {
            if (dependency.getBom() == null) {
                this.contribute(details, (Dependency)dependency);
            }
        });
        if (!details.isEmpty()) {
            builder.withDetail("dependency-ranges", details);
        }
    }

    private void contribute(Map<String, Object> details, Dependency dependency) {
        if (!ObjectUtils.isEmpty((Object)dependency.getMappings())) {
            LinkedHashMap<String, VersionRange> dep = new LinkedHashMap<String, VersionRange>();
            dependency.getMappings().forEach(it -> {
                if (it.getRange() != null && it.getVersion() != null) {
                    dep.put(it.getVersion(), it.getRange());
                }
            });
            if (!dep.isEmpty()) {
                boolean openRange;
                if (dependency.getRange() == null && !(openRange = dep.values().stream().anyMatch(v -> v.getHigherVersion() == null))) {
                    Version higher = this.getHigher(dep);
                    dep.put("managed", new VersionRange(higher));
                }
                LinkedHashMap depInfo = new LinkedHashMap();
                dep.forEach((k, r) -> depInfo.put(k, "Spring Boot " + String.valueOf(r)));
                details.put(dependency.getId(), depInfo);
            }
        } else if (dependency.getVersion() != null && dependency.getRange() != null) {
            LinkedHashMap<String, CallSite> dep = new LinkedHashMap<String, CallSite>();
            String requirement = "Spring Boot " + String.valueOf(dependency.getRange());
            dep.put(dependency.getVersion(), (CallSite)((Object)requirement));
            details.put(dependency.getId(), dep);
        }
    }

    private Version getHigher(Map<String, VersionRange> dep) {
        Version higher = null;
        for (VersionRange versionRange : dep.values()) {
            Version candidate = versionRange.getHigherVersion();
            if (higher == null) {
                higher = candidate;
                continue;
            }
            if (candidate.compareTo(higher) <= 0) continue;
            higher = candidate;
        }
        return higher;
    }
}

