/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.actuate.stat;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.spring.initializr.actuate.stat.ProjectRequestDocument;
import io.spring.initializr.actuate.stat.ProjectRequestDocumentFactory;
import io.spring.initializr.actuate.stat.StatsProperties;
import io.spring.initializr.web.project.ProjectRequestEvent;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.event.EventListener;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class ProjectGenerationStatPublisher {
    private static final Log logger = LogFactory.getLog(ProjectGenerationStatPublisher.class);
    private final ProjectRequestDocumentFactory documentFactory;
    private final ObjectMapper objectMapper;
    private final RestTemplate restTemplate;
    private URI requestUrl;
    private final RetryTemplate retryTemplate;

    public ProjectGenerationStatPublisher(ProjectRequestDocumentFactory documentFactory, StatsProperties statsProperties, RestTemplateBuilder restTemplateBuilder, RetryTemplate retryTemplate) {
        this.documentFactory = documentFactory;
        this.objectMapper = ProjectGenerationStatPublisher.createObjectMapper();
        StatsProperties.Elastic elastic = statsProperties.getElastic();
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUri((URI)ProjectGenerationStatPublisher.determineEntityUrl(elastic));
        this.restTemplate = ProjectGenerationStatPublisher.configureAuthorization(restTemplateBuilder, elastic, uriBuilder).build();
        this.requestUrl = uriBuilder.userInfo(null).build().toUri();
        this.retryTemplate = retryTemplate;
    }

    @EventListener
    @Async
    public void handleEvent(ProjectRequestEvent event) {
        String json = null;
        try {
            ProjectRequestDocument document = this.documentFactory.createDocument(event);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Publishing " + document));
            }
            json = this.toJson(document);
            RequestEntity request = RequestEntity.post((URI)this.requestUrl).contentType(MediaType.APPLICATION_JSON).body((Object)json);
            this.retryTemplate.execute(context -> {
                this.restTemplate.exchange(request, String.class);
                return null;
            });
        }
        catch (Exception ex) {
            logger.warn((Object)String.format("Failed to publish stat to index, document follows %n%n%s%n", json), (Throwable)ex);
        }
    }

    private String toJson(ProjectRequestDocument stats) {
        try {
            return this.objectMapper.writeValueAsString((Object)stats);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalStateException("Cannot convert to JSON", ex);
        }
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }

    protected RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    protected void updateRequestUrl(URI requestUrl) {
        this.requestUrl = requestUrl;
    }

    private static RestTemplateBuilder configureAuthorization(RestTemplateBuilder restTemplateBuilder, StatsProperties.Elastic elastic, UriComponentsBuilder uriComponentsBuilder) {
        String userInfo = uriComponentsBuilder.build().getUserInfo();
        if (StringUtils.hasText((String)userInfo)) {
            String[] credentials = userInfo.split(":");
            return restTemplateBuilder.basicAuthentication(credentials[0], credentials[1]);
        }
        if (StringUtils.hasText((String)elastic.getUsername())) {
            return restTemplateBuilder.basicAuthentication(elastic.getUsername(), elastic.getPassword());
        }
        return restTemplateBuilder;
    }

    private static URI determineEntityUrl(StatsProperties.Elastic elastic) {
        String entityUrl = elastic.getUri() + "/" + elastic.getIndexName() + "/" + elastic.getEntityName();
        try {
            return new URI(entityUrl);
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Cannot create entity URL: " + entityUrl, ex);
        }
    }
}

